/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.ConversionManager;

public final class ExceptionMessageGenerator {
    private static final String CR = System.lineSeparator();

    private ExceptionMessageGenerator() {
    }

    public static ClassLoader getLoader() {
        ClassLoader loader = ExceptionMessageGenerator.class.getClassLoader();
        if (loader == null) {
            loader = ConversionManager.getDefaultManager().getLoader();
        }
        return loader;
    }

    public static String buildMessage(Class<?> exceptionClass, int errorNumber, Object[] arguments) {
        String shortClassName = exceptionClass.getSimpleName();
        String message = "";
        ResourceBundle bundle2 = null;
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] != null) continue;
            arguments[i] = "null";
        }
        bundle2 = ResourceBundle.getBundle("org.eclipse.persistence.exceptions.i18n." + shortClassName + "Resource", Locale.getDefault(), ExceptionMessageGenerator.getLoader());
        try {
            message = bundle2.getString(String.valueOf(errorNumber));
        }
        catch (MissingResourceException mre) {
            bundle2 = ResourceBundle.getBundle("org.eclipse.persistence.exceptions.i18n.ExceptionResource", Locale.getDefault(), ExceptionMessageGenerator.getLoader());
            String noTranslationMessage = bundle2.getString("NoExceptionTranslationForThisLocale");
            Object[] args = new Object[]{CR};
            return ExceptionMessageGenerator.format(message, arguments) + ExceptionMessageGenerator.format(noTranslationMessage, args);
        }
        return ExceptionMessageGenerator.format(message, arguments);
    }

    protected static String format(String message, Object[] arguments) {
        try {
            return MessageFormat.format(message, arguments);
        }
        catch (Exception ex) {
            ResourceBundle bundle2 = null;
            bundle2 = ResourceBundle.getBundle("org.eclipse.persistence.exceptions.i18n.ExceptionResource", Locale.getDefault(), ExceptionMessageGenerator.getLoader());
            String errorMessage = bundle2.getString("ErrorFormattingMessage");
            Vector<Object> vec = new Vector<Object>();
            if (arguments != null) {
                for (int index = 0; index < arguments.length; ++index) {
                    try {
                        vec.add(arguments[index].toString());
                        continue;
                    }
                    catch (Exception ex2) {
                        vec.add(ex2);
                    }
                }
            }
            return MessageFormat.format(errorMessage, message, vec);
        }
    }

    public static String getHeader(String headerLabel) {
        ResourceBundle bundle2 = null;
        try {
            bundle2 = ResourceBundle.getBundle("org.eclipse.persistence.exceptions.i18n.ExceptionResource", Locale.getDefault(), ExceptionMessageGenerator.getLoader());
            return bundle2.getString(headerLabel);
        }
        catch (MissingResourceException mre) {
            return "[" + headerLabel + "]";
        }
    }
}

