/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.annotations.CacheIsolationType;
import org.eclipse.persistence.annotations.CacheKeyType;
import org.eclipse.persistence.annotations.IdValidation;
import org.eclipse.persistence.core.descriptors.CoreDescriptor;
import org.eclipse.persistence.descriptors.AllFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.CachePolicy;
import org.eclipse.persistence.descriptors.ChangedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventManager;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.FetchGroupManager;
import org.eclipse.persistence.descriptors.FieldsLockingPolicy;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.descriptors.InterfacePolicy;
import org.eclipse.persistence.descriptors.MultitenantPolicy;
import org.eclipse.persistence.descriptors.ReturningPolicy;
import org.eclipse.persistence.descriptors.SelectedFieldsLockingPolicy;
import org.eclipse.persistence.descriptors.SerializedObjectPolicy;
import org.eclipse.persistence.descriptors.TablePerClassPolicy;
import org.eclipse.persistence.descriptors.TablePerMultitenantPolicy;
import org.eclipse.persistence.descriptors.TimestampLockingPolicy;
import org.eclipse.persistence.descriptors.VersionLockingPolicy;
import org.eclipse.persistence.descriptors.WrapperPolicy;
import org.eclipse.persistence.descriptors.changetracking.AttributeChangeTrackingPolicy;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.DeferredChangeDetectionPolicy;
import org.eclipse.persistence.descriptors.changetracking.ObjectChangePolicy;
import org.eclipse.persistence.descriptors.copying.CloneCopyPolicy;
import org.eclipse.persistence.descriptors.copying.CopyPolicy;
import org.eclipse.persistence.descriptors.copying.InstantiationCopyPolicy;
import org.eclipse.persistence.descriptors.copying.PersistenceEntityCopyPolicy;
import org.eclipse.persistence.descriptors.copying.RecordCopyPolicy;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.NoExpiryCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.partitioning.PartitioningPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.HistoryPolicy;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.descriptors.CascadeLockingPolicy;
import org.eclipse.persistence.internal.descriptors.InstantiationPolicy;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.descriptors.PersistenceObjectAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.PersistenceObjectInstantiationPolicy;
import org.eclipse.persistence.internal.descriptors.RecordInstantiationPolicy;
import org.eclipse.persistence.internal.descriptors.SerializedObjectPolicyWrapper;
import org.eclipse.persistence.internal.descriptors.VirtualAttributeMethodInfo;
import org.eclipse.persistence.internal.dynamic.DynamicEntityImpl;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.expressions.SQLStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.MappingCompare;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedChangeTracking;
import org.eclipse.persistence.mappings.AggregateCollectionMapping;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.AggregateObjectMapping;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.DirectToFieldMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ManyToManyMapping;
import org.eclipse.persistence.mappings.ManyToOneMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.OneToManyMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;
import org.eclipse.persistence.mappings.UnidirectionalOneToManyMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.querykeys.DirectQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;
import org.eclipse.persistence.queries.AttributeGroup;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Project;
import org.eclipse.persistence.sessions.interceptors.CacheInterceptor;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public class ClassDescriptor
extends CoreDescriptor<AttributeGroup, DescriptorEventManager, DatabaseField, InheritancePolicy, InstantiationPolicy, List<String>, ObjectBuilder>
implements Cloneable,
Serializable {
    protected Class<?> javaClass;
    protected String javaClassName;
    protected List<DatabaseTable> tables = new ArrayList<DatabaseTable>(3);
    protected transient DatabaseTable defaultTable;
    protected List<DatabaseField> primaryKeyFields;
    protected Map<DatabaseTable, Map<DatabaseField, DatabaseField>> additionalTablePrimaryKeyFields;
    protected transient List<DatabaseTable> multipleTableInsertOrder;
    protected Map<DatabaseTable, Set<DatabaseTable>> multipleTableForeignKeys;
    protected boolean isCascadeOnDeleteSetOnDatabaseOnSecondaryTables;
    protected transient List<DatabaseField> fields;
    protected transient List<DatabaseField> allFields;
    protected transient List<DatabaseField> selectionFields;
    protected transient List<DatabaseField> allSelectionFields;
    protected transient List<DatabaseField> returnFieldsToGenerateInsert;
    protected transient List<DatabaseField> returnFieldsToGenerateUpdate;
    protected transient List<DatabaseField> returnFieldsToMergeInsert;
    protected transient List<DatabaseField> returnFieldsToMergeUpdate;
    protected List<DatabaseMapping> mappings = new ArrayList<DatabaseMapping>();
    protected Set<ClassDescriptor> referencingClasses;
    protected List<DatabaseMapping> lockableMappings;
    protected Map<String, QueryKey> queryKeys;
    protected String sequenceNumberName;
    protected DatabaseField sequenceNumberField;
    protected transient String sessionName;
    protected transient List<Class<?>> constraintDependencies;
    protected transient String amendmentMethodName;
    protected transient Class<?> amendmentClass;
    protected String amendmentClassName;
    protected String alias;
    protected boolean shouldBeReadOnly = false;
    protected boolean shouldAlwaysConformResultsInUnitOfWork = false;
    protected boolean shouldRegisterResultsInUnitOfWork = true;
    protected DescriptorQueryManager queryManager;
    protected CopyPolicy copyPolicy;
    protected String copyPolicyClassName;
    protected InterfacePolicy interfacePolicy;
    protected OptimisticLockingPolicy optimisticLockingPolicy;
    protected transient List<CascadeLockingPolicy> cascadeLockingPolicies;
    protected WrapperPolicy wrapperPolicy;
    protected ObjectChangePolicy changePolicy;
    protected ReturningPolicy returningPolicy;
    protected List<ReturningPolicy> returningPolicies;
    protected HistoryPolicy historyPolicy;
    protected String partitioningPolicyName;
    protected PartitioningPolicy partitioningPolicy;
    protected CMPPolicy cmpPolicy;
    protected CachePolicy cachePolicy;
    protected MultitenantPolicy multitenantPolicy;
    protected SerializedObjectPolicy serializedObjectPolicy;
    protected FetchGroupManager fetchGroupManager;
    protected Map properties;
    protected Map<String, List<String>> unconvertedProperties;
    protected transient int initializationStage = 0;
    protected transient int interfaceInitializationStage = 0;
    protected static final int UNINITIALIZED = 0;
    protected static final int PREINITIALIZED = 1;
    protected static final int INITIALIZED = 2;
    protected static final int POST_INITIALIZED = 3;
    protected static final int ERROR = -1;
    protected int descriptorType = 0;
    protected static final int NORMAL = 0;
    protected static final int INTERFACE = 1;
    protected static final int AGGREGATE = 2;
    protected static final int AGGREGATE_COLLECTION = 3;
    protected boolean shouldOrderMappings = true;
    protected CacheInvalidationPolicy cacheInvalidationPolicy = null;
    protected boolean shouldAcquireCascadedLocks = false;
    protected boolean cascadedLockingInitialized = false;
    protected boolean hasSimplePrimaryKey = false;
    protected boolean hasMultipleTableConstraintDependecy = false;
    public static final int UNDEFINED_OBJECT_CHANGE_BEHAVIOR = 0;
    public static final int SEND_OBJECT_CHANGES = 1;
    public static final int INVALIDATE_CHANGED_OBJECTS = 2;
    public static final int SEND_NEW_OBJECTS_WITH_CHANGES = 3;
    public static final int DO_NOT_SEND_CHANGES = 4;
    public static final int UNDEFINED_ISOLATATION = -1;
    public static final int USE_SESSION_CACHE_AFTER_TRANSACTION = 0;
    public static final int ISOLATE_NEW_DATA_AFTER_TRANSACTION = 1;
    public static final int ISOLATE_CACHE_AFTER_TRANSACTION = 2;
    public static final int ISOLATE_FROM_CLIENT_SESSION = 3;
    public static final int ISOLATE_CACHE_ALWAYS = 4;
    public static boolean shouldUseFullChangeSetsForNewObjects = false;
    protected boolean isNativeConnectionRequired;
    protected IdValidation idValidation;
    protected List<IdValidation> primaryKeyIdValidations;
    protected Map<String, DatabaseMapping> derivesIdMappings;
    protected QueryRedirector defaultQueryRedirector;
    protected QueryRedirector defaultReadAllQueryRedirector;
    protected QueryRedirector defaultReadObjectQueryRedirector;
    protected QueryRedirector defaultReportQueryRedirector;
    protected QueryRedirector defaultUpdateObjectQueryRedirector;
    protected QueryRedirector defaultInsertObjectQueryRedirector;
    protected QueryRedirector defaultDeleteObjectQueryRedirector;
    protected String defaultQueryRedirectorClassName;
    protected String defaultReadAllQueryRedirectorClassName;
    protected String defaultReadObjectQueryRedirectorClassName;
    protected String defaultReportQueryRedirectorClassName;
    protected String defaultUpdateObjectQueryRedirectorClassName;
    protected String defaultInsertObjectQueryRedirectorClassName;
    protected String defaultDeleteObjectQueryRedirectorClassName;
    protected Sequence sequence;
    protected List<DatabaseMapping> mappingsPostCalculateChanges;
    protected List<DatabaseMapping> mappingsPostCalculateChangesOnDeleted;
    protected transient List<DatabaseField> additionalAggregateCollectionKeyFields;
    protected List<DatabaseMapping> preDeleteMappings;
    protected transient List<DatabaseField> additionalWritableMapKeyFields;
    protected boolean hasRelationships = false;
    protected Set<DatabaseField> foreignKeyValuesForCaching;
    protected boolean hasNoncacheableMappings = false;
    protected boolean weavingUsesPropertyAccess = false;
    protected List<VirtualAttributeMethodInfo> virtualAttributeMethods = null;
    protected List<AttributeAccessor> accessorTree;
    protected String descriptorCustomizerClassName;
    protected boolean shouldLockForClone = true;

    public ClassDescriptor() {
        this.primaryKeyFields = new ArrayList<DatabaseField>(2);
        this.fields = new ArrayList<DatabaseField>();
        this.allFields = new ArrayList<DatabaseField>();
        this.constraintDependencies = new ArrayList(2);
        this.multipleTableForeignKeys = new HashMap<DatabaseTable, Set<DatabaseTable>>(5);
        this.queryKeys = new HashMap<String, QueryKey>(5);
        this.derivesIdMappings = new HashMap<String, DatabaseMapping>(5);
        this.referencingClasses = new HashSet<ClassDescriptor>();
        this.objectBuilder = new ObjectBuilder(this);
        this.cachePolicy = new CachePolicy();
        this.additionalWritableMapKeyFields = new ArrayList<DatabaseField>(2);
        this.foreignKeyValuesForCaching = new HashSet<DatabaseField>();
    }

    public void addAbstractQueryKey(String queryKeyName) {
        QueryKey queryKey = new QueryKey();
        queryKey.setName(queryKeyName);
        this.addQueryKey(queryKey);
    }

    public void addCascadeLockingPolicy(CascadeLockingPolicy policy) {
        this.getCascadeLockingPolicies().add(policy);
        if (this.hasInheritance()) {
            for (ClassDescriptor parent : this.getInheritancePolicy().getAllChildDescriptors()) {
                parent.addCascadeLockingPolicy(policy);
            }
        }
        if (!this.cascadedLockingInitialized && this.isInitialized(2)) {
            for (DatabaseMapping mapping : this.getMappings()) {
                this.prepareCascadeLockingPolicy(mapping);
            }
            this.cascadedLockingInitialized = true;
        }
    }

    public void addConstraintDependencies(Class<?> dependencies) {
        this.addConstraintDependency(dependencies);
    }

    public void addConstraintDependency(Class<?> dependencies) {
        this.getConstraintDependencies().add(dependencies);
    }

    public AbstractDirectMapping newDirectMapping() {
        return new DirectToFieldMapping();
    }

    public AggregateMapping newAggregateMapping() {
        return new AggregateObjectMapping();
    }

    public DatabaseMapping newAggregateCollectionMapping() {
        return new AggregateCollectionMapping();
    }

    public DatabaseMapping newDirectCollectionMapping() {
        return new DirectCollectionMapping();
    }

    public ObjectReferenceMapping newOneToOneMapping() {
        OneToOneMapping mapping = new OneToOneMapping();
        mapping.setIsOneToOneRelationship(true);
        return mapping;
    }

    public ObjectReferenceMapping newManyToOneMapping() {
        return new ManyToOneMapping();
    }

    public CollectionMapping newOneToManyMapping() {
        return new OneToManyMapping();
    }

    public CollectionMapping newUnidirectionalOneToManyMapping() {
        return new UnidirectionalOneToManyMapping();
    }

    public CollectionMapping newManyToManyMapping() {
        return new ManyToManyMapping();
    }

    public DatabaseMapping addDirectMapping(String attributeName, String fieldName) {
        AbstractDirectMapping mapping = this.newDirectMapping();
        mapping.setAttributeName(attributeName);
        mapping.setField(new DatabaseField(fieldName));
        return this.addMapping(mapping);
    }

    public DatabaseMapping addDirectMapping(String attributeName, String getMethodName, String setMethodName, String fieldName) {
        AbstractDirectMapping mapping = (AbstractDirectMapping)this.addDirectMapping(attributeName, fieldName);
        mapping.setSetMethodName(setMethodName);
        mapping.setGetMethodName(getMethodName);
        return mapping;
    }

    public void addDirectQueryKey(String queryKeyName, String fieldName) {
        DirectQueryKey queryKey = new DirectQueryKey();
        DatabaseField field = new DatabaseField(fieldName);
        queryKey.setName(queryKeyName);
        queryKey.setField(field);
        this.getQueryKeys().put(queryKeyName, queryKey);
    }

    public void addForeignKeyFieldNameForMultipleTable(String sourceForeignKeyFieldName, String targetPrimaryKeyFieldName) throws DescriptorException {
        this.addForeignKeyFieldForMultipleTable(new DatabaseField(sourceForeignKeyFieldName), new DatabaseField(targetPrimaryKeyFieldName));
    }

    public void addForeignKeyFieldForMultipleTable(DatabaseField sourceForeignKeyField, DatabaseField targetPrimaryKeyField) throws DescriptorException {
        if (!sourceForeignKeyField.hasTableName() || !targetPrimaryKeyField.hasTableName()) {
            throw DescriptorException.multipleTablePrimaryKeyMustBeFullyQualified(this);
        }
        this.setAdditionalTablePrimaryKeyFields(sourceForeignKeyField.getTable(), targetPrimaryKeyField, sourceForeignKeyField);
        Set sourceTables = this.getMultipleTableForeignKeys().computeIfAbsent(targetPrimaryKeyField.getTable(), k -> new HashSet(3));
        sourceTables.add(sourceForeignKeyField.getTable());
    }

    public DatabaseMapping addMapping(DatabaseMapping mapping) {
        if (mapping.getDescriptor() == null) {
            mapping.setDescriptor(this);
        }
        this.getMappings().add(mapping);
        return mapping;
    }

    protected void validateMappingType(DatabaseMapping mapping) {
        if (!mapping.isRelationalMapping()) {
            throw DescriptorException.invalidMappingType(mapping);
        }
    }

    public void addPrimaryKeyFieldName(String fieldName) {
        this.addPrimaryKeyField(new DatabaseField(fieldName));
    }

    public void addPrimaryKeyField(DatabaseField field) {
        List<DatabaseField> pkFields = this.getPrimaryKeyFields();
        if (!pkFields.contains(field)) {
            pkFields.add(field);
        }
    }

    public void addQueryKey(QueryKey queryKey) {
        this.getQueryKeys().put(queryKey.getName(), queryKey);
    }

    public void addTable(DatabaseTable table) {
        this.getTables().add(table);
    }

    public void addTableName(String tableName) {
        this.addTable(new DatabaseTable(tableName));
    }

    public void addUnconvertedProperty(String propertyName, String propertyValue, String propertyType) {
        ArrayList<String> valuePair = new ArrayList<String>(2);
        valuePair.add(propertyValue);
        valuePair.add(propertyType);
        this.getUnconvertedProperties().put(propertyName, valuePair);
    }

    public void adjustMultipleTableInsertOrder() {
        if (this.getMultipleTableInsertOrder() == null || this.getMultipleTableInsertOrder().isEmpty()) {
            this.createMultipleTableInsertOrder();
        } else {
            this.verifyMultipleTableInsertOrder();
        }
        this.toggleAdditionalTablePrimaryKeyFields();
    }

    public void alwaysConformResultsInUnitOfWork() {
        this.setShouldAlwaysConformResultsInUnitOfWork(true);
    }

    public void alwaysRefreshCache() {
        this.setShouldAlwaysRefreshCache(true);
    }

    public void alwaysRefreshCacheOnRemote() {
        this.setShouldAlwaysRefreshCacheOnRemote(true);
    }

    public void applyAmendmentMethod() {
        this.applyAmendmentMethod(null);
    }

    public void applyAmendmentMethod(DescriptorEvent event) {
        if (this.getAmendmentClass() == null || this.getAmendmentMethodName() == null) {
            return;
        }
        Method method = null;
        Class[] argTypes = new Class[]{ClassDescriptor.class};
        try {
            method = Helper.getDeclaredMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), argTypes);
        }
        catch (Exception ignore) {
            argTypes[0] = ClassDescriptor.class;
            try {
                method = Helper.getDeclaredMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), argTypes);
            }
            catch (Exception exception) {
                throw DescriptorException.invalidAmendmentMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), exception, this);
            }
        }
        Object[] args = new Object[]{this};
        Method lambdaMethod = method;
        PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.invokeMethod(lambdaMethod, null, args), ex -> DescriptorException.errorOccuredInAmendmentMethod(this.getAmendmentClass(), this.getAmendmentMethodName(), ex, this));
    }

    public boolean arePrimaryKeyFields(List<DatabaseField> fields) {
        if (fields.size() != this.getPrimaryKeyFields().size()) {
            return false;
        }
        for (DatabaseField field : fields) {
            if (this.getPrimaryKeyFields().contains(field)) continue;
            return false;
        }
        return true;
    }

    protected void assignDefaultValues(AbstractSession session) {
        if (this.idValidation == null) {
            this.idValidation = session.getProject().getDefaultIdValidation();
        }
        this.getCachePolicy().assignDefaultValues(session);
    }

    public Expression buildBatchCriteriaByPK(ExpressionBuilder builder, ObjectLevelReadQuery query) {
        int size = this.getPrimaryKeyFields().size();
        if (size > 1) {
            ArrayList<Expression> fields = new ArrayList<Expression>(size);
            for (DatabaseField targetForeignKeyField : this.primaryKeyFields) {
                fields.add(builder.getField(targetForeignKeyField));
            }
            return query.getSession().getPlatform().buildBatchCriteriaForComplexId(builder, fields);
        }
        return query.getSession().getPlatform().buildBatchCriteria(builder, builder.getField(this.primaryKeyFields.get(0)));
    }

    public DatasourceCall buildCallFromStatement(SQLStatement statement, DatabaseQuery query, AbstractSession session) {
        DatabaseCall call = statement.buildCall(session);
        if (this.isNativeConnectionRequired()) {
            call.setIsNativeConnectionRequired(true);
        }
        return call;
    }

    public List<Object> buildDirectValuesFromFieldValue(Object fieldValue) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public DatabaseField buildField(String fieldName) {
        DatabaseField field = new DatabaseField(fieldName);
        DatabaseTable table = field.hasTableName() ? this.getTable(field.getTableName()) : (this.getDefaultTable() != null ? this.getDefaultTable() : this.getTable(this.getTableName()));
        field.setTable(table);
        return field;
    }

    public DatabaseField buildField(DatabaseField field) {
        return this.buildField(field, null);
    }

    public DatabaseField buildField(DatabaseField field, DatabaseTable relationTable) {
        DatabaseField builtField = this.getObjectBuilder().getFieldsMap().get(field);
        if (builtField == null) {
            builtField = field;
            DatabaseTable table = relationTable != null && field.hasTableName() && field.getTableName().equals(relationTable.getName()) ? relationTable : (relationTable != null && !field.hasTableName() ? relationTable : (field.hasTableName() ? this.getTable(field.getTableName()) : this.getDefaultTable()));
            builtField.setTable(table);
            this.getObjectBuilder().getFieldsMap().put(builtField, builtField);
        }
        return builtField;
    }

    public Object buildFieldValueFromDirectValues(Vector directValues, String elementDataTypeName, AbstractSession session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Object buildFieldValueFromForeignKeys(Vector foreignKeys, String referenceDataTypeName, AbstractSession session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Object buildFieldValueFromNestedRow(AbstractRecord nestedRow, AbstractSession session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public Object buildFieldValueFromNestedRows(Vector nestedRows, String structureName, AbstractSession session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public AbstractRecord buildNestedRowFromFieldValue(Object fieldValue) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    public List<AbstractRecord> buildNestedRowsFromFieldValue(Object fieldValue, AbstractSession session) throws DatabaseException {
        throw DescriptorException.normalDescriptorsDoNotSupportNonRelationalExtensions(this);
    }

    protected void checkDatabase(AbstractSession session) {
        if (session.getIntegrityChecker().shouldCheckDatabase()) {
            for (DatabaseTable table : this.getTables()) {
                if (session.getIntegrityChecker().checkTable(table, session)) {
                    ArrayList<String> databaseFields = new ArrayList<String>();
                    Vector<AbstractRecord> result = session.getAccessor().getColumnInfo(table.getName(), null, session);
                    if (result.isEmpty() && session.getPlatform().shouldForceFieldNamesToUpperCase()) {
                        result = session.getAccessor().getColumnInfo(table.getName().toLowerCase(), null, session);
                    }
                    for (AbstractRecord row : result) {
                        if (session.getPlatform().shouldForceFieldNamesToUpperCase()) {
                            databaseFields.add(((String)row.get("COLUMN_NAME")).toUpperCase());
                            continue;
                        }
                        databaseFields.add((String)row.get("COLUMN_NAME"));
                    }
                    for (DatabaseField field : this.getFields()) {
                        if (!field.getTable().equals(table) || databaseFields.contains(field.getName())) continue;
                        session.getIntegrityChecker().handleError(DescriptorException.fieldIsNotPresentInDatabase(this, table.getName(), field.getName()));
                    }
                    continue;
                }
                session.getIntegrityChecker().handleError(DescriptorException.tableIsNotPresentInDatabase(this));
            }
        }
    }

    public void checkInheritanceTreeAggregateSettings(AbstractSession session, AggregateMapping mapping) throws DescriptorException {
        if (!this.hasInheritance()) {
            return;
        }
        if (this.isChildDescriptor()) {
            Class<?> parentClass = this.getInheritancePolicy().getParentClass();
            if (parentClass == this.getJavaClass()) {
                throw DescriptorException.parentClassIsSelf(this);
            }
            ((ClassDescriptor)session.getDescriptor((Class)parentClass)).checkInheritanceTreeAggregateSettings(session, mapping);
        } else {
            this.checkInheritanceTreeAggregateSettingsForChildren(session, mapping);
        }
    }

    private void checkInheritanceTreeAggregateSettingsForChildren(AbstractSession session, AggregateMapping mapping) throws DescriptorException {
        if (!this.isAggregateDescriptor()) {
            session.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregate(this.getJavaClass().getName(), mapping));
        }
        for (ClassDescriptor childDescriptor : this.getInheritancePolicy().getChildDescriptors()) {
            childDescriptor.checkInheritanceTreeAggregateSettingsForChildren(session, mapping);
        }
    }

    protected void createMultipleTableInsertOrder() {
        int nParentTables = 0;
        if (this.isChildDescriptor()) {
            nParentTables = this.getInheritancePolicy().getParentDescriptor().getTables().size();
            this.setMultipleTableInsertOrder(new ArrayList<DatabaseTable>(this.getInheritancePolicy().getParentDescriptor().getMultipleTableInsertOrder()));
            if (nParentTables == this.getTables().size()) {
                return;
            }
        }
        if (this.getMultipleTableForeignKeys().isEmpty()) {
            if (nParentTables == 0) {
                this.setMultipleTableInsertOrder((List)((ArrayList)this.getTables()).clone());
            } else {
                for (int k = nParentTables; k < this.getTables().size(); ++k) {
                    this.getMultipleTableInsertOrder().add(this.getTables().get(k));
                }
            }
            return;
        }
        this.verifyMultipleTablesForeignKeysTables();
        int[][] tableComparison = this.createTableComparison(this.getTables(), nParentTables);
        this.createMultipleTableInsertOrderFromComparison(tableComparison, nParentTables);
    }

    protected void verifyMultipleTableInsertOrder() {
        int nParentTables = 0;
        if (this.isChildDescriptor() && (nParentTables = this.getInheritancePolicy().getParentDescriptor().getTables().size()) + this.getMultipleTableInsertOrder().size() == this.getTables().size()) {
            List<DatabaseTable> childMultipleTableInsertOrder = this.getMultipleTableInsertOrder();
            this.setMultipleTableInsertOrder(new ArrayList<DatabaseTable>(this.getInheritancePolicy().getParentDescriptor().getMultipleTableInsertOrder()));
            this.getMultipleTableInsertOrder().addAll(childMultipleTableInsertOrder);
        }
        if (this.getMultipleTableInsertOrder().size() != this.getTables().size()) {
            throw DescriptorException.multipleTableInsertOrderMismatch(this);
        }
        if (nParentTables == this.getTables().size()) {
            return;
        }
        if (this.getMultipleTableForeignKeys().isEmpty()) {
            return;
        }
        this.verifyMultipleTablesForeignKeysTables();
        int[][] tableComparison = this.createTableComparison(this.getMultipleTableInsertOrder(), nParentTables);
        for (int i = nParentTables; i < this.getMultipleTableInsertOrder().size(); ++i) {
            for (int j = i + 1; j < this.getTables().size(); ++j) {
                if (tableComparison[i - nParentTables][j - nParentTables] <= 0) continue;
                throw DescriptorException.insertOrderConflictsWithMultipleTableForeignKeys(this, this.getMultipleTableInsertOrder().get(i), this.getMultipleTableInsertOrder().get(j));
            }
        }
    }

    protected void verifyMultipleTablesForeignKeysTables() {
        for (Map.Entry<DatabaseTable, Set<DatabaseTable>> entry : this.getMultipleTableForeignKeys().entrySet()) {
            DatabaseTable targetTable = entry.getKey();
            if (!this.getTables().contains(targetTable)) {
                throw DescriptorException.illegalTableNameInMultipleTableForeignKeyField(this, targetTable);
            }
            for (DatabaseTable sourceTable : entry.getValue()) {
                if (this.getTables().contains(sourceTable)) continue;
                throw DescriptorException.illegalTableNameInMultipleTableForeignKeyField(this, targetTable);
            }
        }
    }

    protected int[][] createTableComparison(List<DatabaseTable> tables, int nStart) {
        int nTables = tables.size();
        int[][] tableComparison = new int[nTables - nStart][nTables - nStart];
        for (Map.Entry<DatabaseTable, Set<DatabaseTable>> entry : this.getMultipleTableForeignKeys().entrySet()) {
            DatabaseTable targetTable = entry.getKey();
            int targetIndex = tables.indexOf(targetTable) - nStart;
            if (targetIndex < 0) continue;
            Set<DatabaseTable> sourceTables = entry.getValue();
            for (DatabaseTable sourceTable : sourceTables) {
                int sourceIndex = tables.indexOf(sourceTable) - nStart;
                if (sourceIndex >= 0) {
                    if (tableComparison[targetIndex][sourceIndex] == 1) {
                        throw DescriptorException.insertOrderCyclicalDependencyBetweenTwoTables(this, sourceTable, targetTable);
                    }
                    tableComparison[targetIndex][sourceIndex] = -1;
                    tableComparison[sourceIndex][targetIndex] = 1;
                    continue;
                }
                throw DescriptorException.insertOrderChildBeforeParent(this, sourceTable, targetTable);
            }
        }
        return tableComparison;
    }

    protected void createMultipleTableInsertOrderFromComparison(int[][] tableComparison, int nStart) {
        int[] tableOrder;
        int nTables = this.getTables().size();
        boolean bOk = this.createTableOrder(0, nTables - nStart, tableOrder = new int[nTables - nStart], tableComparison);
        if (bOk) {
            if (nStart == 0) {
                this.setMultipleTableInsertOrder(new ArrayList<DatabaseTable>(nTables));
            }
            for (int k = 0; k < nTables - nStart; ++k) {
                this.getMultipleTableInsertOrder().add(this.getTables().get(tableOrder[k] + nStart));
            }
        } else {
            throw DescriptorException.insertOrderCyclicalDependencyBetweenThreeOrMoreTables(this);
        }
    }

    protected boolean createTableOrder(int k, int nTables, int[] tableOrder, int[][] tableComparison) {
        if (k == nTables) {
            return true;
        }
        int[] iAvailable = new int[nTables - k];
        int l = 0;
        for (int i = 0; i < nTables; ++i) {
            boolean isUsed = false;
            for (int j = 0; j < k && !isUsed; ++j) {
                if (i != tableOrder[j]) continue;
                isUsed = true;
            }
            if (isUsed) continue;
            iAvailable[l] = i;
            ++l;
        }
        boolean bOk = false;
        for (int i = 0; i < nTables - k && !bOk; ++i) {
            boolean isSmallest = true;
            for (int j = 0; j < nTables - k && isSmallest; ++j) {
                if (i == j || tableComparison[iAvailable[i]][iAvailable[j]] <= 0) continue;
                isSmallest = false;
            }
            if (!isSmallest) continue;
            tableOrder[k] = iAvailable[i];
            bOk = this.createTableOrder(k + 1, nTables, tableOrder, tableComparison);
        }
        return bOk;
    }

    public Object clone() {
        try {
            ClassDescriptor clonedDescriptor = (ClassDescriptor)super.clone();
            ArrayList<DatabaseMapping> mappingsList = new ArrayList<DatabaseMapping>();
            for (DatabaseMapping databaseMapping : this.getMappings()) {
                DatabaseMapping mapping = (DatabaseMapping)databaseMapping.clone();
                mapping.setDescriptor(clonedDescriptor);
                mappingsList.add(mapping);
            }
            clonedDescriptor.setMappings(mappingsList);
            HashMap<String, QueryKey> queryKeys = new HashMap<String, QueryKey>(this.getQueryKeys().size() + 2);
            for (QueryKey queryKey : this.getQueryKeys().values()) {
                queryKey = (QueryKey)queryKey.clone();
                queryKey.setDescriptor(clonedDescriptor);
                queryKeys.put(queryKey.getName(), queryKey);
            }
            clonedDescriptor.setQueryKeys(queryKeys);
            ArrayList<DatabaseField> arrayList = new ArrayList<DatabaseField>(this.getPrimaryKeyFields().size());
            List<DatabaseField> primaryKeyFields = this.getPrimaryKeyFields();
            for (int index = 0; index < primaryKeyFields.size(); ++index) {
                DatabaseField primaryKey = primaryKeyFields.get(index).clone();
                arrayList.add(primaryKey);
            }
            clonedDescriptor.setPrimaryKeyFields((List<DatabaseField>)arrayList);
            clonedDescriptor.setFields(new ArrayList<DatabaseField>());
            clonedDescriptor.referencingClasses = new HashSet<ClassDescriptor>(this.referencingClasses);
            if (this.mappingsPostCalculateChanges != null) {
                clonedDescriptor.mappingsPostCalculateChanges = new ArrayList<DatabaseMapping>();
                for (DatabaseMapping databaseMapping : this.mappingsPostCalculateChanges) {
                    clonedDescriptor.mappingsPostCalculateChanges.add((DatabaseMapping)databaseMapping.clone());
                }
            }
            if (this.mappingsPostCalculateChangesOnDeleted != null) {
                clonedDescriptor.mappingsPostCalculateChangesOnDeleted = new ArrayList<DatabaseMapping>();
                for (DatabaseMapping databaseMapping : this.mappingsPostCalculateChangesOnDeleted) {
                    clonedDescriptor.mappingsPostCalculateChangesOnDeleted.add((DatabaseMapping)databaseMapping.clone());
                }
            }
            if (clonedDescriptor.hasInheritance()) {
                clonedDescriptor.setInheritancePolicy((InheritancePolicy)this.getInheritancePolicy().clone());
                clonedDescriptor.getInheritancePolicy().setDescriptor(clonedDescriptor);
            }
            if (clonedDescriptor.hasSerializedObjectPolicy()) {
                clonedDescriptor.setSerializedObjectPolicy(this.getSerializedObjectPolicy().clone());
            }
            if (clonedDescriptor.hasReturningPolicy()) {
                clonedDescriptor.setReturningPolicy((ReturningPolicy)this.getReturningPolicy().clone());
                clonedDescriptor.getReturningPolicy().setDescriptor(clonedDescriptor);
            }
            if (clonedDescriptor.hasReturningPolicies()) {
                clonedDescriptor.returningPolicies = new ArrayList<ReturningPolicy>();
                for (ReturningPolicy returningPolicy : this.returningPolicies) {
                    clonedDescriptor.returningPolicies.add((ReturningPolicy)returningPolicy.clone());
                }
                clonedDescriptor.prepareReturnFields(clonedDescriptor.returningPolicies);
            }
            clonedDescriptor.setObjectBuilder((ObjectBuilder)this.getObjectBuilder().clone());
            clonedDescriptor.getObjectBuilder().setDescriptor(clonedDescriptor);
            clonedDescriptor.setEventManager((DescriptorEventManager)this.getEventManager().clone());
            clonedDescriptor.getEventManager().setDescriptor(clonedDescriptor);
            clonedDescriptor.setQueryManager((DescriptorQueryManager)this.getQueryManager().clone());
            clonedDescriptor.getQueryManager().setDescriptor(clonedDescriptor);
            if (this.hasFetchGroupManager()) {
                clonedDescriptor.setFetchGroupManager((FetchGroupManager)this.getFetchGroupManager().clone());
            }
            if (this.cachePolicy != null) {
                clonedDescriptor.setCachePolicy(this.cachePolicy.clone());
            }
            if (this.instantiationPolicy != null) {
                clonedDescriptor.setInstantiationPolicy((InstantiationPolicy)this.getInstantiationPolicy().clone());
            }
            if (this.copyPolicy != null) {
                clonedDescriptor.setCopyPolicy((CopyPolicy)this.getCopyPolicy().clone());
            }
            if (this.getOptimisticLockingPolicy() != null) {
                clonedDescriptor.setOptimisticLockingPolicy((OptimisticLockingPolicy)this.getOptimisticLockingPolicy().clone());
            }
            clonedDescriptor.setObjectChangePolicy(this.getObjectChangePolicyInternal());
            ArrayList<DatabaseTable> tables = new ArrayList<DatabaseTable>(3);
            for (DatabaseTable table : this.getTables()) {
                tables.add(table.clone());
            }
            clonedDescriptor.setTables(tables);
            if (this.getDefaultTable() != null) {
                clonedDescriptor.setDefaultTable(this.getDefaultTable().clone());
            }
            if (this.getCMPPolicy() != null) {
                clonedDescriptor.setCMPPolicy(this.getCMPPolicy().clone());
                clonedDescriptor.getCMPPolicy().setDescriptor(clonedDescriptor);
            }
            if (this.getSequenceNumberField() != null) {
                clonedDescriptor.setSequenceNumberField(this.getSequenceNumberField().clone());
            }
            if (this.hasMultitenantPolicy()) {
                clonedDescriptor.setMultitenantPolicy(this.getMultitenantPolicy().clone(clonedDescriptor));
            }
            return clonedDescriptor;
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class redirectorClass;
        if (this.getJavaClass() == null && this.getJavaClassName() != null) {
            Class descriptorClass = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(this.getJavaClassName(), true, classLoader), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.getJavaClassName(), ex));
            this.setJavaClass(descriptorClass);
        }
        if (this.getAmendmentClass() == null && this.getAmendmentClassName() != null) {
            Class amendmentClass = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(this.getAmendmentClassName(), true, classLoader), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.getAmendmentClassName(), ex));
            this.setAmendmentClass(amendmentClass);
        }
        if (this.copyPolicy == null && this.getCopyPolicyClassName() != null) {
            Class copyPolicyClass = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(this.getCopyPolicyClassName(), true, classLoader), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.getCopyPolicyClassName(), ex));
            CopyPolicy newCopyPolicy = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> (CopyPolicy)PrivilegedAccessHelper.newInstanceFromClass(copyPolicyClass), ex -> ValidationException.reflectiveExceptionWhileCreatingClassInstance(this.getCopyPolicyClassName(), ex));
            this.setCopyPolicy(newCopyPolicy);
        }
        if (this.serializedObjectPolicy != null && this.serializedObjectPolicy instanceof SerializedObjectPolicyWrapper) {
            String serializedObjectPolicyClassName = ((SerializedObjectPolicyWrapper)this.serializedObjectPolicy).getSerializedObjectPolicyClassName();
            Class serializedObjectPolicyClass = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(serializedObjectPolicyClassName, true, classLoader), ex -> ValidationException.classNotFoundWhileConvertingClassNames(serializedObjectPolicyClassName, ex));
            SerializedObjectPolicy newSerializedObjectPolicy = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> (SerializedObjectPolicy)PrivilegedAccessHelper.newInstanceFromClass(serializedObjectPolicyClass), ex -> ValidationException.reflectiveExceptionWhileCreatingClassInstance(serializedObjectPolicyClassName, ex));
            newSerializedObjectPolicy.setField(this.serializedObjectPolicy.getField());
            this.setSerializedObjectPolicy(newSerializedObjectPolicy);
        }
        if (this.defaultQueryRedirectorClassName != null) {
            redirectorClass = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(this.defaultQueryRedirectorClassName, true, classLoader), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.defaultQueryRedirectorClassName, ex));
            this.setDefaultQueryRedirector((QueryRedirector)PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.newInstanceFromClass(redirectorClass), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.defaultQueryRedirectorClassName, ex)));
        }
        if (this.defaultReadObjectQueryRedirectorClassName != null) {
            redirectorClass = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(this.defaultReadObjectQueryRedirectorClassName, true, classLoader), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadObjectQueryRedirectorClassName, ex));
            this.setDefaultReadObjectQueryRedirector((QueryRedirector)PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.newInstanceFromClass(redirectorClass), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadObjectQueryRedirectorClassName, ex)));
        }
        if (this.defaultReadAllQueryRedirectorClassName != null) {
            redirectorClass = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(this.defaultReadAllQueryRedirectorClassName, true, classLoader), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadAllQueryRedirectorClassName, ex));
            this.setDefaultReadAllQueryRedirector((QueryRedirector)PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.newInstanceFromClass(redirectorClass), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReadAllQueryRedirectorClassName, ex)));
        }
        if (this.defaultReportQueryRedirectorClassName != null) {
            redirectorClass = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(this.defaultReportQueryRedirectorClassName, true, classLoader), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReportQueryRedirectorClassName, ex));
            this.setDefaultReportQueryRedirector((QueryRedirector)PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.newInstanceFromClass(redirectorClass), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.defaultReportQueryRedirectorClassName, ex)));
        }
        if (this.defaultInsertObjectQueryRedirectorClassName != null) {
            redirectorClass = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(this.defaultInsertObjectQueryRedirectorClassName, true, classLoader), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.defaultInsertObjectQueryRedirectorClassName, ex));
            this.setDefaultInsertObjectQueryRedirector((QueryRedirector)PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.newInstanceFromClass(redirectorClass), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.defaultInsertObjectQueryRedirectorClassName, ex)));
        }
        if (this.defaultUpdateObjectQueryRedirectorClassName != null) {
            redirectorClass = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(this.defaultUpdateObjectQueryRedirectorClassName, true, classLoader), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.defaultUpdateObjectQueryRedirectorClassName, ex));
            this.setDefaultUpdateObjectQueryRedirector((QueryRedirector)PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.newInstanceFromClass(redirectorClass), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.defaultUpdateObjectQueryRedirectorClassName, ex)));
        }
        if (this.defaultDeleteObjectQueryRedirectorClassName != null) {
            redirectorClass = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(this.defaultDeleteObjectQueryRedirectorClassName, true, classLoader), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.defaultDeleteObjectQueryRedirectorClassName, ex));
            this.setDefaultDeleteObjectQueryRedirector((QueryRedirector)PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.newInstanceFromClass(redirectorClass), ex -> ValidationException.classNotFoundWhileConvertingClassNames(this.defaultDeleteObjectQueryRedirectorClassName, ex)));
        }
        Iterator<DatabaseMapping> mappings = this.getMappings().iterator();
        while (mappings.hasNext()) {
            mappings.next().convertClassNamesToClasses(classLoader);
        }
        if (this.inheritancePolicy != null) {
            ((InheritancePolicy)this.inheritancePolicy).convertClassNamesToClasses(classLoader);
        }
        if (this.interfacePolicy != null) {
            this.interfacePolicy.convertClassNamesToClasses(classLoader);
        }
        if (this.instantiationPolicy != null) {
            ((InstantiationPolicy)this.instantiationPolicy).convertClassNamesToClasses(classLoader);
        }
        if (this.hasCMPPolicy()) {
            this.getCMPPolicy().convertClassNamesToClasses(classLoader);
        }
        if (this.queryManager != null) {
            this.queryManager.convertClassNamesToClasses(classLoader);
        }
        if (this.cachePolicy != null) {
            this.cachePolicy.convertClassNamesToClasses(classLoader);
        }
        if (this.hasUnconvertedProperties()) {
            for (String propertyName : this.getUnconvertedProperties().keySet()) {
                List<String> valuePair = this.getUnconvertedProperties().get(propertyName);
                String value = valuePair.get(0);
                String valueTypeName = valuePair.get(1);
                Class valueType = String.class;
                if (valueTypeName != null) {
                    valueType = PrivilegedAccessHelper.callDoPrivilegedWithException(() -> PrivilegedAccessHelper.getClassForName(valueTypeName, true, classLoader), ex -> ValidationException.classNotFoundWhileConvertingClassNames(valueTypeName, ex));
                }
                this.getProperties().put(propertyName, ConversionManager.getDefaultManager().convertObject(value, valueType));
            }
        }
    }

    public void createCopyPolicy(String policyType) {
        if (policyType.equals("clone")) {
            this.useCloneCopyPolicy();
            return;
        }
        if (policyType.equals("constructor")) {
            this.useInstantiationCopyPolicy();
            return;
        }
    }

    public void createInstantiationPolicy(String policyType) {
        if (policyType.equals("static method")) {
            return;
        }
        if (policyType.equals("constructor")) {
            this.useDefaultConstructorInstantiationPolicy();
            return;
        }
        if (policyType.equals("factory")) {
            return;
        }
    }

    public void descriptorIsAggregate() {
        this.setDescriptorType(2);
    }

    public void descriptorIsAggregateCollection() {
        this.setDescriptorType(3);
    }

    public void descriptorIsForInterface() {
        this.setDescriptorType(1);
    }

    public void descriptorIsNormal() {
        this.setDescriptorType(0);
    }

    public void disableCacheHits() {
        this.setShouldDisableCacheHits(true);
    }

    public void disableCacheHitsOnRemote() {
        this.setShouldDisableCacheHitsOnRemote(true);
    }

    public void dontAlwaysConformResultsInUnitOfWork() {
        this.setShouldAlwaysConformResultsInUnitOfWork(false);
    }

    public void dontAlwaysRefreshCache() {
        this.setShouldAlwaysRefreshCache(false);
    }

    public void dontAlwaysRefreshCacheOnRemote() {
        this.setShouldAlwaysRefreshCacheOnRemote(false);
    }

    public void dontDisableCacheHits() {
        this.setShouldDisableCacheHits(false);
    }

    public void dontDisableCacheHitsOnRemote() {
        this.setShouldDisableCacheHitsOnRemote(false);
    }

    public void dontOnlyRefreshCacheIfNewerVersion() {
        this.setShouldOnlyRefreshCacheIfNewerVersion(false);
    }

    protected DatabaseTable extractDefaultTable() {
        if (this.getTables().isEmpty()) {
            if (this.isChildDescriptor()) {
                return this.getInheritancePolicy().getParentDescriptor().extractDefaultTable();
            }
            return null;
        }
        return this.getTables().get(0);
    }

    public List<DatabaseField> getAdditionalAggregateCollectionKeyFields() {
        if (this.additionalAggregateCollectionKeyFields == null) {
            this.additionalAggregateCollectionKeyFields = new ArrayList<DatabaseField>();
        }
        return this.additionalAggregateCollectionKeyFields;
    }

    public Map<DatabaseTable, Map<DatabaseField, DatabaseField>> getAdditionalTablePrimaryKeyFields() {
        if (this.additionalTablePrimaryKeyFields == null) {
            this.additionalTablePrimaryKeyFields = new HashMap<DatabaseTable, Map<DatabaseField, DatabaseField>>(5);
        }
        return this.additionalTablePrimaryKeyFields;
    }

    public List<DatabaseField> getAdditionalWritableMapKeyFields() {
        if (this.additionalWritableMapKeyFields == null) {
            this.additionalWritableMapKeyFields = new ArrayList<DatabaseField>(2);
        }
        return this.additionalWritableMapKeyFields;
    }

    public String getAlias() {
        if (this.alias == null && this.getJavaClassName() != null) {
            this.alias = Helper.getShortClassName(this.getJavaClassName());
        }
        return this.alias;
    }

    public List<DatabaseField> getAllFields() {
        return this.allFields;
    }

    public List<DatabaseField> getAllSelectionFields() {
        return this.allSelectionFields;
    }

    public List<DatabaseField> getAllSelectionFields(ObjectLevelReadQuery query) {
        if (this.hasSerializedObjectPolicy() && query.shouldUseSerializedObjectPolicy()) {
            return this.serializedObjectPolicy.getAllSelectionFields();
        }
        return this.allSelectionFields;
    }

    public List<DatabaseField> getReturnFieldsToGenerateInsert() {
        return this.returnFieldsToGenerateInsert;
    }

    public List<DatabaseField> getReturnFieldsToGenerateUpdate() {
        return this.returnFieldsToGenerateUpdate;
    }

    public List<DatabaseField> getReturnFieldsToMergeInsert() {
        return this.returnFieldsToMergeInsert;
    }

    public List<DatabaseField> getReturnFieldsToMergeUpdate() {
        return this.returnFieldsToMergeUpdate;
    }

    public Class<?> getAmendmentClass() {
        return this.amendmentClass;
    }

    public String getAmendmentClassName() {
        if (this.amendmentClassName == null && this.amendmentClass != null) {
            this.amendmentClassName = this.amendmentClass.getName();
        }
        return this.amendmentClassName;
    }

    public String getAmendmentMethodName() {
        return this.amendmentMethodName;
    }

    public List<AttributeAccessor> getAccessorTree() {
        return this.accessorTree;
    }

    public ObjectChangePolicy getObjectChangePolicy() {
        if (this.changePolicy == null) {
            this.changePolicy = new DeferredChangeDetectionPolicy();
        }
        return this.changePolicy;
    }

    public ObjectChangePolicy getObjectChangePolicyInternal() {
        return this.changePolicy;
    }

    public HistoryPolicy getHistoryPolicy() {
        return this.historyPolicy;
    }

    public PartitioningPolicy getPartitioningPolicy() {
        return this.partitioningPolicy;
    }

    public void setPartitioningPolicy(PartitioningPolicy partitioningPolicy) {
        this.partitioningPolicy = partitioningPolicy;
    }

    public String getPartitioningPolicyName() {
        return this.partitioningPolicyName;
    }

    public void setPartitioningPolicyName(String partitioningPolicyName) {
        this.partitioningPolicyName = partitioningPolicyName;
    }

    public Class<? extends CacheInterceptor> getCacheInterceptorClass() {
        return this.getCachePolicy().getCacheInterceptorClass();
    }

    public String getCacheInterceptorClassName() {
        return this.getCachePolicy().getCacheInterceptorClassName();
    }

    public CacheInvalidationPolicy getCacheInvalidationPolicy() {
        if (this.cacheInvalidationPolicy == null) {
            this.cacheInvalidationPolicy = new NoExpiryCacheInvalidationPolicy();
        }
        return this.cacheInvalidationPolicy;
    }

    public int getCacheSynchronizationType() {
        return this.getCachePolicy().getCacheSynchronizationType();
    }

    public List<CascadeLockingPolicy> getCascadeLockingPolicies() {
        if (this.cascadeLockingPolicies == null) {
            this.cascadeLockingPolicies = new ArrayList<CascadeLockingPolicy>();
        }
        return this.cascadeLockingPolicies;
    }

    public List<Class<?>> getConstraintDependencies() {
        if (this.constraintDependencies == null) {
            this.constraintDependencies = new ArrayList(1);
        }
        return this.constraintDependencies;
    }

    public CopyPolicy getCopyPolicy() {
        if (this.copyPolicy == null) {
            if (this.javaClass != null && this.javaClass.isRecord()) {
                this.setCopyPolicy(new RecordCopyPolicy());
            } else {
                this.setCopyPolicy(new InstantiationCopyPolicy());
            }
        }
        return this.copyPolicy;
    }

    public String getCopyPolicyClassName() {
        return this.copyPolicyClassName;
    }

    public DatabaseTable getDefaultTable() {
        return this.defaultTable;
    }

    public int getDescriptorType() {
        return this.descriptorType;
    }

    public String getDescriptorTypeValue() {
        if (this.isAggregateCollectionDescriptor()) {
            return "Aggregate collection";
        }
        if (this.isAggregateDescriptor()) {
            return "Aggregate";
        }
        if (this.isDescriptorForInterface()) {
            return "Interface";
        }
        return "Normal";
    }

    public Collection<DatabaseMapping> getDerivesIdMappinps() {
        return this.derivesIdMappings.values();
    }

    public String getDescriptorCustomizerClassName() {
        return this.descriptorCustomizerClassName;
    }

    public DescriptorEventManager getDescriptorEventManager() {
        return this.getEventManager();
    }

    @Override
    public DescriptorEventManager getEventManager() {
        if (this.eventManager == null) {
            this.setEventManager(new DescriptorEventManager());
        }
        return (DescriptorEventManager)this.eventManager;
    }

    public List<DatabaseField> getFields() {
        if (this.fields == null) {
            this.fields = new ArrayList<DatabaseField>();
        }
        return this.fields;
    }

    public List<DatabaseField> getSelectionFields() {
        return this.selectionFields;
    }

    public List<DatabaseField> getSelectionFields(ObjectLevelReadQuery query) {
        if (this.hasSerializedObjectPolicy() && query.shouldUseSerializedObjectPolicy()) {
            return this.serializedObjectPolicy.getSelectionFields();
        }
        return this.selectionFields;
    }

    public Set<DatabaseField> getForeignKeyValuesForCaching() {
        return this.foreignKeyValuesForCaching;
    }

    public <T extends IdentityMap> Class<T> getIdentityMapClass() {
        return this.getCachePolicy().getIdentityMapClass();
    }

    public int getIdentityMapSize() {
        return this.getCachePolicy().getIdentityMapSize();
    }

    public InheritancePolicy getDescriptorInheritancePolicy() {
        return this.getInheritancePolicy();
    }

    @Override
    public InheritancePolicy getInheritancePolicy() {
        if (this.inheritancePolicy == null) {
            this.setInheritancePolicy(new InheritancePolicy(this));
        }
        return (InheritancePolicy)this.inheritancePolicy;
    }

    public InheritancePolicy getInheritancePolicyOrNull() {
        return (InheritancePolicy)this.inheritancePolicy;
    }

    @Override
    public InstantiationPolicy getInstantiationPolicy() {
        if (this.instantiationPolicy == null) {
            if (this.javaClass != null && this.javaClass.isRecord()) {
                this.setInstantiationPolicy(new RecordInstantiationPolicy(this.javaClass));
            } else {
                this.setInstantiationPolicy(new InstantiationPolicy());
            }
        }
        return (InstantiationPolicy)this.instantiationPolicy;
    }

    public InterfacePolicy getInterfacePolicy() {
        if (this.interfacePolicy == null) {
            this.setInterfacePolicy(new InterfacePolicy(this));
        }
        return this.interfacePolicy;
    }

    public InterfacePolicy getInterfacePolicyOrNull() {
        return this.interfacePolicy;
    }

    @Override
    public <T> Class<T> getJavaClass() {
        return this.javaClass;
    }

    public String getJavaClassName() {
        if (this.javaClassName == null && this.javaClass != null) {
            this.javaClassName = this.javaClass.getName();
        }
        return this.javaClassName;
    }

    public List<DatabaseMapping> getLockableMappings() {
        if (this.lockableMappings == null) {
            this.lockableMappings = new ArrayList<DatabaseMapping>();
        }
        return this.lockableMappings;
    }

    public DatabaseMapping getMappingForAttributeName(String attributeName) {
        for (DatabaseMapping mapping : this.mappings) {
            if (mapping.getAttributeName() == null || !mapping.getAttributeName().equals(attributeName)) continue;
            return mapping;
        }
        return null;
    }

    public DatabaseMapping removeMappingForAttributeName(String attributeName) {
        DatabaseMapping mapping = this.getMappingForAttributeName(attributeName);
        this.getMappings().remove(mapping);
        return mapping;
    }

    public List<DatabaseMapping> getMappings() {
        return this.mappings;
    }

    public List<Association> getMultipleTableForeignKeyAssociations() {
        ArrayList<Association> associations = new ArrayList<Association>(this.getAdditionalTablePrimaryKeyFields().size() * 2);
        for (Map<DatabaseField, DatabaseField> tableHash : this.getAdditionalTablePrimaryKeyFields().values()) {
            for (DatabaseField keyField : tableHash.keySet()) {
                if (!this.getMultipleTableForeignKeys().containsKey(keyField.getTable())) continue;
                Association association = new Association(keyField.getQualifiedName(), tableHash.get(keyField).getQualifiedName());
                associations.add(association);
            }
        }
        return associations;
    }

    public Map<DatabaseTable, Set<DatabaseTable>> getMultipleTableForeignKeys() {
        if (this.multipleTableForeignKeys == null) {
            this.multipleTableForeignKeys = new HashMap<DatabaseTable, Set<DatabaseTable>>(5);
        }
        return this.multipleTableForeignKeys;
    }

    public List<DatabaseTable> getMultipleTableInsertOrder() throws DescriptorException {
        return this.multipleTableInsertOrder;
    }

    public List<Association> getMultipleTablePrimaryKeyAssociations() {
        ArrayList<Association> associations = new ArrayList<Association>(this.getAdditionalTablePrimaryKeyFields().size() * 2);
        for (Map<DatabaseField, DatabaseField> tableHash : this.getAdditionalTablePrimaryKeyFields().values()) {
            for (DatabaseField keyField : tableHash.keySet()) {
                if (this.getMultipleTableForeignKeys().containsKey(keyField.getTable())) continue;
                Association association = new Association(keyField.getQualifiedName(), tableHash.get(keyField).getQualifiedName());
                associations.add(association);
            }
        }
        return associations;
    }

    public MultitenantPolicy getMultitenantPolicy() {
        return this.multitenantPolicy;
    }

    @Override
    public ObjectBuilder getObjectBuilder() {
        return (ObjectBuilder)this.objectBuilder;
    }

    public OptimisticLockingPolicy getOptimisticLockingPolicy() {
        return this.optimisticLockingPolicy;
    }

    public List<DatabaseMapping> getPreDeleteMappings() {
        if (this.preDeleteMappings == null) {
            this.preDeleteMappings = new ArrayList<DatabaseMapping>();
        }
        return this.preDeleteMappings;
    }

    public void addPreDeleteMapping(DatabaseMapping mapping) {
        this.getPreDeleteMappings().add(mapping);
    }

    @Override
    public List<String> getPrimaryKeyFieldNames() {
        ArrayList<String> result = new ArrayList<String>(this.getPrimaryKeyFields().size());
        List<DatabaseField> primaryKeyFields = this.getPrimaryKeyFields();
        for (int index = 0; index < primaryKeyFields.size(); ++index) {
            result.add(primaryKeyFields.get(index).getQualifiedName());
        }
        return result;
    }

    @Override
    public List<DatabaseField> getPrimaryKeyFields() {
        return this.primaryKeyFields;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap(5);
        }
        return this.properties;
    }

    public Object getProperty(String name) {
        return this.getProperties().get(name);
    }

    public QueryKey getQueryKeyNamed(String queryKeyName) {
        return this.getQueryKeys().get(queryKeyName);
    }

    public Map<String, QueryKey> getQueryKeys() {
        return this.queryKeys;
    }

    public DescriptorQueryManager getDescriptorQueryManager() {
        return this.getQueryManager();
    }

    public DescriptorQueryManager getQueryManager() {
        if (this.queryManager == null) {
            this.setQueryManager(new DescriptorQueryManager());
        }
        return this.queryManager;
    }

    public <T extends IdentityMap> Class<T> getRemoteIdentityMapClass() {
        return this.getCachePolicy().getRemoteIdentityMapClass();
    }

    public ClassDescriptor getRootDescriptor() {
        if (this.hasInheritance()) {
            return this.getInheritancePolicy().getRootParentDescriptor();
        }
        return this;
    }

    public int getRemoteIdentityMapSize() {
        return this.getCachePolicy().getRemoteIdentityMapSize();
    }

    public ReturningPolicy getReturningPolicy() {
        return this.returningPolicy;
    }

    public List<ReturningPolicy> getReturningPolicies() {
        return this.returningPolicies;
    }

    public DatabaseField getSequenceNumberField() {
        return this.sequenceNumberField;
    }

    public String getSequenceNumberFieldName() {
        if (this.getSequenceNumberField() == null) {
            return null;
        }
        return this.getSequenceNumberField().getQualifiedName();
    }

    public String getSequenceNumberName() {
        return this.sequenceNumberName;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public DatabaseTable getTable(String tableName) throws DescriptorException {
        DatabaseTable table;
        if (this.hasTablePerMultitenantPolicy() && (table = ((TablePerMultitenantPolicy)this.getMultitenantPolicy()).getTable(tableName)) != null) {
            return table;
        }
        if (this.getTables().isEmpty()) {
            return null;
        }
        for (DatabaseTable table2 : this.getTables()) {
            String currentTableName;
            if (tableName.indexOf(32) != -1 && (currentTableName = table2.getName()).substring(1, currentTableName.length() - 1).equals(tableName)) {
                return table2;
            }
            if (!table2.getName().equals(tableName)) continue;
            return table2;
        }
        if (this.isAggregateDescriptor()) {
            return this.getDefaultTable();
        }
        throw DescriptorException.tableNotPresent(tableName, this);
    }

    public String getTableName() {
        if (this.getTables().isEmpty()) {
            return null;
        }
        return this.getTables().get(0).getName();
    }

    public List<String> getTableNames() {
        ArrayList<String> tableNames = new ArrayList<String>(this.getTables().size());
        for (DatabaseTable table : this.getTables()) {
            tableNames.add(table.getQualifiedName());
        }
        return tableNames;
    }

    public TablePerClassPolicy getTablePerClassPolicy() {
        return (TablePerClassPolicy)this.interfacePolicy;
    }

    public List<DatabaseTable> getTables() {
        return this.tables;
    }

    @Override
    public DatabaseField getTypedField(DatabaseField field) {
        DatabaseField returnField;
        boolean mayBeMoreThanOne = this.hasMultipleTables() && !field.hasTableName();
        DatabaseField foundField = null;
        for (int index = 0; index < this.getFields().size(); ++index) {
            DatabaseField descField = this.getFields().get(index);
            if (!field.equals(descField) || descField.getType() == null) continue;
            foundField = descField;
            if (!mayBeMoreThanOne || descField.getTable().equals(this.getDefaultTable())) break;
        }
        if (foundField == null && this.hasReturningPolicy() && (returnField = this.getReturningPolicy().getField(field)) != null && returnField.getType() != null) {
            foundField = returnField;
        }
        if (foundField != null) {
            foundField = foundField.clone();
            if (!field.hasTableName()) {
                foundField.setTableName("");
            }
        }
        return foundField;
    }

    public WrapperPolicy getWrapperPolicy() {
        return this.wrapperPolicy;
    }

    public boolean hasDependencyOnParts() {
        for (DatabaseMapping mapping : this.getMappings()) {
            if (!mapping.hasDependency()) continue;
            return true;
        }
        return false;
    }

    public boolean hasDerivedId() {
        return !this.derivesIdMappings.isEmpty();
    }

    @Override
    public boolean hasEventManager() {
        return null != this.eventManager;
    }

    @Override
    public boolean hasInheritance() {
        return this.inheritancePolicy != null;
    }

    public boolean hasInterfacePolicy() {
        return this.interfacePolicy != null;
    }

    public boolean hasMultipleTables() {
        return this.getTables().size() > 1;
    }

    public boolean hasNestedIdentityReference(boolean withChildren) {
        if (withChildren && this.hasInheritance() && this.getInheritancePolicy().hasChildren()) {
            for (ClassDescriptor childDescriptor : this.getInheritancePolicy().getAllChildDescriptors()) {
                if (childDescriptor.getInheritancePolicy().hasChildren() || !childDescriptor.hasNestedIdentityReference(false)) continue;
                return true;
            }
        } else {
            for (DatabaseMapping mapping : this.getMappings()) {
                if (!mapping.hasNestedIdentityReference()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasNoncacheableMappings() {
        return this.hasNoncacheableMappings;
    }

    public boolean hasPreDeleteMappings() {
        return this.preDeleteMappings != null;
    }

    public boolean hasPrivatelyOwnedParts() {
        for (DatabaseMapping mapping : this.getMappings()) {
            if (!mapping.isPrivateOwned()) continue;
            return true;
        }
        return false;
    }

    public boolean hasQueryKeyOrMapping(String attributeName) {
        return this.getQueryKeys().containsKey(attributeName) || this.getObjectBuilder().getMappingForAttributeName(attributeName) != null;
    }

    public boolean hasRelationships() {
        return this.hasRelationships;
    }

    public boolean hasRelationshipsExceptBackpointer(ClassDescriptor descriptor) {
        Iterator<DatabaseMapping> i = this.mappings.iterator();
        boolean foundRelationship = false;
        while (i.hasNext()) {
            DatabaseMapping mapping = i.next();
            if (!mapping.isForeignReferenceMapping()) continue;
            ForeignReferenceMapping frMapping = (ForeignReferenceMapping)mapping;
            if (frMapping.getReferenceDescriptor().equals(descriptor)) {
                if (foundRelationship) {
                    return true;
                }
                foundRelationship = true;
                continue;
            }
            return true;
        }
        return false;
    }

    public boolean hasReturningPolicy() {
        return this.returningPolicy != null;
    }

    public boolean hasReturningPolicies() {
        return this.returningPolicies != null;
    }

    public boolean hasSerializedObjectPolicy() {
        return this.serializedObjectPolicy != null;
    }

    public SerializedObjectPolicy getSerializedObjectPolicy() {
        return this.serializedObjectPolicy;
    }

    public void setSerializedObjectPolicy(SerializedObjectPolicy serializedObjectPolicy) {
        this.serializedObjectPolicy = serializedObjectPolicy;
        if (serializedObjectPolicy != null) {
            serializedObjectPolicy.setDescriptor(this);
        }
    }

    public boolean hasWrapperPolicy() {
        return this.wrapperPolicy != null;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        ClassDescriptor parentDescriptor;
        if (this.isInitialized(2) || this.isInvalid()) {
            return;
        }
        this.setInitializationStage(2);
        if (this.isChildDescriptor()) {
            ClassDescriptor parentDescriptor2 = this.getInheritancePolicy().getParentDescriptor();
            parentDescriptor2.initialize(session);
            this.getCachePolicy().initializeFromParent(parentDescriptor2.getCachePolicy(), this, parentDescriptor2, session);
            this.getInheritancePolicy().initializeOptimisticLocking();
            this.getInheritancePolicy().initializeCacheInvalidationPolicy();
            if (parentDescriptor2.hasSerializedObjectPolicy() && !this.hasSerializedObjectPolicy()) {
                this.setSerializedObjectPolicy(parentDescriptor2.getSerializedObjectPolicy().instantiateChild());
            }
        }
        if (this.shouldOrderMappings()) {
            List<DatabaseMapping> mappings = this.getMappings();
            DatabaseMapping[] mappingsArray = new DatabaseMapping[mappings.size()];
            for (int index = 0; index < mappings.size(); ++index) {
                mappingsArray[index] = mappings.get(index);
            }
            Arrays.sort(mappingsArray, new MappingCompare());
            mappings = new ArrayList<DatabaseMapping>(mappingsArray.length);
            mappings.addAll(Arrays.asList(mappingsArray));
            this.setMappings(mappings);
        }
        boolean initializeCascadeLocking = this.usesOptimisticLocking() && this.getOptimisticLockingPolicy().isCascaded() || this.hasCascadeLockingPolicies();
        for (DatabaseMapping mapping : this.getMappings()) {
            ClassDescriptor referencedDescriptor;
            this.validateMappingType(mapping);
            mapping.initialize(session);
            if (!mapping.isCacheable()) {
                this.hasNoncacheableMappings = true;
            }
            if (mapping.isForeignReferenceMapping()) {
                if (((ForeignReferenceMapping)mapping).getIndirectionPolicy() instanceof ProxyIndirectionPolicy) {
                    session.getProject().setHasProxyIndirection(true);
                }
                if ((referencedDescriptor = mapping.getReferenceDescriptor()) != null) {
                    referencedDescriptor.referencingClasses.add(this);
                }
            }
            if (mapping.isAggregateObjectMapping() && (referencedDescriptor = mapping.getReferenceDescriptor()) != null) {
                referencedDescriptor.referencingClasses.add(this);
            }
            if (initializeCascadeLocking) {
                this.prepareCascadeLockingPolicy(mapping);
            }
            if (mapping.derivesId()) {
                this.derivesIdMappings.put(mapping.getAttributeName(), mapping);
            }
            Helper.addAllUniqueToList(this.getFields(), mapping.getFields());
        }
        if (initializeCascadeLocking) {
            this.cascadedLockingInitialized = true;
        }
        if (this.hasMappingsPostCalculateChangesOnDeleted()) {
            session.getProject().setHasMappingsPostCalculateChangesOnDeleted(true);
        }
        if (!this.isAggregateDescriptor()) {
            if (!this.isChildDescriptor() && this.usesOptimisticLocking()) {
                this.getOptimisticLockingPolicy().initializeProperties();
            }
            if (this.hasSerializedObjectPolicy()) {
                this.getSerializedObjectPolicy().initializeField(session);
            }
        }
        for (QueryKey queryKey : this.getQueryKeys().values()) {
            queryKey.initialize(this);
        }
        if (this.getPartitioningPolicyName() != null) {
            PartitioningPolicy policy = session.getProject().getPartitioningPolicy(this.getPartitioningPolicyName());
            if (policy == null) {
                session.getIntegrityChecker().handleError(DescriptorException.missingPartitioningPolicy(this.getPartitioningPolicyName(), this, null));
            }
            this.setPartitioningPolicy(policy);
        }
        if (this.hasInheritance()) {
            this.getInheritancePolicy().initialize(session);
            if (this.getInheritancePolicy().isChildDescriptor()) {
                ClassDescriptor parentDescriptor3 = this.getInheritancePolicy().getParentDescriptor();
                for (DatabaseMapping mapping : parentDescriptor3.getMappings()) {
                    if (mapping.isAggregateObjectMapping() || mapping.isForeignReferenceMapping() && !mapping.isDirectCollectionMapping() && !((ForeignReferenceMapping)mapping).usesIndirection()) {
                        this.getLockableMappings().add(mapping);
                    }
                    if (!mapping.derivesId()) continue;
                    this.derivesIdMappings.put(mapping.getAttributeName(), mapping);
                }
                if (parentDescriptor3.hasPreDeleteMappings()) {
                    this.getPreDeleteMappings().addAll(parentDescriptor3.getPreDeleteMappings());
                }
                if (parentDescriptor3.hasMappingsPostCalculateChanges()) {
                    this.getMappingsPostCalculateChanges().addAll(parentDescriptor3.getMappingsPostCalculateChanges());
                }
                if (parentDescriptor3.hasMappingsPostCalculateChangesOnDeleted()) {
                    this.getMappingsPostCalculateChangesOnDeleted().addAll(parentDescriptor3.getMappingsPostCalculateChangesOnDeleted());
                }
            }
        }
        if (this.hasInheritance() && this.shouldOrderMappings()) {
            List<DatabaseMapping> mappings = this.getMappings();
            DatabaseMapping[] mappingsArray = new DatabaseMapping[mappings.size()];
            for (int index = 0; index < mappings.size(); ++index) {
                mappingsArray[index] = mappings.get(index);
            }
            Arrays.sort(mappingsArray, new MappingCompare());
            mappings = new ArrayList<DatabaseMapping>(mappingsArray.length);
            mappings.addAll(Arrays.asList(mappingsArray));
            this.setMappings(mappings);
        }
        this.setAllFields((List)((ArrayList)this.getFields()).clone());
        this.getObjectBuilder().initialize(session);
        if (this.hasMultitenantPolicy()) {
            this.getMultitenantPolicy().initialize(session);
        }
        if (this.shouldOrderMappings()) {
            for (int index = this.getObjectBuilder().getPrimaryKeyMappings().size() - 1; index >= 0; --index) {
                DatabaseMapping mapping = this.getObjectBuilder().getPrimaryKeyMappings().get(index);
                if (mapping == null || !mapping.isAbstractColumnMapping()) continue;
                this.getMappings().remove(mapping);
                this.getMappings().add(0, mapping);
                DatabaseField field = mapping.getField();
                this.getFields().remove(field);
                this.getFields().add(0, field);
                this.getAllFields().remove(field);
                this.getAllFields().add(0, field);
            }
        }
        if (this.usesOptimisticLocking() && !this.isChildDescriptor()) {
            this.getOptimisticLockingPolicy().initialize(session);
        }
        if (this.hasInterfacePolicy() || this.isDescriptorForInterface()) {
            this.interfaceInitialization(session);
        }
        if (this.hasWrapperPolicy()) {
            this.getWrapperPolicy().initialize(session);
        }
        if (this.hasReturningPolicy()) {
            this.getReturningPolicy().initialize(session);
        }
        if (this.hasSerializedObjectPolicy()) {
            this.getSerializedObjectPolicy().initialize(session);
        }
        this.getQueryManager().initialize(session);
        this.getEventManager().initialize(session);
        this.getCopyPolicy().initialize(session);
        this.getInstantiationPolicy().initialize(session);
        this.getCachePolicy().initialize(this, session);
        if (this.getHistoryPolicy() != null) {
            this.getHistoryPolicy().initialize(session);
        } else if (this.hasInheritance() && (parentDescriptor = this.getInheritancePolicy().getParentDescriptor()) != null && parentDescriptor.getHistoryPolicy() != null) {
            this.setHistoryPolicy((HistoryPolicy)parentDescriptor.getHistoryPolicy().clone());
        }
        if (this.getCMPPolicy() != null) {
            this.getCMPPolicy().initialize(this, session);
        }
        if (this.hasFetchGroupManager()) {
            this.getFetchGroupManager().initialize(session);
        }
        if (this.getObjectChangePolicyInternal() == null && ChangeTracker.class.isAssignableFrom(this.getJavaClass()) && (Arrays.asList(this.getJavaClass().getInterfaces()).contains(PersistenceWeavedChangeTracking.class) || DynamicEntityImpl.class.isAssignableFrom(this.getJavaClass())) && this.supportsChangeTracking(session.getProject())) {
            this.setObjectChangePolicy(new AttributeChangeTrackingPolicy());
        }
        this.getObjectChangePolicy().initialize(session, this);
        if (this.defaultReadAllQueryRedirector == null) {
            this.defaultReadAllQueryRedirector = this.defaultQueryRedirector;
        }
        if (this.defaultReadObjectQueryRedirector == null) {
            this.defaultReadObjectQueryRedirector = this.defaultQueryRedirector;
        }
        if (this.defaultReportQueryRedirector == null) {
            this.defaultReportQueryRedirector = this.defaultQueryRedirector;
        }
        if (this.defaultInsertObjectQueryRedirector == null) {
            this.defaultInsertObjectQueryRedirector = this.defaultQueryRedirector;
        }
        if (this.defaultUpdateObjectQueryRedirector == null) {
            this.defaultUpdateObjectQueryRedirector = this.defaultQueryRedirector;
        }
    }

    public void initialize(DescriptorQueryManager queryManager, AbstractSession session) {
        if (!queryManager.hasReadObjectQuery()) {
            ReadObjectQuery readObjectQuery = new ReadObjectQuery();
            readObjectQuery.setSelectionCriteria(this.getObjectBuilder().getPrimaryKeyExpression());
            queryManager.setReadObjectQuery(readObjectQuery);
        }
        queryManager.getReadObjectQuery().setName("read" + this.getJavaClass().getSimpleName());
        if (!queryManager.hasInsertQuery()) {
            queryManager.setInsertQuery(new InsertObjectQuery());
        }
        queryManager.getInsertQuery().setModifyRow(this.getObjectBuilder().buildTemplateInsertRow(session));
        if (!this.usesFieldLocking()) {
            if (!queryManager.hasDeleteQuery()) {
                queryManager.setDeleteQuery(new DeleteObjectQuery());
            }
            queryManager.getDeleteQuery().setModifyRow(new DatabaseRecord());
        }
        if (queryManager.hasUpdateQuery()) {
            queryManager.getUpdateQuery().setModifyRow(this.getObjectBuilder().buildTemplateUpdateRow(session));
        }
    }

    public void initializeAggregateInheritancePolicy(AbstractSession session) {
        CoreDescriptor parentDescriptor = session.getDescriptor((Class)this.getInheritancePolicy().getParentClass());
        ((ClassDescriptor)parentDescriptor).getInheritancePolicy().addChildDescriptor(this);
    }

    public void initializeMultipleTablePrimaryKeyFields() {
        DatabaseTable table;
        int index;
        boolean isChild;
        int tableSize = this.getTables().size();
        int additionalTablesSize = tableSize - 1;
        boolean bl = isChild = this.hasInheritance() && this.getInheritancePolicy().isChildDescriptor();
        if (isChild) {
            additionalTablesSize = tableSize - this.getInheritancePolicy().getParentDescriptor().getTables().size();
        }
        if (tableSize <= 1) {
            return;
        }
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression joinExpression = this.getQueryManager().getMultipleTableJoinExpression();
        for (index = 1; index < tableSize; ++index) {
            table = this.getTables().get(index);
            Map<DatabaseField, DatabaseField> oldKeyMapping = this.getAdditionalTablePrimaryKeyFields().get(table);
            if (oldKeyMapping != null) {
                if (this.getQueryManager().hasCustomMultipleTableJoinExpression()) continue;
                Expression keyJoinExpression = null;
                for (Map.Entry<DatabaseField, DatabaseField> entry : oldKeyMapping.entrySet()) {
                    DatabaseField sourceTableField = entry.getKey();
                    DatabaseField targetTableField = entry.getValue();
                    if (!this.getFields().contains(sourceTableField)) {
                        this.getFields().add(sourceTableField);
                    }
                    if (!this.getFields().contains(targetTableField)) {
                        this.getFields().add(targetTableField);
                    }
                    keyJoinExpression = builder.getField(targetTableField).equal(builder.getField(sourceTableField)).and(keyJoinExpression);
                }
                if (keyJoinExpression != null) {
                    joinExpression = keyJoinExpression.and(joinExpression);
                }
                this.getQueryManager().getTablesJoinExpressions().put(table, keyJoinExpression);
                continue;
            }
            HashMap<DatabaseField, DatabaseField> newKeyMapping = new HashMap<DatabaseField, DatabaseField>(this.getPrimaryKeyFields().size());
            this.getAdditionalTablePrimaryKeyFields().put(table, newKeyMapping);
            Expression keyJoinExpression = null;
            for (DatabaseField primaryKeyField : this.getPrimaryKeyFields()) {
                DatabaseField secondaryKeyField = primaryKeyField.clone();
                secondaryKeyField.setTable(table);
                newKeyMapping.put(primaryKeyField, secondaryKeyField);
                this.getFields().add(this.buildField(secondaryKeyField));
                if (this.getQueryManager().hasCustomMultipleTableJoinExpression()) continue;
                keyJoinExpression = builder.getField(secondaryKeyField).equal(builder.getField(primaryKeyField)).and(keyJoinExpression);
            }
            if (keyJoinExpression != null) {
                joinExpression = keyJoinExpression.and(joinExpression);
            }
            this.getQueryManager().getTablesJoinExpressions().put(table, keyJoinExpression);
        }
        if (joinExpression != null) {
            this.getQueryManager().setInternalMultipleTableJoinExpression(joinExpression);
        }
        if (this.getQueryManager().hasCustomMultipleTableJoinExpression()) {
            Map<DatabaseTable, Expression> tablesJoinExpressions = SQLSelectStatement.mapTableToExpression(joinExpression, this.getTables());
            this.getQueryManager().getTablesJoinExpressions().putAll(tablesJoinExpressions);
        }
        if (isChild && additionalTablesSize > 0) {
            for (index = tableSize - additionalTablesSize; index < tableSize; ++index) {
                table = this.getTables().get(index);
                this.getInheritancePolicy().addChildTableJoinExpressionToAllParents(table, this.getQueryManager().getTablesJoinExpressions().get(table));
            }
        }
    }

    protected void initializeProperties(AbstractSession session) throws DescriptorException {
        if (!this.isAggregateDescriptor()) {
            if (!this.isChildDescriptor()) {
                for (int index = 0; index < this.getPrimaryKeyFields().size(); ++index) {
                    DatabaseField primaryKey = this.getPrimaryKeyFields().get(index);
                    primaryKey = this.buildField(primaryKey);
                    primaryKey.setPrimaryKey(true);
                    this.getPrimaryKeyFields().set(index, primaryKey);
                }
                ArrayList pkFields = (ArrayList)this.getPrimaryKeyFields();
                if (!pkFields.isEmpty()) {
                    List primaryKeyFields = (List)pkFields.clone();
                    for (int index = 0; index < primaryKeyFields.size(); ++index) {
                        DatabaseField primaryKey = (DatabaseField)primaryKeyFields.get(index);
                        if (primaryKey.getTable().equals(this.getDefaultTable())) continue;
                        this.getPrimaryKeyFields().remove(primaryKey);
                    }
                }
            }
            if (this.getSequenceNumberField() != null) {
                this.setSequenceNumberField(this.buildField(this.getSequenceNumberField()));
            }
        }
        this.setSessionName(session.getName());
    }

    public void interfaceInitialization(AbstractSession session) throws DescriptorException {
        if (this.isInterfaceInitialized(2)) {
            return;
        }
        this.setInterfaceInitializationStage(2);
        if (this.isInterfaceChildDescriptor()) {
            for (Class<?> parentInterface : this.getInterfacePolicy().getParentInterfaces()) {
                CoreDescriptor parentDescriptor = session.getDescriptor((Class)parentInterface);
                ((ClassDescriptor)parentDescriptor).interfaceInitialization(session);
                if (this.isDescriptorForInterface()) {
                    this.setQueryKeys(Helper.concatenateMaps(this.getQueryKeys(), ((ClassDescriptor)parentDescriptor).getQueryKeys()));
                } else {
                    for (String queryKeyName : ((ClassDescriptor)parentDescriptor).getQueryKeys().keySet()) {
                        if (this.hasQueryKeyOrMapping(queryKeyName)) continue;
                        session.getIntegrityChecker().handleError(DescriptorException.childDoesNotDefineAbstractQueryKeyOfParent(this, (ClassDescriptor)parentDescriptor, queryKeyName));
                    }
                }
                if (parentDescriptor != this) continue;
                return;
            }
        }
        this.getInterfacePolicy().initialize(session);
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.getJavaClass().getModifiers());
    }

    public boolean isAggregateCollectionDescriptor() {
        return this.descriptorType == 3;
    }

    public boolean isAggregateDescriptor() {
        return this.descriptorType == 2;
    }

    public boolean isChildDescriptor() {
        return this.hasInheritance() && this.getInheritancePolicy().isChildDescriptor();
    }

    public boolean isEISDescriptor() {
        return false;
    }

    public boolean isObjectRelationalDataTypeDescriptor() {
        return false;
    }

    public boolean isXMLDescriptor() {
        return false;
    }

    public boolean isRelationalDescriptor() {
        return false;
    }

    public boolean isDescriptorForInterface() {
        return this.descriptorType == 1;
    }

    public boolean isDescriptorTypeAggregate() {
        return this.descriptorType == 3 || this.descriptorType == 2;
    }

    public boolean isDescriptorTypeNormal() {
        return this.descriptorType == 0;
    }

    public boolean isFullyInitialized() {
        return this.initializationStage == 3;
    }

    protected boolean isInitialized(int initializationStage) {
        return this.initializationStage >= initializationStage;
    }

    public boolean isInterfaceChildDescriptor() {
        return this.hasInterfacePolicy() && this.getInterfacePolicy().isInterfaceChildDescriptor();
    }

    protected boolean isInterfaceInitialized(int interfaceInitializationStage) {
        return this.interfaceInitializationStage >= interfaceInitializationStage;
    }

    public boolean isInvalid() {
        return this.initializationStage == -1;
    }

    public boolean isIsolated() {
        return this.getCachePolicy().isIsolated();
    }

    public boolean isProtectedIsolation() {
        return this.getCachePolicy().isProtectedIsolation();
    }

    public boolean isSharedIsolation() {
        return this.getCachePolicy().isSharedIsolation();
    }

    public boolean isMultipleTableDescriptor() {
        return this.getTables().size() > 1;
    }

    public boolean isPrimaryKeySetAfterInsert(AbstractSession session) {
        return this.usesSequenceNumbers() && this.getSequence().shouldAcquireValueAfterInsert() || this.hasReturningPolicy() && this.getReturningPolicy().isUsedToSetPrimaryKey();
    }

    public boolean shouldLockForClone() {
        return this.shouldLockForClone;
    }

    public boolean shouldUseFullChangeSetsForNewObjects() {
        return this.getCachePolicy().getCacheSynchronizationType() == 3 || shouldUseFullChangeSetsForNewObjects;
    }

    public void onlyRefreshCacheIfNewerVersion() {
        this.setShouldOnlyRefreshCacheIfNewerVersion(true);
    }

    public void postInitialize(AbstractSession session) throws DescriptorException {
        if (this.getHistoryPolicy() != null) {
            session.getProject().setHasGenericHistorySupport(true);
        }
        if (this.isInitialized(3) || this.isInvalid()) {
            return;
        }
        this.setInitializationStage(3);
        if (this.hasInheritance()) {
            for (ClassDescriptor child : this.getInheritancePolicy().getChildDescriptors()) {
                child.postInitialize(session);
            }
        }
        for (DatabaseMapping mapping : this.getMappings()) {
            mapping.postInitialize(session);
            if (!this.shouldAcquireCascadedLocks()) {
                if (mapping.isForeignReferenceMapping()) {
                    if (!((ForeignReferenceMapping)mapping).usesIndirection()) {
                        this.setShouldAcquireCascadedLocks(true);
                    }
                    this.hasRelationships = true;
                }
                if (mapping.isAggregateObjectMapping()) {
                    if (mapping.getReferenceDescriptor().shouldAcquireCascadedLocks()) {
                        this.setShouldAcquireCascadedLocks(true);
                    }
                    if (mapping.getReferenceDescriptor().hasRelationships()) {
                        this.hasRelationships = true;
                    }
                }
            }
            if (this.getCachePolicy().isProtectedIsolation() && (mapping.isForeignReferenceMapping() && !mapping.isCacheable() || mapping.isAggregateObjectMapping() && mapping.getReferenceDescriptor().hasNoncacheableMappings())) {
                mapping.collectQueryParameters(this.foreignKeyValuesForCaching);
            }
            if (!mapping.isLockableMapping()) continue;
            this.getLockableMappings().add(mapping);
        }
        if (this.hasInheritance()) {
            this.getInheritancePolicy().postInitialize(session);
        }
        for (int index = this.getPrimaryKeyFields().size() - 1; index >= 0; --index) {
            DatabaseField primaryKeyField = this.getPrimaryKeyFields().get(index);
            int fieldIndex = this.getFields().indexOf(primaryKeyField);
            if (fieldIndex == -1) continue;
            primaryKeyField = this.getFields().get(fieldIndex);
            this.getPrimaryKeyFields().set(index, primaryKeyField);
            primaryKeyField.setPrimaryKey(true);
        }
        List<DatabaseField> sopSelectionFields = null;
        if (this.hasSerializedObjectPolicy()) {
            this.getSerializedObjectPolicy().postInitialize(session);
            this.selectionFields = (List)((ArrayList)this.getFields()).clone();
            this.selectionFields.remove(this.getSerializedObjectPolicy().getField());
            this.allSelectionFields = (List)((ArrayList)this.getAllFields()).clone();
            this.allSelectionFields.remove(this.getSerializedObjectPolicy().getField());
            sopSelectionFields = this.getSerializedObjectPolicy().getSelectionFields();
            if (sopSelectionFields.size() == this.getFields().size()) {
                sopSelectionFields = null;
            }
        } else {
            this.selectionFields = this.getFields();
            this.allSelectionFields = this.getAllFields();
        }
        for (int index = 0; index < this.getFields().size(); ++index) {
            int sopFieldIndex;
            DatabaseMapping mapping;
            DatabaseField field = this.getFields().get(index);
            if (field.getType() == null && (mapping = this.getObjectBuilder().getMappingForField(field)) != null) {
                field.setType(mapping.getFieldClassification(field));
            }
            if (field.getType() == ClassConstants.BLOB || field.getType() == ClassConstants.CLOB) {
                this.setHasMultipleTableConstraintDependecy(true);
            }
            field.setIndex(index);
            if (sopSelectionFields == null || (sopFieldIndex = sopSelectionFields.indexOf(field)) == -1) continue;
            field.setIndex(sopFieldIndex);
        }
        for (DatabaseMapping mapping : this.getMappings()) {
            mapping.postInitializeSourceAndTargetExpressions();
        }
        if (this.getCachePolicy().getCacheKeyType() == null || this.getCachePolicy().getCacheKeyType() == CacheKeyType.AUTO) {
            if (this.getPrimaryKeyFields().size() > 1 || this.getObjectBuilder().isXMLObjectBuilder()) {
                this.setCacheKeyType(CacheKeyType.CACHE_ID);
            } else if (this.getPrimaryKeyFields().size() == 1 && this.getObjectBuilder().getPrimaryKeyClassifications().size() == 1) {
                Class<?> type2 = this.getObjectBuilder().getPrimaryKeyClassifications().get(0);
                if (type2 == null || type2.isArray()) {
                    this.getCachePolicy().setCacheKeyType(CacheKeyType.CACHE_ID);
                } else {
                    this.getCachePolicy().setCacheKeyType(CacheKeyType.ID_VALUE);
                }
            } else {
                this.getCachePolicy().setCacheKeyType(CacheKeyType.CACHE_ID);
            }
        } else if (this.getCachePolicy().getCacheKeyType() == CacheKeyType.ID_VALUE && this.getPrimaryKeyFields().size() > 1) {
            session.getIntegrityChecker().handleError(DescriptorException.cannotUseIdValueForCompositeId(this));
        }
        if (this.hasFetchGroupManager()) {
            this.getFetchGroupManager().postInitialize(session);
        }
        this.getObjectBuilder().postInitialize(session);
        this.getQueryManager().postInitialize(session);
        if (this.hasMultitenantPolicy()) {
            this.getMultitenantPolicy().postInitialize(session);
        }
        this.getCachePolicy().postInitialize(this, session);
        this.postInitializeReturningPolicies();
        this.validateAfterInitialization(session);
        this.checkDatabase(session);
    }

    private void postInitializeReturningPolicies() {
        ArrayList<ReturningPolicy> returningPolicies = new ArrayList<ReturningPolicy>();
        if (this.hasReturningPolicy()) {
            returningPolicies.add(this.getReturningPolicy());
        }
        this.browseReturningPolicies(returningPolicies, this.getMappings());
        if (!returningPolicies.isEmpty()) {
            this.returningPolicies = returningPolicies;
            this.prepareReturnFields(returningPolicies);
        }
    }

    private void browseReturningPolicies(List<ReturningPolicy> returningPolicies, List<DatabaseMapping> mappings) {
        for (DatabaseMapping databaseMapping : mappings) {
            ClassDescriptor referenceDescriptor;
            if (!databaseMapping.isAggregateObjectMapping() || (referenceDescriptor = databaseMapping.getReferenceDescriptor()) == null) continue;
            this.browseReturningPolicies(returningPolicies, referenceDescriptor.getMappings());
            if (!referenceDescriptor.hasReturningPolicy()) continue;
            returningPolicies.add(referenceDescriptor.getReturningPolicy());
        }
    }

    private void prepareReturnFields(List<ReturningPolicy> returningPolicies) {
        ArrayList<DatabaseField> returnFieldsInsert = new ArrayList<DatabaseField>();
        ArrayList<DatabaseField> returnFieldsUpdate = new ArrayList<DatabaseField>();
        ArrayList<DatabaseField> returnFieldsToMergeInsert = new ArrayList<DatabaseField>();
        ArrayList<DatabaseField> returnFieldsToMergeUpdate = new ArrayList<DatabaseField>();
        for (ReturningPolicy returningPolicy : returningPolicies) {
            Collection<DatabaseField> tmpFields = returningPolicy.getFieldsToGenerateInsert(this.defaultTable);
            if (tmpFields != null) {
                returnFieldsInsert.addAll(tmpFields);
            }
            if ((tmpFields = returningPolicy.getFieldsToGenerateUpdate(this.defaultTable)) != null) {
                returnFieldsUpdate.addAll(tmpFields);
            }
            if ((tmpFields = returningPolicy.getFieldsToMergeInsert()) != null) {
                returnFieldsToMergeInsert.addAll(tmpFields);
            }
            if ((tmpFields = returningPolicy.getFieldsToMergeUpdate()) == null) continue;
            returnFieldsToMergeUpdate.addAll(tmpFields);
        }
        this.returnFieldsToGenerateInsert = returnFieldsInsert.isEmpty() ? null : returnFieldsInsert;
        this.returnFieldsToGenerateUpdate = returnFieldsUpdate.isEmpty() ? null : returnFieldsUpdate;
        this.returnFieldsToMergeInsert = returnFieldsToMergeInsert.isEmpty() ? null : returnFieldsToMergeInsert;
        this.returnFieldsToMergeUpdate = returnFieldsToMergeUpdate.isEmpty() ? null : returnFieldsToMergeUpdate;
    }

    public void notifyReferencingDescriptorsOfIsolation(AbstractSession session) {
        for (ClassDescriptor descriptor : this.referencingClasses) {
            if (descriptor.getCachePolicy().getCacheIsolation() != null && descriptor.getCachePolicy().getCacheIsolation() != CacheIsolationType.SHARED) continue;
            descriptor.getCachePolicy().setCacheIsolation(CacheIsolationType.PROTECTED);
            descriptor.getCachePolicy().postInitialize(descriptor, session);
            for (DatabaseMapping mapping : descriptor.getMappings()) {
                if (!mapping.isAggregateMapping() || mapping.getReferenceDescriptor() == null) continue;
                mapping.getReferenceDescriptor().getCachePolicy().setCacheIsolation(CacheIsolationType.PROTECTED);
            }
        }
    }

    public void preInitialize(AbstractSession session) throws DescriptorException {
        if (this.isInitialized(1)) {
            return;
        }
        this.setInitializationStage(1);
        this.assignDefaultValues(session);
        if (this.isCascadeOnDeleteSetOnDatabaseOnSecondaryTables && !session.getPlatform().supportsDeleteOnCascade()) {
            this.isCascadeOnDeleteSetOnDatabaseOnSecondaryTables = false;
        }
        if (FetchGroupTracker.class.isAssignableFrom(this.getJavaClass()) && this.getFetchGroupManager() == null && !this.isAggregateDescriptor()) {
            this.setFetchGroupManager(new FetchGroupManager());
        }
        if (Arrays.asList(this.getJavaClass().getInterfaces()).contains(PersistenceObject.class)) {
            boolean isMethodAccess = false;
            for (DatabaseMapping mapping : this.getMappings()) {
                if (mapping.isUsingMethodAccess()) {
                    if (mapping.isOneToOneMapping() && ((ForeignReferenceMapping)mapping).usesIndirection()) continue;
                    isMethodAccess = true;
                    continue;
                }
                if (mapping.isWriteOnly()) continue;
                mapping.setAttributeAccessor(new PersistenceObjectAttributeAccessor(mapping.getAttributeName()));
            }
            if (!isMethodAccess) {
                if (this.copyPolicy == null) {
                    if (this.javaClass != null && this.javaClass.isRecord()) {
                        this.setCopyPolicy(new RecordCopyPolicy());
                    } else {
                        this.setCopyPolicy(new PersistenceEntityCopyPolicy());
                    }
                }
                if (!this.isAbstract()) {
                    try {
                        if (this.instantiationPolicy == null) {
                            if (this.javaClass != null && this.javaClass.isRecord()) {
                                this.setInstantiationPolicy(new RecordInstantiationPolicy(this.javaClass));
                            } else {
                                this.setInstantiationPolicy(new PersistenceObjectInstantiationPolicy((PersistenceObject)this.getJavaClass().getConstructor(new Class[0]).newInstance(new Object[0])));
                            }
                        }
                    }
                    catch (Exception iterator) {
                        // empty catch block
                    }
                }
            }
        }
        for (DatabaseTable next : this.getTables()) {
            if (next.getName().indexOf(32) == -1) continue;
            next.setUseDelimiters(true);
        }
        for (DatabaseMapping mapping : this.getMappings()) {
            try {
                mapping.preInitialize(session);
            }
            catch (DescriptorException exception) {
                session.getIntegrityChecker().handleError(exception);
            }
        }
        this.validateBeforeInitialization(session);
        this.preInitializeInheritancePolicy(session);
        if (this.hasInheritance()) {
            this.getInheritancePolicy().preInitialize(session);
        } else {
            this.setInternalDefaultTable();
        }
        if (this.hasMultitenantPolicy()) {
            this.getMultitenantPolicy().preInitialize(session);
        }
        this.verifyTableQualifiers(session.getDatasourcePlatform());
        this.initializeProperties(session);
        if (!this.isAggregateDescriptor()) {
            this.adjustMultipleTableInsertOrder();
            this.initializeMultipleTablePrimaryKeyFields();
        }
        if (this.hasInterfacePolicy()) {
            this.preInterfaceInitialization(session);
        }
        this.getQueryManager().preInitialize(session);
    }

    protected void prepareCascadeLockingPolicy(DatabaseMapping mapping) {
        if (mapping.isPrivateOwned() && mapping.isForeignReferenceMapping()) {
            if (mapping.isCascadedLockingSupported()) {
                if (((ForeignReferenceMapping)mapping).hasCustomSelectionQuery()) {
                    throw ValidationException.unsupportedCascadeLockingMappingWithCustomQuery(mapping);
                }
                if (this.isDescriptorTypeAggregate()) {
                    throw ValidationException.unsupportedCascadeLockingDescriptor(this);
                }
                mapping.prepareCascadeLockingPolicy();
            } else {
                throw ValidationException.unsupportedCascadeLockingMapping(mapping);
            }
        }
    }

    protected void preInitializeInheritancePolicy(AbstractSession session) throws DescriptorException {
        if (this.isChildDescriptor() && this.requiresInitialization(session)) {
            if (this.getInheritancePolicy().getParentClass().equals(this.getJavaClass())) {
                this.setInterfaceInitializationStage(-1);
                throw DescriptorException.parentClassIsSelf(this);
            }
            CoreDescriptor parentDescriptor = session.getDescriptor((Class)this.getInheritancePolicy().getParentClass());
            ((ClassDescriptor)parentDescriptor).getInheritancePolicy().addChildDescriptor(this);
            this.getInheritancePolicy().setParentDescriptor((ClassDescriptor)parentDescriptor);
            ((ClassDescriptor)parentDescriptor).preInitialize(session);
        }
    }

    public void preInterfaceInitialization(AbstractSession session) throws DescriptorException {
        if (this.isInterfaceInitialized(1)) {
            return;
        }
        this.setInterfaceInitializationStage(1);
        this.assignDefaultValues(session);
        if (this.isInterfaceChildDescriptor()) {
            for (Class<?> parentInterface : this.getInterfacePolicy().getParentInterfaces()) {
                CoreDescriptor parentDescriptor = session.getDescriptor((Class)parentInterface);
                if (parentDescriptor == null || ((ClassDescriptor)parentDescriptor).getJavaClass() == this.getJavaClass() || ((ClassDescriptor)parentDescriptor).getInterfacePolicy().usesImplementorDescriptor()) {
                    session.getProject().getDescriptors().put(parentInterface, this);
                    session.clearLastDescriptorAccessed();
                    continue;
                }
                if (!((ClassDescriptor)parentDescriptor).isDescriptorForInterface()) {
                    throw DescriptorException.descriptorForInterfaceIsMissing(parentInterface.getName());
                }
                ((ClassDescriptor)parentDescriptor).preInterfaceInitialization(session);
                ((ClassDescriptor)parentDescriptor).getInterfacePolicy().addChildDescriptor(this);
                this.getInterfacePolicy().addParentDescriptor((ClassDescriptor)parentDescriptor);
            }
        }
    }

    public void rehashFieldDependancies(AbstractSession session) {
        this.getObjectBuilder().rehashFieldDependancies(session);
        for (DatabaseMapping mapping : this.getMappings()) {
            mapping.rehashFieldDependancies(session);
        }
    }

    public void reInitializeJoinedAttributes() {
        if (!this.isInitialized(3)) {
            return;
        }
        this.getObjectBuilder().initializeJoinedAttributes();
        if (this.hasInheritance()) {
            for (ClassDescriptor child : this.getInheritancePolicy().getChildDescriptors()) {
                child.reInitializeJoinedAttributes();
            }
        }
    }

    public void remoteInitialization(DistributedSession session) {
        if (this.getHistoryPolicy() != null) {
            session.getProject().setHasGenericHistorySupport(true);
        }
        if (!this.getCachePolicy().isSharedIsolation()) {
            session.getProject().setHasIsolatedClasses(true);
        }
        if (!this.getCachePolicy().shouldIsolateObjectsInUnitOfWork() && !this.shouldBeReadOnly()) {
            session.getProject().setHasNonIsolatedUOWClasses(true);
        }
        for (DatabaseMapping mapping : this.getMappings()) {
            mapping.remoteInitialization(session);
        }
        this.getEventManager().remoteInitialization(session);
        this.getInstantiationPolicy().initialize(session);
        this.getCopyPolicy().initialize(session);
        if (this.hasInheritance()) {
            this.getInheritancePolicy().remoteInitialization(session);
        }
        if (this.getCMPPolicy() != null) {
            this.getCMPPolicy().remoteInitialize(this, session);
        }
    }

    public void removeProperty(String property) {
        this.getProperties().remove(property);
    }

    public boolean requiresInitialization(AbstractSession session) {
        if (this.isDescriptorTypeAggregate() || this.isDescriptorForInterface()) {
            return false;
        }
        if (this.hasTablePerMultitenantPolicy()) {
            return ((TablePerMultitenantPolicy)this.getMultitenantPolicy()).shouldInitialize(session);
        }
        return true;
    }

    protected void selfValidationAfterInitialization(AbstractSession session) throws DescriptorException {
        if (!(this.hasInheritance() && (this.getInheritancePolicy().shouldReadSubclasses() || this.isAbstract()) || this.hasTablePerClassPolicy() && this.isAbstract() || !session.getIntegrityChecker().shouldCheckInstantiationPolicy())) {
            this.getInstantiationPolicy().buildNewInstance();
        }
        if (this.hasReturningPolicy()) {
            this.getReturningPolicy().validationAfterDescriptorInitialization(session);
        }
        this.getObjectBuilder().validate(session);
    }

    protected void selfValidationBeforeInitialization(AbstractSession session) throws DescriptorException {
        if (this.isChildDescriptor()) {
            CoreDescriptor parentDescriptor = session.getDescriptor((Class)this.getInheritancePolicy().getParentClass());
            if (parentDescriptor == null) {
                session.getIntegrityChecker().handleError(DescriptorException.parentDescriptorNotSpecified(this.getInheritancePolicy().getParentClass().getName(), this));
            }
        } else if (this.getTables().isEmpty() && !this.isAggregateDescriptor()) {
            session.getIntegrityChecker().handleError(DescriptorException.tableNotSpecified(this));
        }
        if (!this.isChildDescriptor() && !this.isDescriptorTypeAggregate() && this.getPrimaryKeyFieldNames().isEmpty()) {
            session.getIntegrityChecker().handleError(DescriptorException.primaryKeyFieldsNotSepcified(this));
        }
        if (ClassConstants.NoIdentityMap_Class.equals(this.getIdentityMapClass()) && this.getQueryManager().getDoesExistQuery().shouldCheckCacheForDoesExist()) {
            session.getIntegrityChecker().handleError(DescriptorException.identityMapNotSpecified(this));
        }
        if (this.getSequenceNumberName() != null && this.getSequenceNumberField() == null || this.getSequenceNumberName() == null && this.getSequenceNumberField() != null) {
            session.getIntegrityChecker().handleError(DescriptorException.sequenceNumberPropertyNotSpecified(this));
        }
    }

    protected void setAdditionalTablePrimaryKeyFields(DatabaseTable table, DatabaseField field1, DatabaseField field2) {
        Map tableAdditionalPKFields = this.getAdditionalTablePrimaryKeyFields().computeIfAbsent(table, k -> new HashMap(2));
        tableAdditionalPKFields.put(field1, field2);
    }

    protected void toggleAdditionalTablePrimaryKeyFields() {
        if (this.additionalTablePrimaryKeyFields == null) {
            return;
        }
        int nProcessedTables = 1;
        if (this.isChildDescriptor()) {
            nProcessedTables = this.getInheritancePolicy().getParentDescriptor().getTables().size();
            if (this.getTables().size() > nProcessedTables) {
                ++nProcessedTables;
            }
        }
        Map<DatabaseTable, Map<DatabaseField, DatabaseField>> additionalTablePrimaryKeyFieldsOld = this.additionalTablePrimaryKeyFields;
        this.additionalTablePrimaryKeyFields = null;
        for (Map.Entry<DatabaseTable, Map<DatabaseField, DatabaseField>> entryTable : additionalTablePrimaryKeyFieldsOld.entrySet()) {
            DatabaseTable sourceTable = entryTable.getKey();
            boolean isSourceProcessed = this.getTables().indexOf(sourceTable) < nProcessedTables;
            int sourceInsertOrderIndex = this.getMultipleTableInsertOrder().indexOf(sourceTable);
            Map<DatabaseField, DatabaseField> targetTableAdditionalPKFields = entryTable.getValue();
            for (Map.Entry<DatabaseField, DatabaseField> entryField : targetTableAdditionalPKFields.entrySet()) {
                DatabaseField targetField = entryField.getKey();
                DatabaseField sourceField = entryField.getValue();
                DatabaseTable targetTable = targetField.getTable();
                boolean isTargetProcessed = this.getTables().indexOf(targetTable) < nProcessedTables;
                int targetInsertOrderIndex = this.getMultipleTableInsertOrder().indexOf(targetTable);
                if (!isTargetProcessed && (isSourceProcessed || sourceInsertOrderIndex > targetInsertOrderIndex)) {
                    this.setAdditionalTablePrimaryKeyFields(targetTable, sourceField, targetField);
                    continue;
                }
                this.setAdditionalTablePrimaryKeyFields(sourceTable, targetField, sourceField);
            }
        }
    }

    public void setAdditionalTablePrimaryKeyFields(Map<DatabaseTable, Map<DatabaseField, DatabaseField>> additionalTablePrimaryKeyFields) {
        this.additionalTablePrimaryKeyFields = additionalTablePrimaryKeyFields;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    protected void setAllFields(List<DatabaseField> allFields) {
        this.allFields = allFields;
    }

    public void setAmendmentClass(Class<?> amendmentClass) {
        this.amendmentClass = amendmentClass;
    }

    public void setAmendmentClassName(String amendmentClassName) {
        this.amendmentClassName = amendmentClassName;
    }

    public void setAmendmentMethodName(String amendmentMethodName) {
        this.amendmentMethodName = amendmentMethodName;
    }

    public void setAccessorTree(List<AttributeAccessor> accessorTree) {
        this.accessorTree = accessorTree;
    }

    public void setCacheSynchronizationType(int type2) {
        this.getCachePolicy().setCacheSynchronizationType(type2);
    }

    public void setObjectChangePolicy(ObjectChangePolicy policy) {
        this.changePolicy = policy;
    }

    public void setHistoryPolicy(HistoryPolicy policy) {
        this.historyPolicy = policy;
        if (policy != null) {
            policy.setDescriptor(this);
        }
    }

    public void setCacheInterceptorClass(Class<? extends CacheInterceptor> cacheInterceptorClass) {
        this.getCachePolicy().setCacheInterceptorClass(cacheInterceptorClass);
    }

    public void setCacheInterceptorClassName(String cacheInterceptorClassName) {
        this.getCachePolicy().setCacheInterceptorClassName(cacheInterceptorClassName);
    }

    public void setCacheInvalidationPolicy(CacheInvalidationPolicy policy) {
        this.cacheInvalidationPolicy = policy;
    }

    public void setConstraintDependencies(List<Class<?>> constraintDependencies) {
        this.constraintDependencies = constraintDependencies;
    }

    public void setCopyPolicy(CopyPolicy policy) {
        this.copyPolicy = policy;
        if (policy != null) {
            policy.setDescriptor(this);
        }
    }

    public void setCopyPolicyClassName(String className) {
        this.copyPolicyClassName = className;
    }

    public void setDefaultTable(DatabaseTable defaultTable) {
        this.defaultTable = defaultTable;
    }

    public void setDefaultTableName(String defaultTableName) {
        this.setDefaultTable(new DatabaseTable(defaultTableName));
    }

    public void setDescriptorCustomizerClassName(String descriptorCustomizerClassName) {
        this.descriptorCustomizerClassName = descriptorCustomizerClassName;
    }

    public void setDescriptorType(int descriptorType) {
        this.descriptorType = descriptorType;
    }

    public void setDescriptorTypeValue(String value) {
        switch (value) {
            case "Aggregate collection": {
                this.descriptorIsAggregateCollection();
                break;
            }
            case "Aggregate": {
                this.descriptorIsAggregate();
                break;
            }
            case "Interface": {
                this.descriptorIsForInterface();
                break;
            }
            default: {
                this.descriptorIsNormal();
            }
        }
    }

    @Override
    public void setEventManager(DescriptorEventManager eventManager) {
        this.eventManager = eventManager;
        if (eventManager != null) {
            eventManager.setDescriptor(this);
        }
    }

    public void setExistenceChecking(String token) throws DescriptorException {
        this.getQueryManager().setExistenceCheck(token);
    }

    public void setFields(List<DatabaseField> fields) {
        this.fields = fields;
    }

    public void setForeignKeyFieldNamesForMultipleTable(List<Association> associations) throws DescriptorException {
        for (Association association : associations) {
            this.addForeignKeyFieldNameForMultipleTable((String)association.getKey(), (String)association.getValue());
        }
    }

    public void setFullyMergeEntity(boolean fullyMergeEntity) {
        this.getCachePolicy().setFullyMergeEntity(fullyMergeEntity);
    }

    public void setIdentityMapClass(Class<? extends IdentityMap> theIdentityMapClass) {
        this.getCachePolicy().setIdentityMapClass(theIdentityMapClass);
    }

    public void setIdentityMapSize(int identityMapSize) {
        this.getCachePolicy().setIdentityMapSize(identityMapSize);
    }

    @Override
    public void setInheritancePolicy(InheritancePolicy inheritancePolicy) {
        this.inheritancePolicy = inheritancePolicy;
        if (inheritancePolicy != null) {
            inheritancePolicy.setDescriptor(this);
        }
    }

    public void setReturningPolicy(ReturningPolicy returningPolicy) {
        this.returningPolicy = returningPolicy;
        if (returningPolicy != null) {
            returningPolicy.setDescriptor(this);
        }
    }

    protected void setInitializationStage(int initializationStage) {
        this.initializationStage = initializationStage;
    }

    @Override
    public void setInstantiationPolicy(InstantiationPolicy instantiationPolicy) {
        this.instantiationPolicy = instantiationPolicy;
        if (instantiationPolicy != null) {
            instantiationPolicy.setDescriptor(this);
        }
    }

    protected void setInterfaceInitializationStage(int interfaceInitializationStage) {
        this.interfaceInitializationStage = interfaceInitializationStage;
    }

    public void setInterfacePolicy(InterfacePolicy interfacePolicy) {
        this.interfacePolicy = interfacePolicy;
        if (interfacePolicy != null) {
            interfacePolicy.setDescriptor(this);
        }
    }

    public void setInternalDefaultTable() {
        if (this.getDefaultTable() == null) {
            this.setDefaultTable(this.extractDefaultTable());
        }
    }

    public void setInternalDefaultTable(DatabaseTable defaultTable) {
        if (this.getDefaultTable() == null) {
            this.setDefaultTable(defaultTable);
        }
    }

    public void setCacheable(Boolean cacheable) {
        this.getCachePolicy().setCacheable(cacheable);
    }

    public CacheIsolationType getCacheIsolation() {
        return this.getCachePolicy().getCacheIsolation();
    }

    public void setCacheIsolation(CacheIsolationType isolationType) {
        this.getCachePolicy().setCacheIsolation(isolationType);
    }

    public boolean shouldIsolateObjectsInUnitOfWork() {
        return this.getCachePolicy().shouldIsolateObjectsInUnitOfWork();
    }

    public boolean shouldIsolateProtectedObjectsInUnitOfWork() {
        return this.getCachePolicy().shouldIsolateProtectedObjectsInUnitOfWork();
    }

    public boolean shouldIsolateObjectsInUnitOfWorkEarlyTransaction() {
        return this.getCachePolicy().shouldIsolateObjectsInUnitOfWorkEarlyTransaction();
    }

    public boolean shouldUseSessionCacheInUnitOfWorkEarlyTransaction() {
        return this.getCachePolicy().shouldUseSessionCacheInUnitOfWorkEarlyTransaction();
    }

    public Map<String, List<String>> getUnconvertedProperties() {
        if (this.unconvertedProperties == null) {
            this.unconvertedProperties = new HashMap<String, List<String>>(5);
        }
        return this.unconvertedProperties;
    }

    public int getUnitOfWorkCacheIsolationLevel() {
        return this.getCachePolicy().getUnitOfWorkCacheIsolationLevel();
    }

    public void setUnitOfWorkCacheIsolationLevel(int unitOfWorkCacheIsolationLevel) {
        this.getCachePolicy().setUnitOfWorkCacheIsolationLevel(unitOfWorkCacheIsolationLevel);
    }

    public void setHasRelationships(boolean hasRelationships) {
        this.hasRelationships = hasRelationships;
    }

    @Override
    public void setJavaClass(Class<?> theJavaClass) {
        this.javaClass = theJavaClass;
    }

    public void setJavaClassName(String theJavaClassName) {
        this.javaClassName = theJavaClassName;
    }

    public void setJavaInterface(Class<?> theJavaInterface) {
        this.javaClass = theJavaInterface;
        this.descriptorIsForInterface();
    }

    public void setJavaInterfaceName(String theJavaInterfaceName) {
        this.javaClassName = theJavaInterfaceName;
        this.descriptorIsForInterface();
    }

    public void setLockableMappings(List<DatabaseMapping> lockableMappings) {
        this.lockableMappings = lockableMappings;
    }

    public void setMappings(List<DatabaseMapping> mappings) {
        for (DatabaseMapping mapping : mappings) {
            if (mapping.getDescriptor() != null) continue;
            mapping.setDescriptor(this);
        }
        this.mappings = mappings;
    }

    protected void setMultipleTableForeignKeys(Map<DatabaseTable, Set<DatabaseTable>> newValue) {
        this.multipleTableForeignKeys = newValue;
    }

    public void setMultipleTableInsertOrder(List<DatabaseTable> newValue) {
        this.multipleTableInsertOrder = newValue;
    }

    public void setMultitenantPolicy(MultitenantPolicy multitenantPolicy) {
        this.multitenantPolicy = multitenantPolicy;
    }

    public boolean isCascadeOnDeleteSetOnDatabaseOnSecondaryTables() {
        return this.isCascadeOnDeleteSetOnDatabaseOnSecondaryTables;
    }

    public void setIsCascadeOnDeleteSetOnDatabaseOnSecondaryTables(boolean isCascadeOnDeleteSetOnDatabaseOnSecondaryTables) {
        this.isCascadeOnDeleteSetOnDatabaseOnSecondaryTables = isCascadeOnDeleteSetOnDatabaseOnSecondaryTables;
    }

    @Override
    protected void setObjectBuilder(ObjectBuilder builder) {
        this.objectBuilder = builder;
    }

    public void setOptimisticLockingPolicy(OptimisticLockingPolicy optimisticLockingPolicy) {
        this.optimisticLockingPolicy = optimisticLockingPolicy;
        if (optimisticLockingPolicy != null) {
            optimisticLockingPolicy.setDescriptor(this);
        }
    }

    public void setPrimaryKeyFieldName(String fieldName) {
        this.addPrimaryKeyFieldName(fieldName);
    }

    @Override
    public void setPrimaryKeyFieldNames(List<String> primaryKeyFieldsName) {
        this.setPrimaryKeyFields((List<DatabaseField>)new ArrayList<DatabaseField>(primaryKeyFieldsName.size()));
        for (String fieldName : primaryKeyFieldsName) {
            this.addPrimaryKeyFieldName(fieldName);
        }
    }

    @Override
    public void setPrimaryKeyFields(List<DatabaseField> thePrimaryKeyFields) {
        this.primaryKeyFields = thePrimaryKeyFields;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public void setProperty(String name, Object value) {
        this.getProperties().put(name, value);
    }

    public void setQueryKeys(Map<String, QueryKey> queryKeys) {
        this.queryKeys = queryKeys;
    }

    public void setQueryManager(DescriptorQueryManager queryManager) {
        this.queryManager = queryManager;
        if (queryManager != null) {
            queryManager.setDescriptor(this);
        }
    }

    public void setRemoteIdentityMapClass(Class<? extends IdentityMap> theIdentityMapClass) {
        this.getCachePolicy().setRemoteIdentityMapClass(theIdentityMapClass);
    }

    public void setRemoteIdentityMapSize(int identityMapSize) {
        this.getCachePolicy().setRemoteIdentityMapSize(identityMapSize);
    }

    public void setSequenceNumberField(DatabaseField sequenceNumberField) {
        this.sequenceNumberField = sequenceNumberField;
    }

    public void setSequenceNumberFieldName(String fieldName) {
        if (fieldName == null) {
            this.setSequenceNumberField(null);
        } else {
            this.setSequenceNumberField(new DatabaseField(fieldName));
        }
    }

    public void setSequenceNumberName(String name) {
        this.sequenceNumberName = name;
    }

    protected void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void setShouldAlwaysConformResultsInUnitOfWork(boolean shouldAlwaysConformResultsInUnitOfWork) {
        this.shouldAlwaysConformResultsInUnitOfWork = shouldAlwaysConformResultsInUnitOfWork;
    }

    public void setShouldAlwaysRefreshCache(boolean shouldAlwaysRefreshCache) {
        this.getCachePolicy().setShouldAlwaysRefreshCache(shouldAlwaysRefreshCache);
    }

    public void setShouldAlwaysRefreshCacheOnRemote(boolean shouldAlwaysRefreshCacheOnRemote) {
        this.getCachePolicy().setShouldAlwaysRefreshCacheOnRemote(shouldAlwaysRefreshCacheOnRemote);
    }

    public void setShouldBeReadOnly(boolean shouldBeReadOnly) {
        this.shouldBeReadOnly = shouldBeReadOnly;
    }

    public void setReadOnly() {
        this.setShouldBeReadOnly(true);
    }

    public void setShouldDisableCacheHits(boolean shouldDisableCacheHits) {
        this.getCachePolicy().setShouldDisableCacheHits(shouldDisableCacheHits);
    }

    public void setShouldDisableCacheHitsOnRemote(boolean shouldDisableCacheHitsOnRemote) {
        this.getCachePolicy().setShouldDisableCacheHitsOnRemote(shouldDisableCacheHitsOnRemote);
    }

    public void setShouldLockForClone(boolean shouldLockForClone) {
        this.shouldLockForClone = shouldLockForClone;
    }

    public void setShouldOnlyRefreshCacheIfNewerVersion(boolean shouldOnlyRefreshCacheIfNewerVersion) {
        this.getCachePolicy().setShouldOnlyRefreshCacheIfNewerVersion(shouldOnlyRefreshCacheIfNewerVersion);
    }

    public void setShouldOrderMappings(boolean shouldOrderMappings) {
        this.shouldOrderMappings = shouldOrderMappings;
    }

    public void setShouldRegisterResultsInUnitOfWork(boolean shouldRegisterResultsInUnitOfWork) {
        this.shouldRegisterResultsInUnitOfWork = shouldRegisterResultsInUnitOfWork;
    }

    public void setTableName(String tableName) throws DescriptorException {
        if (this.getTables().isEmpty()) {
            this.addTableName(tableName);
        } else {
            this.getTables().get(0).setPossiblyQualifiedName(tableName);
        }
    }

    public void setTableNames(List<String> tableNames) {
        this.setTables(new ArrayList<DatabaseTable>(tableNames.size()));
        for (String name : tableNames) {
            this.addTableName(name);
        }
    }

    public void setTablePerClassPolicy(TablePerClassPolicy tablePerClassPolicy) {
        this.interfacePolicy = tablePerClassPolicy;
        if (this.interfacePolicy != null) {
            this.interfacePolicy.setDescriptor(this);
        }
    }

    public void setTableQualifier(String tableQualifier) {
        for (DatabaseTable table : this.getTables()) {
            table.setTableQualifier(tableQualifier);
        }
    }

    public void setTables(List<DatabaseTable> theTables) {
        this.tables = theTables;
    }

    public void setWrapperPolicy(WrapperPolicy wrapperPolicy) {
        this.wrapperPolicy = wrapperPolicy;
        if (wrapperPolicy != null) {
            wrapperPolicy.setDescriptor(this);
        }
        this.getObjectBuilder().setHasWrapperPolicy(wrapperPolicy != null);
    }

    public boolean shouldAlwaysConformResultsInUnitOfWork() {
        return this.shouldAlwaysConformResultsInUnitOfWork;
    }

    public boolean shouldAlwaysRefreshCache() {
        return this.getCachePolicy().shouldAlwaysRefreshCache();
    }

    public boolean shouldAlwaysRefreshCacheOnRemote() {
        return this.getCachePolicy().shouldAlwaysRefreshCacheOnRemote();
    }

    public boolean shouldBeReadOnly() {
        return this.shouldBeReadOnly;
    }

    public boolean shouldDisableCacheHits() {
        return this.getCachePolicy().shouldDisableCacheHits();
    }

    public boolean shouldDisableCacheHitsOnRemote() {
        return this.getCachePolicy().shouldDisableCacheHitsOnRemote();
    }

    public boolean shouldOnlyRefreshCacheIfNewerVersion() {
        return this.getCachePolicy().shouldOnlyRefreshCacheIfNewerVersion();
    }

    public boolean shouldOrderMappings() {
        return this.shouldOrderMappings;
    }

    public boolean hasSimplePrimaryKey() {
        return this.hasSimplePrimaryKey;
    }

    public boolean hasTablePerClassPolicy() {
        return this.hasInterfacePolicy() && this.interfacePolicy.isTablePerClassPolicy();
    }

    public void setHasSimplePrimaryKey(boolean hasSimplePrimaryKey) {
        this.hasSimplePrimaryKey = hasSimplePrimaryKey;
    }

    public boolean shouldAcquireCascadedLocks() {
        return this.shouldAcquireCascadedLocks;
    }

    public void setShouldAcquireCascadedLocks(boolean shouldAcquireCascadedLocks) {
        this.shouldAcquireCascadedLocks = shouldAcquireCascadedLocks;
    }

    public boolean shouldUseAdditionalJoinExpression() {
        return this.getQueryManager().getAdditionalJoinExpression() != null && (!this.hasInheritance() || !this.getInheritancePolicy().hasView());
    }

    public boolean shouldUseCacheIdentityMap() {
        return ClassConstants.CacheIdentityMap_Class.equals(this.getIdentityMapClass());
    }

    public boolean shouldUseFullIdentityMap() {
        return ClassConstants.FullIdentityMap_Class.equals(this.getIdentityMapClass());
    }

    public boolean shouldUseSoftIdentityMap() {
        return ClassConstants.SoftIdentityMap_Class.equals(this.getIdentityMapClass());
    }

    public boolean shouldUseRemoteSoftIdentityMap() {
        return ClassConstants.SoftIdentityMap_Class.equals(this.getRemoteIdentityMapClass());
    }

    public boolean shouldUseHardCacheWeakIdentityMap() {
        return ClassConstants.HardCacheWeakIdentityMap_Class.equals(this.getIdentityMapClass());
    }

    public boolean shouldUseNoIdentityMap() {
        return ClassConstants.NoIdentityMap_Class.equals(this.getIdentityMapClass());
    }

    public boolean shouldRegisterResultsInUnitOfWork() {
        return this.shouldRegisterResultsInUnitOfWork;
    }

    public boolean shouldUseRemoteCacheIdentityMap() {
        return ClassConstants.CacheIdentityMap_Class.equals(this.getRemoteIdentityMapClass());
    }

    public boolean shouldUseRemoteFullIdentityMap() {
        return ClassConstants.FullIdentityMap_Class.equals(this.getRemoteIdentityMapClass());
    }

    public boolean shouldUseRemoteHardCacheWeakIdentityMap() {
        return ClassConstants.HardCacheWeakIdentityMap_Class.equals(this.getRemoteIdentityMapClass());
    }

    public boolean shouldUseRemoteNoIdentityMap() {
        return ClassConstants.NoIdentityMap_Class.equals(this.getRemoteIdentityMapClass());
    }

    public boolean shouldUseRemoteSoftCacheWeakIdentityMap() {
        return ClassConstants.SoftCacheWeakIdentityMap_Class.equals(this.getRemoteIdentityMapClass());
    }

    public boolean shouldUseRemoteWeakIdentityMap() {
        return ClassConstants.WeakIdentityMap_Class.equals(this.getRemoteIdentityMapClass());
    }

    public boolean shouldUseSoftCacheWeakIdentityMap() {
        return ClassConstants.SoftCacheWeakIdentityMap_Class.equals(this.getIdentityMapClass());
    }

    public boolean shouldUseWeakIdentityMap() {
        return ClassConstants.WeakIdentityMap_Class.equals(this.getIdentityMapClass());
    }

    public boolean supportsChangeTracking(Project project) {
        OptimisticLockingPolicy lockingPolicy = this.getOptimisticLockingPolicy();
        if (lockingPolicy instanceof FieldsLockingPolicy) {
            return false;
        }
        List<DatabaseMapping> mappings = this.getMappings();
        for (DatabaseMapping mapping : mappings) {
            if (mapping.isChangeTrackingSupported(project)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getJavaClassName() + " --> " + String.valueOf(this.getTables()) + ")";
    }

    public void useAllFieldsLocking() {
        this.setOptimisticLockingPolicy(new AllFieldsLockingPolicy());
    }

    public void useCacheIdentityMap() {
        this.setIdentityMapClass(ClassConstants.CacheIdentityMap_Class);
    }

    public void useChangedFieldsLocking() {
        this.setOptimisticLockingPolicy(new ChangedFieldsLockingPolicy());
    }

    public void useCloneCopyPolicy() {
        this.useCloneCopyPolicy("clone");
    }

    public void useCloneCopyPolicy(String cloneMethodName) {
        CloneCopyPolicy policy = new CloneCopyPolicy();
        policy.setMethodName(cloneMethodName);
        this.setCopyPolicy(policy);
    }

    public void useInstantiationCopyPolicy() {
        this.setCopyPolicy(new InstantiationCopyPolicy());
    }

    public void useDefaultConstructorInstantiationPolicy() {
        this.getInstantiationPolicy().useDefaultConstructorInstantiationPolicy();
    }

    public void useFactoryInstantiationPolicy(Class<?> factoryClass, String methodName) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(factoryClass, methodName);
    }

    public void useFactoryInstantiationPolicy(String factoryClassName, String methodName) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(factoryClassName, methodName);
    }

    public void useFactoryInstantiationPolicy(Class<?> factoryClass, String methodName, String factoryMethodName) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(factoryClass, methodName, factoryMethodName);
    }

    public void useFactoryInstantiationPolicy(String factoryClassName, String methodName, String factoryMethodName) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(factoryClassName, methodName, factoryMethodName);
    }

    public void useFactoryInstantiationPolicy(Object factory, String methodName) {
        this.getInstantiationPolicy().useFactoryInstantiationPolicy(factory, methodName);
    }

    public void useFullIdentityMap() {
        this.getCachePolicy().useFullIdentityMap();
    }

    public void useHardCacheWeakIdentityMap() {
        this.getCachePolicy().useHardCacheWeakIdentityMap();
    }

    public void useSoftIdentityMap() {
        this.getCachePolicy().useSoftIdentityMap();
    }

    public void useRemoteSoftIdentityMap() {
        this.getCachePolicy().setRemoteIdentityMapClass(ClassConstants.SoftIdentityMap_Class);
    }

    public void useMethodInstantiationPolicy(String staticMethodName) {
        this.getInstantiationPolicy().useMethodInstantiationPolicy(staticMethodName);
    }

    public void useNoIdentityMap() {
        this.getCachePolicy().useNoIdentityMap();
    }

    public void useRemoteCacheIdentityMap() {
        this.getCachePolicy().setRemoteIdentityMapClass(ClassConstants.CacheIdentityMap_Class);
    }

    public void useRemoteFullIdentityMap() {
        this.getCachePolicy().setRemoteIdentityMapClass(ClassConstants.FullIdentityMap_Class);
    }

    public void useRemoteHardCacheWeakIdentityMap() {
        this.getCachePolicy().setRemoteIdentityMapClass(ClassConstants.HardCacheWeakIdentityMap_Class);
    }

    public void useRemoteNoIdentityMap() {
        this.getCachePolicy().setRemoteIdentityMapClass(ClassConstants.NoIdentityMap_Class);
    }

    public void useRemoteSoftCacheWeakIdentityMap() {
        this.getCachePolicy().setRemoteIdentityMapClass(ClassConstants.SoftCacheWeakIdentityMap_Class);
    }

    public void useRemoteWeakIdentityMap() {
        this.getCachePolicy().setRemoteIdentityMapClass(ClassConstants.WeakIdentityMap_Class);
    }

    public void useSelectedFieldsLocking(List<String> fieldNames) {
        SelectedFieldsLockingPolicy policy = new SelectedFieldsLockingPolicy();
        policy.setLockFieldNames(fieldNames);
        this.setOptimisticLockingPolicy(policy);
    }

    public boolean usesFieldLocking() {
        return this.usesOptimisticLocking() && this.getOptimisticLockingPolicy() instanceof FieldsLockingPolicy;
    }

    public void useSoftCacheWeakIdentityMap() {
        this.setIdentityMapClass(ClassConstants.SoftCacheWeakIdentityMap_Class);
    }

    public boolean usesOptimisticLocking() {
        return this.optimisticLockingPolicy != null;
    }

    public boolean usesVersionLocking() {
        return this.usesOptimisticLocking() && this.getOptimisticLockingPolicy() instanceof VersionLockingPolicy;
    }

    public boolean usesSequenceNumbers() {
        return this.sequenceNumberField != null;
    }

    public void useTimestampLocking(String writeLockFieldName) {
        this.useTimestampLocking(writeLockFieldName, true);
    }

    public void useTimestampLocking(String writeLockFieldName, boolean shouldStoreInCache) {
        TimestampLockingPolicy policy = new TimestampLockingPolicy(writeLockFieldName);
        if (shouldStoreInCache) {
            policy.storeInCache();
        } else {
            policy.storeInObject();
        }
        this.setOptimisticLockingPolicy(policy);
    }

    public void useVersionLocking(String writeLockFieldName) {
        this.useVersionLocking(writeLockFieldName, true);
    }

    public void useVersionLocking(String writeLockFieldName, boolean shouldStoreInCache) {
        VersionLockingPolicy policy = new VersionLockingPolicy(writeLockFieldName);
        if (shouldStoreInCache) {
            policy.storeInCache();
        } else {
            policy.storeInObject();
        }
        this.setOptimisticLockingPolicy(policy);
    }

    public void useWeakIdentityMap() {
        this.getCachePolicy().useWeakIdentityMap();
    }

    protected void validateAfterInitialization(AbstractSession session) {
        this.selfValidationAfterInitialization(session);
        for (DatabaseMapping mapping : this.getMappings()) {
            mapping.validateAfterInitialization(session);
        }
    }

    protected void validateBeforeInitialization(AbstractSession session) {
        this.selfValidationBeforeInitialization(session);
        for (DatabaseMapping mapping : this.getMappings()) {
            mapping.validateBeforeInitialization(session);
        }
    }

    protected void verifyTableQualifiers(Platform platform) {
        String tableQualifier = platform.getTableQualifier();
        if (tableQualifier.isEmpty()) {
            return;
        }
        for (DatabaseTable table : this.getTables()) {
            if (!table.getTableQualifier().isEmpty()) continue;
            table.setTableQualifier(tableQualifier);
        }
    }

    public CMPPolicy getCMPPolicy() {
        return this.cmpPolicy;
    }

    public void setCMPPolicy(CMPPolicy newCMPPolicy) {
        this.cmpPolicy = newCMPPolicy;
        if (this.cmpPolicy != null) {
            this.cmpPolicy.setDescriptor(this);
        }
    }

    public CachePolicy getCachePolicy() {
        if (this.cachePolicy == null) {
            this.cachePolicy = new CachePolicy();
        }
        return this.cachePolicy;
    }

    public void setCachePolicy(CachePolicy cachePolicy) {
        this.cachePolicy = cachePolicy;
    }

    public boolean hasPessimisticLockingPolicy() {
        return this.cmpPolicy != null && this.cmpPolicy.hasPessimisticLockingPolicy();
    }

    public FetchGroupManager getFetchGroupManager() {
        return this.fetchGroupManager;
    }

    public boolean getFullyMergeEntity() {
        return this.getCachePolicy().getFullyMergeEntity();
    }

    public void setFetchGroupManager(FetchGroupManager fetchGroupManager) {
        this.fetchGroupManager = fetchGroupManager;
        if (fetchGroupManager != null) {
            fetchGroupManager.setDescriptor(this);
        }
    }

    public boolean hasFetchGroupManager() {
        return this.fetchGroupManager != null;
    }

    public boolean hasCascadeLockingPolicies() {
        return this.cascadeLockingPolicies != null && !this.cascadeLockingPolicies.isEmpty();
    }

    public boolean hasCMPPolicy() {
        return this.cmpPolicy != null;
    }

    public FetchGroup getDefaultFetchGroup() {
        if (!this.hasFetchGroupManager()) {
            return null;
        }
        return this.getFetchGroupManager().getDefaultFetchGroup();
    }

    public boolean isReturnTypeRequiredForReturningPolicy() {
        return true;
    }

    public void setIsNativeConnectionRequired(boolean isNativeConnectionRequired) {
        this.isNativeConnectionRequired = isNativeConnectionRequired;
    }

    public boolean isNativeConnectionRequired() {
        return this.isNativeConnectionRequired;
    }

    public void setIdValidation(IdValidation idValidation) {
        this.idValidation = idValidation;
        if (this.getPrimaryKeyIdValidations() != null) {
            for (int index = 0; index < this.getPrimaryKeyIdValidations().size(); ++index) {
                this.getPrimaryKeyIdValidations().set(index, idValidation);
            }
        }
    }

    public IdValidation getIdValidation() {
        return this.idValidation;
    }

    public List<IdValidation> getPrimaryKeyIdValidations() {
        return this.primaryKeyIdValidations;
    }

    public void setPrimaryKeyIdValidations(List<IdValidation> primaryKeyIdValidations) {
        this.primaryKeyIdValidations = primaryKeyIdValidations;
    }

    public void setCacheKeyType(CacheKeyType cacheKeyType) {
        this.getCachePolicy().setCacheKeyType(cacheKeyType);
    }

    public CacheKeyType getCacheKeyType() {
        return this.getCachePolicy().getCacheKeyType();
    }

    public QueryRedirector getDefaultQueryRedirector() {
        return this.defaultQueryRedirector;
    }

    public void setDefaultQueryRedirector(QueryRedirector defaultRedirector) {
        this.defaultQueryRedirector = defaultRedirector;
    }

    public QueryRedirector getDefaultReadAllQueryRedirector() {
        return this.defaultReadAllQueryRedirector;
    }

    public void setDefaultReadAllQueryRedirector(QueryRedirector defaultReadAllQueryRedirector) {
        this.defaultReadAllQueryRedirector = defaultReadAllQueryRedirector;
    }

    public QueryRedirector getDefaultReadObjectQueryRedirector() {
        return this.defaultReadObjectQueryRedirector;
    }

    public void setDefaultReadObjectQueryRedirector(QueryRedirector defaultReadObjectQueryRedirector) {
        this.defaultReadObjectQueryRedirector = defaultReadObjectQueryRedirector;
    }

    public QueryRedirector getDefaultReportQueryRedirector() {
        return this.defaultReportQueryRedirector;
    }

    public void setDefaultReportQueryRedirector(QueryRedirector defaultReportQueryRedirector) {
        this.defaultReportQueryRedirector = defaultReportQueryRedirector;
    }

    public QueryRedirector getDefaultUpdateObjectQueryRedirector() {
        return this.defaultUpdateObjectQueryRedirector;
    }

    public void setDefaultUpdateObjectQueryRedirector(QueryRedirector defaultUpdateQueryRedirector) {
        this.defaultUpdateObjectQueryRedirector = defaultUpdateQueryRedirector;
    }

    public QueryRedirector getDefaultInsertObjectQueryRedirector() {
        return this.defaultInsertObjectQueryRedirector;
    }

    public void setDefaultInsertObjectQueryRedirector(QueryRedirector defaultInsertQueryRedirector) {
        this.defaultInsertObjectQueryRedirector = defaultInsertQueryRedirector;
    }

    public QueryRedirector getDefaultDeleteObjectQueryRedirector() {
        return this.defaultDeleteObjectQueryRedirector;
    }

    public void setDefaultDeleteObjectQueryRedirector(QueryRedirector defaultDeleteObjectQueryRedirector) {
        this.defaultDeleteObjectQueryRedirector = defaultDeleteObjectQueryRedirector;
    }

    public void setDefaultQueryRedirectorClassName(String defaultQueryRedirectorClassName) {
        this.defaultQueryRedirectorClassName = defaultQueryRedirectorClassName;
    }

    public void setDefaultReadAllQueryRedirectorClassName(String defaultReadAllQueryRedirectorClassName) {
        this.defaultReadAllQueryRedirectorClassName = defaultReadAllQueryRedirectorClassName;
    }

    public void setDefaultReadObjectQueryRedirectorClassName(String defaultReadObjectQueryRedirectorClassName) {
        this.defaultReadObjectQueryRedirectorClassName = defaultReadObjectQueryRedirectorClassName;
    }

    public void setDefaultReportQueryRedirectorClassName(String defaultReportQueryRedirectorClassName) {
        this.defaultReportQueryRedirectorClassName = defaultReportQueryRedirectorClassName;
    }

    public void setDefaultUpdateObjectQueryRedirectorClassName(String defaultUpdateObjectQueryRedirectorClassName) {
        this.defaultUpdateObjectQueryRedirectorClassName = defaultUpdateObjectQueryRedirectorClassName;
    }

    public void setDefaultInsertObjectQueryRedirectorClassName(String defaultInsertObjectQueryRedirectorClassName) {
        this.defaultInsertObjectQueryRedirectorClassName = defaultInsertObjectQueryRedirectorClassName;
    }

    public void setDefaultDeleteObjectQueryRedirectorClassName(String defaultDeleteObjectQueryRedirectorClassName) {
        this.defaultDeleteObjectQueryRedirectorClassName = defaultDeleteObjectQueryRedirectorClassName;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public List<DatabaseMapping> getMappingsPostCalculateChanges() {
        if (this.mappingsPostCalculateChanges == null) {
            this.mappingsPostCalculateChanges = new ArrayList<DatabaseMapping>();
        }
        return this.mappingsPostCalculateChanges;
    }

    public boolean hasMappingsPostCalculateChanges() {
        return this.mappingsPostCalculateChanges != null;
    }

    public void addMappingsPostCalculateChanges(DatabaseMapping mapping) {
        if (mapping.getReferenceDescriptor() != null) {
            this.getMappingsPostCalculateChanges().add(mapping);
        }
    }

    public List<DatabaseMapping> getMappingsPostCalculateChangesOnDeleted() {
        if (this.mappingsPostCalculateChangesOnDeleted == null) {
            this.mappingsPostCalculateChangesOnDeleted = new ArrayList<DatabaseMapping>();
        }
        return this.mappingsPostCalculateChangesOnDeleted;
    }

    public boolean hasMappingsPostCalculateChangesOnDeleted() {
        return this.mappingsPostCalculateChangesOnDeleted != null;
    }

    public void addMappingsPostCalculateChangesOnDeleted(DatabaseMapping mapping) {
        this.getMappingsPostCalculateChangesOnDeleted().add(mapping);
    }

    public boolean hasMultipleTableConstraintDependecy() {
        return this.hasMultipleTableConstraintDependecy;
    }

    public boolean hasMultitenantPolicy() {
        return this.multitenantPolicy != null;
    }

    public boolean hasTablePerMultitenantPolicy() {
        return this.hasMultitenantPolicy() && this.getMultitenantPolicy().isTablePerMultitenantPolicy();
    }

    public boolean hasUnconvertedProperties() {
        return this.unconvertedProperties != null;
    }

    public void setHasMultipleTableConstraintDependecy(boolean hasMultipleTableConstraintDependecy) {
        this.hasMultipleTableConstraintDependecy = hasMultipleTableConstraintDependecy;
    }

    public boolean usesPropertyAccessForWeaving() {
        return this.weavingUsesPropertyAccess;
    }

    public void usePropertyAccessForWeaving() {
        this.weavingUsesPropertyAccess = true;
    }

    public List<VirtualAttributeMethodInfo> getVirtualAttributeMethods() {
        if (this.virtualAttributeMethods == null) {
            this.virtualAttributeMethods = new ArrayList<VirtualAttributeMethodInfo>();
        }
        return this.virtualAttributeMethods;
    }

    public void setVirtualAttributeMethods(List<VirtualAttributeMethodInfo> virtualAttributeMethods) {
        this.virtualAttributeMethods = virtualAttributeMethods;
    }

    public boolean hasTargetForeignKeyMapping(AbstractSession session) {
        for (DatabaseMapping mapping : this.getMappings()) {
            if (mapping.isCollectionMapping() || mapping.isObjectReferenceMapping() && !((ObjectReferenceMapping)mapping).isForeignKeyRelationship() || mapping.isAbstractCompositeDirectCollectionMapping()) {
                return true;
            }
            if (!mapping.isAggregateObjectMapping()) continue;
            CoreDescriptor referenceDescriptor = mapping.getReferenceDescriptor();
            if (referenceDescriptor == null) {
                referenceDescriptor = session.getDescriptor((Class)((AggregateObjectMapping)mapping).getReferenceClass());
            }
            if (!referenceDescriptor.hasTargetForeignKeyMapping(session)) continue;
            return true;
        }
        return false;
    }

    @Override
    public AttributeGroup getAttributeGroup(String name) {
        return (AttributeGroup)super.getAttributeGroup(name);
    }

    @Override
    public Map<String, AttributeGroup> getAttributeGroups() {
        return super.getAttributeGroups();
    }

    public void clearReferencingClasses() {
        this.referencingClasses.clear();
    }
}

