/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.persistence.logging.AbstractSessionLog;

public final class Version {
    private static String product = "Eclipse Persistence Services";
    private static final char SEPARATOR = '.';
    private static final String VERSION_PROPERTIES_FILE = "version.properties";
    private static final String RESOURCE_BUNDLE = "org.eclipse.persistence.internal.localization.i18n.LoggingLocalizationResource";
    private static final String ERROR_MESSAGE_KEY = "eclipselink_version_error";
    private static Properties versionProperties;

    private Version() {
    }

    public static String getVersionString() {
        StringBuilder sb = new StringBuilder(Version.getVersion().length() + 1 + Version.getQualifier().length());
        sb.append(Version.getVersion());
        sb.append('.');
        sb.append(Version.getQualifier());
        sb.append('-');
        sb.append(Version.getBuildRevision());
        return sb.toString();
    }

    public static String getProduct() {
        return product;
    }

    public static void setProduct(String ProductName) {
        product = ProductName;
    }

    public static String getVersion() {
        return Version.getProperty("version");
    }

    public static String getQualifier() {
        return Version.getProperty("qualifier");
    }

    public static String getBuildNumber() {
        return Version.getBuildDate();
    }

    public static String getBuildDate() {
        return Version.getProperty("buildDate");
    }

    public static String getBuildTime() {
        return Version.getProperty("buildTime");
    }

    public static String getBuildRevision() {
        return Version.getProperty("buildRevision");
    }

    public static String getBuildType() {
        return Version.getProperty("buildType");
    }

    public static void printVersion() {
        System.out.println(Version.getVersionString());
    }

    public static void main(String[] args) {
        try {
            System.out.println();
            System.out.print(Version.getProduct());
            System.out.println(" (EclipseLink)");
            System.out.print("   Build Version:   ");
            System.out.println(Version.getVersionString());
            System.out.print("   Build Qualifier: ");
            System.out.println(Version.getQualifier());
            System.out.print("   Build Date:      ");
            System.out.println(Version.getBuildDate());
            System.out.print("   Build Time:      ");
            System.out.println(Version.getBuildTime());
            System.out.print("   Build Revision:  ");
            System.out.println(Version.getBuildRevision());
        }
        catch (Throwable e) {
            AbstractSessionLog.getLog().logThrowable(7, e);
        }
    }

    private static Properties loadProperties(String propertiesFileName) throws Exception {
        Properties properties = null;
        try (InputStream versionStream = Version.class.getResourceAsStream(propertiesFileName);){
            properties = new Properties();
            properties.load(versionStream);
        }
        return properties;
    }

    private static String getProperty(String propertyName) {
        try {
            if (versionProperties == null) {
                versionProperties = Version.loadProperties(VERSION_PROPERTIES_FILE);
            }
            return versionProperties.getProperty(propertyName);
        }
        catch (Exception e) {
            ResourceBundle bundle2 = ResourceBundle.getBundle(RESOURCE_BUNDLE, Locale.getDefault());
            throw new RuntimeException(MessageFormat.format(bundle2.getString(ERROR_MESSAGE_KEY), VERSION_PROPERTIES_FILE));
        }
    }
}

