/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import org.apache.catalina.Context;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.Store;
import org.apache.catalina.session.PersistentManager;
import org.apache.catalina.valves.ValveBase;

public class PersistentValve
extends ValveBase {
    private static final String info = "org.apache.catalina.valves.PersistentValve/1.0";

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public int invoke(Request request, Response response) throws IOException, ServletException {
        Store store;
        Context context = request.getContext();
        if (context == null) {
            ((HttpServletResponse)response.getResponse()).sendError(500, rb.getString("AS-WEB-CORE-00514"));
            return 2;
        }
        Thread.currentThread().setContextClassLoader(context.getLoader().getClassLoader());
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        String sessionId = hreq.getRequestedSessionId();
        Manager manager = context.getManager();
        if (sessionId != null && manager != null && manager instanceof PersistentManager && (store = ((PersistentManager)manager).getStore()) != null) {
            Session session = null;
            try {
                session = store.load(sessionId);
            }
            catch (Exception e) {
                this.log("deserializeError");
            }
            if (session != null) {
                if (!session.isValid() || this.isSessionStale(session, System.currentTimeMillis())) {
                    this.log("session swapped in is invalid or expired");
                    session.expire();
                    store.remove(sessionId);
                } else {
                    session.setManager(manager);
                    manager.add(session);
                    session.access();
                }
            }
        }
        this.log("sessionId: " + sessionId);
        return 1;
    }

    @Override
    public void postInvoke(Request request, Response response) throws IOException, ServletException {
        Context context = request.getContext();
        if (context == null) {
            ((HttpServletResponse)response.getResponse()).sendError(500, rb.getString("AS-WEB-CORE-00514"));
            return;
        }
        Thread.currentThread().setContextClassLoader(context.getLoader().getClassLoader());
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        Manager manager = context.getManager();
        String newsessionId = null;
        if (request instanceof org.apache.catalina.connector.Request) {
            Session sess;
            try {
                sess = ((org.apache.catalina.connector.Request)request).getSessionInternal();
            }
            catch (Exception ex) {
                sess = null;
            }
            if (sess != null) {
                newsessionId = sess.getIdInternal();
            }
        } else {
            HttpSession hsess;
            try {
                hsess = hreq.getSession();
            }
            catch (Exception ex) {
                hsess = null;
            }
            if (hsess != null) {
                newsessionId = hsess.getId();
            }
        }
        this.log("newsessionId: " + newsessionId);
        if (newsessionId != null) {
            if (manager instanceof PersistentManager) {
                Session session = manager.findSession(newsessionId);
                Store store = ((PersistentManager)manager).getStore();
                if (store != null && session != null && session.isValid() && !this.isSessionStale(session, System.currentTimeMillis())) {
                    store.save(session);
                    ((PersistentManager)manager).removeSuper(session);
                    session.recycle();
                } else if (session != null) {
                    this.log("newsessionId store: " + String.valueOf(store) + " session: " + String.valueOf(session) + " valid: " + session.isValid() + " Staled: " + this.isSessionStale(session, System.currentTimeMillis()));
                }
            } else {
                this.log("newsessionId Manager: " + String.valueOf(manager));
            }
        }
    }

    protected void log(String message) {
        Logger logger2 = this.container.getLogger();
        if (logger2 != null) {
            logger2.log(this.toString() + ": " + message);
        } else {
            System.out.println(this.toString() + ": " + message);
        }
    }

    protected boolean isSessionStale(Session session, long timeNow) {
        int timeIdle;
        int maxInactiveInterval = session.getMaxInactiveInterval();
        return maxInactiveInterval >= 0 && (timeIdle = (int)((timeNow - session.getLastAccessedTime()) / 1000L)) >= maxInactiveInterval;
    }
}

