/*
 * Decompiled with CFR 0.152.
 */
package jakarta.security.jacc;

import jakarta.security.jacc.HttpMethodSpec;
import jakarta.security.jacc.URLPatternSpec;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.security.Permission;
import java.util.HashMap;
import java.util.Map;

public final class WebUserDataPermission
extends Permission {
    private static final long serialVersionUID = -970193775626385011L;
    private static final transient String EMPTY_STRING = "";
    private static final transient String ESCAPED_COLON = "%3A";
    private static String[] transportKeys = new String[]{"NONE", "INTEGRAL", "CONFIDENTIAL"};
    private static Map<String, Integer> transportHash = new HashMap<String, Integer>();
    private static int TT_NONE;
    private static int TT_CONFIDENTIAL;
    private transient URLPatternSpec urlPatternSpec;
    private transient HttpMethodSpec methodSpec;
    private transient int transportType;
    private transient int hashCodeValue;
    private static final ObjectStreamField[] serialPersistentFields;

    public WebUserDataPermission(String name, String actions2) {
        super(name);
        this.urlPatternSpec = new URLPatternSpec(name);
        this.parseActions(actions2);
    }

    public WebUserDataPermission(String urlPatternSpec, String[] HTTPMethods2, String transportType) {
        super(urlPatternSpec);
        this.urlPatternSpec = new URLPatternSpec(urlPatternSpec);
        this.transportType = TT_NONE;
        if (transportType != null) {
            Integer bit = transportHash.get(transportType);
            if (bit == null) {
                throw new IllegalArgumentException("illegal transport value");
            }
            this.transportType = bit;
        }
        this.methodSpec = HttpMethodSpec.getSpec(HTTPMethods2);
    }

    public WebUserDataPermission(HttpServletRequest request) {
        super(WebUserDataPermission.getUriMinusContextPath(request));
        this.urlPatternSpec = new URLPatternSpec(super.getName());
        this.transportType = request.isSecure() ? TT_CONFIDENTIAL : TT_NONE;
        this.methodSpec = HttpMethodSpec.getSpec(request.getMethod());
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof WebUserDataPermission)) {
            return false;
        }
        WebUserDataPermission that = (WebUserDataPermission)o;
        if (this.transportType != that.transportType) {
            return false;
        }
        if (!this.methodSpec.equals(that.methodSpec)) {
            return false;
        }
        return this.urlPatternSpec.equals(that.urlPatternSpec);
    }

    @Override
    public String getActions() {
        String methodSpecActions = this.methodSpec.getActions();
        if (this.transportType == TT_NONE && methodSpecActions == null) {
            return null;
        }
        if (this.transportType == TT_NONE) {
            return methodSpecActions;
        }
        if (methodSpecActions == null) {
            return ":" + transportKeys[this.transportType];
        }
        return methodSpecActions + ":" + transportKeys[this.transportType];
    }

    @Override
    public int hashCode() {
        if (this.hashCodeValue == 0) {
            String hashInput = this.urlPatternSpec.toString() + " " + this.methodSpec.hashCode() + ":" + this.transportType;
            this.hashCodeValue = hashInput.hashCode();
        }
        return this.hashCodeValue;
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof WebUserDataPermission)) {
            return false;
        }
        WebUserDataPermission that = (WebUserDataPermission)permission;
        if (this.transportType != TT_NONE && this.transportType != that.transportType) {
            return false;
        }
        if (!this.methodSpec.implies(that.methodSpec)) {
            return false;
        }
        return this.urlPatternSpec.implies(that.urlPatternSpec);
    }

    private static String getUriMinusContextPath(HttpServletRequest request) {
        int contextLength;
        String uri = request.getRequestURI();
        if (uri == null) {
            return EMPTY_STRING;
        }
        String contextPath = request.getContextPath();
        int n = contextLength = contextPath == null ? 0 : contextPath.length();
        if (contextLength > 0) {
            uri = uri.substring(contextLength);
        }
        if (uri.equals("/")) {
            return EMPTY_STRING;
        }
        return uri.replaceAll(":", ESCAPED_COLON);
    }

    private void parseActions(String actions2) {
        this.transportType = TT_NONE;
        if (actions2 == null || actions2.equals(EMPTY_STRING)) {
            this.methodSpec = HttpMethodSpec.getSpec((String)null);
        } else {
            int colon = actions2.indexOf(58);
            if (colon < 0) {
                this.methodSpec = HttpMethodSpec.getSpec(actions2);
            } else {
                this.methodSpec = colon == 0 ? HttpMethodSpec.getSpec((String)null) : HttpMethodSpec.getSpec(actions2.substring(0, colon));
                Integer bit = transportHash.get(actions2.substring(colon + 1));
                if (bit == null) {
                    throw new IllegalArgumentException("illegal transport value");
                }
                this.transportType = bit;
            }
        }
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        this.parseActions((String)inputStream.readFields().get("actions", null));
        this.urlPatternSpec = new URLPatternSpec(super.getName());
    }

    private synchronized void writeObject(ObjectOutputStream outputStream) throws IOException {
        outputStream.putFields().put("actions", this.getActions());
        outputStream.writeFields();
    }

    static {
        for (int i = 0; i < transportKeys.length; ++i) {
            transportHash.put(transportKeys[i], i);
        }
        TT_NONE = transportHash.get("NONE");
        TT_CONFIDENTIAL = transportHash.get("CONFIDENTIAL");
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("actions", String.class)};
    }
}

