/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.BeanSupport;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.ELUtil;
import jakarta.el.LambdaExpression;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BeanELResolver
extends ELResolver {
    private boolean isReadOnly;
    private final SoftConcurrentHashMap properties = new SoftConcurrentHashMap();

    public BeanELResolver() {
        this.isReadOnly = false;
    }

    public BeanELResolver(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        BeanProperty beanProperty = this.getBeanProperty(context, base, property);
        context.setPropertyResolved(true);
        if (this.isReadOnly || beanProperty.isReadOnly(base)) {
            return null;
        }
        return beanProperty.getPropertyType();
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        Object value;
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        Method method = this.getBeanProperty(context, base, property).getReadMethod(base);
        if (method == null) {
            throw new PropertyNotFoundException(ELUtil.getExceptionMessageString(context, "propertyNotReadable", new Object[]{base.getClass().getName(), property.toString()}));
        }
        try {
            value = method.invoke(base, new Object[0]);
            context.setPropertyResolved(base, property);
        }
        catch (ELException ex) {
            throw ex;
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
        catch (Exception ex) {
            throw new ELException(ex);
        }
        return value;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object val) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return;
        }
        if (this.isReadOnly) {
            throw new PropertyNotWritableException(ELUtil.getExceptionMessageString(context, "resolverNotwritable", new Object[]{base.getClass().getName()}));
        }
        Method method = this.getBeanProperty(context, base, property).getWriteMethod(base);
        if (method == null) {
            throw new PropertyNotWritableException(ELUtil.getExceptionMessageString(context, "propertyNotWritable", new Object[]{base.getClass().getName(), property.toString()}));
        }
        try {
            method.invoke(base, val);
            context.setPropertyResolved(base, property);
        }
        catch (ELException ex) {
            throw ex;
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
        catch (Exception ex) {
            if (null == val) {
                val = "null";
            }
            String message = ELUtil.getExceptionMessageString(context, "setPropertyFailed", new Object[]{property.toString(), base.getClass().getName(), val});
            throw new ELException(message, ex);
        }
    }

    @Override
    public Object invoke(ELContext context, Object base, Object methodName, Class<?>[] paramTypes, Object[] params) {
        if (base == null || methodName == null) {
            return null;
        }
        Method method = ELUtil.findMethod(base.getClass(), base, methodName.toString(), paramTypes, params, false);
        if (params != null) {
            for (Object param : params) {
                if (!(param instanceof LambdaExpression)) continue;
                ((LambdaExpression)param).setELContext(context);
            }
        }
        Object ret = ELUtil.invokeMethod(context, method, base, params);
        context.setPropertyResolved(base, methodName);
        return ret;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return false;
        }
        context.setPropertyResolved(true);
        if (this.isReadOnly) {
            return true;
        }
        return this.getBeanProperty(context, base, property).isReadOnly(base);
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        return Object.class;
    }

    private BeanProperty getBeanProperty(ELContext context, Object base, Object prop) {
        BeanProperty beanProperty;
        String property = prop.toString();
        Class<?> baseClass = base.getClass();
        BeanProperties beanProperties = this.properties.get(baseClass);
        if (beanProperties == null) {
            beanProperties = BeanSupport.getInstance().getBeanProperties(baseClass);
            this.properties.put(baseClass, beanProperties);
        }
        if ((beanProperty = beanProperties.getBeanProperty(property)) == null) {
            throw new PropertyNotFoundException(ELUtil.getExceptionMessageString(context, "propertyNotFound", new Object[]{baseClass.getName(), property}));
        }
        return beanProperty;
    }

    private static class SoftConcurrentHashMap
    extends ConcurrentHashMap<Class<?>, BeanProperties> {
        private static final long serialVersionUID = -178867497897782229L;
        private static final int CACHE_INIT_SIZE = 1024;
        private ConcurrentHashMap<Class<?>, BPSoftReference> map = new ConcurrentHashMap(1024);
        private ReferenceQueue<BeanProperties> refQ = new ReferenceQueue();

        private SoftConcurrentHashMap() {
        }

        private void cleanup() {
            BPSoftReference BPRef = null;
            while ((BPRef = (BPSoftReference)this.refQ.poll()) != null) {
                this.map.remove(BPRef.key);
            }
        }

        @Override
        public BeanProperties put(Class<?> key, BeanProperties value) {
            this.cleanup();
            BPSoftReference prev = this.map.put(key, new BPSoftReference(key, value, this.refQ));
            return prev == null ? null : (BeanProperties)prev.get();
        }

        @Override
        public BeanProperties putIfAbsent(Class<?> key, BeanProperties value) {
            this.cleanup();
            BPSoftReference prev = this.map.putIfAbsent(key, new BPSoftReference(key, value, this.refQ));
            return prev == null ? null : (BeanProperties)prev.get();
        }

        @Override
        public BeanProperties get(Object key) {
            this.cleanup();
            BPSoftReference BPRef = this.map.get(key);
            if (BPRef == null) {
                return null;
            }
            if (BPRef.get() == null) {
                this.map.remove(key);
                return null;
            }
            return (BeanProperties)BPRef.get();
        }
    }

    static abstract class BeanProperty {
        private final Class<?> baseClass;
        private final Class<?> type;
        private Method readMethod;
        private Method writeMethod;

        public BeanProperty(Class<?> baseClass, Class<?> type2) {
            this.baseClass = baseClass;
            this.type = type2;
        }

        public Class<?> getPropertyType() {
            return this.type;
        }

        public boolean isReadOnly(Object base) {
            return this.getWriteMethod(base) == null;
        }

        public Method getReadMethod(Object base) {
            if (this.readMethod == null) {
                this.readMethod = ELUtil.getMethod(this.baseClass, base, this.getReadMethod());
            }
            return this.readMethod;
        }

        public Method getWriteMethod(Object base) {
            if (this.writeMethod == null) {
                this.writeMethod = ELUtil.getMethod(this.baseClass, base, this.getWriteMethod());
            }
            return this.writeMethod;
        }

        abstract Method getWriteMethod();

        abstract Method getReadMethod();
    }

    static abstract class BeanProperties {
        protected final Map<String, BeanProperty> propertyMap = new HashMap<String, BeanProperty>();
        protected final Class<?> baseClass;

        BeanProperties(Class<?> baseClass) {
            this.baseClass = baseClass;
        }

        public BeanProperty getBeanProperty(String property) {
            return this.propertyMap.get(property);
        }
    }

    private static class BPSoftReference
    extends SoftReference<BeanProperties> {
        final Class<?> key;

        BPSoftReference(Class<?> key, BeanProperties beanProperties, ReferenceQueue<BeanProperties> refQ) {
            super(beanProperties, refQ);
            this.key = key;
        }
    }
}

