/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.security.common.CNonceCache;
import org.glassfish.security.common.NonceInfo;
import org.jvnet.hk2.annotations.Service;

@Service(name="CNonceCache")
@PerLookup
public final class CNonceCacheImpl
extends LinkedHashMap<String, NonceInfo>
implements CNonceCache {
    private static final long serialVersionUID = 4657887758539980470L;
    private static final long LOG_SUPPRESS_TIME = 300000L;
    private long lastLog = 0L;
    private static final Logger log = Logger.getLogger(CNonceCacheImpl.class.getName());
    private String eldestCNonce;
    private String storeName;
    long cnonceCacheSize = 1000L;
    long nonceValidity = 300000L;

    @Override
    protected boolean removeEldestEntry(Map.Entry<String, NonceInfo> eldest) {
        long currentTime = System.currentTimeMillis();
        this.eldestCNonce = eldest.getKey();
        if ((long)this.size() > this.getCnonceCacheSize()) {
            if (this.lastLog < currentTime && currentTime - eldest.getValue().getTimestamp() < this.getNonceValidity()) {
                this.lastLog = currentTime + 300000L;
                log.log(Level.WARNING, "The lastLog was set to {0}", this.lastLog);
            }
            return true;
        }
        return false;
    }

    @Override
    public long getCnonceCacheSize() {
        return this.cnonceCacheSize;
    }

    @Override
    public long getNonceValidity() {
        return this.nonceValidity;
    }

    public String getEldestCNonce() {
        return this.eldestCNonce;
    }

    @Override
    public void init(long size, String name, long validity, Map<String, String> props) {
        this.storeName = name;
        this.cnonceCacheSize = size;
        this.nonceValidity = validity;
    }

    @Override
    public void setCnonceCacheSize(long cnonceCacheSize) {
        this.cnonceCacheSize = cnonceCacheSize;
    }

    @Override
    public void setNonceValidity(long nonceValidity) {
        this.nonceValidity = nonceValidity;
    }

    @Override
    public void destroy() {
        this.clear();
    }
}

