/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.faces;

import com.sun.faces.facelets.el.VariableMapperWrapper;
import com.sun.faces.facelets.tag.MetaRulesetImpl;
import com.sun.faces.facelets.tag.MetadataTargetImpl;
import com.sun.faces.facelets.tag.faces.ActionSourceRule;
import com.sun.faces.facelets.tag.faces.ComponentSupport;
import com.sun.faces.facelets.tag.faces.ComponentTagHandlerDelegateImpl;
import com.sun.faces.facelets.tag.faces.EditableValueHolderRule;
import com.sun.faces.facelets.tag.faces.RenderPropertyRule;
import com.sun.faces.facelets.tag.faces.ValueHolderRule;
import com.sun.faces.facelets.util.ReflectionUtil;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.el.ELException;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import jakarta.faces.FacesException;
import jakarta.faces.FactoryFinder;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.application.Resource;
import jakarta.faces.component.ActionSource;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIPanel;
import jakarta.faces.component.UISelectMany;
import jakarta.faces.component.UISelectOne;
import jakarta.faces.component.UniqueIdVendor;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.view.AttachedObjectHandler;
import jakarta.faces.view.ViewDeclarationLanguage;
import jakarta.faces.view.ViewDeclarationLanguageFactory;
import jakarta.faces.view.facelets.ComponentConfig;
import jakarta.faces.view.facelets.ComponentHandler;
import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.MetaRule;
import jakarta.faces.view.facelets.MetaRuleset;
import jakarta.faces.view.facelets.Metadata;
import jakarta.faces.view.facelets.MetadataTarget;
import jakarta.faces.view.facelets.Tag;
import jakarta.faces.view.facelets.TagAttribute;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CompositeComponentTagHandler
extends ComponentHandler
implements ComponentTagHandlerDelegateImpl.CreateComponentDelegate {
    private static final Logger LOGGER = FacesLogger.TAGLIB.getLogger();
    private Resource ccResource;
    private TagAttribute binding;
    private static final String ccInstanceVariableStandinKey = CompositeComponentTagHandler.class.getName() + "_";
    private static final String ATTACHED_OBJECT_HANDLERS_KEY = "jakarta.faces.view.AttachedObjectHandlers";

    public CompositeComponentTagHandler(Resource ccResource, ComponentConfig config) {
        super(config);
        this.ccResource = ccResource;
        this.binding = config.getTag().getAttributes().get("binding");
        ((ComponentTagHandlerDelegateImpl)this.getTagHandlerDelegate()).setCreateCompositeComponentDelegate(this);
    }

    @Override
    public UIComponent createComponent(FaceletContext ctx) {
        UIComponent cc;
        FacesContext context = ctx.getFacesContext();
        if (this.binding != null) {
            ValueExpression ve = this.binding.getValueExpression(ctx, UIComponent.class);
            cc = (UIComponent)ve.getValue(ctx);
            if (cc != null && !UIComponent.isCompositeComponent(cc)) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "faces.compcomp.binding.eval.non.compcomp", this.binding.toString());
                }
                cc = null;
            }
            if (cc == null) {
                cc = context.getApplication().createComponent(context, this.ccResource);
                cc.setValueExpression("binding", ve);
                ve.setValue(ctx, cc);
            }
        } else {
            cc = context.getApplication().createComponent(context, this.ccResource);
        }
        context.getViewRoot().getAttributes().put("com.sun.faces.TreeHasDynamicComponents", Boolean.TRUE);
        this.setCompositeComponent(context, cc);
        return cc;
    }

    @Override
    public void applyNextHandler(FaceletContext ctx, UIComponent c) throws IOException, FacesException, ELException {
        this.setAttributes(ctx, c);
        super.applyNextHandler(ctx, c);
        this.applyCompositeComponent(ctx, c);
        if (ComponentHandler.isNew(c)) {
            FacesContext context = ctx.getFacesContext();
            String viewId = context.getViewRoot().getViewId();
            ViewDeclarationLanguageFactory factory = (ViewDeclarationLanguageFactory)FactoryFinder.getFactory("jakarta.faces.view.ViewDeclarationLanguageFactory");
            ViewDeclarationLanguage vdl = factory.getViewDeclarationLanguage(viewId);
            vdl.retargetAttachedObjects(context, c, CompositeComponentTagHandler.getAttachedObjectHandlers(c, false));
            vdl.retargetMethodExpressions(context, c);
            CompositeComponentTagHandler.getAttachedObjectHandlers(c).clear();
        }
    }

    @Override
    public void setCompositeComponent(FacesContext context, UIComponent cc) {
        String key;
        Map<Object, Object> contextMap = context.getAttributes();
        if (!contextMap.containsKey(key = ccInstanceVariableStandinKey + this.tagId)) {
            contextMap.put(key, cc);
        }
    }

    @Override
    public UIComponent getCompositeComponent(FacesContext context) {
        Map<Object, Object> contextMap = context.getAttributes();
        String key = ccInstanceVariableStandinKey + this.tagId;
        UIComponent result = (UIComponent)contextMap.get(key);
        return result;
    }

    @Override
    public void setAttributes(FaceletContext ctx, Object instance) {
        if (instance != null) {
            if (ctx.getFacesContext().isProjectStage(ProjectStage.Development)) {
                Metadata meta = this.createMetaRuleset(instance.getClass()).finish();
                meta.applyMetadata(ctx, instance);
            } else {
                super.setAttributes(ctx, instance);
            }
        }
    }

    @Override
    protected MetaRuleset createMetaRuleset(Class type2) {
        Util.notNull("type", type2);
        FacesContext context = FacesContext.getCurrentInstance();
        UIComponent cc = this.getCompositeComponent(context);
        if (null == cc) {
            FaceletContext faceletContext = (FaceletContext)context.getAttributes().get(FaceletContext.FACELET_CONTEXT_KEY);
            cc = this.createComponent(faceletContext);
            this.setCompositeComponent(context, cc);
        }
        CompositeComponentMetaRuleset m = new CompositeComponentMetaRuleset(this.getTag(), type2, (BeanInfo)cc.getAttributes().get("jakarta.faces.component.BEANINFO_KEY"));
        ((MetaRuleset)m).ignore("binding").ignore("id");
        ((MetaRuleset)m).addRule(CompositeComponentRule.Instance);
        if (ActionSource.class.isAssignableFrom(type2)) {
            ((MetaRuleset)m).addRule(ActionSourceRule.Instance);
        }
        if (ValueHolder.class.isAssignableFrom(type2)) {
            ((MetaRuleset)m).addRule(ValueHolderRule.Instance);
            if (EditableValueHolder.class.isAssignableFrom(type2)) {
                ((MetaRuleset)m).ignore("submittedValue");
                ((MetaRuleset)m).ignore("valid");
                ((MetaRuleset)m).addRule(EditableValueHolderRule.Instance);
            }
        }
        if (UISelectOne.class.isAssignableFrom(type2) || UISelectMany.class.isAssignableFrom(type2)) {
            ((MetaRuleset)m).addRule(RenderPropertyRule.Instance);
        }
        return m;
    }

    public static List<AttachedObjectHandler> getAttachedObjectHandlers(UIComponent component) {
        return CompositeComponentTagHandler.getAttachedObjectHandlers(component, true);
    }

    public static List<AttachedObjectHandler> getAttachedObjectHandlers(UIComponent component, boolean create) {
        Map<String, Object> attrs = component.getAttributes();
        ArrayList result = (ArrayList)attrs.get(ATTACHED_OBJECT_HANDLERS_KEY);
        if (result == null) {
            if (create) {
                result = new ArrayList();
                attrs.put(ATTACHED_OBJECT_HANDLERS_KEY, result);
            } else {
                result = Collections.EMPTY_LIST;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyCompositeComponent(FaceletContext ctx, UIComponent c) throws IOException {
        UIPanel facetComponent;
        FacesContext facesContext = ctx.getFacesContext();
        VariableMapper orig = ctx.getVariableMapper();
        if (ComponentHandler.isNew(c)) {
            facetComponent = (UIPanel)facesContext.getApplication().createComponent("jakarta.faces.Panel");
            facetComponent.setRendererType("jakarta.faces.Group");
            facetComponent.setId((c instanceof UniqueIdVendor ? (UniqueIdVendor)((Object)c) : ComponentSupport.getViewRoot(ctx, c)).createUniqueId(facesContext, null));
            c.getFacets().put("jakarta.faces.component.COMPOSITE_FACET_NAME", facetComponent);
        } else {
            facetComponent = (UIPanel)c.getFacets().get("jakarta.faces.component.COMPOSITE_FACET_NAME");
        }
        assert (null != facetComponent);
        try {
            VariableMapperWrapper wrapper = new VariableMapperWrapper(orig){

                @Override
                public ValueExpression resolveVariable(String variable) {
                    return super.resolveVariable(variable);
                }
            };
            ctx.setVariableMapper(wrapper);
            ctx.includeFacelet((UIComponent)facetComponent, this.ccResource.getURL());
        }
        finally {
            ctx.setVariableMapper(orig);
        }
    }

    private static final class CompositeComponentMetaRuleset
    extends MetaRulesetImpl {
        private BeanInfo compBeanInfo;
        private Class<?> type;

        public CompositeComponentMetaRuleset(Tag tag, Class<?> type2, BeanInfo compBeanInfo) {
            super(tag, type2);
            this.compBeanInfo = compBeanInfo;
            this.type = type2;
        }

        @Override
        protected MetadataTarget getMetadataTarget() {
            try {
                return new CompositeMetadataTarget(this.type, this.compBeanInfo);
            }
            catch (IntrospectionException ie) {
                throw new FacesException(ie);
            }
        }

        private static final class CompositeMetadataTarget
        extends MetadataTargetImpl {
            private BeanInfo compBeanInfo;

            public CompositeMetadataTarget(Class<?> type2, BeanInfo compBeanInfo) throws IntrospectionException {
                super(type2);
                this.compBeanInfo = compBeanInfo;
            }

            @Override
            public Class getPropertyType(String name) {
                PropertyDescriptor compDescriptor = this.findDescriptor(name);
                if (compDescriptor != null) {
                    Object obj = compDescriptor.getValue("type");
                    if (null != obj && !(obj instanceof Class)) {
                        ValueExpression typeVE = (ValueExpression)obj;
                        String className = (String)typeVE.getValue(FacesContext.getCurrentInstance().getELContext());
                        if (className != null) {
                            className = this.prefix(className);
                            try {
                                return ReflectionUtil.forName(className);
                            }
                            catch (ClassNotFoundException cnfe) {
                                throw new FacesException(cnfe);
                            }
                        }
                        return Object.class;
                    }
                    return (Class)obj;
                }
                return super.getPropertyType(name);
            }

            private PropertyDescriptor findDescriptor(String name) {
                for (PropertyDescriptor pd : this.compBeanInfo.getPropertyDescriptors()) {
                    if (!pd.getName().equals(name)) continue;
                    return pd;
                }
                return null;
            }

            private String prefix(String className) {
                if (className.indexOf(46) == -1 && Character.isUpperCase(className.charAt(0))) {
                    return "java.lang." + className;
                }
                return className;
            }
        }
    }

    private static class CompositeComponentRule
    extends MetaRule {
        private static final CompositeComponentRule Instance = new CompositeComponentRule();

        private CompositeComponentRule() {
        }

        @Override
        public Metadata applyRule(String name, TagAttribute attribute, MetadataTarget meta) {
            if (meta.isTargetInstanceOf(UIComponent.class)) {
                Class<Object> type2 = meta.getPropertyType(name);
                if (type2 == null) {
                    type2 = Object.class;
                }
                if (!attribute.isLiteral()) {
                    return new CompositeExpressionMetadata(name, type2, attribute);
                }
                return new LiteralAttributeMetadata(name, type2, attribute);
            }
            return null;
        }

        private static final class CompositeExpressionMetadata
        extends Metadata {
            private String name;
            private Class<?> type;
            private TagAttribute attr;

            public CompositeExpressionMetadata(String name, Class<?> type2, TagAttribute attr) {
                this.name = name;
                this.type = type2;
                this.attr = attr;
            }

            @Override
            public void applyMetadata(FaceletContext ctx, Object instance) {
                ValueExpression ve = this.attr.getValueExpression(ctx, this.type);
                UIComponent cc = (UIComponent)instance;
                assert (UIComponent.isCompositeComponent(cc));
                Map<String, Object> attrs = cc.getAttributes();
                BeanInfo componentMetadata = (BeanInfo)attrs.get("jakarta.faces.component.BEANINFO_KEY");
                BeanDescriptor desc = componentMetadata.getBeanDescriptor();
                Collection attributesWithDeclaredDefaultValues = (Collection)desc.getValue("jakarta.faces.component.ATTR_NAMES_WITH_DEFAULT_VALUES");
                if (null != attributesWithDeclaredDefaultValues && attributesWithDeclaredDefaultValues.contains(this.name) && attrs.containsKey(this.name)) {
                    attrs.remove(this.name);
                }
                cc.setValueExpression(this.name, ve);
            }
        }

        private static final class LiteralAttributeMetadata
        extends Metadata {
            private String name;
            private Class<?> type;
            private TagAttribute attribute;

            public LiteralAttributeMetadata(String name, Class<?> type2, TagAttribute attribute) {
                this.name = name;
                this.type = type2;
                this.attribute = attribute;
            }

            @Override
            public void applyMetadata(FaceletContext ctx, Object instance) {
                UIComponent c = (UIComponent)instance;
                Object value = this.attribute.getObject(ctx, this.type);
                if (value != null) {
                    c.getAttributes().put(this.name, value);
                }
            }
        }
    }
}

