/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config;

import com.sun.faces.config.ConfigureListener;
import com.sun.faces.config.InitFacesContext;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.annotation.FacesConfig;
import jakarta.faces.application.ResourceDependencies;
import jakarta.faces.application.ResourceDependency;
import jakarta.faces.component.FacesComponent;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.behavior.FacesBehavior;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.FacesConverter;
import jakarta.faces.event.ListenerFor;
import jakarta.faces.event.ListenersFor;
import jakarta.faces.event.NamedEvent;
import jakarta.faces.event.PhaseListener;
import jakarta.faces.flow.FlowScoped;
import jakarta.faces.flow.builder.FlowBuilderParameter;
import jakarta.faces.flow.builder.FlowDefinition;
import jakarta.faces.lifecycle.ClientWindowScoped;
import jakarta.faces.model.DataModel;
import jakarta.faces.model.FacesDataModel;
import jakarta.faces.push.Push;
import jakarta.faces.render.FacesBehaviorRenderer;
import jakarta.faces.render.FacesRenderer;
import jakarta.faces.render.Renderer;
import jakarta.faces.validator.FacesValidator;
import jakarta.faces.validator.Validator;
import jakarta.faces.view.ViewScoped;
import jakarta.faces.webapp.FacesServlet;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.annotation.HandlesTypes;
import jakarta.websocket.server.ServerContainer;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@HandlesTypes(value={ClientWindowScoped.class, Converter.class, DataModel.class, FacesBehavior.class, FacesBehaviorRenderer.class, FacesComponent.class, FacesConfig.class, FacesConverter.class, FacesDataModel.class, FacesRenderer.class, FacesValidator.class, FlowBuilderParameter.class, FlowDefinition.class, FlowScoped.class, ListenerFor.class, ListenersFor.class, NamedEvent.class, PhaseListener.class, Push.class, Renderer.class, ResourceDependencies.class, ResourceDependency.class, UIComponent.class, Validator.class, ViewScoped.class})
public class FacesInitializer
implements ServletContainerInitializer {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    public static final String FACES_PACKAGE_PREFIX = "jakarta.faces.";
    public static final String MOJARRA_PACKAGE_PREFIX = "com.sun.faces.";
    public static final String MOJARRA_TEST_PACKAGE_PREFIX = "com.sun.faces.test.";
    private static final String FACES_CONFIG_RESOURCE_PATH = "/WEB-INF/faces-config.xml";
    private static final String FACES_SERVLET_CLASS_NAME = FacesServlet.class.getName();
    private static final String[] FACES_SERVLET_MAPPINGS_WITH_XHTML = new String[]{"/faces/*", "*.jsf", "*.faces", "*.xhtml"};
    private static final String[] FACES_SERVLET_MAPPINGS_WITHOUT_XHTML = new String[]{"/faces/*", "*.jsf", "*.faces"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        boolean appHasFacesContent = !Util.isEmpty(classes) || FacesInitializer.isFacesConfigFilePresent(servletContext);
        boolean appHasFacesServlet = FacesInitializer.isFacesServletRegistrationPresent(servletContext);
        if (appHasFacesContent || appHasFacesServlet) {
            FacesInitializer.addAnnotatedClasses(classes, servletContext);
            InitFacesContext initFacesContext = new InitFacesContext(servletContext);
            try {
                if (appHasFacesContent) {
                    FacesInitializer.handleMappingConcerns(servletContext);
                }
                FacesInitializer.handleCdiConcerns(servletContext);
                FacesInitializer.handleWebSocketConcerns(servletContext);
                servletContext.addListener(ConfigureListener.class);
            }
            finally {
                initFacesContext.releaseCurrentInstance();
                initFacesContext.release();
            }
        } else if (servletContext.getAttribute("com.sun.faces.AnnotatedClasses") != null) {
            servletContext.removeAttribute("com.sun.faces.AnnotatedClasses");
        }
    }

    public static void addAnnotatedClasses(Set<Class<?>> classes, ServletContext servletContext) {
        if (Util.isEmpty(classes)) {
            return;
        }
        Set existingClasses = (Set)servletContext.getAttribute("com.sun.faces.AnnotatedClasses");
        if (Util.isEmpty(existingClasses)) {
            servletContext.setAttribute("com.sun.faces.AnnotatedClasses", classes);
            return;
        }
        HashSet newAnnotatedClasses = new HashSet();
        newAnnotatedClasses.addAll(classes);
        newAnnotatedClasses.addAll(existingClasses);
        servletContext.setAttribute("com.sun.faces.AnnotatedClasses", newAnnotatedClasses);
    }

    private static boolean isFacesConfigFilePresent(ServletContext context) {
        try {
            return context.getResource(FACES_CONFIG_RESOURCE_PATH) != null;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    private static boolean isFacesServletRegistrationPresent(ServletContext context) {
        return FacesInitializer.getExistingFacesServletRegistration(context) != null;
    }

    private static ServletRegistration getExistingFacesServletRegistration(ServletContext servletContext) {
        Map<String, ? extends ServletRegistration> existing = servletContext.getServletRegistrations();
        for (ServletRegistration servletRegistration : existing.values()) {
            if (!FACES_SERVLET_CLASS_NAME.equals(servletRegistration.getClassName())) continue;
            return servletRegistration;
        }
        return null;
    }

    private static void handleMappingConcerns(ServletContext servletContext) throws ServletException {
        ServletRegistration existingFacesServletRegistration = FacesInitializer.getExistingFacesServletRegistration(servletContext);
        if (existingFacesServletRegistration != null) {
            servletContext.setAttribute("com.sun.faces.FacesServletRegistration", existingFacesServletRegistration);
            return;
        }
        ServletRegistration.Dynamic newFacesServletRegistration = servletContext.addServlet(FacesServlet.class.getSimpleName(), FACES_SERVLET_CLASS_NAME);
        if (Boolean.parseBoolean(servletContext.getInitParameter("jakarta.faces.DISABLE_FACESSERVLET_TO_XHTML"))) {
            newFacesServletRegistration.addMapping(FACES_SERVLET_MAPPINGS_WITHOUT_XHTML);
        } else {
            newFacesServletRegistration.addMapping(FACES_SERVLET_MAPPINGS_WITH_XHTML);
        }
        servletContext.setAttribute("com.sun.faces.FacesServletMappings", newFacesServletRegistration.getMappings());
        servletContext.setAttribute("com.sun.faces.FacesServletRegistration", newFacesServletRegistration);
    }

    private static void handleCdiConcerns(ServletContext context) throws ServletException {
        Class<?> weldInitializerClass;
        if (context.getAttribute("org.jboss.weld.environment.servlet.jakarta.enterprise.inject.spi.BeanManager") instanceof BeanManager) {
            return;
        }
        ClassLoader cl = context.getClassLoader();
        try {
            weldInitializerClass = cl.loadClass("org.jboss.weld.environment.servlet.EnhancedListener");
        }
        catch (ClassNotFoundException ignore) {
            return;
        }
        context.setInitParameter("org.jboss.weld.environment.servlet.archive.isolation", "false");
        if (context.getAttribute("org.jboss.weld.environment.servlet.enhancedListenerUsed") == Boolean.TRUE) {
            try {
                LOGGER.log(Level.WARNING, "Weld skipped initialization - forcing it to reinitialize");
                ServletContainerInitializer weldInitializer = (ServletContainerInitializer)weldInitializerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                weldInitializer.onStartup(null, context);
            }
            catch (Exception | LinkageError e) {
                throw new ServletException("Reinitializing Weld failed - giving up, please make sure your project contains at least one bean class with a bean defining annotation and retry", e);
            }
        }
    }

    private static void handleWebSocketConcerns(ServletContext context) throws ServletException {
        Class<?> tyrusInitializerClass;
        if (context.getAttribute(ServerContainer.class.getName()) != null) {
            return;
        }
        if (!Boolean.parseBoolean(context.getInitParameter("jakarta.faces.ENABLE_WEBSOCKET_ENDPOINT"))) {
            return;
        }
        ClassLoader cl = context.getClassLoader();
        try {
            tyrusInitializerClass = cl.loadClass("org.glassfish.tyrus.servlet.TyrusServletContainerInitializer");
        }
        catch (ClassNotFoundException ignore) {
            return;
        }
        try {
            ServletContainerInitializer tyrusInitializer = (ServletContainerInitializer)tyrusInitializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Class<?> tyrusConfigClass = cl.loadClass("org.glassfish.tyrus.server.TyrusServerConfiguration");
            HashSet handledTypes = new HashSet();
            handledTypes.add(tyrusConfigClass);
            tyrusInitializer.onStartup(handledTypes, context);
        }
        catch (Exception e) {
            throw new ServletException(e);
        }
    }
}

