/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.cdi;

import com.sun.faces.cdi.AnyAnnotationLiteral;
import com.sun.faces.cdi.CdiExtension;
import com.sun.faces.cdi.CdiUtils;
import com.sun.faces.cdi.DefaultAnnotationLiteral;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.faces.context.FacesContext;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

abstract class CdiProducer<T>
implements Bean<T>,
PassivationCapable,
Serializable {
    private static final long serialVersionUID = 1L;
    private String id = this.getClass().getName();
    private String name;
    private Class<?> beanClass = Object.class;
    private Set<Type> types = Collections.singleton(Object.class);
    private Set<Annotation> qualifiers = Collections.unmodifiableSet(CdiProducer.asSet(new DefaultAnnotationLiteral(), new AnyAnnotationLiteral()));
    private Class<? extends Annotation> scope = Dependent.class;
    private Function<CreationalContext<T>, T> create;

    CdiProducer() {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public Set<Type> getTypes() {
        return this.types;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        return FacesContext.getCurrentInstance() != null ? (T)this.create.apply(creationalContext) : null;
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    @Override
    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    protected CdiProducer<T> name(String name) {
        this.name = name;
        return this;
    }

    protected CdiProducer<T> create(Function<CreationalContext<T>, T> create) {
        this.create = create;
        return this;
    }

    protected CdiProducer<T> beanClass(BeanManager beanManager, Class<?> beanClass) {
        this.beanClass = CdiUtils.isWeld(beanManager) ? CdiExtension.class : beanClass;
        return this;
    }

    protected CdiProducer<T> types(Type ... types) {
        this.types = CdiProducer.asSet(types);
        this.types.add(this.getClass());
        return this;
    }

    protected CdiProducer<T> qualifiers(Annotation ... qualifiers) {
        this.qualifiers = CdiProducer.asSet(qualifiers);
        return this;
    }

    protected CdiProducer<T> scope(Class<? extends Annotation> scope) {
        this.scope = scope;
        return this;
    }

    protected CdiProducer<T> addToId(Object object) {
        this.id = this.id + " " + object.toString();
        return this;
    }

    @SafeVarargs
    private static <T> Set<T> asSet(T ... a) {
        return new HashSet<T>(Arrays.asList(a));
    }
}

