/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.StateHolderSaver;
import com.sun.faces.context.StateContext;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.ComponentStruct;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import jakarta.faces.FacesException;
import jakarta.faces.application.ProjectStage;
import jakarta.faces.application.ViewHandler;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIForm;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.component.visit.VisitContext;
import jakarta.faces.component.visit.VisitHint;
import jakarta.faces.component.visit.VisitResult;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.ResponseStateManager;
import jakarta.faces.view.StateManagementStrategy;
import jakarta.faces.view.ViewDeclarationLanguage;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FaceletFullStateManagementStrategy
extends StateManagementStrategy {
    private static final Logger LOGGER = FacesLogger.APPLICATION_VIEW.getLogger();
    private static final Set<VisitHint> SKIP_ITERATION_HINT = EnumSet.of(VisitHint.SKIP_ITERATION);
    private Map<String, Class<?>> classMap;
    private boolean isDevelopmentMode;

    public FaceletFullStateManagementStrategy() {
        this(FacesContext.getCurrentInstance());
    }

    public FaceletFullStateManagementStrategy(FacesContext context) {
        this.isDevelopmentMode = context.isProjectStage(ProjectStage.Development);
        this.classMap = new ConcurrentHashMap(32);
    }

    private void captureChild(List<TreeNode> tree, int parent, UIComponent component) {
        if (!component.isTransient() && !component.getAttributes().containsKey("com.sun.faces.DynamicComponent")) {
            TreeNode treeNode = new TreeNode(parent, component);
            int pos = tree.size();
            tree.add(treeNode);
            this.captureRest(tree, pos, component);
        }
    }

    private void captureFacet(List<TreeNode> tree, int parent, String name, UIComponent component) {
        if (!component.isTransient() && !component.getAttributes().containsKey("com.sun.faces.DynamicComponent")) {
            FacetNode facetNode = new FacetNode(parent, name, component);
            int pos = tree.size();
            tree.add(facetNode);
            this.captureRest(tree, pos, component);
        }
    }

    private void captureRest(List<TreeNode> tree, int pos, UIComponent component) {
        int sz = component.getChildCount();
        if (sz > 0) {
            List<UIComponent> child = component.getChildren();
            for (int i = 0; i < sz; ++i) {
                this.captureChild(tree, pos, child.get(i));
            }
        }
        if ((sz = component.getFacetCount()) > 0) {
            for (Map.Entry<String, UIComponent> entry : component.getFacets().entrySet()) {
                this.captureFacet(tree, pos, entry.getKey(), entry.getValue());
            }
        }
    }

    private UIComponent locateComponentByClientId(FacesContext context, UIComponent subTree, String clientId) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "FaceletFullStateManagementStrategy.locateComponentByClientId", clientId);
        }
        ArrayList found = new ArrayList();
        UIComponent result = null;
        VisitContext visitContext = VisitContext.createVisitContext(context, null, SKIP_ITERATION_HINT);
        subTree.visitTree(visitContext, (visitContext1, component) -> {
            VisitResult result1 = VisitResult.ACCEPT;
            if (component.getClientId(visitContext1.getFacesContext()).equals(clientId)) {
                found.add(component);
                result1 = VisitResult.COMPLETE;
            } else if (component instanceof UIForm) {
                UIForm form = (UIForm)component;
                if (form.isPrependId() && !clientId.startsWith(form.getClientId(visitContext1.getFacesContext()))) {
                    result1 = VisitResult.REJECT;
                }
            } else if (component instanceof NamingContainer && !clientId.startsWith(component.getClientId(visitContext1.getFacesContext()))) {
                result1 = VisitResult.REJECT;
            }
            return result1;
        });
        if (!found.isEmpty()) {
            result = (UIComponent)found.get(0);
        }
        return result;
    }

    private UIComponent newInstance(TreeNode treeNode) throws FacesException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "FaceletFullStateManagementStrategy.newInstance", treeNode.componentType);
        }
        try {
            Class clazz;
            Class clazz2 = clazz = this.classMap != null ? this.classMap.get(treeNode.componentType) : null;
            if (clazz == null) {
                clazz = Util.loadClass(treeNode.componentType, treeNode);
                if (!Util.isAnyNull(clazz, this.classMap)) {
                    this.classMap.put(treeNode.componentType, clazz);
                } else if (!this.isDevelopmentMode) {
                    throw new NullPointerException();
                }
            }
            UIComponent component = (UIComponent)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            component.setId(treeNode.id);
            return component;
        }
        catch (IllegalArgumentException | NullPointerException | ReflectiveOperationException | SecurityException e) {
            throw new FacesException(e);
        }
    }

    private void pruneAndReAddToDynamicActions(List<ComponentStruct> dynamicActionList, ComponentStruct struct) {
        int firstIndex;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletFullStateManagementStrategy.pruneAndReAddToDynamicActions");
        }
        if ((firstIndex = dynamicActionList.indexOf(struct)) == -1) {
            dynamicActionList.add(struct);
        } else {
            int lastIndex = dynamicActionList.lastIndexOf(struct);
            if (lastIndex == -1 || lastIndex == firstIndex) {
                dynamicActionList.add(struct);
            } else {
                if ("ADD".equals(struct.getAction())) {
                    dynamicActionList.remove(lastIndex);
                    dynamicActionList.remove(firstIndex);
                    dynamicActionList.add(struct);
                }
                if ("REMOVE".equals(struct.getAction())) {
                    dynamicActionList.remove(lastIndex);
                }
            }
        }
    }

    private void restoreComponentState(FacesContext context, HashMap<String, Object> state) {
        StateContext stateContext = StateContext.getStateContext(context);
        UIViewRoot viewRoot = context.getViewRoot();
        VisitContext visitContext = VisitContext.createVisitContext(context, null, SKIP_ITERATION_HINT);
        viewRoot.visitTree(visitContext, (visitContext1, component) -> {
            VisitResult result = VisitResult.ACCEPT;
            String clientId = component.getClientId(context);
            Object stateObj = state.get(clientId);
            if (stateObj != null && !stateContext.componentAddedDynamically(component)) {
                boolean restoreStateNow = true;
                if (stateObj instanceof StateHolderSaver) {
                    boolean bl = restoreStateNow = !((StateHolderSaver)stateObj).componentAddedDynamically();
                }
                if (restoreStateNow) {
                    try {
                        component.restoreState(context, stateObj);
                    }
                    catch (Exception e) {
                        throw new FacesException(e);
                    }
                }
            }
            return result;
        });
    }

    private void restoreDynamicActions(FacesContext context, StateContext stateContext, HashMap<String, Object> state) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletFullStateManagementStrategy.restoreDynamicActions");
        }
        List savedActions = (List)context.getViewRoot().getAttributes().get("com.sun.faces.DynamicActions");
        List<ComponentStruct> actions2 = stateContext.getDynamicActions();
        if (!Util.isEmpty(savedActions)) {
            for (Object savedAction : savedActions) {
                ComponentStruct action = new ComponentStruct();
                action.restoreState(context, savedAction);
                if ("ADD".equals(action.getAction())) {
                    this.restoreDynamicAdd(context, state, action);
                }
                if ("REMOVE".equals(action.getAction())) {
                    this.restoreDynamicRemove(context, action);
                }
                this.pruneAndReAddToDynamicActions(actions2, action);
            }
        }
    }

    private void restoreDynamicAdd(FacesContext context, Map<String, Object> state, ComponentStruct struct) {
        UIComponent parent;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletFullStateManagementStrategy.restoreDynamicAdd");
        }
        if ((parent = this.locateComponentByClientId(context, context.getViewRoot(), struct.getParentClientId())) != null) {
            StateHolderSaver saver;
            UIComponent child = this.locateComponentByClientId(context, parent, struct.getClientId());
            if (child != null) {
                if (struct.getFacetName() == null) {
                    parent.getChildren().remove(child);
                } else {
                    parent.getFacets().remove(struct.getFacetName());
                }
            }
            if (child == null && (saver = (StateHolderSaver)state.get(struct.getClientId())) != null) {
                child = (UIComponent)saver.restore(context);
            }
            StateContext stateContext = StateContext.getStateContext(context);
            if (child == null) {
                child = stateContext.getDynamicComponents().get(struct.getClientId());
            }
            if (child != null) {
                if (struct.getFacetName() != null) {
                    parent.getFacets().put(struct.getFacetName(), child);
                } else {
                    int childIndex = -1;
                    if (child.getAttributes().containsKey("com.sun.faces.DynamicComponent")) {
                        childIndex = (Integer)child.getAttributes().get("com.sun.faces.DynamicComponent");
                    }
                    child.setId(struct.getId());
                    if (childIndex >= parent.getChildCount() || childIndex == -1) {
                        parent.getChildren().add(child);
                    } else {
                        parent.getChildren().add(childIndex, child);
                    }
                    child.getClientId();
                }
                child.getAttributes().put("com.sun.faces.DynamicComponent", child.getParent().getChildren().indexOf(child));
                stateContext.getDynamicComponents().put(struct.getClientId(), child);
            }
        }
    }

    private void restoreDynamicRemove(FacesContext context, ComponentStruct struct) {
        UIComponent child;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletFullStateManagementStrategy.restoreDynamicRemove");
        }
        if ((child = this.locateComponentByClientId(context, context.getViewRoot(), struct.getClientId())) != null) {
            StateContext stateContext = StateContext.getStateContext(context);
            stateContext.getDynamicComponents().put(struct.getClientId(), child);
            UIComponent parent = child.getParent();
            if (struct.getFacetName() != null) {
                parent.getFacets().remove(struct.getFacetName());
            } else {
                parent.getChildren().remove(child);
            }
        }
    }

    private UIViewRoot restoreTree(FacesContext context, String renderKitId, Object[] tree) throws FacesException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "FaceletFullStateManagementStrategy.restoreTree", renderKitId);
        }
        for (int i = 0; i < tree.length; ++i) {
            UIComponent component;
            if (tree[i] instanceof FacetNode) {
                FacetNode facetNode = (FacetNode)tree[i];
                component = this.newInstance(facetNode);
                tree[i] = component;
                if (i == facetNode.getParent()) continue;
                ((UIComponent)tree[facetNode.getParent()]).getFacets().put(facetNode.facetName, component);
                continue;
            }
            TreeNode treeNode = (TreeNode)tree[i];
            component = this.newInstance(treeNode);
            tree[i] = component;
            if (i != treeNode.parent) {
                ((UIComponent)tree[treeNode.parent]).getChildren().add(component);
                continue;
            }
            UIViewRoot viewRoot = (UIViewRoot)component;
            context.setViewRoot(viewRoot);
            viewRoot.setRenderKitId(renderKitId);
        }
        return (UIViewRoot)tree[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "FaceletFullStateManagementStrategy.restoreView", new Object[]{viewId, renderKitId});
        }
        UIViewRoot result = null;
        ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, renderKitId);
        Object[] state = (Object[])rsm.getState(context, viewId);
        if (state != null && state.length >= 2) {
            if (state[0] != null) {
                result = this.restoreTree(context, renderKitId, (Object[])((Object[])state[0]).clone());
                context.setViewRoot(result);
            }
            if (result != null) {
                StateContext stateContext = StateContext.getStateContext(context);
                stateContext.startTrackViewModifications(context, result);
                stateContext.setTrackViewModifications(false);
                try {
                    HashMap stateMap = (HashMap)state[1];
                    if (stateMap != null) {
                        this.restoreComponentState(context, stateMap);
                        this.restoreDynamicActions(context, stateContext, stateMap);
                    }
                }
                finally {
                    stateContext.setTrackViewModifications(true);
                }
            }
        }
        ViewHandler viewHandler = context.getApplication().getViewHandler();
        ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(context, viewId);
        context.setResourceLibraryContracts(vdl.calculateResourceLibraryContracts(context, viewId));
        return result;
    }

    private Object saveComponentState(FacesContext context) {
        HashMap stateMap = new HashMap();
        StateContext stateContext = StateContext.getStateContext(context);
        UIViewRoot viewRoot = context.getViewRoot();
        FacesContext finalContext = context;
        VisitContext visitContext = VisitContext.createVisitContext(context, null, SKIP_ITERATION_HINT);
        viewRoot.visitTree(visitContext, (context1, component) -> {
            VisitResult result = VisitResult.ACCEPT;
            if (!component.isTransient()) {
                Object stateObj;
                if (stateContext.componentAddedDynamically(component)) {
                    component.getAttributes().put("com.sun.faces.DynamicComponent", this.getProperChildIndex(component));
                    stateObj = new StateHolderSaver(finalContext, component);
                } else {
                    stateObj = component.saveState(finalContext);
                }
                if (stateObj != null) {
                    stateMap.put(component.getClientId(finalContext), stateObj);
                }
            } else {
                result = VisitResult.REJECT;
            }
            return result;
        });
        return stateMap;
    }

    private void saveDynamicActions(FacesContext context, StateContext stateContext, UIViewRoot viewRoot) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletFullStateManagementStrategy.saveDynamicActions");
        }
        List<ComponentStruct> actions2 = stateContext.getDynamicActions();
        HashMap<String, UIComponent> componentMap = stateContext.getDynamicComponents();
        if (actions2 != null) {
            ArrayList<Object> savedActions = new ArrayList<Object>(actions2.size());
            for (ComponentStruct action : actions2) {
                UIComponent component = componentMap.get(action.getClientId());
                if (component == null && context.isProjectStage(ProjectStage.Development)) {
                    LOGGER.log(Level.WARNING, "Unable to save dynamic action with clientId ''{0}'' because the UIComponent cannot be found", action.getClientId());
                }
                if (component == null) continue;
                savedActions.add(action.saveState(context));
            }
            viewRoot.getAttributes().put("com.sun.faces.DynamicActions", savedActions);
        }
    }

    @Override
    public Object saveView(FacesContext context) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("FaceletFullStateManagementStrategy.saveView");
        }
        UIViewRoot viewRoot = context.getViewRoot();
        Util.checkIdUniqueness(context, viewRoot, new HashSet<String>(viewRoot.getChildCount() << 1));
        StateContext stateContext = StateContext.getStateContext(context);
        this.saveDynamicActions(context, stateContext, viewRoot);
        Object state = this.saveComponentState(context);
        ArrayList<TreeNode> treeList = new ArrayList<TreeNode>(32);
        this.captureChild(treeList, 0, viewRoot);
        Object[] tree = treeList.toArray();
        Object[] result = new Object[]{tree, state};
        StateContext.release(context);
        return result;
    }

    private int getProperChildIndex(UIComponent component) {
        int result = -1;
        if (component.getParent().getChildren().contains(component)) {
            UIComponent parent = component.getParent();
            int index = 0;
            for (UIComponent child : parent.getChildren()) {
                if (child == component) break;
                if (child.isTransient()) continue;
                ++index;
            }
            if (index == 0 && !parent.getChildren().isEmpty() && parent.getChildren().get(0).isTransient()) {
                index = -1;
            }
            result = index;
        }
        return result;
    }

    private static class TreeNode
    implements Externalizable {
        private static final long serialVersionUID = -835775352718473281L;
        private static final String NULL_ID = "";
        private String componentType;
        private String id;
        private int parent;

        public TreeNode() {
        }

        public TreeNode(int parent, UIComponent c) {
            this.parent = parent;
            this.id = c.getId();
            this.componentType = c.getClass().getName();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.parent = in.readInt();
            this.componentType = in.readUTF();
            this.id = in.readUTF();
            if (this.id.length() == 0) {
                this.id = null;
            }
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.parent);
            out.writeUTF(this.componentType);
            if (this.id != null) {
                out.writeUTF(this.id);
            } else {
                out.writeUTF(NULL_ID);
            }
        }

        public int getParent() {
            return this.parent;
        }
    }

    private static final class FacetNode
    extends TreeNode {
        private static final long serialVersionUID = -3777170310958005106L;
        private String facetName;

        public FacetNode() {
        }

        public FacetNode(int parent, String name, UIComponent c) {
            super(parent, c);
            this.facetName = name;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            super.readExternal(in);
            this.facetName = in.readUTF();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            super.writeExternal(out);
            out.writeUTF(this.facetName);
        }
    }
}

