/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.io.ServerDirs;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.enterprise.v3.server.SystemTasks;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service
@RunLevel(value=1, mode=0)
public class SystemTasksImpl
implements SystemTasks,
PostConstruct {
    private static final Logger LOG = KernelLoggerInfo.getLogger();
    private static final LocalStringsImpl I18N = new LocalStringsImpl(SystemTasks.class);
    @Inject
    private ServerEnvironment env;
    @Inject
    @Optional
    @Named(value="default-instance-name")
    private JavaConfig javaConfig;
    @Inject
    @Named(value="default-instance-name")
    private Server server;
    @Inject
    private Domain domain;

    @Override
    public void postConstruct() {
        this.setVersion();
        this.setSystemPropertiesFromEnv();
        this.setSystemPropertiesFromDomainXml();
        this.resolveJavaConfig();
        LOG.log(Level.FINE, "SystemTasks: loaded server named: {0}", this.server.getName());
    }

    @Override
    public void writePidFile() {
        File pidFile = null;
        try {
            ServerDirs serverDirs = new ServerDirs(this.env.getInstanceRoot());
            ProcessUtils.saveCurrentPid(serverDirs.getLastPidFile());
            pidFile = serverDirs.getPidFile();
            pidFile.deleteOnExit();
            ProcessUtils.saveCurrentPid(pidFile);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, I18N.get("internal_error", e), e);
        }
    }

    private void setVersion() {
        System.setProperty("glassfish.version", Version.getProductIdInfo());
    }

    private void setSystemProperty(String name, String value) {
        System.setProperty(name, value);
    }

    private void setSystemPropertiesFromEnv() {
        this.setSystemProperty("com.sun.aas.javaRoot", System.getProperty("java.home"));
        String hostname = "localhost";
        try {
            hostname = NetUtils.getCanonicalHostName();
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "NCLS-CORE-00089", ex);
        }
        if (hostname != null) {
            this.setSystemProperty("com.sun.aas.hostName", hostname);
        }
    }

    private void setSystemPropertiesFromDomainXml() {
        List<SystemProperty> domainSPList = this.domain.getSystemProperty();
        List<SystemProperty> configSPList = this.getConfigSystemProperties();
        Cluster cluster = this.server.getCluster();
        List<SystemProperty> clusterSPList = cluster == null ? null : cluster.getSystemProperty();
        List<SystemProperty> serverSPList = this.server.getSystemProperty();
        this.setSystemProperties(domainSPList);
        this.setSystemProperties(configSPList);
        if (clusterSPList != null) {
            this.setSystemProperties(clusterSPList);
        }
        this.setSystemProperties(serverSPList);
    }

    private List<SystemProperty> getConfigSystemProperties() {
        try {
            String configName = this.server.getConfigRef();
            Configs configs = this.domain.getConfigs();
            List<Config> configsList = configs.getConfig();
            Config config = null;
            for (Config c : configsList) {
                if (!c.getName().equals(configName)) continue;
                config = c;
                break;
            }
            return config == null ? Collections.emptyList() : config.getSystemProperty();
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    private void resolveJavaConfig() {
        if (this.javaConfig != null) {
            Pattern p = Pattern.compile("-D([^=]*)=(.*)");
            for (String jvmOption : this.javaConfig.getJvmOptions()) {
                Matcher m = p.matcher(jvmOption);
                if (!m.matches()) continue;
                String name = m.group(1);
                String value = TranslatedConfigView.expandValue(m.group(2));
                LOG.log(Level.FINEST, "Setting {0}={1}", new Object[]{name, value});
                this.setSystemProperty(name, value);
            }
        }
    }

    private void setSystemProperties(List<SystemProperty> spList) {
        for (SystemProperty sp : spList) {
            String name = sp.getName();
            String value = sp.getValue();
            if (!SystemTasksImpl.ok(name)) continue;
            this.setSystemProperty(name, value);
        }
    }

    private static boolean ok(String s) {
        return s != null && !s.isEmpty();
    }
}

