/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.classmodel.reflect.AnnotatedElement;
import org.glassfish.hk2.classmodel.reflect.AnnotationType;
import org.glassfish.hk2.classmodel.reflect.Member;
import org.glassfish.hk2.classmodel.reflect.Parameter;
import org.glassfish.hk2.classmodel.reflect.ParameterizedType;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.deployment.SnifferManager;
import org.jvnet.hk2.annotations.Service;

@Service
public class SnifferManagerImpl
implements SnifferManager {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(SnifferManagerImpl.class);
    @Inject
    protected ServiceLocator serviceLocator;

    @Override
    public Collection<Sniffer> getSniffers() {
        ArrayList<Sniffer> sniffers = new ArrayList<Sniffer>(this.serviceLocator.getAllServices(Sniffer.class, new Annotation[0]));
        Collections.sort(sniffers, (o1, o2) -> o1.getModuleType().compareTo(o2.getModuleType()));
        return sniffers;
    }

    @Override
    public final boolean hasNoSniffers() {
        return this.getSniffers().isEmpty();
    }

    @Override
    public Sniffer getSniffer(String appType) {
        assert (appType != null);
        for (Sniffer sniffer : this.getSniffers()) {
            if (!appType.equalsIgnoreCase(sniffer.getModuleType())) continue;
            return sniffer;
        }
        return null;
    }

    @Override
    public Collection<Sniffer> getSniffers(DeploymentContext context) {
        return this.getSniffers(context, context.getArchiveHandler().getClassPathURIs(context.getSource()), context.getTransientAppMetaData(Types.class.getName(), Types.class));
    }

    @Override
    public Collection<Sniffer> getSniffers(DeploymentContext context, List<URI> uris, Types types) {
        Collection<Sniffer> regularSniffers = this.getSniffers();
        List<Sniffer> appSniffers = this.getApplicableSniffers(context, uris, types, regularSniffers, true);
        for (Sniffer sniffer : regularSniffers) {
            if (appSniffers.contains(sniffer) || !sniffer.handles(context)) continue;
            appSniffers.add(sniffer);
        }
        return appSniffers;
    }

    private <T extends Sniffer> List<T> getApplicableSniffers(DeploymentContext context, List<URI> uris, Types types, Collection<T> sniffers, boolean checkPath) {
        if (sniffers == null || sniffers.isEmpty() || types == null || types.getAllTypes().isEmpty()) {
            return new ArrayList();
        }
        ArchiveType archiveType = this.serviceLocator.getService(ArchiveType.class, context.getArchiveHandler().getArchiveType(), new Annotation[0]);
        ArrayList<Sniffer> applicableSniffers = new ArrayList<Sniffer>();
        for (Sniffer sniffer : sniffers) {
            String[] annotationNames;
            if (archiveType != null && !sniffer.supportsArchiveType(archiveType) || (annotationNames = sniffer.getAnnotationNames(context)) == null) continue;
            block1: for (String annotationName : annotationNames) {
                Type type2 = types.getBy(annotationName);
                if (!(type2 instanceof AnnotationType)) continue;
                Collection<AnnotatedElement> elements = ((AnnotationType)type2).allAnnotatedTypes();
                for (AnnotatedElement element : elements) {
                    if (checkPath) {
                        Type t = SnifferManagerImpl.getDeclaringType(element);
                        if (t == null || !t.wasDefinedIn(uris)) continue;
                        applicableSniffers.add(sniffer);
                        continue block1;
                    }
                    applicableSniffers.add(sniffer);
                    continue block1;
                }
            }
        }
        return applicableSniffers;
    }

    public void validateSniffers(Collection<? extends Sniffer> sniffers, DeploymentContext context) {
        for (Sniffer sniffer : sniffers) {
            String[] incompatibleTypes = sniffer.getIncompatibleSnifferTypes();
            if (incompatibleTypes == null) {
                return;
            }
            for (String type2 : incompatibleTypes) {
                for (Sniffer sniffer2 : sniffers) {
                    if (!sniffer2.getModuleType().equals(type2)) continue;
                    throw new IllegalArgumentException(localStrings.getLocalString("invalidarchivepackaging", "Invalid archive packaging {2}", sniffer.getModuleType(), type2, context.getSourceDir().getPath()));
                }
            }
        }
    }

    private static Type getDeclaringType(AnnotatedElement element) {
        if (element instanceof Type) {
            return (Type)element;
        }
        if (element instanceof Member) {
            return ((Member)((Object)element)).getDeclaringType();
        }
        if (element instanceof Parameter) {
            return SnifferManagerImpl.getDeclaringType(((Parameter)element).getMethod());
        }
        if (element instanceof ParameterizedType) {
            return ((ParameterizedType)((Object)element)).getType();
        }
        throw new IllegalStateException("Unable to recognise declaring type: " + element.getName());
    }
}

