/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import com.sun.enterprise.config.modularity.ConfigModularityUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import org.glassfish.config.support.ConfigurationPersistence;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.IndentingXMLStreamWriter;

@Service
@Singleton
public class DomainXmlPersistence
implements ConfigurationPersistence {
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    protected Logger logger;
    @Inject
    ConfigModularityUtils modularityUtils;
    DomDocument skippedDoc;
    final XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();
    static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DomainXmlPersistence.class);

    @Override
    public synchronized void save(DomDocument doc) throws IOException {
        if (this.modularityUtils.isIgnorePersisting() && !this.modularityUtils.isCommandInvocation()) {
            this.skippedDoc = doc;
            return;
        }
        File destination = this.getDestination();
        if (destination == null) {
            throw new IOException("The domain.xml cannot be persisted, null destination");
        }
        File domainXmlTmp = File.createTempFile("domain", ".xml", destination.getParentFile());
        if (!domainXmlTmp.exists()) {
            throw new IOException("Cannot create temporary file when saving domain.xml");
        }
        try (FileOutputStream fos = new FileOutputStream(domainXmlTmp);
             IndentingXMLStreamWriter writer = new IndentingXMLStreamWriter(this.xmlFactory.createXMLStreamWriter(new BufferedOutputStream(fos)));){
            doc.writeTo(writer);
        }
        catch (XMLStreamException e) {
            throw new IOException("Configuration could not be saved to temporary file " + String.valueOf(domainXmlTmp), e);
        }
        File backup = new File(this.env.getConfigDirPath(), "domain.xml.bak");
        if (destination.exists()) {
            Files.move(destination.toPath(), backup.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        try {
            Files.move(domainXmlTmp.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            try {
                Files.move(backup.toPath(), destination.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
        this.skippedDoc = null;
        this.saved(destination);
    }

    public void touch() throws IOException {
        this.getDestination().setLastModified(System.currentTimeMillis());
    }

    protected void saved(File destination) {
        this.logger.fine("Configuration saved at " + String.valueOf(destination));
    }

    protected File getDestination() throws IOException {
        return new File(this.env.getConfigDirPath(), "domain.xml");
    }

    @Service
    @RunLevel(value=20)
    static class SkippedWriteWriter
    implements PostConstruct {
        @Inject
        DomainXmlPersistence domPersist;
        @Inject
        Logger logger;

        SkippedWriteWriter() {
        }

        @Override
        public void postConstruct() {
            DomDocument doc = this.domPersist.skippedDoc;
            if (doc != null) {
                try {
                    this.domPersist.save(doc);
                }
                catch (IOException e) {
                    this.logger.log(Level.SEVERE, localStrings.getLocalString("ioexception", "IOException while saving the configuration, changes not persisted"), e);
                }
            }
        }
    }
}

