/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import jakarta.inject.Inject;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="_validate-node")
@I18n(value="validate.node")
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="_validate-node", description="_validate-node")})
public class ValidateNodeCommand
implements AdminCommand {
    @Inject
    private Nodes nodes;
    @Inject
    private CommandRunner cr;
    @Param(name="name", primary=true)
    private String name;
    @Param(name="nodedir", optional=true)
    private String nodedir;
    @Param(name="nodehost", optional=true)
    private String nodehost;
    @Param(name="installdir", optional=true)
    private String installdir;
    @Param(name="sshport", optional=true)
    private String sshport;
    @Param(name="sshuser", optional=true)
    private String sshuser;
    @Param(name="sshnodehost", optional=true)
    private String sshnodehost;
    @Param(name="sshkeyfile", optional=true)
    private String sshkeyfile;
    private Set<String> excludeFromUpdate = new HashSet<String>();

    @Override
    public void execute(AdminCommandContext context) {
        Node node;
        ActionReport report = context.getActionReport();
        Logger logger2 = context.getLogger();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        if (logger2.isLoggable(Level.FINE)) {
            logger2.fine(Strings.get("Validating node {0}", this.name));
        }
        if ((node = this.nodes.getNode(this.name)) == null) {
            String msg = Strings.get("noSuchNode", this.name);
            logger2.warning(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(msg);
            return;
        }
        try {
            this.validateNode(node);
        }
        catch (CommandValidationException e) {
            logger2.warning(e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setMessage(e.getMessage());
            return;
        }
        if (logger2.isLoggable(Level.FINE)) {
            logger2.fine(Strings.get("Node {0} is valid. Updating if needed", this.name));
        }
        CommandRunner.CommandInvocation ci = this.cr.getCommandInvocation("_update-node", report, context.getSubject());
        ParameterMap map = new ParameterMap();
        map.add("DEFAULT", this.name);
        if (!this.excludeFromUpdate.contains("installdir")) {
            map.add("installdir", this.installdir);
        }
        if (!this.excludeFromUpdate.contains("nodehost")) {
            map.add("nodehost", this.nodehost);
        }
        if (!this.excludeFromUpdate.contains("nodedir")) {
            map.add("nodedir", this.nodedir);
        }
        if (!this.excludeFromUpdate.contains("sshport")) {
            map.add("sshport", this.sshport);
        }
        if (!this.excludeFromUpdate.contains("sshuser")) {
            map.add("sshuser", this.sshuser);
        }
        if (!this.excludeFromUpdate.contains("sshkeyfile")) {
            map.add("sshkeyfile", this.sshkeyfile);
        }
        if (map.size() > 1) {
            ci.parameters(map);
            ci.execute();
        }
    }

    public void validateNode(Node node) throws CommandValidationException {
        String value = null;
        value = node.getNodeDir();
        if (!StringUtils.ok(this.nodedir) && StringUtils.ok(value)) {
            throw new CommandValidationException(Strings.get("attribute.mismatch", this.name, "nodedir", this.nodedir, value));
        }
        this.validatePathSimple("nodedir", this.nodedir, value);
        value = node.getNodeHost();
        this.validateHostname("nodehost", this.nodehost, value);
        value = node.getInstallDir();
        this.validatePathSimple("installdir", this.installdir, value);
        SshConnector sshc = node.getSshConnector();
        if (sshc == null) {
            return;
        }
        value = sshc.getSshPort();
        this.validateString("sshport", this.sshport, value, false);
        value = sshc.getSshHost();
        this.validateHostname("sshnodehost", this.sshnodehost, value);
        SshAuth ssha = sshc.getSshAuth();
        if (ssha == null) {
            return;
        }
        value = ssha.getUserName();
        this.validateString("sshuser", this.sshuser, value, false);
        value = ssha.getKeyfile();
        this.validatePath("sshkeyfile", this.sshkeyfile, value);
    }

    private void validatePath(String propname, String value, String configValue) throws CommandValidationException {
        if (!StringUtils.ok(value) || !StringUtils.ok(configValue)) {
            return;
        }
        String canonicalValueFile = FileUtils.safeGetCanonicalPath(new File(value));
        String canonicalConfigValueFile = FileUtils.safeGetCanonicalPath(new File(configValue));
        if (canonicalConfigValueFile == null || canonicalValueFile == null) {
            throw new CommandValidationException(Strings.get("attribute.null", this.name, propname, canonicalValueFile, canonicalConfigValueFile));
        }
        if (!canonicalValueFile.equals(canonicalConfigValueFile)) {
            throw new CommandValidationException(Strings.get("attribute.mismatch", this.name, propname, canonicalValueFile, canonicalConfigValueFile));
        }
        this.excludeFromUpdate.add(propname);
    }

    private void validatePathSimple(String propname, String value, String configValue) throws CommandValidationException {
        if (value != null) {
            value = FileUtils.makeForwardSlashes(value);
        }
        if (configValue != null) {
            configValue = FileUtils.makeForwardSlashes(configValue);
        }
        if (value != null && value.endsWith("/")) {
            value = value.substring(0, value.length() - 1);
        }
        if (configValue != null && configValue.endsWith("/")) {
            configValue = configValue.substring(0, configValue.length() - 1);
        }
        if (value != null && configValue != null) {
            File valFile = new File(value);
            File configValFile = new File(configValue);
            if (valFile.isAbsolute() && !configValFile.isAbsolute() && value.endsWith(configValue)) {
                value = configValue;
            } else if (!valFile.isAbsolute() && configValFile.isAbsolute() && configValue.endsWith(value)) {
                configValue = value;
            }
        }
        if (OS.isWindows()) {
            this.validateString(propname, value, configValue, true);
        } else {
            this.validateString(propname, value, configValue, false);
        }
    }

    private void validateHostname(String propname, String value, String configValue) throws CommandValidationException {
        try {
            this.validateString(propname, value, configValue, true);
            return;
        }
        catch (CommandValidationException e) {
            if (!(NetUtils.isSameHost(value, configValue) || NetUtils.isThisHostLocal(value) && NetUtils.isThisHostLocal(configValue))) {
                throw new CommandValidationException(Strings.get("attribute.mismatch", this.name, propname, value, configValue));
            }
            this.excludeFromUpdate.add(propname);
            return;
        }
    }

    private void validateString(String propname, String value, String configValue, boolean ignorecase) throws CommandValidationException {
        if (!StringUtils.ok(value) || !StringUtils.ok(configValue)) {
            return;
        }
        boolean match = false;
        match = ignorecase ? value.equalsIgnoreCase(configValue) : value.equals(configValue);
        if (!match) {
            throw new CommandValidationException(Strings.get("attribute.mismatch", this.name, propname, value, configValue));
        }
        this.excludeFromUpdate.add(propname);
    }
}

