/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.util.InstanceRegisterInstanceCommandParameters;
import com.sun.enterprise.config.util.RegisterInstanceCommandParameters;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="_post-register-instance")
@Supplemental(value="_register-instance", ifFailure=FailurePolicy.Warn)
@PerLookup
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="_post-register-instance", description="_post-register-instance")})
public class PostRegisterInstanceCommand
extends RegisterInstanceCommandParameters
implements AdminCommand {
    @Inject
    private ServiceLocator habitat;
    @Inject
    private Target target;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger2 = context.getLogger();
        InstanceRegisterInstanceCommandParameters suppInfo = context.getActionReport().getResultType(InstanceRegisterInstanceCommandParameters.class);
        if (suppInfo != null && this.clusterName != null) {
            try {
                ParameterMapExtractor pme = new ParameterMapExtractor(suppInfo, this);
                ParameterMap paramMap = pme.extract();
                ArrayList<String> targets = new ArrayList<String>();
                List<Server> instances = this.target.getInstances(this.clusterName);
                for (Server s : instances) {
                    targets.add(s.getName());
                }
                ClusterOperationUtil.replicateCommand("_register-instance-at-instance", FailurePolicy.Warn, FailurePolicy.Warn, FailurePolicy.Ignore, targets, context, paramMap, this.habitat);
            }
            catch (Exception e) {
                report.failure(logger2, e.getMessage());
            }
        }
    }
}

