/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.SshAuth;
import com.sun.enterprise.config.serverbeans.SshConnector;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.util.ExceptionUtil;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.cluster.RemoteType;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.SSHCommandExecutionException;
import org.glassfish.cluster.ssh.connect.NodeRunner;
import org.glassfish.cluster.ssh.launcher.SSHException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.sftp.SFTPPath;
import org.glassfish.common.util.admin.AuthTokenManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.RelativePathResolver;

public class NodeUtils {
    private static final System.Logger LOG = System.getLogger(NodeUtils.class.getName());
    public static final String NODE_DEFAULT_SSH_PORT = "22";
    public static final String NODE_DEFAULT_REMOTE_USER = "${user.name}";
    static final String NODE_DEFAULT_INSTALLDIR = "${com.sun.aas.productRoot}";
    static final String PARAM_NODEHOST = "nodehost";
    static final String PARAM_INSTALLDIR = "installdir";
    static final String PARAM_NODEDIR = "nodedir";
    static final String PARAM_REMOTEPORT = "sshport";
    public static final String PARAM_REMOTEUSER = "sshuser";
    static final String PARAM_SSHKEYFILE = "sshkeyfile";
    static final String PARAM_REMOTEPASSWORD = "sshpassword";
    static final String PARAM_SSHKEYPASSPHRASE = "sshkeypassphrase";
    static final String PARAM_WINDOWSDOMAINNAME = "windowsdomain";
    static final String PARAM_TYPE = "type";
    static final String PARAM_INSTALL = "install";
    public static final String PARAM_WINDOWS_DOMAIN = "windowsdomain";
    static final Path LANDMARK_FILE = Path.of("glassfish", "modules", "admin-cli.jar");
    private static final String NL = System.lineSeparator();
    private TokenResolver resolver = null;
    private ServiceLocator locator = null;

    NodeUtils(ServiceLocator locator) {
        this.locator = locator;
        HashMap<Object, Object> systemPropsMap = new HashMap<Object, Object>(System.getProperties());
        this.resolver = new TokenResolver(systemPropsMap);
    }

    static boolean isSSHNode(Node node) {
        if (node == null) {
            return false;
        }
        return node.getType().equals("SSH");
    }

    String getGlassFishVersionOnNode(Node node, AdminCommandContext context) throws CommandValidationException {
        if (node == null) {
            return "";
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("version");
        command.add("--local");
        command.add("--terse");
        NodeRunner nr = new NodeRunner(this.locator.getService(AuthTokenManager.class, new Annotation[0]));
        StringBuilder output = new StringBuilder();
        try {
            int commandStatus = nr.runAdminCommandOnNode(node, output, command, context);
            if (commandStatus != 0) {
                return "unknown version: " + output.toString();
            }
        }
        catch (Exception e) {
            throw new CommandValidationException(Strings.get("failed.to.run", ((Object)command).toString(), node.getNodeHost()), e);
        }
        return output.toString().trim();
    }

    void validate(Node node) throws CommandValidationException {
        ParameterMap map = new ParameterMap();
        map.add("DEFAULT", node.getName());
        map.add(PARAM_INSTALLDIR, node.getInstallDir());
        map.add(PARAM_NODEHOST, node.getNodeHost());
        map.add(PARAM_NODEDIR, node.getNodeDirAbsolute());
        SshConnector sshc = node.getSshConnector();
        if (sshc != null) {
            map.add(PARAM_REMOTEPORT, sshc.getSshPort());
            SshAuth ssha = sshc.getSshAuth();
            map.add(PARAM_REMOTEUSER, ssha.getUserName());
            map.add(PARAM_SSHKEYFILE, ssha.getKeyfile());
            map.add(PARAM_REMOTEPASSWORD, ssha.getPassword());
            map.add(PARAM_SSHKEYPASSPHRASE, ssha.getKeyPassphrase());
            map.add(PARAM_TYPE, node.getType());
        }
        this.validate(map);
    }

    void validate(ParameterMap map) throws CommandValidationException {
        this.validatePassword((String)map.getOne(PARAM_REMOTEPASSWORD));
        String nodehost = (String)map.getOne(PARAM_NODEHOST);
        this.validateHostName(nodehost);
        this.validateRemote(map, nodehost);
    }

    private void validateRemote(ParameterMap map, String nodehost) throws CommandValidationException {
        RemoteType type2 = this.parseType(map);
        if (type2 == RemoteType.SSH) {
            this.validateSsh(map, nodehost);
        }
        if (nodehost.equals("localhost")) {
            return;
        }
        this.validateRemoteConnection(map);
    }

    private void validateSsh(ParameterMap map, String nodehost) throws CommandValidationException {
        String sshkeyfile = (String)map.getOne(PARAM_SSHKEYFILE);
        if (StringUtils.ok(sshkeyfile)) {
            File kfile = new File(this.resolver.resolve(sshkeyfile));
            if (!kfile.isAbsolute()) {
                throw new CommandValidationException(Strings.get("key.path.not.absolute", kfile.getPath()));
            }
            if (!kfile.exists()) {
                throw new CommandValidationException(Strings.get("key.path.not.found", kfile.getPath()));
            }
            if (!kfile.canRead()) {
                throw new CommandValidationException(Strings.get("key.path.not.readable", kfile.getPath(), System.getProperty("user.name")));
            }
        }
    }

    void validateHostName(String hostName) throws CommandValidationException {
        if (!StringUtils.ok(hostName)) {
            throw new CommandValidationException(Strings.get("nodehost.required"));
        }
        try {
            InetAddress.getByName(hostName);
        }
        catch (UnknownHostException e) {
            throw new CommandValidationException(Strings.get("unknown.host", hostName), e);
        }
    }

    private void validatePassword(String p) throws CommandValidationException {
        String expandedPassword = null;
        if (StringUtils.ok(p)) {
            try {
                expandedPassword = RelativePathResolver.getRealPasswordFromAlias(p);
            }
            catch (IllegalArgumentException e) {
                throw new CommandValidationException(Strings.get("no.such.password.alias", p));
            }
            catch (Exception e) {
                throw new CommandValidationException(Strings.get("no.such.password.alias", p), e);
            }
            if (expandedPassword == null) {
                throw new CommandValidationException(Strings.get("no.such.password.alias", p));
            }
        }
    }

    void pingRemoteConnection(Node node) throws CommandValidationException {
        RemoteType type2 = RemoteType.valueOf(node.getType());
        this.validateHostName(node.getNodeHost());
        switch (type2) {
            case SSH: {
                this.pingSSHConnection(node);
                break;
            }
            default: {
                throw new CommandValidationException("Internal Error: unknown type");
            }
        }
    }

    private void pingSSHConnection(Node node) throws CommandValidationException {
        SSHLauncher sshL = new SSHLauncher(node);
        try {
            sshL.pingConnection();
        }
        catch (SSHException e) {
            String msg = Strings.get("ssh.bad.connect", node.getNodeHost(), "SSH", e.getMessage());
            LOG.log(System.Logger.Level.WARNING, msg, (Throwable)e);
            throw new CommandValidationException(msg, e);
        }
    }

    private void validateRemoteConnection(ParameterMap map) throws CommandValidationException {
        RemoteType type2 = this.parseType(map);
        if (type2 == RemoteType.SSH) {
            this.validateSSHConnection(map);
        }
    }

    private void validateSSHConnection(ParameterMap map) throws CommandValidationException {
        String nodehost = (String)map.getOne(PARAM_NODEHOST);
        String installdir = (String)map.getOne(PARAM_INSTALLDIR);
        String sshport = (String)map.getOne(PARAM_REMOTEPORT);
        String sshuser = (String)map.getOne(PARAM_REMOTEUSER);
        String sshkeyfile = (String)map.getOne(PARAM_SSHKEYFILE);
        String sshpassword = (String)map.getOne(PARAM_REMOTEPASSWORD);
        String sshkeypassphrase = (String)map.getOne(PARAM_SSHKEYPASSPHRASE);
        boolean installFlag = Boolean.parseBoolean((String)map.getOne(PARAM_INSTALL));
        if (!NetUtils.isPortStringValid(this.resolver.resolve(sshport))) {
            throw new CommandValidationException(Strings.get("ssh.invalid.port", sshport));
        }
        int port = Integer.parseInt(this.resolver.resolve(sshport));
        SFTPPath resolvedInstallDir = SFTPPath.of(this.resolver.resolve(installdir));
        String keyFile = this.resolver.resolve(sshkeyfile);
        String host = this.resolver.resolve(nodehost);
        SSHLauncher sshLauncher = new SSHLauncher(this.resolver.resolve(sshuser), this.resolver.resolve(nodehost), port, sshpassword, keyFile == null ? null : new File(keyFile), sshkeypassphrase);
        try {
            SFTPPath pathToCheck = resolvedInstallDir.resolve(LANDMARK_FILE);
            if (!installFlag && !sshLauncher.exists(pathToCheck)) {
                throw new CommandValidationException("Invalid install directory: could not find " + String.valueOf(pathToCheck) + " on " + host);
            }
        }
        catch (SSHException e) {
            String msg = Strings.get("ssh.bad.connect", nodehost, "SSH", e.getMessage());
            LOG.log(System.Logger.Level.WARNING, msg, (Throwable)e);
            throw new CommandValidationException(msg, e);
        }
    }

    static void sanitizeReport(ActionReport report) {
        Throwable rootCause;
        if (report != null && report.hasFailures() && report.getFailureCause() != null && (rootCause = ExceptionUtil.getRootCause(report.getFailureCause())) != null && StringUtils.ok(rootCause.getMessage())) {
            report.setMessage(rootCause.getMessage());
        }
    }

    void runAdminCommandOnNode(Node node, List<String> command, AdminCommandContext context, String firstErrorMessage, String humanCommand, StringBuilder output) {
        ActionReport report = context.getActionReport();
        boolean failure = true;
        String msg1 = firstErrorMessage;
        String msg2 = "";
        String msg3 = "";
        String nodeHost = node.getNodeHost();
        String nodeName = node.getName();
        String installDir = node.getInstallDir();
        if (output == null) {
            output = new StringBuilder();
        }
        if (StringUtils.ok(humanCommand)) {
            msg3 = Strings.get("node.remote.tocomplete", nodeHost, installDir, humanCommand);
        }
        NodeRunner nr = new NodeRunner(this.locator.getService(AuthTokenManager.class, new Annotation[0]));
        try {
            int status = nr.runAdminCommandOnNode(node, output, command, context);
            if (status == 0) {
                failure = false;
                LOG.log(System.Logger.Level.INFO, output.toString().trim());
            } else {
                msg2 = Strings.get("node.command.failed", nodeName, nodeHost, output.toString().trim(), nr.getLastCommandRun());
                LOG.log(System.Logger.Level.WARNING, StringUtils.cat(": ", msg1, msg2, msg3));
                msg2 = Strings.get("node.command.failed.short", nodeName, nodeHost, output.toString().trim());
            }
        }
        catch (SSHCommandExecutionException e) {
            msg2 = Strings.get("node.ssh.bad.connect", nodeName, nodeHost, e.getMessage());
            String msg = Strings.get("node.command.failed.ssh.details", nodeName, nodeHost, e.getCommandRun(), e.getMessage(), e.getSSHSettings());
            LOG.log(System.Logger.Level.WARNING, StringUtils.cat(": ", msg1, msg, msg3), (Throwable)e);
        }
        catch (ProcessManagerException e) {
            msg2 = Strings.get("node.command.failed.local.details", e.getMessage(), nr.getLastCommandRun());
            LOG.log(System.Logger.Level.WARNING, StringUtils.cat(": ", msg1, msg2, msg3), (Throwable)e);
            msg2 = Strings.get("node.command.failed.local.exception", e.getMessage());
        }
        catch (UnsupportedOperationException e) {
            msg2 = Strings.get("node.not.ssh", nodeName, nodeHost);
            LOG.log(System.Logger.Level.WARNING, StringUtils.cat(": ", msg1, msg2, msg3), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            msg2 = e.getMessage();
            LOG.log(System.Logger.Level.WARNING, StringUtils.cat(": ", msg1, msg2, msg3), (Throwable)e);
        }
        if (failure) {
            report.setMessage(StringUtils.cat(NL + NL, msg1, msg2, msg3));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        } else {
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
    }

    private RemoteType parseType(ParameterMap map) throws CommandValidationException {
        try {
            return RemoteType.valueOf((String)map.getOne(PARAM_TYPE));
        }
        catch (Exception e) {
            throw new CommandValidationException(e);
        }
    }
}

