/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.CompletedJob;
import com.sun.enterprise.v3.admin.JobManagerService;
import jakarta.inject.Inject;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import org.glassfish.api.admin.progress.JobInfo;
import org.glassfish.api.admin.progress.JobInfos;
import org.glassfish.api.admin.progress.JobPersistence;
import org.glassfish.kernel.KernelLoggerInfo;
import org.jvnet.hk2.annotations.Service;

@Service(name="job-persistence")
public class JobPersistenceService
implements JobPersistence {
    protected static final Logger logger = KernelLoggerInfo.getLogger();
    protected static final LocalStringManagerImpl adminStrings = new LocalStringManagerImpl(JobPersistenceService.class);
    protected Marshaller jaxbMarshaller;
    protected Unmarshaller jaxbUnmarshaller;
    protected JobInfos jobInfos;
    protected JAXBContext jaxbContext;
    @Inject
    private JobManagerService jobManager;

    @Override
    public void persist(Object obj) {
        JobInfo jobInfo = (JobInfo)obj;
        this.jobInfos = this.jobManager.getCompletedJobs(this.jobManager.getJobsFile());
        this.doPersist(this.jobInfos, jobInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPersist(JobInfos jobInfos, JobInfo jobInfo) {
        File file;
        File file2 = file = jobInfo.getJobsFile();
        synchronized (file2) {
            if (jobInfos == null) {
                jobInfos = new JobInfos();
            }
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance(JobInfos.class);
                this.jaxbMarshaller = jaxbContext.createMarshaller();
                this.jaxbMarshaller.setProperty("jaxb.formatted.output", true);
                CopyOnWriteArrayList<JobInfo> jobList = new CopyOnWriteArrayList<JobInfo>(jobInfos.getJobInfoList());
                jobInfos.setJobInfoList(jobList);
                jobList.add(jobInfo);
                this.jaxbMarshaller.marshal((Object)jobInfos, file);
                this.jobManager.addToCompletedJobs(new CompletedJob(jobInfo.jobId, jobInfo.commandCompletionDate, jobInfo.getJobsFile()));
                this.jobManager.purgeJob(jobInfo.jobId);
            }
            catch (JAXBException e) {
                throw new RuntimeException(adminStrings.getLocalString("error.persisting.jobs", "Error while persisting jobs", jobInfo.jobId, e.getLocalizedMessage()), e);
            }
        }
    }
}

