/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.JavaConfig;
import com.sun.enterprise.config.serverbeans.Profiler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.CLIUtil;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="create-profiler")
@PerLookup
@I18n(value="create.profiler")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=JavaConfig.class, opType=RestEndpoint.OpType.POST, path="create-profiler", description="Create Profiler")})
public class CreateProfiler
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateProfiler.class);
    @Param(optional=true)
    String classpath;
    @Param(optional=true, defaultValue="true")
    Boolean enabled;
    @Param(name="nativelibrarypath", optional=true)
    String nativeLibraryPath;
    @Param(name="profiler_name", primary=true)
    String name;
    @Param(name="property", optional=true, separator=58)
    Properties properties;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    Target targetService;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @AccessRequired.To(value={"update"})
    private JavaConfig javaConfig;

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        this.config = CLIUtil.chooseConfig(this.targetService, this.config, this.target);
        this.javaConfig = this.config.getJavaConfig();
        return true;
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (this.javaConfig.getProfiler() != null) {
            System.out.println("profiler exists. Please delete it first");
            report.setMessage(localStrings.getLocalString("create.profiler.alreadyExists", "profiler exists. Please delete it first"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply(new SingleConfigCode<JavaConfig>(){

                @Override
                public Object run(JavaConfig param) throws PropertyVetoException, TransactionFailure {
                    Profiler newProfiler = param.createChild(Profiler.class);
                    newProfiler.setName(CreateProfiler.this.name);
                    newProfiler.setClasspath(CreateProfiler.this.classpath);
                    newProfiler.setEnabled(CreateProfiler.this.enabled.toString());
                    newProfiler.setNativeLibraryPath(CreateProfiler.this.nativeLibraryPath);
                    if (CreateProfiler.this.properties != null) {
                        for (Map.Entry<Object, Object> e : CreateProfiler.this.properties.entrySet()) {
                            Property prop = newProfiler.createChild(Property.class);
                            prop.setName((String)e.getKey());
                            prop.setValue((String)e.getValue());
                            newProfiler.getProperty().add(prop);
                        }
                    }
                    param.setProfiler(newProfiler);
                    return newProfiler;
                }
            }, this.javaConfig);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("create.profiler.fail", "{0} create failed ", this.name));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

