/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.xml;

import com.sun.enterprise.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

class SysPropsHandler {
    private Map<String, String> server = new HashMap<String, String>();
    private Map<String, String> cluster = new HashMap<String, String>();
    private Map<String, String> config = new HashMap<String, String>();
    private Map<String, String> domain = new HashMap<String, String>();

    SysPropsHandler() {
    }

    Map<String, String> getCombinedSysProps() {
        HashMap<String, String> map = new HashMap<String, String>(this.domain);
        map.putAll(this.config);
        map.putAll(this.cluster);
        map.putAll(this.server);
        return map;
    }

    String get(String key) {
        return this.getCombinedSysProps().get(key);
    }

    void add(Type type2, Map<String, String> map) {
        if (type2 == null || map == null) {
            return;
        }
        switch (type2.ordinal()) {
            case 0: {
                this.server.putAll(map);
                break;
            }
            case 1: {
                this.cluster.putAll(map);
                break;
            }
            case 2: {
                this.config.putAll(map);
                break;
            }
            case 3: {
                this.domain.putAll(map);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type");
            }
        }
    }

    void add(Type type2, String name, String value) {
        if (type2 == null || !StringUtils.ok(name)) {
            return;
        }
        switch (type2.ordinal()) {
            case 0: {
                this.server.put(name, value);
                break;
            }
            case 1: {
                this.cluster.put(name, value);
                break;
            }
            case 2: {
                this.config.put(name, value);
                break;
            }
            case 3: {
                this.domain.put(name, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type");
            }
        }
    }

    static enum Type {
        SERVER,
        CLUSTER,
        CONFIG,
        DOMAIN;

    }
}

