/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.transaction.jts.recovery;

import com.sun.enterprise.transaction.JavaEETransactionManagerSimplified;
import com.sun.enterprise.transaction.api.XAResourceWrapper;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.logging.LogDomains;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class OracleXAResource
extends XAResourceWrapper {
    private static final StringManager sm = StringManager.getManager(XAResourceWrapper.class);
    private static final Logger _logger = LogDomains.getLogger(JavaEETransactionManagerSimplified.class, "jakarta.enterprise.resource.jta");
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    @Override
    public XAResourceWrapper getInstance() {
        return new OracleXAResource();
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        if (flag == 0) {
            return null;
        }
        return this.recoverList(flag);
    }

    private Xid[] recoverList(int flag) throws XAException {
        Statement statement = null;
        ResultSet resultset = null;
        Connection connection = null;
        try {
            connection = (Connection)this.m_xacon.getConnection(this.subject, null);
            if (connection == null) {
                throw new XAException(sm.getString("transaction.oracle_xa_wrapper_connection_failed"));
            }
            statement = connection.createStatement();
            resultset = statement.executeQuery("select pending.local_tran_id from SYS.PENDING_TRANS$ pending, SYS.DBA_2PC_NEIGHBORS");
            resultset.close();
            resultset = null;
            statement.close();
            statement = null;
            Xid[] xidArray = this.m_xacon.getXAResource().recover(flag);
            return xidArray;
        }
        catch (SQLException sqlexception) {
            throw new XAException(sm.getString("transaction.oracle_sqlexception_occurred", sqlexception));
        }
        catch (XAException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XAException(sm.getString("transaction.oracle_unknownexception_occurred", e));
        }
        finally {
            if (resultset != null) {
                try {
                    resultset.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    @Override
    public void commit(Xid xid, boolean flag) throws XAException {
        this.doRecovery(xid, true);
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        this.doRecovery(xid, false);
    }

    private void doRecovery(Xid xid, boolean isCommit) throws XAException {
        try {
            if (isCommit) {
                this.m_xacon.getXAResource().commit(xid, true);
            } else {
                this.m_xacon.getXAResource().rollback(xid);
            }
        }
        catch (XAException ex) {
            _logger.log(Level.FINEST, " An XAException occurred while calling XAResource method ", ex);
        }
        catch (Exception ex) {
            _logger.log(Level.FINEST, " An Exception occurred while calling XAResource method ", ex);
        }
        Statement statement = null;
        ResultSet resultset = null;
        Connection connection = null;
        try {
            connection = (Connection)this.m_xacon.getConnection(this.subject, null);
            if (connection == null) {
                throw new XAException(sm.getString("transaction.oracle_xa_wrapper_connection_failed"));
            }
            statement = connection.createStatement();
            resultset = statement.executeQuery("select pending.local_tran_id from SYS.PENDING_TRANS$ pending, SYS.DBA_2PC_NEIGHBORS dba where pending.global_foreign_id = '" + OracleXAResource.toHexString(xid.getGlobalTransactionId()) + "' and pending.local_tran_id = dba.local_tran_id and dba.branch = '" + OracleXAResource.toHexString(xid.getBranchQualifier()) + "' and pending.state = 'prepared'");
            if (resultset.next()) {
                String s = resultset.getString(1);
                resultset.close();
                resultset = null;
                statement.executeUpdate((isCommit ? "commit force '" : "rollback force '") + s + "'");
                statement.close();
                statement = null;
            }
        }
        catch (SQLException sqlexception) {
            _logger.log(Level.FINE, " An SQLException during recovery ", sqlexception);
            throw new XAException(sm.getString("transaction.oracle_sqlexception_occurred", sqlexception));
        }
        catch (Exception e) {
            _logger.log(Level.FINE, " An Exception during recovery ", e);
            throw new XAException(sm.getString("transaction.oracle_unknownexception_occurred", e));
        }
        finally {
            if (resultset != null) {
                try {
                    resultset.close();
                }
                catch (SQLException sQLException) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private static String toHexString(byte[] abyte0) {
        StringBuffer stringbuffer = new StringBuffer();
        if (null != abyte0 && 0 < abyte0.length) {
            for (int i = 0; i < abyte0.length; ++i) {
                stringbuffer.append(HEX_DIGITS[(abyte0[i] & 0xF0) >> 4]);
                stringbuffer.append(HEX_DIGITS[abyte0[i] & 0xF]);
            }
            return stringbuffer.toString();
        }
        return "";
    }
}

