/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.authorization;

import com.sun.enterprise.config.serverbeans.JaccProvider;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.util.i18n.StringManager;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import jakarta.security.jacc.Policy;
import jakarta.security.jacc.PolicyFactory;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.exousia.modules.def.DefaultPolicyFactory;
import org.glassfish.hk2.api.IterableProvider;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
@Singleton
public class PolicyLoader {
    @Inject
    @Named(value="default-instance-name")
    private SecurityService securityService;
    @Inject
    private IterableProvider<JaccProvider> authorizationModules;
    private static Logger LOGGER = SecurityLoggerInfo.getLogger();
    private static StringManager SM = StringManager.getManager(PolicyLoader.class);
    private static final String POLICY_PROVIDER = "jakarta.security.jacc.policy.provider";
    private static final String POLICY_CONF_FACTORY = "jakarta.security.jacc.PolicyConfigurationFactory.provider";
    private static final String POLICY_PROP_PREFIX = "com.sun.enterprise.jaccprovider.property.";
    private boolean isPolicyInstalled;

    public void loadPolicy() {
        if (this.isPolicyInstalled) {
            LOGGER.log(Level.FINE, "Policy already installed. Will not re-install.");
            return;
        }
        JaccProvider authorizationModule = this.getConfiguredJakartaAuthorizationModule();
        this.setPolicyConfigurationFactory(authorizationModule);
        String javaPolicyClassName = System.getProperty(POLICY_PROVIDER);
        if (javaPolicyClassName != null) {
            LOGGER.log(Level.INFO, "NCLS-SECURITY-01140", new String[]{POLICY_PROVIDER, javaPolicyClassName});
        } else if (authorizationModule != null) {
            javaPolicyClassName = authorizationModule.getPolicyProvider();
        }
        if (System.getProperty("simple.jacc.provider.JACCRoleMapper.class") == null) {
            System.setProperty("simple.jacc.provider.JACCRoleMapper.class", "com.sun.enterprise.security.ee.authorization.GlassfishRoleMapper");
        }
        if (javaPolicyClassName != null) {
            try {
                LOGGER.log(Level.INFO, "NCLS-SECURITY-01143", javaPolicyClassName);
                Policy policy = this.loadPolicy(javaPolicyClassName);
                PolicyFactory.setPolicyFactory(new DefaultPolicyFactory());
                PolicyFactory.getPolicyFactory().setPolicy(policy);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "NCLS-SECURITY-01144", e.getLocalizedMessage());
                throw new RuntimeException(e);
            }
            LOGGER.fine("Policy set to: " + javaPolicyClassName);
            this.isPolicyInstalled = true;
        } else {
            LOGGER.warning("NCLS-SECURITY-01145");
        }
    }

    private Policy loadPolicy(String javaPolicyClassName) throws ReflectiveOperationException, SecurityException {
        Object javaPolicyInstance = Thread.currentThread().getContextClassLoader().loadClass(javaPolicyClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (!(javaPolicyInstance instanceof Policy)) {
            throw new RuntimeException(SM.getString("enterprise.security.plcyload.not14"));
        }
        return (Policy)javaPolicyInstance;
    }

    private JaccProvider getConfiguredJakartaAuthorizationModule() {
        JaccProvider authorizationModule = null;
        try {
            String name = this.securityService.getJacc();
            authorizationModule = this.getAuthorizationModuleByName(name);
            if (authorizationModule == null) {
                LOGGER.log(Level.WARNING, "NCLS-SECURITY-01141", name);
            }
        }
        catch (Exception e) {
            LOGGER.warning("NCLS-SECURITY-01142");
            authorizationModule = null;
        }
        return authorizationModule;
    }

    private JaccProvider getAuthorizationModuleByName(String authorizationModuleName) {
        if (this.authorizationModules == null || authorizationModuleName == null) {
            return null;
        }
        for (JaccProvider authorizationModule : this.authorizationModules) {
            if (!authorizationModule.getName().equals(authorizationModuleName)) continue;
            return authorizationModule;
        }
        return null;
    }

    private void setPolicyConfigurationFactory(JaccProvider authorizationModule) {
        if (authorizationModule == null) {
            return;
        }
        String factoryFromSystemProperty = System.getProperty(POLICY_CONF_FACTORY);
        if (factoryFromSystemProperty != null) {
            LOGGER.log(Level.WARNING, "NCLS-SECURITY-01146", new String[]{POLICY_CONF_FACTORY, factoryFromSystemProperty});
        } else {
            String factoryFromDomain = authorizationModule.getPolicyConfigurationFactoryProvider();
            if (factoryFromDomain == null) {
                LOGGER.log(Level.WARNING, "NCLS-SECURITY-01147");
            } else {
                System.setProperty(POLICY_CONF_FACTORY, factoryFromDomain);
            }
        }
        List<Property> authorizationModuleProperties = authorizationModule.getProperty();
        for (Property authorizationModuleProperty : authorizationModuleProperties) {
            String name = POLICY_PROP_PREFIX + authorizationModuleProperty.getName();
            String value = authorizationModuleProperty.getValue();
            LOGGER.finest("PolicyLoader set [" + name + "] to [" + value + "]");
            System.setProperty(name, value);
        }
    }
}

