/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.auth.realm.AbstractGlassFishRealmState;
import com.sun.enterprise.security.auth.realm.GlassFishUserManagement;
import com.sun.enterprise.security.auth.realm.GlassFishUserStore;
import com.sun.enterprise.security.auth.realm.RealmStatsProvider;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.auth.realm.RealmsManagerHolder;
import com.sun.enterprise.security.auth.realm.exceptions.BadRealmException;
import com.sun.enterprise.security.auth.realm.exceptions.NoSuchRealmException;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Contract;

@Contract
public abstract class Realm
extends AbstractGlassFishRealmState
implements GlassFishUserStore,
GlassFishUserManagement {
    protected static final Logger _logger = SecurityLoggerInfo.getLogger();
    static final String RI_DEFAULT = "default";
    private static RealmStatsProvider realmStatsProvier;

    public static synchronized Realm instantiate(String name, String className, Properties props) throws BadRealmException {
        Realm.registerRealmStatsProvier();
        Realm realmClass = Realm._getInstance(name);
        if (realmClass == null) {
            realmClass = Realm.doInstantiate(name, className, props);
            RealmsManagerHolder.getRealmsManager().putIntoLoadedRealms(name, realmClass);
        }
        return realmClass;
    }

    public static synchronized Realm instantiate(String name, String className, Properties props, String configName) throws BadRealmException {
        Realm.registerRealmStatsProvier();
        Realm realmClass = Realm._getInstance(configName, name);
        if (realmClass == null) {
            realmClass = Realm.doInstantiate(name, className, props);
            RealmsManagerHolder.getRealmsManager().putIntoLoadedRealms(configName, name, realmClass);
        }
        return realmClass;
    }

    public static synchronized Realm getDefaultInstance() throws NoSuchRealmException {
        return Realm.getInstance(Realm.getDefaultRealm());
    }

    public static synchronized Realm getInstance(String name) throws NoSuchRealmException {
        Realm instance = Realm._getInstance(name);
        if (instance == null) {
            throw new NoSuchRealmException(MessageFormat.format("Realm {0} does not exists.", name));
        }
        return instance;
    }

    public static synchronized Realm getInstance(String configName, String name) throws NoSuchRealmException {
        Realm instance = Realm._getInstance(configName, name);
        if (instance == null) {
            throw new NoSuchRealmException(MessageFormat.format("Realm {0} does not exists.", name));
        }
        return instance;
    }

    public static synchronized String getDefaultRealm() {
        return RealmsManagerHolder.getNonNullRealmsManager().getDefaultRealmName();
    }

    public static synchronized void setDefaultRealm(String realmName) {
        RealmsManagerHolder.getNonNullRealmsManager().setDefaultRealmName(realmName);
    }

    public static boolean isValidRealm(String name) {
        return RealmsManagerHolder.getNonNullRealmsManager().isValidRealm(name);
    }

    public static boolean isValidRealm(String configName, String name) {
        return RealmsManagerHolder.getNonNullRealmsManager().isValidRealm(configName, name);
    }

    public static synchronized Enumeration<String> getRealmNames() {
        return RealmsManagerHolder.getNonNullRealmsManager().getRealmNames();
    }

    public static synchronized void unloadInstance(String realmName) throws NoSuchRealmException {
        Realm.getInstance(realmName);
        RealmsManagerHolder.getNonNullRealmsManager().removeFromLoadedRealms(realmName);
        _logger.log(Level.INFO, "NCLS-SECURITY-01119", realmName);
    }

    public static synchronized void unloadInstance(String configName, String realmName) throws NoSuchRealmException {
        RealmsManagerHolder.getNonNullRealmsManager().removeFromLoadedRealms(configName, realmName);
        _logger.log(Level.INFO, "NCLS-SECURITY-01119", realmName);
    }

    protected static synchronized void updateInstance(Realm realm, String name) {
        RealmsManager realmsManager = RealmsManagerHolder.getNonNullRealmsManager();
        Realm oldRealm = realmsManager.getFromLoadedRealms(name);
        if (!oldRealm.getClass().equals(realm.getClass())) {
            throw new Error("Incompatible class " + String.valueOf(realm.getClass()) + " in replacement realm " + name);
        }
        realm.setName(oldRealm.getName());
        realmsManager.putIntoLoadedRealms(name, realm);
        _logger.log(Level.INFO, "NCLS-SECURITY-01117", new Object[]{realm.getName()});
    }

    protected static synchronized void updateInstance(String configName, Realm realm, String name) {
        RealmsManager realmsManager = RealmsManagerHolder.getNonNullRealmsManager();
        Realm oldRealm = realmsManager.getFromLoadedRealms(configName, name);
        if (!oldRealm.getClass().equals(realm.getClass())) {
            throw new Error("Incompatible class " + String.valueOf(realm.getClass()) + " in replacement realm " + name);
        }
        realm.setName(oldRealm.getName());
        realmsManager.putIntoLoadedRealms(configName, name, realm);
        _logger.log(Level.INFO, "NCLS-SECURITY-01117", new Object[]{realm.getName()});
    }

    public static synchronized void getRealmStatsProvier() {
        if (realmStatsProvier == null) {
            realmStatsProvier = new RealmStatsProvider();
        }
    }

    private static synchronized Realm doInstantiate(String name, String className, Properties props) throws BadRealmException {
        ServiceLocator serviceLocator = Globals.getDefaultBaseServiceLocator();
        RealmsManager realmsManager = null;
        try {
            realmsManager = RealmsManagerHolder.getRealmsManager();
            Realm realm = serviceLocator.getService(Realm.class, name, new Annotation[0]);
            if (realm == null) {
                try {
                    realm = (Realm)serviceLocator.getService(ClassLoaderHierarchy.class, new Annotation[0]).getCommonClassLoader().loadClass(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalArgumentException | ReflectiveOperationException | SecurityException ex) {
                    realm = (Realm)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            realm.setName(name);
            realm.init(props);
            if (realmsManager == null) {
                throw new BadRealmException("Unable to locate RealmsManager Service");
            }
            _logger.log(Level.INFO, "NCLS-SECURITY-01115", new Object[]{name, className});
            return realm;
        }
        catch (NoSuchRealmException | ReflectiveOperationException ex) {
            throw new BadRealmException(ex);
        }
    }

    private static void registerRealmStatsProvier() {
        if (realmStatsProvier == null) {
            Realm.getRealmStatsProvier();
            StatsProviderManager.register("security", PluginPoint.SERVER, "security/realm", realmStatsProvier);
        }
    }

    private static synchronized Realm _getInstance(String name) {
        return RealmsManagerHolder.getNonNullRealmsManager()._getInstance(name);
    }

    private static synchronized Realm _getInstance(String configName, String name) {
        return RealmsManagerHolder.getNonNullRealmsManager()._getInstance(configName, name);
    }
}

