/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.common.iiop.security.AnonCredential;
import com.sun.enterprise.common.iiop.security.GSSUPName;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.auth.login.DigestCredentials;
import com.sun.enterprise.security.auth.login.common.LoginException;
import com.sun.enterprise.security.auth.login.common.PasswordCredential;
import com.sun.enterprise.security.auth.login.common.ServerLoginCallbackHandler;
import com.sun.enterprise.security.auth.login.common.X509CertificateCredential;
import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.certificate.CertificateRealm;
import com.sun.enterprise.security.auth.realm.exceptions.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.exceptions.NoSuchUserException;
import com.sun.enterprise.security.common.ClientSecurityContext;
import com.sun.enterprise.util.Utility;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.x500.X500Principal;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.UserNameAndPassword;

public class LoginContextDriver {
    private static final Logger LOG = SecurityLoggerInfo.getLogger();
    private static final ServerLoginCallbackHandler dummyCallback = new ServerLoginCallbackHandler();
    public static final String CERT_REALMNAME = "certificate";
    private static volatile AuditManager AUDIT_MANAGER;

    private LoginContextDriver() {
    }

    private static AuditManager getAuditManager() {
        if (AUDIT_MANAGER != null) {
            return AUDIT_MANAGER;
        }
        return LoginContextDriver._getAuditManager();
    }

    private static synchronized AuditManager _getAuditManager() {
        if (AUDIT_MANAGER == null) {
            SecurityServicesUtil secServUtil = Globals.get(SecurityServicesUtil.class);
            AUDIT_MANAGER = secServUtil.getAuditManager();
        }
        return AUDIT_MANAGER;
    }

    public static void login(String username, char[] password, String realmName) {
        if (realmName == null || !Realm.isValidRealm(realmName)) {
            realmName = Realm.getDefaultRealm();
        }
        Subject subject = new Subject();
        subject.getPrivateCredentials().add(new PasswordCredential(username, password, realmName));
        LoginContextDriver.login(subject, PasswordCredential.class);
    }

    public static void login(Subject subject, Class<?> credentialClass) throws LoginException {
        LOG.log(Level.FINEST, "Processing login with credentials of type: {0}", credentialClass);
        if (credentialClass.equals(PasswordCredential.class)) {
            LoginContextDriver.doPasswordLogin(subject);
        } else if (credentialClass.equals(X509CertificateCredential.class)) {
            LoginContextDriver.doCertificateLogin(subject);
        } else if (credentialClass.equals(AnonCredential.class)) {
            LoginContextDriver.doAnonLogin();
        } else if (credentialClass.equals(GSSUPName.class)) {
            LoginContextDriver.doGSSUPLogin(subject);
        } else if (credentialClass.equals(X500Principal.class)) {
            LoginContextDriver.doX500Login(subject, null);
        } else {
            LOG.log(Level.INFO, "NCLS-SECURITY-05019", credentialClass);
            throw new LoginException("Unknown credential type " + String.valueOf(credentialClass) + ", cannot login.");
        }
    }

    public static void loginPrincipal(String username, String realmName) throws LoginException {
        if (realmName == null || realmName.isEmpty()) {
            realmName = Realm.getDefaultRealm();
        }
        Subject subject = new Subject();
        subject.getPrincipals().add(new UserNameAndPassword(username));
        subject.getPublicCredentials().add(new GSSUPName(username, realmName));
        try {
            Enumeration<String> groupNames = Realm.getInstance(realmName).getGroupNames(username);
            while (groupNames.hasMoreElements()) {
                subject.getPrincipals().add(new Group(groupNames.nextElement()));
            }
        }
        catch (NoSuchUserException ex) {
            LOG.log(Level.WARNING, "NCLS-SECURITY-01151", new Object[]{username, realmName, ex.toString()});
        }
        catch (NoSuchRealmException ex) {
            throw new LoginException(ex.toString(), ex);
        }
        LoginContextDriver.setSecurityContext(username, subject, realmName);
    }

    public static void logout() throws LoginException {
        LoginContextDriver.unsetSecurityContext();
    }

    private static void doPasswordLogin(Subject subject) throws LoginException {
        Object obj = LoginContextDriver.getPrivateCredentials(subject, PasswordCredential.class);
        PasswordCredential passwordCredential = (PasswordCredential)obj;
        String user = passwordCredential.getUser();
        String realm = passwordCredential.getRealm();
        String jaasCtx = LoginContextDriver.getJaasCtx(realm);
        LOG.log(Level.FINE, "Logging in user {0} into realm {1} using JAAS module {2}", new Object[]{user, realm, jaasCtx});
        try {
            new LoginContext(jaasCtx, subject, dummyCallback).login();
        }
        catch (Exception e) {
            LOG.log(Level.FINEST, "doPasswordLogin fails", e);
            if (LoginContextDriver.getAuditManager() != null && LoginContextDriver.getAuditManager().isAuditOn()) {
                LoginContextDriver.getAuditManager().authentication(user, realm, false);
            }
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            throw new LoginException("Login failed: " + e.getMessage(), e);
        }
        if (LoginContextDriver.getAuditManager() != null && LoginContextDriver.getAuditManager().isAuditOn()) {
            LoginContextDriver.getAuditManager().authentication(user, realm, true);
        }
        LOG.log(Level.FINE, "Password login succeeded for {0}", user);
        LoginContextDriver.setSecurityContext(user, subject, realm);
        LOG.log(Level.FINE, "Set security context as user {0}", user);
    }

    private static String getJaasCtx(String realm) {
        try {
            return Realm.getInstance(realm).getJAASContext();
        }
        catch (Exception ex) {
            if (ex instanceof LoginException) {
                throw (LoginException)ex;
            }
            throw (LoginException)new LoginException(ex.toString()).initCause(ex);
        }
    }

    public static void jmacLogin(Subject subject, Principal callerPrincipal, String realmName) throws LoginException {
        if (CERT_REALMNAME.equals(realmName)) {
            if (callerPrincipal instanceof X500Principal) {
                LoginContextDriver.jmacLogin(subject, (X500Principal)callerPrincipal);
            }
        } else if (!callerPrincipal.equals(SecurityContext.getDefaultCallerPrincipal())) {
            LoginContextDriver.jmacLogin(subject, callerPrincipal.getName(), realmName);
        }
    }

    public static Subject jmacLogin(Subject subject, String username, char[] password, String realmName) throws LoginException {
        if (realmName == null || !Realm.isValidRealm(realmName)) {
            realmName = Realm.getDefaultRealm();
        }
        if (subject == null) {
            subject = new Subject();
        }
        PasswordCredential passwordCredential = new PasswordCredential(username, password, realmName);
        subject.getPrivateCredentials().add(passwordCredential);
        String jaasCtx = LoginContextDriver.getJaasCtx(realmName);
        LOG.log(Level.FINE, "JMAC login user {0} into realm {1} using JAAS module {2}", new Object[]{username, realmName, jaasCtx});
        try {
            new LoginContext(jaasCtx, subject, dummyCallback).login();
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "NCLS-SECURITY-05046", username);
            if (LoginContextDriver.getAuditManager().isAuditOn()) {
                LoginContextDriver.getAuditManager().authentication(username, realmName, false);
            }
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            throw new LoginException("Login failed: " + e.getMessage(), e);
        }
        if (LoginContextDriver.getAuditManager().isAuditOn()) {
            LoginContextDriver.getAuditManager().authentication(username, realmName, true);
        }
        LOG.log(Level.FINE, "jmac Password login succeeded for {0}", username);
        return subject;
    }

    public static Subject jmacLogin(Subject subject, X500Principal x500Principal) throws LoginException {
        if (subject == null) {
            subject = new Subject();
        }
        String userName = "";
        try {
            userName = x500Principal.getName();
            subject.getPublicCredentials().add(x500Principal);
            CertificateRealm certRealm = (CertificateRealm)Realm.getInstance(CERT_REALMNAME);
            String jaasCtx = certRealm.getJAASContext();
            if (jaasCtx != null) {
                new LoginContext(jaasCtx, subject, dummyCallback).login();
            }
            certRealm.authenticate(subject, x500Principal);
        }
        catch (Exception ex) {
            LOG.log(Level.INFO, "NCLS-SECURITY-05046", userName);
            if (LoginContextDriver.getAuditManager().isAuditOn()) {
                LoginContextDriver.getAuditManager().authentication(userName, CERT_REALMNAME, false);
            }
            if (ex instanceof LoginException) {
                throw (LoginException)ex;
            }
            throw new LoginException("Authentication failed.", ex);
        }
        LOG.log(Level.FINE, "JMAC cert login succeeded for {0}", userName);
        if (LoginContextDriver.getAuditManager().isAuditOn()) {
            LoginContextDriver.getAuditManager().authentication(userName, CERT_REALMNAME, true);
        }
        return subject;
    }

    public static Subject jmacLogin(Subject subject, String userName, String realm) throws LoginException {
        if (subject == null) {
            subject = new Subject();
        }
        try {
            Enumeration<String> groups;
            if (Utility.isEmpty(realm)) {
                realm = Realm.getDefaultRealm();
            }
            if ((groups = Realm.getInstance(realm).getGroupNames(userName)) != null) {
                while (groups.hasMoreElements()) {
                    subject.getPrincipals().add(new Group(groups.nextElement()));
                }
            }
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "Exception when trying to populate groups for CallerPrincipal " + userName, ex);
        }
        return subject;
    }

    private static void doCertificateLogin(Subject s) throws LoginException {
        LOG.log(Level.FINE, "Processing X509 certificate login.");
        String realm = CERT_REALMNAME;
        String user = null;
        try {
            Object obj = LoginContextDriver.getPublicCredentials(s, X509CertificateCredential.class);
            X509CertificateCredential xp = (X509CertificateCredential)obj;
            user = xp.getAlias();
            LOG.log(Level.FINE, "Set security context as user {0}", user);
            LoginContextDriver.setSecurityContext(user, s, realm);
            if (LoginContextDriver.getAuditManager().isAuditOn()) {
                LoginContextDriver.getAuditManager().authentication(user, realm, true);
            }
        }
        catch (LoginException le) {
            if (LoginContextDriver.getAuditManager().isAuditOn()) {
                LoginContextDriver.getAuditManager().authentication(user, realm, false);
            }
            throw le;
        }
    }

    private static void doAnonLogin() throws LoginException {
        SecurityContext.setUnauthenticatedContext();
        LOG.log(Level.FINE, "Set anonymous security context.");
    }

    private static void doGSSUPLogin(Subject s) throws LoginException {
        LOG.fine("Processing GSSUP login.");
        String user = null;
        String realm = Realm.getDefaultRealm();
        try {
            Object obj = LoginContextDriver.getPublicCredentials(s, GSSUPName.class);
            user = ((GSSUPName)obj).getUser();
            LoginContextDriver.setSecurityContext(user, s, realm);
            if (LoginContextDriver.getAuditManager().isAuditOn()) {
                LoginContextDriver.getAuditManager().authentication(user, realm, true);
            }
            LOG.log(Level.FINE, "GSSUP login succeeded for {0}", user);
        }
        catch (LoginException le) {
            if (LoginContextDriver.getAuditManager().isAuditOn()) {
                LoginContextDriver.getAuditManager().authentication(user, realm, false);
            }
            throw le;
        }
    }

    public static void doX500Login(Subject s, String appModuleID) throws LoginException {
        LOG.log(Level.FINE, "Processing X.500 name login for appModuleID={0}.", appModuleID);
        String user = null;
        String realm_name = null;
        try {
            X500Principal x500Principal = (X500Principal)LoginContextDriver.getPublicCredentials(s, X500Principal.class);
            user = x500Principal.getName();
            Realm realm = Realm.getInstance(CERT_REALMNAME);
            if (realm instanceof CertificateRealm) {
                CertificateRealm certRealm = (CertificateRealm)realm;
                String jaasCtx = certRealm.getJAASContext();
                if (jaasCtx != null) {
                    LoginContext lg = new LoginContext(jaasCtx, s, new ServerLoginCallbackHandler(user, null, appModuleID));
                    lg.login();
                }
                certRealm.authenticate(s, x500Principal);
                realm_name = CERT_REALMNAME;
                if (LoginContextDriver.getAuditManager().isAuditOn()) {
                    LoginContextDriver.getAuditManager().authentication(user, realm_name, true);
                }
            } else {
                LOG.warning("NCLS-SECURITY-01050");
                realm_name = realm.getName();
                LoginContextDriver.setSecurityContext(user, s, realm_name);
            }
            LOG.log(Level.FINE, "X.500 name login succeeded for: {0}", user);
        }
        catch (LoginException le) {
            if (LoginContextDriver.getAuditManager().isAuditOn()) {
                LoginContextDriver.getAuditManager().authentication(user, realm_name, false);
            }
            throw le;
        }
        catch (Exception ex) {
            throw new LoginException("Login failed", ex);
        }
    }

    private static Object getPublicCredentials(Subject subject, Class<?> cls) throws LoginException {
        Set<?> publicCredentials = subject.getPublicCredentials(cls);
        if (publicCredentials.isEmpty()) {
            throw new LoginException("Expected public credential of type: " + String.valueOf(cls) + " but none found.");
        }
        try {
            return publicCredentials.iterator().next();
        }
        catch (Exception e) {
            if (e instanceof LoginException) {
                LoginException loginException = (LoginException)e;
                throw loginException;
            }
            throw new LoginException("Failed to retrieve public credential: " + e.getMessage(), e);
        }
    }

    private static Object getPrivateCredentials(Subject subject, Class<?> cls) throws LoginException {
        Set<?> privateCredentials = subject.getPrivateCredentials(cls);
        if (privateCredentials.isEmpty()) {
            throw new LoginException("Expected private credential of type: " + String.valueOf(cls) + " but none found.");
        }
        try {
            return privateCredentials.iterator().next();
        }
        catch (Exception e) {
            if (e instanceof LoginException) {
                LoginException loginException = (LoginException)e;
                throw loginException;
            }
            throw new LoginException("Failed to retrieve private credential: " + e.getMessage(), e);
        }
    }

    private static void setSecurityContext(String userName, Subject subject, String realm) {
        SecurityContext.setCurrent(new SecurityContext(userName, subject, realm));
    }

    private static void unsetSecurityContext() {
        SecurityContext.setCurrent(null);
    }

    public static Subject doClientLogin(int type2, CallbackHandler jaasHandler) throws LoginException {
        CallbackHandler handler = jaasHandler;
        Subject subject = new Subject();
        if (type2 == 1) {
            try {
                LoginContext lg = new LoginContext("default", subject, handler);
                lg.login();
            }
            catch (javax.security.auth.login.LoginException e) {
                throw new LoginException(e.getMessage(), e);
            }
            LoginContextDriver.postClientAuth(subject, PasswordCredential.class);
            return subject;
        }
        if (type2 == 2) {
            try {
                LoginContext lg = new LoginContext(CERT_REALMNAME, subject, handler);
                lg.login();
            }
            catch (javax.security.auth.login.LoginException e) {
                throw new LoginException(e.getMessage(), e);
            }
            LoginContextDriver.postClientAuth(subject, X509CertificateCredential.class);
            return subject;
        }
        if (type2 == 3) {
            try {
                LoginContext lgup = new LoginContext("default", subject, handler);
                LoginContext lgc = new LoginContext(CERT_REALMNAME, subject, handler);
                lgup.login();
                LoginContextDriver.postClientAuth(subject, PasswordCredential.class);
                lgc.login();
                LoginContextDriver.postClientAuth(subject, X509CertificateCredential.class);
            }
            catch (javax.security.auth.login.LoginException e) {
                throw new LoginException(e.getMessage(), e);
            }
            return subject;
        }
        try {
            LoginContext lg = new LoginContext("default", subject, handler);
            lg.login();
            LoginContextDriver.postClientAuth(subject, PasswordCredential.class);
        }
        catch (javax.security.auth.login.LoginException e) {
            throw new LoginException(e.getMessage(), e);
        }
        return subject;
    }

    public static void doClientLogout() throws LoginException {
        LoginContextDriver.unsetClientSecurityContext();
    }

    public static void login(DigestCredentials digestCred) {
        Subject subject = new Subject();
        subject.getPrivateCredentials().add(digestCred);
        String jaasCtx = null;
        try {
            jaasCtx = Realm.getInstance(digestCred.getRealmName()).getJAASContext();
        }
        catch (Exception ex) {
            if (ex instanceof LoginException) {
                throw (LoginException)ex;
            }
            throw new LoginException("Failed obtaining the JAAS context.", ex);
        }
        try {
            LoginContext lg = new LoginContext(jaasCtx, subject, dummyCallback);
            lg.login();
        }
        catch (Exception e) {
            LOG.log(Level.INFO, "NCLS-SECURITY-05046", digestCred.getUserName());
            LOG.log(Level.FINEST, "doPasswordLogin failed", e);
            if (LoginContextDriver.getAuditManager().isAuditOn()) {
                LoginContextDriver.getAuditManager().authentication(digestCred.getUserName(), digestCred.getRealmName(), false);
            }
            if (e instanceof LoginException) {
                throw (LoginException)e;
            }
            throw new LoginException("Login failed: " + e.getMessage(), e);
        }
        LoginContextDriver.setSecurityContext(digestCred.getUserName(), subject, digestCred.getRealmName());
    }

    private static void postClientAuth(Subject subject, Class<?> clazz) {
        LOG.log(Level.FINEST, "LCD post login subject: {0}", subject);
        for (Object privateCredential : subject.getPrivateCredentials(clazz)) {
            if (privateCredential instanceof PasswordCredential) {
                PasswordCredential passwordCredential = (PasswordCredential)privateCredential;
                String user = passwordCredential.getUser();
                LOG.log(Level.FINEST, "In LCD user-pass login: {0}, realm: {1}", new Object[]{user, passwordCredential.getRealm()});
                LoginContextDriver.setClientSecurityContext(user, subject);
                return;
            }
            if (!(privateCredential instanceof X509CertificateCredential)) continue;
            X509CertificateCredential certificateCredential = (X509CertificateCredential)privateCredential;
            String user = certificateCredential.getAlias();
            LOG.log(Level.FINEST, "In LCD cert-login: {0}, realm: {1}", new Object[]{user, certificateCredential.getRealm()});
            LoginContextDriver.setClientSecurityContext(user, subject);
            return;
        }
    }

    private static void setClientSecurityContext(String username, Subject subject) {
        ClientSecurityContext securityContext = new ClientSecurityContext(username, subject);
        ClientSecurityContext.setCurrent(securityContext);
    }

    private static void unsetClientSecurityContext() {
        ClientSecurityContext.setCurrent(null);
    }
}

