/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.login;

import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.auth.login.common.X509CertificateCredential;
import com.sun.enterprise.security.integration.AppClientSSL;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.glassfish.internal.api.Globals;
import org.glassfish.security.common.UserNameAndPassword;
import org.glassfish.security.common.UserPrincipal;

public class ClientCertificateLoginModule
implements LoginModule {
    private static final Logger _logger = SecurityLoggerInfo.getLogger();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ClientCertificateLoginModule.class);
    private static KeyStore keyStore;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private boolean debug;
    private boolean succeeded;
    private boolean commitSucceeded;
    private String alias;
    private X509Certificate certificate;
    private UserPrincipal userPrincipal;
    private AppClientSSL ssl;
    private SSLUtils sslUtils;

    public static void setKeyStore(KeyStore keyStore) {
        ClientCertificateLoginModule.keyStore = keyStore;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        this.sslUtils = Globals.getDefaultHabitat().getService(SSLUtils.class, new Annotation[0]);
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException("Error: no CallbackHandler available to garner authentication information from the user");
        }
        try {
            String[] as = new String[keyStore.size()];
            String[] aliasString = new String[keyStore.size()];
            Enumeration<String> aliases = keyStore.aliases();
            for (int i = 0; i < keyStore.size(); ++i) {
                aliasString[i] = aliases.nextElement();
                as[i] = ((X509Certificate)keyStore.getCertificate(aliasString[i])).getSubjectX500Principal().getName();
            }
            Callback[] callbacks = new Callback[]{new ChoiceCallback(localStrings.getLocalString("login.certificate", "Choose from list of certificates: "), as, 0, false)};
            this.callbackHandler.handle(callbacks);
            int[] idx = ((ChoiceCallback)callbacks[0]).getSelectedIndexes();
            if (idx == null) {
                throw new LoginException("No certificate selected!");
            }
            if (idx[0] == -1) {
                throw new LoginException("Incorrect keystore password");
            }
            if (this.debug && _logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "\t\t[ClientCertificateLoginModule] user entered certificate: ");
                for (int element : idx) {
                    _logger.log(Level.FINE, aliasString[element]);
                }
            }
            this.alias = aliasString[idx[0]];
            this.certificate = (X509Certificate)keyStore.getCertificate(this.alias);
            if (this.debug) {
                _logger.log(Level.FINE, "[ClientCertificateLoginModule] authentication succeeded");
            }
            this.succeeded = true;
            return true;
        }
        catch (IOException ioe) {
            throw new LoginException(ioe.toString());
        }
        catch (UnsupportedCallbackException uce) {
            throw new LoginException("Error: " + uce.getCallback().toString() + " not available to garner authentication information from the user");
        }
        catch (Exception e) {
            throw new LoginException(e.toString());
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.userPrincipal = new UserNameAndPassword(this.alias);
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        if (this.debug) {
            _logger.log(Level.FINE, "\t\t[ClientCertificateLoginModule] added UserPrincipal to Subject");
        }
        this.ssl = new AppClientSSL();
        this.ssl.setCertNickname(this.alias);
        this.sslUtils.setAppclientSsl(this.ssl);
        String realm = "certificate";
        X509Certificate[] certChain = new X509Certificate[]{this.certificate};
        X509CertificateCredential pc = new X509CertificateCredential(certChain, this.alias, realm);
        if (!this.subject.getPrivateCredentials().contains(pc)) {
            this.subject.getPrivateCredentials().add(pc);
        }
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.alias = null;
            this.userPrincipal = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.ssl = null;
        this.sslUtils.setAppclientSsl(this.ssl);
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.succeeded = false;
        this.commitSucceeded = false;
        this.alias = null;
        this.userPrincipal = null;
        return true;
    }
}

