/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.admin.cli.Strings;
import jakarta.inject.Inject;
import java.beans.PropertyChangeEvent;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Changed;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.NotProcessed;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Service
@RunLevel(value=20)
public class SecureAdminConfigMonitor
implements ConfigListener {
    private static final String restartRequiredMsg = Strings.get("secure.admin.change.requires.restart");
    @Inject
    private Domain domain;

    @Override
    public UnprocessedChangeEvents changed(final PropertyChangeEvent[] events) {
        return ConfigSupport.sortAndDispatch(events, new Changed(){

            @Override
            public <T extends ConfigBeanProxy> NotProcessed changed(Changed.TYPE type2, Class<T> tClass, T t) {
                if (t instanceof Domain) {
                    return SecureAdminConfigMonitor.this.processDomain(type2, (Domain)t, events);
                }
                if (t instanceof SecureAdmin) {
                    return SecureAdminConfigMonitor.this.processSecureAdmin(type2, (SecureAdmin)t, events);
                }
                return null;
            }
        }, SecurityLoggerInfo.getLogger());
    }

    private NotProcessed processDomain(Changed.TYPE type2, Domain d, PropertyChangeEvent[] events) {
        for (PropertyChangeEvent event : events) {
            if ((!(event.getOldValue() instanceof SecureAdmin) || type2 != Changed.TYPE.REMOVE) && (!(event.getNewValue() instanceof SecureAdmin) || type2 != Changed.TYPE.ADD)) continue;
            return new NotProcessed(restartRequiredMsg);
        }
        return null;
    }

    private NotProcessed processSecureAdmin(Changed.TYPE type2, SecureAdmin sa, PropertyChangeEvent[] events) {
        return new NotProcessed(restartRequiredMsg);
    }
}

