/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.admin.cli;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.SecureAdminHelper;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.admin.cli.Strings;
import com.sun.enterprise.security.ssl.GlassfishSSLImpl;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.grizzly.config.dom.FileCache;
import org.glassfish.grizzly.config.dom.Http;
import org.glassfish.grizzly.config.dom.HttpRedirect;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.PortUnification;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.ProtocolFinder;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.grizzly.config.dom.Ssl;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;

public abstract class SecureAdminCommand
implements AdminCommand {
    static final String SEC_ADMIN_LISTENER_PROTOCOL_NAME = "sec-admin-listener";
    private static final String REDIRECT_PROTOCOL_NAME = "admin-http-redirect";
    public static final String ADMIN_LISTENER_NAME = "admin-listener";
    static final String DAS_CONFIG_NAME = "server-config";
    static final String PORT_UNIF_PROTOCOL_NAME = "pu-protocol";
    static final Logger logger = SecurityLoggerInfo.getLogger();
    @Inject
    protected Domain domain;
    private final Step<TopLevelContext> perDomainStep = new Step<TopLevelContext>(){

        private void updateSecureAdminEnabledSetting(SecureAdmin secureAdmin_w, boolean newEnabledValue) {
            secureAdmin_w.setEnabled(Boolean.toString(newEnabledValue));
        }

        @Override
        public Work<TopLevelContext> enableWork() {
            return new TopLevelWork(true);
        }

        @Override
        public Work<TopLevelContext> disableWork() {
            return new TopLevelWork(false);
        }

        class TopLevelWork
        implements Work<TopLevelContext> {
            private final boolean newEnabledState;

            TopLevelWork(boolean newEnabledState) {
                this.newEnabledState = newEnabledState;
            }

            @Override
            public boolean run(TopLevelContext context) throws TransactionFailure {
                SecureAdmin secureAdmin_w = context.writableSecureAdmin();
                this.updateSecureAdminEnabledSetting(secureAdmin_w, this.newEnabledState);
                return SecureAdminCommand.this.updateSecureAdminSettings(secureAdmin_w);
            }
        }
    };
    private final Step<ConfigLevelContext> jmxConnectorStep = new Step<ConfigLevelContext>(this){

        @Override
        public Work<ConfigLevelContext> enableWork() {
            return new Work<ConfigLevelContext>(this){

                @Override
                public boolean run(ConfigLevelContext context) throws TransactionFailure {
                    JmxConnector jmxConnector_w = context.writeableJmxConnector();
                    if (jmxConnector_w == null) {
                        return false;
                    }
                    try {
                        jmxConnector_w.setSecurityEnabled("true");
                        Ssl ssl_w = context.writeableJmxSSL();
                        ConfigLevelContext.initSsl(ssl_w, ConfigLevelContext.chooseCertNickname(context.config_w.getName(), context.topLevelContext.writableSecureAdmin().dasAlias(), context.topLevelContext.writableSecureAdmin().instanceAlias()));
                        return true;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            };
        }

        @Override
        public Work<ConfigLevelContext> disableWork() {
            return new Work<ConfigLevelContext>(this){

                @Override
                public boolean run(ConfigLevelContext context) throws TransactionFailure {
                    JmxConnector jmxC_w = context.writeableJmxConnector();
                    try {
                        jmxC_w.setSsl(null);
                        jmxC_w.setSecurityEnabled("false");
                        return true;
                    }
                    catch (PropertyVetoException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            };
        }
    };
    private final Step<ConfigLevelContext> secAdminListenerProtocolStep = new Step<ConfigLevelContext>(this){
        private static final String ASADMIN_VIRTUAL_SERVER_NAME = "__asadmin";
        private static final String AUTH_LAYER_NAME = "HttpServlet";
        private static final String PROVIDER_ID_VALUE = "GFConsoleAuthModule";

        private Http writeableHttpWithFileCacheChild(Transaction t, Protocol secAdminListenerProtocol_w) throws TransactionFailure {
            Http http_w;
            Http http = secAdminListenerProtocol_w.getHttp();
            if (http == null) {
                http_w = secAdminListenerProtocol_w.createChild(Http.class);
                secAdminListenerProtocol_w.setHttp(http_w);
            } else {
                http_w = t.enroll(http);
            }
            http_w.setDefaultVirtualServer(ASADMIN_VIRTUAL_SERVER_NAME);
            http_w.setEncodedSlashEnabled("true");
            FileCache cache = http_w.createChild(FileCache.class);
            http_w.setFileCache(cache);
            return http_w;
        }

        private Ssl writeableSsl(Transaction t, Protocol secAdminListenerProtocol_w, String certNickname) throws TransactionFailure {
            Ssl ssl_w = null;
            Ssl ssl = secAdminListenerProtocol_w.getSsl();
            if (ssl == null) {
                ssl_w = secAdminListenerProtocol_w.createChild(Ssl.class);
                secAdminListenerProtocol_w.setSsl(ssl_w);
            } else {
                ssl_w = t.enroll(ssl);
            }
            return ConfigLevelContext.initSsl(ssl_w, certNickname);
        }

        @Override
        public Work<ConfigLevelContext> enableWork() {
            return new Work<ConfigLevelContext>(){

                @Override
                public boolean run(ConfigLevelContext context) throws TransactionFailure {
                    Protocol secAdminListenerProtocol_w = context.writableProtocol(SecureAdminCommand.SEC_ADMIN_LISTENER_PROTOCOL_NAME, true);
                    if (secAdminListenerProtocol_w == null) {
                        return false;
                    }
                    this.writeableHttpWithFileCacheChild(context.t, secAdminListenerProtocol_w);
                    this.writeableSsl(context.t, secAdminListenerProtocol_w, ConfigLevelContext.chooseCertNickname(context.config_w.getName(), context.topLevelContext.writableSecureAdmin().dasAlias(), context.topLevelContext.writableSecureAdmin().instanceAlias()));
                    return true;
                }
            };
        }

        @Override
        public Work<ConfigLevelContext> disableWork() {
            return new Work<ConfigLevelContext>(this){

                @Override
                public boolean run(ConfigLevelContext context) throws TransactionFailure {
                    context.deleteProtocol(SecureAdminCommand.SEC_ADMIN_LISTENER_PROTOCOL_NAME);
                    return true;
                }
            };
        }
    };
    private final Step<ConfigLevelContext> secAdminPortUnifAndRedirectStep = new Step<ConfigLevelContext>(this){
        private static final String PORT_UNIF_PROTOCOL_NAME = "pu-protocol";
        private static final String UNSECURE_ADMIN_LISTENER_PROTOCOL_NAME = "admin-listener";
        private static final String HTTP_FINDER_PROTOCOL_FINDER_NAME = "http-finder";
        private static final String ADMIN_HTTP_REDIRECT_FINDER_NAME = "admin-http-redirect";
        private static final String PROTOCOL_FINDER_CLASSNAME = "org.glassfish.grizzly.config.portunif.HttpProtocolFinder";

        private HttpRedirect writeableHttpRedirect(Transaction t, Protocol adminHttpRedirectProtocol_w) throws TransactionFailure {
            HttpRedirect redirect_w;
            HttpRedirect redirect = adminHttpRedirectProtocol_w.getHttpRedirect();
            if (redirect == null) {
                redirect_w = adminHttpRedirectProtocol_w.createChild(HttpRedirect.class);
                adminHttpRedirectProtocol_w.setHttpRedirect(redirect_w);
            } else {
                redirect_w = t.enroll(redirect);
            }
            redirect_w.setSecure(Boolean.TRUE.toString());
            return redirect_w;
        }

        private PortUnification writeablePortUnification(Transaction t, Protocol protocol_w) throws TransactionFailure {
            PortUnification pu_w;
            PortUnification pu = protocol_w.getPortUnification();
            if (pu == null) {
                pu_w = protocol_w.createChild(PortUnification.class);
                protocol_w.setPortUnification(pu_w);
            } else {
                pu_w = t.enroll(pu);
            }
            return pu_w;
        }

        private ProtocolFinder writeableProtocolFinder(Transaction t, PortUnification pu_w, ProtocolFinderInfo finderInfo) throws TransactionFailure {
            ProtocolFinder pf_w = null;
            for (ProtocolFinder pf : pu_w.getProtocolFinder()) {
                if (!pf.getName().equals(finderInfo.name)) continue;
                pf_w = t.enroll(pf);
                break;
            }
            if (pf_w == null) {
                pf_w = pu_w.createChild(ProtocolFinder.class);
                pu_w.getProtocolFinder().add(pf_w);
            }
            pf_w.setName(finderInfo.name);
            Objects.requireNonNull(finderInfo);
            pf_w.setClassname(PROTOCOL_FINDER_CLASSNAME);
            pf_w.setProtocol(finderInfo.protocolName);
            return pf_w;
        }

        private NetworkListener writableNetworkListener(Transaction t, Config config_w, String listenerName) throws TransactionFailure {
            NetworkListener nl_w = null;
            NetworkConfig nc = config_w.getNetworkConfig();
            if (nc == null) {
                return null;
            }
            NetworkListener nl = nc.getNetworkListener(listenerName);
            if (nl == null) {
                return null;
            }
            nl_w = t.enroll(nl);
            return nl_w;
        }

        private void assignAdminListenerProtocol(Transaction t, Config config_w, String protocolName) throws TransactionFailure {
            NetworkListener nl_w = this.writableNetworkListener(t, config_w, "admin-listener");
            if (nl_w != null) {
                nl_w.setProtocol(protocolName);
            }
        }

        @Override
        public Work<ConfigLevelContext> enableWork() {
            return new Work<ConfigLevelContext>(){

                @Override
                public boolean run(ConfigLevelContext context) throws TransactionFailure {
                    Protocol adminHttpRedirectProtocol_w = context.writableProtocol("admin-http-redirect", false);
                    if (adminHttpRedirectProtocol_w == null) {
                        return true;
                    }
                    this.writeableHttpRedirect(context.t, adminHttpRedirectProtocol_w);
                    Protocol puProtocol_w = context.writableProtocol("pu-protocol", false);
                    PortUnification portUnif_w = this.writeablePortUnification(context.t, puProtocol_w);
                    this.writeableProtocolFinder(context.t, portUnif_w, ProtocolFinderInfo.HTTP_FINDER);
                    this.writeableProtocolFinder(context.t, portUnif_w, ProtocolFinderInfo.ADMIN_HTTP_REDIRECT_FINDER);
                    this.assignAdminListenerProtocol(context.t, context.config_w, "pu-protocol");
                    return true;
                }
            };
        }

        @Override
        public Work<ConfigLevelContext> disableWork() {
            return new Work<ConfigLevelContext>(){

                @Override
                public boolean run(ConfigLevelContext context) throws TransactionFailure {
                    Config config_w = context.config_w;
                    Transaction t = context.t;
                    this.assignAdminListenerProtocol(t, config_w, "admin-listener");
                    context.deleteProtocol("pu-protocol");
                    context.deleteProtocol("admin-http-redirect");
                    return true;
                }
            };
        }
    };
    final Step<TopLevelContext>[] secureAdminSteps = new Step[]{this.perDomainStep};
    final Step<ConfigLevelContext>[] perConfigSteps = new Step[]{this.secAdminListenerProtocolStep, this.secAdminPortUnifAndRedirectStep, this.jmxConnectorStep};

    boolean updateSecureAdminSettings(SecureAdmin secureAdmin_w) throws TransactionFailure {
        return true;
    }

    protected abstract String transactionErrorMessageKey();

    abstract Iterator<Work<TopLevelContext>> secureAdminSteps();

    abstract Iterator<Work<ConfigLevelContext>> perConfigSteps();

    public void run() throws TransactionFailure, SecureAdminHelper.SecureAdminCommandException {
        ConfigSupport.apply(new SingleConfigCode<Domain>(){

            @Override
            public Object run(Domain domain_w) throws PropertyVetoException, TransactionFailure {
                Transaction t = Transaction.getTransaction(domain_w);
                TopLevelContext topLevelContext = new TopLevelContext(t, domain_w);
                if (t != null) {
                    Iterator<Work<TopLevelContext>> it = SecureAdminCommand.this.secureAdminSteps();
                    while (it.hasNext()) {
                        Work<TopLevelContext> step = it.next();
                        if (step.run(topLevelContext)) continue;
                        t.rollback();
                        return Boolean.FALSE;
                    }
                    Configs configs = domain_w.getConfigs();
                    for (Config c : configs.getConfig()) {
                        Config c_w = t.enroll(c);
                        ConfigLevelContext configLevelContext = new ConfigLevelContext(topLevelContext, c_w);
                        Iterator<Work<ConfigLevelContext>> it2 = SecureAdminCommand.this.perConfigSteps();
                        while (it2.hasNext()) {
                            Work<ConfigLevelContext> step = it2.next();
                            if (step.run(configLevelContext)) continue;
                            t.rollback();
                            return Boolean.FALSE;
                        }
                    }
                }
                return Boolean.TRUE;
            }
        }, this.domain);
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
            this.run();
            report.setMessage(Strings.get("restartReq"));
        }
        catch (TransactionFailure ex) {
            report.failure(context.getLogger(), Strings.get(this.transactionErrorMessageKey()), ex);
        }
        catch (SecureAdminHelper.SecureAdminCommandException ex) {
            report.failure(context.getLogger(), ex.getLocalizedMessage());
        }
    }

    void execute() throws TransactionFailure, SecureAdminHelper.SecureAdminCommandException {
        try {
            this.run();
        }
        catch (TransactionFailure ex) {
            logger.log(Level.SEVERE, Strings.get(this.transactionErrorMessageKey()), ex);
            throw ex;
        }
        catch (SecureAdminHelper.SecureAdminCommandException ex) {
            logger.log(Level.SEVERE, ex.getLocalizedMessage());
            throw ex;
        }
    }

    static interface Step<T extends Context> {
        public Work<T> enableWork();

        public Work<T> disableWork();
    }

    private static enum ProtocolFinderInfo {
        HTTP_FINDER("http-finder", "sec-admin-listener"),
        ADMIN_HTTP_REDIRECT_FINDER("admin-http-redirect", "admin-http-redirect");

        private final String name;
        private final String protocolName;
        private final String classname = "org.glassfish.grizzly.config.portunif.HttpProtocolFinder";

        private ProtocolFinderInfo(String name, String protocolName) {
            this.name = name;
            this.protocolName = protocolName;
        }
    }

    static class ConfigLevelContext
    extends AbstractContext {
        private static final String CLIENT_AUTH_VALUE = "want";
        private static final String SSL3_ENABLED_VALUE = "false";
        private static final String CLASSNAME_VALUE = GlassfishSSLImpl.class.getName();
        private final Transaction t;
        private final Config config_w;
        private final TopLevelContext topLevelContext;
        private Protocols protocols_w;
        private final Map<String, Protocol> namedProtocols_w = new HashMap<String, Protocol>();
        private JmxConnector jmxConnector_w;
        private Ssl jmxConnectorSsl_w;

        ConfigLevelContext(TopLevelContext topLevelContext, Config config_w) {
            this.topLevelContext = topLevelContext;
            this.t = topLevelContext.t;
            this.config_w = config_w;
        }

        private static Ssl initSsl(Ssl ssl_w, String certNickname) {
            ssl_w.setClientAuth(CLIENT_AUTH_VALUE);
            ssl_w.setSsl3Enabled(SSL3_ENABLED_VALUE);
            ssl_w.setClassname(CLASSNAME_VALUE);
            ssl_w.setCertNickname(certNickname);
            ssl_w.setRenegotiateOnClientAuthWant(true);
            return ssl_w;
        }

        private static String chooseCertNickname(String configName, String dasAlias, String instanceAlias) throws TransactionFailure {
            return configName.equals(SecureAdminCommand.DAS_CONFIG_NAME) ? dasAlias : instanceAlias;
        }

        private JmxConnector writeableJmxConnector() throws TransactionFailure {
            if (this.jmxConnector_w == null) {
                AdminService adminService = this.config_w.getAdminService();
                if (adminService == null) {
                    return null;
                }
                JmxConnector jmxC = adminService.getSystemJmxConnector();
                if (jmxC == null) {
                    return null;
                }
                this.jmxConnector_w = this.t.enroll(jmxC);
            }
            return this.jmxConnector_w;
        }

        private Ssl writeableJmxSSL() throws TransactionFailure, PropertyVetoException {
            if (this.jmxConnectorSsl_w == null) {
                JmxConnector jmxC_w = this.writeableJmxConnector();
                if (jmxC_w == null) {
                    return null;
                }
                Ssl jmxConnectorSsl = jmxC_w.getSsl();
                if (jmxConnectorSsl == null) {
                    jmxConnectorSsl = jmxC_w.createChild(Ssl.class);
                    jmxC_w.setSsl(jmxConnectorSsl);
                    this.jmxConnectorSsl_w = jmxConnectorSsl;
                } else {
                    this.jmxConnectorSsl_w = this.t.enroll(jmxConnectorSsl);
                }
            }
            return this.jmxConnectorSsl_w;
        }

        private Protocols writableProtocols() throws TransactionFailure {
            if (this.protocols_w == null) {
                NetworkConfig nc = this.config_w.getNetworkConfig();
                if (nc == null) {
                    return null;
                }
                Protocols p = nc.getProtocols();
                this.protocols_w = this.t.enroll(p);
            }
            return this.protocols_w;
        }

        private Protocol writableProtocol(String protocolName, boolean isSecure) throws TransactionFailure {
            Protocol p_w = this.namedProtocols_w.get(protocolName);
            if (p_w == null) {
                Protocol p_r = this.findProtocol(protocolName);
                if (p_r == null) {
                    Protocols ps_w = this.writableProtocols();
                    if (ps_w == null) {
                        return null;
                    }
                    p_w = ps_w.createChild(Protocol.class);
                    p_w.setName(protocolName);
                    ps_w.getProtocol().add(p_w);
                } else {
                    p_w = this.t.enroll(p_r);
                }
                this.namedProtocols_w.put(protocolName, p_w);
            }
            p_w.setSecurityEnabled(Boolean.toString(isSecure));
            return p_w;
        }

        private Protocol findProtocol(String protocolName) {
            NetworkConfig nc = this.config_w.getNetworkConfig();
            if (nc == null) {
                return null;
            }
            Protocols ps = nc.getProtocols();
            if (ps == null) {
                return null;
            }
            return ps.findProtocol(protocolName);
        }

        private void deleteProtocol(String protocolName) throws TransactionFailure {
            Protocols ps_w = this.writableProtocols();
            if (ps_w == null) {
                return;
            }
            Protocol doomedProtocol = ps_w.findProtocol(protocolName);
            if (doomedProtocol != null) {
                ps_w.getProtocol().remove(doomedProtocol);
            }
        }
    }

    static class TopLevelContext
    extends AbstractContext {
        private final Transaction t;
        private final Domain d;
        private Domain d_w = null;
        private SecureAdmin secureAdmin_w = null;

        TopLevelContext(Transaction t, Domain d) {
            this.t = t;
            this.d = d;
        }

        Domain writableDomain() throws TransactionFailure {
            if (this.d_w == null) {
                this.d_w = this.t.enroll(this.d);
            }
            return this.d_w;
        }

        SecureAdmin writableSecureAdmin() throws TransactionFailure {
            if (this.secureAdmin_w == null) {
                SecureAdmin secureAdmin = this.d.getSecureAdmin();
                if (secureAdmin == null) {
                    this.secureAdmin_w = this.writableDomain().createChild(SecureAdmin.class);
                    this.writableDomain().setSecureAdmin(this.secureAdmin_w);
                } else {
                    this.secureAdmin_w = this.t.enroll(secureAdmin);
                }
            }
            return this.secureAdmin_w;
        }
    }

    static class AbstractContext
    implements Context {
        AbstractContext() {
        }
    }

    static interface Work<T extends Context> {
        public boolean run(T var1) throws TransactionFailure;
    }

    static interface Context {
    }
}

