/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security;

import com.sun.enterprise.security.ContainerSecurityLifecycle;
import com.sun.enterprise.security.SecurityConfigListener;
import com.sun.enterprise.security.SecurityLifecycleException;
import com.sun.enterprise.security.SecurityLoggerInfo;
import com.sun.enterprise.security.SecurityServicesUtil;
import com.sun.enterprise.security.audit.AuditManager;
import com.sun.enterprise.security.auth.realm.RealmsManager;
import com.sun.enterprise.security.common.Util;
import com.sun.enterprise.security.ssl.SSLUtils;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class SecurityLifecycle
implements PostConstruct,
PreDestroy {
    private static final Logger _logger = SecurityLoggerInfo.getLogger();
    private static final String SYS_PROP_LOGIN_CONF = "java.security.auth.login.config";
    private static final String SYS_PROP_JAVA_SEC_POLICY = "java.security.policy";
    @Inject
    private ServerContext serverContext;
    @Inject
    private SecurityServicesUtil securityServicesUtil;
    @Inject
    private Util util;
    @Inject
    private SSLUtils sslUtils;
    @Inject
    private SecurityConfigListener configListener;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private RealmsManager realmsManager;
    @Inject
    @Optional
    private ContainerSecurityLifecycle eeSecLifecycle;
    private EventListener listener;

    public SecurityLifecycle() {
        try {
            if (Util.isEmbeddedServer()) {
                if (System.getProperty(SYS_PROP_LOGIN_CONF) == null) {
                    System.setProperty(SYS_PROP_LOGIN_CONF, Util.writeConfigFileToTempDir("login.conf").getAbsolutePath());
                }
                if (System.getProperty(SYS_PROP_JAVA_SEC_POLICY) == null) {
                    System.setProperty(SYS_PROP_JAVA_SEC_POLICY, Util.writeConfigFileToTempDir("server.policy").getAbsolutePath());
                }
            }
            SecurityManager secMgr = System.getSecurityManager();
            if (_logger.isLoggable(Level.INFO)) {
                if (secMgr != null) {
                    _logger.info("NCLS-SECURITY-01001");
                } else {
                    _logger.info("NCLS-SECURITY-01002");
                }
            }
        }
        catch (Exception ex) {
            _logger.log(Level.SEVERE, "java_security.init_securitylifecycle_fail", ex);
            throw new RuntimeException(ex.toString(), ex);
        }
    }

    public void onInitialization() {
        try {
            _logger.log(Level.INFO, "NCLS-SECURITY-01010");
            this.realmsManager.createRealms();
            AuditManager auditManager = this.securityServicesUtil.getAuditManager();
            auditManager.loadAuditModules();
            auditManager.serverStarted();
            _logger.log(Level.INFO, "NCLS-SECURITY-01011");
        }
        catch (Exception ex) {
            throw new SecurityLifecycleException(ex);
        }
    }

    @Override
    public void postConstruct() {
        this.onInitialization();
        this.listener = new AuditServerShutdownListener();
        Events events = this.serviceLocator.getService(Events.class, new Annotation[0]);
        events.register(this.listener);
    }

    @Override
    public void preDestroy() {
    }

    public class AuditServerShutdownListener
    implements EventListener {
        @Override
        public void event(EventListener.Event<?> event) {
            if (EventTypes.SERVER_SHUTDOWN.equals(event.type())) {
                SecurityLifecycle.this.securityServicesUtil.getAuditManager().serverShutdown();
            }
        }
    }
}

