/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.rm;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.rm.ResourceManager;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.logging.LogDomains;
import jakarta.transaction.SystemException;
import jakarta.transaction.Transaction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationException;

public class ResourceManagerImpl
implements ResourceManager {
    private static final Logger LOG = LogDomains.getLogger(ResourceManagerImpl.class, "jakarta.enterprise.resource.resourceadapter");

    @Override
    public Transaction getTransaction() throws PoolingException {
        ComponentInvocation componentInvocation = ResourceManagerImpl.getCurrentInvocation();
        if (componentInvocation == null) {
            try {
                return ConnectorRuntime.getRuntime().getTransaction();
            }
            catch (Exception ex) {
                return null;
            }
        }
        return (Transaction)componentInvocation.getTransaction();
    }

    @Override
    public Object getComponent() {
        ComponentInvocation componentInvocation = ResourceManagerImpl.getCurrentInvocation();
        if (componentInvocation == null) {
            return null;
        }
        return componentInvocation.getInstance();
    }

    @Override
    public void enlistResource(ResourceHandle resourceHandle) throws PoolingException {
        this.registerResource(resourceHandle);
    }

    @Override
    public void registerResource(ResourceHandle handle) throws PoolingException {
        block15: {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "ResourceManagerImpl.registerResource START: handle=" + String.valueOf(handle) + ", resource=" + String.valueOf(handle.getResource()) + ", transactional=" + handle.isTransactional());
            }
            try {
                JavaEETransactionManager transactionManager = ResourceManagerImpl.getTransactionManager();
                if (!handle.isTransactional()) break block15;
                ComponentInvocation componentInvocation = ResourceManagerImpl.getCurrentInvocation();
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "ResourceManagerImpl.registerResource: componentInvocation=" + String.valueOf(componentInvocation));
                }
                Transaction transaction = null;
                if (componentInvocation == null) {
                    try {
                        transaction = transactionManager.getTransaction();
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, "ResourceManagerImpl.registerResource: A transaction=" + String.valueOf(transaction));
                        }
                    }
                    catch (Exception e) {
                        transaction = null;
                        LOG.log(Level.INFO, e.getMessage());
                    }
                } else {
                    transaction = (Transaction)componentInvocation.getTransaction();
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "ResourceManagerImpl.registerResource: B transaction=" + String.valueOf(transaction));
                    }
                    transactionManager.registerComponentResource(handle);
                }
                if (transaction == null) break block15;
                try {
                    transactionManager.enlistResource(transaction, handle);
                }
                catch (Exception ex) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Exception while trying to enlist resource " + ex.getMessage());
                    }
                    if (componentInvocation != null) {
                        LOG.fine("Attempting to unregister component resource");
                        transactionManager.unregisterComponentResource(handle);
                    }
                    throw ex;
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "poolmgr.component_register_exception", ex);
                throw new PoolingException(ex.toString(), ex);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "ResourceManagerImpl.registerResource END: handle=" + String.valueOf(handle) + ", resource=" + String.valueOf(handle.getResource()) + ", transactional=" + handle.isTransactional());
        }
    }

    protected void enlist(JavaEETransactionManager transactionManager, Transaction transaction, ResourceHandle resourceHandle) throws PoolingException {
        try {
            transactionManager.enlistResource(transaction, resourceHandle);
        }
        catch (Exception e) {
            throw new PoolingException(e.getMessage(), e);
        }
    }

    @Override
    public void rollBackTransaction() {
        JavaEETransactionManager transactionManager = ResourceManagerImpl.getTransactionManager();
        Transaction transaction = null;
        try {
            ComponentInvocation componentInvocation = ResourceManagerImpl.getCurrentInvocation();
            if (componentInvocation == null) {
                try {
                    transaction = transactionManager.getTransaction();
                }
                catch (Exception e) {
                    transaction = null;
                    LOG.log(Level.INFO, e.getMessage());
                }
            } else {
                transaction = (Transaction)componentInvocation.getTransaction();
            }
            if (transaction != null) {
                transaction.setRollbackOnly();
            }
        }
        catch (SystemException ex) {
            LOG.log(Level.WARNING, "poolmgr.system_exception", ex);
        }
        catch (IllegalStateException ex) {
            LOG.log(Level.FINEST, "Ignoring IllegalStateException.", ex);
        }
    }

    @Override
    public void delistResource(ResourceHandle resource, int xaresFlag) {
        this.unregisterResource(resource, xaresFlag);
    }

    @Override
    public void unregisterResource(ResourceHandle resource, int xaresFlag) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "ResourceManagerImpl.unregisterResource START: handle=" + String.valueOf(resource) + ", resource=" + String.valueOf(resource.getResource()) + ", transactional=" + resource.isTransactional());
        }
        JavaEETransactionManager transactionManager = ResourceManagerImpl.getTransactionManager();
        Transaction transaction = null;
        try {
            if (resource.isTransactional()) {
                ComponentInvocation componentInvocation = ResourceManagerImpl.getCurrentInvocation();
                if (componentInvocation == null) {
                    try {
                        transaction = transactionManager.getTransaction();
                    }
                    catch (Exception e) {
                        transaction = null;
                        LOG.log(Level.INFO, e.getMessage());
                    }
                } else {
                    transaction = (Transaction)componentInvocation.getTransaction();
                    transactionManager.unregisterComponentResource(resource);
                }
                if (transaction != null && resource.isEnlisted()) {
                    transactionManager.delistResource(transaction, resource, xaresFlag);
                }
            }
        }
        catch (SystemException ex) {
            LOG.log(Level.WARNING, "poolmgr.system_exception", ex);
        }
        catch (IllegalStateException ex) {
            LOG.log(Level.FINEST, "Ignoring IllegalStateException.", ex);
        }
        catch (InvocationException ex) {
            LOG.log(Level.FINEST, "Ignoring InvocationException.", ex);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "ResourceManagerImpl.unregisterResource END: handle=" + String.valueOf(resource) + ", resource=" + String.valueOf(resource.getResource()) + ", transactional=" + resource.isTransactional());
        }
    }

    private static ComponentInvocation getCurrentInvocation() {
        return ConnectorRuntime.getRuntime().getInvocationManager().getCurrentInvocation();
    }

    private static JavaEETransactionManager getTransactionManager() {
        return ConnectorRuntime.getRuntime().getTransactionManager();
    }
}

