/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.appserv.connectors.internal.api.PoolingException;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceGateway {
    protected static final Logger _logger = LogDomains.getLogger(ResourceGateway.class, "jakarta.enterprise.resource.resourceadapter");

    public boolean allowed() {
        return true;
    }

    public void acquiredResource() {
    }

    public static ResourceGateway getInstance(String className) throws PoolingException {
        if (className == null) {
            return new ResourceGateway();
        }
        return ResourceGateway.initializeCustomResourceGatewayInPrivilegedMode(className);
    }

    private static ResourceGateway initializeCustomResourceGatewayInPrivilegedMode(String className) throws PoolingException {
        ResourceGateway gateway = null;
        try {
            gateway = ResourceGateway.initializeCustomResourceGateway(className);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "pool.resource.gateway.init.failure", className);
            _logger.log(Level.WARNING, "pool.resource.gateway.init.failure", e);
        }
        if (gateway == null) {
            throw new PoolingException("Unable to initalize custom ResourceGateway : " + className);
        }
        return gateway;
    }

    private static ResourceGateway initializeCustomResourceGateway(String className) throws Exception {
        return (ResourceGateway)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    protected static void debug(String debugStatement) {
        _logger.log(Level.FINE, debugStatement);
    }
}

