/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.pool;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.listener.PoolLifeCycleListener;
import com.sun.enterprise.resource.pool.PoolManager;
import com.sun.enterprise.resource.pool.ResourcePool;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.resourcebase.resources.api.PoolInfo;

public class PoolLifeCycleListenerRegistry
implements PoolLifeCycleListener {
    protected List<PoolLifeCycleListener> poolListenersList;
    private PoolInfo poolInfo;

    public PoolLifeCycleListenerRegistry(PoolInfo poolInfo) {
        this.poolInfo = poolInfo;
        this.poolListenersList = new ArrayList<PoolLifeCycleListener>();
    }

    public void registerPoolLifeCycleListener(PoolLifeCycleListener listener) {
        this.poolListenersList.add(listener);
        if (this.poolListenersList.size() <= 1) {
            PoolManager poolMgr = ConnectorRuntime.getRuntime().getPoolManager();
            ResourcePool pool = poolMgr.getPool(this.poolInfo);
            pool.setPoolLifeCycleListener(this);
        }
    }

    public void unRegisterPoolLifeCycleListener(PoolInfo poolInfo) {
        if (this.poolInfo.equals(poolInfo) && this.poolListenersList != null && !this.poolListenersList.isEmpty()) {
            this.poolListenersList.clear();
        }
    }

    @Override
    public void toString(StringBuffer stackTrace) {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.toString(stackTrace);
        }
    }

    @Override
    public void connectionAcquired(long resourceHandleId) {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionAcquired(resourceHandleId);
        }
    }

    @Override
    public void connectionRequestServed(long timeTakenInMillis) {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionRequestServed(timeTakenInMillis);
        }
    }

    @Override
    public void connectionTimedOut() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionTimedOut();
        }
    }

    @Override
    public void connectionNotMatched() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionNotMatched();
        }
    }

    @Override
    public void connectionMatched() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionMatched();
        }
    }

    @Override
    public void connectionUsed(long resourceHandleId) {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionUsed(resourceHandleId);
        }
    }

    @Override
    public void connectionDestroyed(long resourceHandleId) {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionDestroyed(resourceHandleId);
        }
    }

    @Override
    public void connectionReleased(long resourceHandleId) {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionReleased(resourceHandleId);
        }
    }

    @Override
    public void connectionCreated() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionCreated();
        }
    }

    @Override
    public void foundPotentialConnectionLeak() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.foundPotentialConnectionLeak();
        }
    }

    @Override
    public void connectionValidationFailed(int count) {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionValidationFailed(count);
        }
    }

    @Override
    public void connectionsFreed(int count) {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionsFreed(count);
        }
    }

    @Override
    public void decrementConnectionUsed(long resourceHandleId) {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.decrementConnectionUsed(resourceHandleId);
        }
    }

    @Override
    public void decrementNumConnFree() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.decrementNumConnFree();
        }
    }

    @Override
    public void incrementNumConnFree(boolean beingDestroyed, int steadyPoolSize) {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.incrementNumConnFree(beingDestroyed, steadyPoolSize);
        }
    }

    @Override
    public void connectionRequestQueued() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionRequestQueued();
        }
    }

    @Override
    public void connectionRequestDequeued() {
        for (PoolLifeCycleListener listener : this.poolListenersList) {
            listener.connectionRequestDequeued();
        }
    }
}

