/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.MailSessionDescriptor;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.javaee.services.CommonResourceProxy;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.glassfish.resources.mail.config.MailResource;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=MailSessionDescriptor.class)
public class MailSessionDeployer
implements ResourceDeployer<MailSessionDescriptor> {
    private static final Logger LOG = LogDomains.getLogger(MailSessionDeployer.class, "jakarta.enterprise.resource.resourceadapter");
    @Inject
    private Provider<ResourceManagerFactory> resourceManagerFactoryProvider;
    @Inject
    private Provider<CommonResourceProxy> mailSessionProxyProvider;
    @Inject
    private Provider<ResourceNamingService> resourceNamingServiceProvider;
    @Inject
    private ConnectorRuntime runtime;

    @Override
    public void deployResource(MailSessionDescriptor resource, String applicationName, String moduleName) throws Exception {
    }

    @Override
    public void deployResource(MailSessionDescriptor resource) throws Exception {
        SimpleJndiName resourceName = ConnectorsUtil.deriveResourceName(resource.getResourceId(), resource.getJndiName(), resource.getResourceType());
        MyMailResource mailResource = new MyMailResource(resource, resourceName);
        this.getDeployer(mailResource).deployResource(mailResource);
        LOG.log(Level.FINE, "Mail-Session resource is deployed having resource-name [" + resource.getName() + "]");
    }

    @Override
    public void undeployResource(MailSessionDescriptor resource) throws Exception {
        SimpleJndiName resourceName = ConnectorsUtil.deriveResourceName(resource.getResourceId(), resource.getJndiName(), resource.getResourceType());
        MyMailResource mailResource = new MyMailResource(resource, resourceName);
        this.getDeployer(mailResource).undeployResource(mailResource);
        LOG.log(Level.FINE, "Mail-Session resource is undeployed having resource-name [" + resource.getName() + "]");
    }

    @Override
    public void undeployResource(MailSessionDescriptor resource, String applicationName, String moduleName) throws Exception {
    }

    @Override
    public void enableResource(MailSessionDescriptor resource) throws Exception {
        throw new UnsupportedOperationException("enable() not supported for mail-session type");
    }

    @Override
    public void disableResource(MailSessionDescriptor resource) throws Exception {
        throw new UnsupportedOperationException("disable() not supported for mail-session type");
    }

    @Override
    public boolean handles(Object resource) {
        return resource instanceof MailSessionDescriptor;
    }

    @Override
    public void validatePreservedResource(com.sun.enterprise.config.serverbeans.Application oldApp, com.sun.enterprise.config.serverbeans.Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    private ResourceDeployer getDeployer(Object resource) {
        return this.resourceManagerFactoryProvider.get().getResourceDeployer(resource);
    }

    public void registerMailSessions(Application application) {
        String appName = application.getAppName();
        Set<BundleDescriptor> bundles = application.getBundleDescriptors();
        for (BundleDescriptor bundle2 : bundles) {
            this.registerMailSessionDefinitions(appName, bundle2);
            Collection<RootDeploymentDescriptor> dds = bundle2.getExtensionsDescriptors();
            if (dds == null) continue;
            for (RootDeploymentDescriptor dd : dds) {
                this.registerMailSessionDefinitions(appName, dd);
            }
        }
    }

    private void registerMailSessionDefinitions(String appName, Descriptor descriptor) {
        if (descriptor instanceof JndiNameEnvironment) {
            JndiNameEnvironment env = (JndiNameEnvironment)((Object)descriptor);
            for (Descriptor descriptor2 : env.getResourceDescriptors(JavaEEResourceType.MSD)) {
                this.registerMSDReferredByApplication(appName, (MailSessionDescriptor)descriptor2);
            }
        }
        if (descriptor instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbDesc = (EjbBundleDescriptor)descriptor;
            Set<? extends EjbDescriptor> ejbDescriptors = ejbDesc.getEjbs();
            for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
                for (Descriptor descriptor3 : ejbDescriptor.getResourceDescriptors(JavaEEResourceType.MSD)) {
                    this.registerMSDReferredByApplication(appName, (MailSessionDescriptor)descriptor3);
                }
            }
            for (EjbInterceptor ejbInterceptor : ejbDesc.getInterceptors()) {
                for (Descriptor descriptor4 : ejbInterceptor.getResourceDescriptors(JavaEEResourceType.MSD)) {
                    this.registerMSDReferredByApplication(appName, (MailSessionDescriptor)descriptor4);
                }
            }
        }
        if (descriptor instanceof BundleDescriptor) {
            Set<ManagedBeanDescriptor> managedBeanDescriptors = ((BundleDescriptor)descriptor).getManagedBeans();
            for (ManagedBeanDescriptor managedBeanDescriptor : managedBeanDescriptors) {
                for (Descriptor descriptor5 : managedBeanDescriptor.getResourceDescriptors(JavaEEResourceType.MSD)) {
                    this.registerMSDReferredByApplication(appName, (MailSessionDescriptor)descriptor5);
                }
            }
        }
    }

    private void registerMSDReferredByApplication(String appName, MailSessionDescriptor msd) {
        if (!msd.isDeployed()) {
            CommonResourceProxy proxy = this.mailSessionProxyProvider.get();
            ResourceNamingService resourceNamingService = this.resourceNamingServiceProvider.get();
            proxy.setDescriptor(msd);
            if (msd.getJndiName().isJavaApp()) {
                msd.setResourceId(appName);
            }
            if (msd.getJndiName().isJavaGlobal() || msd.getJndiName().isJavaApp()) {
                ResourceInfo resourceInfo = new ResourceInfo(msd.getJndiName(), appName);
                try {
                    resourceNamingService.publishObject(resourceInfo, proxy, true);
                    msd.setDeployed(true);
                }
                catch (NamingException e) {
                    Object[] params = new Object[]{appName, msd.getName(), e};
                    LOG.log(Level.WARNING, "exception while registering mail-session ", params);
                }
            }
        }
    }

    public void unRegisterMailSessions(Application application) {
        Set<BundleDescriptor> bundles = application.getBundleDescriptors();
        for (BundleDescriptor bundle2 : bundles) {
            this.unRegisterMailSessions(bundle2);
            Collection<RootDeploymentDescriptor> dds = bundle2.getExtensionsDescriptors();
            if (dds == null) continue;
            for (RootDeploymentDescriptor dd : dds) {
                this.unRegisterMailSessions(dd);
            }
        }
    }

    private void unRegisterMailSessions(Descriptor descriptor) {
        if (descriptor instanceof JndiNameEnvironment) {
            JndiNameEnvironment env = (JndiNameEnvironment)((Object)descriptor);
            for (Descriptor descriptor2 : env.getResourceDescriptors(JavaEEResourceType.MSD)) {
                this.unRegisterMSDReferredByApplication((MailSessionDescriptor)descriptor2);
            }
        }
        if (descriptor instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbDesc = (EjbBundleDescriptor)descriptor;
            for (EjbDescriptor ejbDescriptor : ejbDesc.getEjbs()) {
                for (Descriptor descriptor3 : ejbDescriptor.getResourceDescriptors(JavaEEResourceType.MSD)) {
                    this.unRegisterMSDReferredByApplication((MailSessionDescriptor)descriptor3);
                }
            }
            for (EjbInterceptor ejbInterceptor : ejbDesc.getInterceptors()) {
                for (Descriptor descriptor4 : ejbInterceptor.getResourceDescriptors(JavaEEResourceType.MSD)) {
                    this.unRegisterMSDReferredByApplication((MailSessionDescriptor)descriptor4);
                }
            }
        }
        if (descriptor instanceof BundleDescriptor) {
            Set<ManagedBeanDescriptor> managedBeanDescriptors = ((BundleDescriptor)descriptor).getManagedBeans();
            for (ManagedBeanDescriptor managedBeanDescriptor : managedBeanDescriptors) {
                for (Descriptor descriptor5 : managedBeanDescriptor.getResourceDescriptors(JavaEEResourceType.MSD)) {
                    this.unRegisterMSDReferredByApplication((MailSessionDescriptor)descriptor5);
                }
            }
        }
    }

    private void unRegisterMSDReferredByApplication(MailSessionDescriptor msd) {
        try {
            if (msd.isDeployed()) {
                this.undeployResource(msd);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "exception while unregistering mail-session [ " + msd.getName() + " ]", e);
        }
    }

    class MyMailResource
    extends FakeConfigBean
    implements MailResource {
        private final MailSessionDescriptor desc;
        private final SimpleJndiName name;

        MyMailResource(MailSessionDescriptor desc, SimpleJndiName name) {
            super(MailSessionDeployer.this);
            this.desc = desc;
            this.name = name;
        }

        @Override
        public String getStoreProtocol() {
            return this.desc.getStoreProtocol();
        }

        @Override
        public void setStoreProtocol(String value) throws PropertyVetoException {
        }

        @Override
        public String getStoreProtocolClass() {
            return this.desc.getProperty("mail." + this.getStoreProtocol() + ".class");
        }

        @Override
        public void setStoreProtocolClass(String value) throws PropertyVetoException {
        }

        @Override
        public String getTransportProtocol() {
            return this.desc.getTransportProtocol();
        }

        @Override
        public void setTransportProtocol(String value) throws PropertyVetoException {
        }

        @Override
        public String getTransportProtocolClass() {
            return this.desc.getProperty("mail." + this.getTransportProtocol() + ".class");
        }

        @Override
        public void setTransportProtocolClass(String value) throws PropertyVetoException {
        }

        @Override
        public String getHost() {
            return this.desc.getHost();
        }

        @Override
        public void setHost(String value) throws PropertyVetoException {
        }

        @Override
        public String getUser() {
            return this.desc.getUser();
        }

        @Override
        public void setUser(String value) throws PropertyVetoException {
        }

        @Override
        public String getFrom() {
            return this.desc.getFrom();
        }

        @Override
        public void setFrom(String value) throws PropertyVetoException {
        }

        @Override
        public String getDebug() {
            return String.valueOf(true);
        }

        @Override
        public void setDebug(String value) throws PropertyVetoException {
        }

        @Override
        public String getJndiName() {
            return this.name.toString();
        }

        @Override
        public void setJndiName(String value) throws PropertyVetoException {
        }

        @Override
        public String getEnabled() {
            return String.valueOf(true);
        }

        @Override
        public void setEnabled(String value) throws PropertyVetoException {
        }

        @Override
        public String getDescription() {
            return this.desc.getDescription();
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
        }

        @Override
        public List<Property> getProperty() {
            ArrayList<Property> props = new ArrayList<Property>();
            for (String key : this.desc.getProperties().stringPropertyNames()) {
                props.add(new MailSessionProperty(MailSessionDeployer.this, key, this.desc.getProperty(key)));
            }
            return props;
        }

        @Override
        public Property getProperty(String name) {
            return new MailSessionProperty(MailSessionDeployer.this, name, this.desc.getProperty(name));
        }

        @Override
        public String getPropertyValue(String name) {
            return this.desc.getProperty(name);
        }

        @Override
        public String getPropertyValue(String name, String defaultValue) {
            String v = this.desc.getProperty(name);
            return v != null ? v : defaultValue;
        }

        @Override
        public String getObjectType() {
            return null;
        }

        @Override
        public void setObjectType(String value) throws PropertyVetoException {
        }

        @Override
        public String getIdentity() {
            return this.name.toString();
        }

        @Override
        public String getDeploymentOrder() {
            return null;
        }

        @Override
        public void setDeploymentOrder(String value) {
        }

        @Override
        public Property addProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Property lookupProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Property removeProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Property removeProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    class MailSessionProperty
    extends FakeConfigBean
    implements Property {
        private String name;
        private String value;
        private String description;

        MailSessionProperty(MailSessionDeployer this$0, String name, String value) {
            super(this$0);
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String value) throws PropertyVetoException {
            this.name = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) throws PropertyVetoException {
            this.value = value;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
            this.description = value;
        }

        public void injectedInto(Object o) {
        }
    }

    abstract class FakeConfigBean
    implements ConfigBeanProxy {
        FakeConfigBean(MailSessionDeployer this$0) {
        }

        @Override
        public ConfigBeanProxy deepCopy(ConfigBeanProxy parent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConfigBeanProxy getParent() {
            return null;
        }

        @Override
        public <T extends ConfigBeanProxy> T getParent(Class<T> tClass) {
            return null;
        }

        @Override
        public <T extends ConfigBeanProxy> T createChild(Class<T> tClass) throws TransactionFailure {
            return null;
        }
    }
}

