/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deployment.ConnectionFactoryDefinitionDescriptor;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.connectors.config.ConnectorConnectionPool;
import org.glassfish.connectors.config.ConnectorResource;
import org.glassfish.connectors.config.SecurityMap;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=ConnectionFactoryDefinitionDescriptor.class)
public class ConnectionFactoryDefinitionDeployer
implements ResourceDeployer<ConnectionFactoryDefinitionDescriptor> {
    private static final System.Logger LOG = System.getLogger(ConnectionFactoryDefinitionDeployer.class.getName());
    private static final String PROPERTY_PREFIX = "org.glassfish.connector-connection-pool.";
    @Inject
    private Provider<ResourceManagerFactory> resourceManagerFactoryProvider;

    @Override
    public void deployResource(ConnectionFactoryDefinitionDescriptor resource, String applicationName, String moduleName) throws Exception {
    }

    @Override
    public void deployResource(ConnectionFactoryDefinitionDescriptor resource) throws Exception {
        SimpleJndiName poolName = ConnectorsUtil.deriveResourceName(resource.getResourceId(), resource.getJndiName(), JavaEEResourceType.CFDPOOL);
        SimpleJndiName resourceName = ConnectorsUtil.deriveResourceName(resource.getResourceId(), resource.getJndiName(), resource.getResourceType());
        LOG.log(System.Logger.Level.INFO, "Deploying resource [{0}] with pool [{1}].", resourceName, poolName);
        MyConnectorConnectionPool connectorCp = new MyConnectorConnectionPool(resource, poolName);
        this.getDeployer(connectorCp).deployResource(connectorCp);
        MyConnectorResource connectorResource = new MyConnectorResource(this, poolName, resourceName);
        this.getDeployer(connectorResource).deployResource(connectorResource);
    }

    @Override
    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    private ResourceDeployer getDeployer(Object resource) {
        return this.resourceManagerFactoryProvider.get().getResourceDeployer(resource);
    }

    private ConnectionFactoryProperty convertProperty(String name, String value) {
        return new ConnectionFactoryProperty(this, name, value);
    }

    @Override
    public void undeployResource(ConnectionFactoryDefinitionDescriptor resource, String applicationName, String moduleName) throws Exception {
    }

    @Override
    public void undeployResource(ConnectionFactoryDefinitionDescriptor resource) throws Exception {
        SimpleJndiName poolName = ConnectorsUtil.deriveResourceName(resource.getResourceId(), resource.getJndiName(), JavaEEResourceType.CFDPOOL);
        SimpleJndiName resourceName = ConnectorsUtil.deriveResourceName(resource.getResourceId(), resource.getJndiName(), resource.getResourceType());
        LOG.log(System.Logger.Level.INFO, "Undeploying resource [{0}] with pool [{1}].", resourceName, poolName);
        MyConnectorResource connectorResource = new MyConnectorResource(this, poolName, resourceName);
        this.getDeployer(connectorResource).undeployResource(connectorResource);
        MyConnectorConnectionPool connectorCp = new MyConnectorConnectionPool(resource, poolName);
        this.getDeployer(connectorCp).undeployResource(connectorCp);
    }

    @Override
    public void enableResource(ConnectionFactoryDefinitionDescriptor resource) throws Exception {
        throw new UnsupportedOperationException("enable() not supported for connection-factory-definition type");
    }

    @Override
    public void disableResource(ConnectionFactoryDefinitionDescriptor resource) throws Exception {
        throw new UnsupportedOperationException("disable() not supported for connection-factory-definition type");
    }

    @Override
    public boolean handles(Object resource) {
        return resource instanceof ConnectionFactoryDefinitionDescriptor;
    }

    class MyConnectorConnectionPool
    extends FakeConfigBean
    implements ConnectorConnectionPool {
        private final ConnectionFactoryDefinitionDescriptor desc;
        private final SimpleJndiName name;

        public MyConnectorConnectionPool(ConnectionFactoryDefinitionDescriptor desc, SimpleJndiName name) {
            super(ConnectionFactoryDefinitionDeployer.this);
            this.desc = desc;
            this.name = name;
        }

        @Override
        public String getObjectType() {
            return "user";
        }

        @Override
        public void setObjectType(String value) throws PropertyVetoException {
        }

        @Override
        public String getIdentity() {
            return this.name.toString();
        }

        @Override
        public String getSteadyPoolSize() {
            int minPoolSize = this.desc.getMinPoolSize();
            return minPoolSize < 0 ? "8" : Integer.toString(minPoolSize);
        }

        @Override
        public void setSteadyPoolSize(String value) throws PropertyVetoException {
        }

        @Override
        public String getMaxPoolSize() {
            int maxPoolSize = this.desc.getMaxPoolSize();
            return maxPoolSize < 0 ? "32" : Integer.toString(maxPoolSize);
        }

        @Override
        public void setMaxPoolSize(String value) throws PropertyVetoException {
        }

        @Override
        public String getMaxWaitTimeInMillis() {
            String maxWaitTimeInMillis = this.desc.getProperty("org.glassfish.connector-connection-pool.max-wait-time-in-millis");
            return maxWaitTimeInMillis == null || maxWaitTimeInMillis.isEmpty() ? "60000" : maxWaitTimeInMillis;
        }

        @Override
        public void setMaxWaitTimeInMillis(String value) throws PropertyVetoException {
        }

        @Override
        public String getPoolResizeQuantity() {
            String poolResizeQuantity = this.desc.getProperty("org.glassfish.connector-connection-pool.pool-resize-quantity");
            return poolResizeQuantity == null || poolResizeQuantity.isEmpty() ? "2" : poolResizeQuantity;
        }

        @Override
        public void setPoolResizeQuantity(String value) throws PropertyVetoException {
        }

        @Override
        public String getIdleTimeoutInSeconds() {
            String timeoutInSeconds = this.desc.getProperty("org.glassfish.connector-connection-pool.idle-timeout-in-seconds");
            return timeoutInSeconds == null || timeoutInSeconds.isEmpty() ? "300" : timeoutInSeconds;
        }

        @Override
        public void setIdleTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getIsConnectionValidationRequired() {
            String isRequired = this.desc.getProperty("org.glassfish.connector-connection-pool.is-connection-validation-required");
            return isRequired == null || isRequired.isEmpty() ? "false" : isRequired;
        }

        @Override
        public void setIsConnectionValidationRequired(String value) throws PropertyVetoException {
        }

        @Override
        public String getResourceAdapterName() {
            return this.desc.getResourceAdapter();
        }

        @Override
        public void setResourceAdapterName(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionDefinitionName() {
            return this.desc.getInterfaceName();
        }

        @Override
        public void setConnectionDefinitionName(String value) throws PropertyVetoException {
        }

        @Override
        public String getFailAllConnections() {
            String failAllConnections = this.desc.getProperty("org.glassfish.connector-connection-pool.fail-all-connections");
            return failAllConnections == null || failAllConnections.isEmpty() ? "false" : failAllConnections;
        }

        @Override
        public void setFailAllConnections(String value) throws PropertyVetoException {
        }

        @Override
        public String getTransactionSupport() {
            return this.desc.getTransactionSupport();
        }

        @Override
        public void setTransactionSupport(String value) throws PropertyVetoException {
        }

        @Override
        public String getValidateAtmostOncePeriodInSeconds() {
            String timeInSeconds = this.desc.getProperty("org.glassfish.connector-connection-pool.validate-at-most-once-period-in-seconds");
            return timeInSeconds == null || timeInSeconds.isEmpty() ? "0" : timeInSeconds;
        }

        @Override
        public void setValidateAtmostOncePeriodInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionLeakTimeoutInSeconds() {
            String timeInSeconds = this.desc.getProperty("org.glassfish.connector-connection-pool.connection-leak-timeout-in-seconds");
            return timeInSeconds == null || timeInSeconds.isEmpty() ? "0" : timeInSeconds;
        }

        @Override
        public void setConnectionLeakTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionLeakReclaim() {
            String conLeakReclaim = this.desc.getProperty("org.glassfish.connector-connection-pool.connection-leak-reclaim");
            return conLeakReclaim == null || conLeakReclaim.isEmpty() ? "0" : conLeakReclaim;
        }

        @Override
        public void setConnectionLeakReclaim(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionCreationRetryAttempts() {
            String attemptCount = this.desc.getProperty("org.glassfish.connector-connection-pool.connection-creation-retry-attempts");
            return attemptCount == null || attemptCount.isEmpty() ? "0" : attemptCount;
        }

        @Override
        public void setConnectionCreationRetryAttempts(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionCreationRetryIntervalInSeconds() {
            String interval = this.desc.getProperty("org.glassfish.connector-connection-pool.connection-creation-retry-interval-in-seconds");
            return interval == null || interval.isEmpty() ? "0" : interval;
        }

        @Override
        public void setConnectionCreationRetryIntervalInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getLazyConnectionEnlistment() {
            String lazy = this.desc.getProperty("org.glassfish.connector-connection-pool.lazy-connection-enlistment");
            return lazy == null || lazy.isEmpty() ? "false" : lazy;
        }

        @Override
        public void setLazyConnectionEnlistment(String value) throws PropertyVetoException {
        }

        @Override
        public String getLazyConnectionAssociation() {
            String lazy = this.desc.getProperty("org.glassfish.connector-connection-pool.lazy-connection-association");
            return lazy == null || lazy.isEmpty() ? "false" : lazy;
        }

        @Override
        public void setLazyConnectionAssociation(String value) throws PropertyVetoException {
        }

        @Override
        public String getAssociateWithThread() {
            String associateWithThread = this.desc.getProperty("org.glassfish.connector-connection-pool.associate-with-thread");
            return associateWithThread == null || associateWithThread.isEmpty() ? "false" : associateWithThread;
        }

        @Override
        public void setAssociateWithThread(String value) throws PropertyVetoException {
        }

        @Override
        public String getPooling() {
            String pooling = this.desc.getProperty("org.glassfish.connector-connection-pool.pooling");
            return pooling == null || pooling.isEmpty() ? "true" : pooling;
        }

        @Override
        public void setPooling(String value) throws PropertyVetoException {
        }

        @Override
        public String getMatchConnections() {
            String matchConn = this.desc.getProperty("org.glassfish.connector-connection-pool.match-connections");
            return matchConn == null || matchConn.isEmpty() ? "true" : matchConn;
        }

        @Override
        public void setMatchConnections(String value) throws PropertyVetoException {
        }

        @Override
        public String getMaxConnectionUsageCount() {
            String count = this.desc.getProperty("org.glassfish.connector-connection-pool.max-connection-usage-count");
            return count == null || count.isEmpty() ? "0" : count;
        }

        @Override
        public void setMaxConnectionUsageCount(String value) throws PropertyVetoException {
        }

        @Override
        public String getDescription() {
            return this.desc.getDescription();
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
        }

        @Override
        public List<Property> getProperty() {
            Properties p = this.desc.getProperties();
            ArrayList<Property> connectionFactoryProperties = new ArrayList<Property>();
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                String key = (String)entry.getKey();
                if (key.startsWith(ConnectionFactoryDefinitionDeployer.PROPERTY_PREFIX)) continue;
                String value = (String)entry.getValue();
                ConnectionFactoryProperty dp = ConnectionFactoryDefinitionDeployer.this.convertProperty(key, value);
                connectionFactoryProperties.add(dp);
            }
            return connectionFactoryProperties;
        }

        @Override
        public Property getProperty(String name) {
            String value = this.desc.getProperty(name);
            return new ConnectionFactoryProperty(ConnectionFactoryDefinitionDeployer.this, name, value);
        }

        @Override
        public String getPropertyValue(String name) {
            return this.desc.getProperty(name);
        }

        @Override
        public String getPropertyValue(String name, String defaultValue) {
            String value = this.desc.getProperty(name);
            return value == null ? defaultValue : value;
        }

        public void injectedInto(Object o) {
        }

        @Override
        public String getName() {
            return this.name.toString();
        }

        @Override
        public void setName(String value) throws PropertyVetoException {
        }

        @Override
        public String getPing() {
            String ping = this.desc.getProperty("org.glassfish.connector-connection-pool.ping");
            return ping == null || ping.isEmpty() ? "false" : ping;
        }

        @Override
        public void setPing(String value) throws PropertyVetoException {
        }

        @Override
        public List<SecurityMap> getSecurityMap() {
            return new ArrayList<SecurityMap>(0);
        }

        @Override
        public String getDeploymentOrder() {
            return null;
        }

        @Override
        public void setDeploymentOrder(String value) {
        }

        @Override
        public Property addProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Property lookupProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Property removeProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Property removeProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    class MyConnectorResource
    extends FakeConfigBean
    implements ConnectorResource {
        private SimpleJndiName poolName;
        private SimpleJndiName jndiName;

        MyConnectorResource(ConnectionFactoryDefinitionDeployer this$0, SimpleJndiName poolName, SimpleJndiName jndiName) {
            super(this$0);
            this.poolName = poolName;
            this.jndiName = jndiName;
        }

        @Override
        public String getPoolName() {
            return this.poolName.toString();
        }

        @Override
        public void setPoolName(String value) throws PropertyVetoException {
            this.poolName = new SimpleJndiName(value);
        }

        @Override
        public String getObjectType() {
            return null;
        }

        @Override
        public void setObjectType(String value) throws PropertyVetoException {
        }

        @Override
        public String getIdentity() {
            return this.jndiName.toString();
        }

        @Override
        public String getEnabled() {
            return String.valueOf(true);
        }

        @Override
        public void setEnabled(String value) throws PropertyVetoException {
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
        }

        @Override
        public List<Property> getProperty() {
            return null;
        }

        @Override
        public Property getProperty(String name) {
            return null;
        }

        @Override
        public String getPropertyValue(String name) {
            return null;
        }

        @Override
        public String getPropertyValue(String name, String defaultValue) {
            return null;
        }

        public void injectedInto(Object o) {
        }

        @Override
        public String getJndiName() {
            return this.jndiName.toString();
        }

        @Override
        public void setJndiName(String value) throws PropertyVetoException {
            this.jndiName = new SimpleJndiName(value);
        }

        @Override
        public String getDeploymentOrder() {
            return null;
        }

        @Override
        public void setDeploymentOrder(String value) {
        }

        @Override
        public Property addProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Property lookupProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Property removeProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Property removeProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    class ConnectionFactoryProperty
    extends FakeConfigBean
    implements Property {
        private String name;
        private String value;
        private String description;

        ConnectionFactoryProperty(ConnectionFactoryDefinitionDeployer this$0, String name, String value) {
            super(this$0);
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String value) throws PropertyVetoException {
            this.name = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) throws PropertyVetoException {
            this.value = value;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
            this.description = value;
        }

        public void injectedInto(Object o) {
        }
    }

    abstract class FakeConfigBean
    implements ConfigBeanProxy {
        FakeConfigBean(ConnectionFactoryDefinitionDeployer this$0) {
        }

        @Override
        public ConfigBeanProxy deepCopy(ConfigBeanProxy parent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConfigBeanProxy getParent() {
            return null;
        }

        @Override
        public <T extends ConfigBeanProxy> T getParent(Class<T> tClass) {
            return null;
        }

        @Override
        public <T extends ConfigBeanProxy> T createChild(Class<T> tClass) throws TransactionFailure {
            return null;
        }
    }
}

