/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.util;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.util.ComponentPostVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.ModuleContentLinker;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class ModuleContentValidator
extends ModuleContentLinker
implements ComponentPostVisitor {
    private ReadableArchive archive_;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ModuleContentValidator.class);

    @Override
    public void setArchive(ReadableArchive archive) {
        this.archive_ = archive;
    }

    @Override
    public void accept(ServiceReferenceDescriptor serviceRef) {
        if (serviceRef.hasWsdlFile()) {
            String wsdlFileUri = serviceRef.getWsdlFileUri();
            URL url = null;
            try {
                url = new URL(wsdlFileUri);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (url != null && (url.getProtocol().equals("http") || url.getProtocol().equals("https"))) {
                return;
            }
            File tmpFile = new File(wsdlFileUri);
            if (tmpFile.isAbsolute() && tmpFile.exists()) {
                return;
            }
            try {
                InputStream wsdlFileInputStream = this.archive_.getEntry(wsdlFileUri);
                if (wsdlFileInputStream != null) {
                    wsdlFileInputStream.close();
                } else {
                    String msg = localStrings.getLocalString("enterprise.deployment.util.wsdlfilenotfound", "wsdl file {0} does not exist for service-ref {1}", wsdlFileUri, serviceRef.getName());
                    DOLUtils.getDefaultLogger().warning(msg);
                }
            }
            catch (IOException ioe) {
                String msg = localStrings.getLocalString("enterprise.deployment.util.wsdlfilenotreadable", "wsdl file {0}  for service-ref {1} cannot be opened : {2}", wsdlFileUri, serviceRef.getName(), ioe.getMessage());
                DOLUtils.getDefaultLogger().warning(msg);
            }
        }
        if (serviceRef.hasMappingFile()) {
            String msg;
            String mappingFileUri = serviceRef.getMappingFileUri();
            try {
                InputStream mappingFileInputStream = this.archive_.getEntry(mappingFileUri);
                if (mappingFileInputStream == null) {
                    msg = localStrings.getLocalString("enterprise.deployment.util.mappingfilenotfound", "mapping file {0} does not exist for service-ref {1}", mappingFileUri, serviceRef.getName());
                    DOLUtils.getDefaultLogger().severe(msg);
                    throw new RuntimeException(msg);
                }
                mappingFileInputStream.close();
            }
            catch (IOException ioe) {
                msg = localStrings.getLocalString("enterprise.deployment.util.mappingfilenotreadable", "mapping file {0}  for service-ref {1} cannot be opened : {2}", mappingFileUri, serviceRef.getName(), ioe.getMessage());
                DOLUtils.getDefaultLogger().severe(msg);
                throw new RuntimeException(ioe);
            }
        }
    }

    @Override
    public void accept(WebService webService) {
        String msg;
        block13: {
            try {
                String wsdlFileUri = webService.getWsdlFileUri();
                if (!webService.hasWsdlFile()) {
                    return;
                }
                try {
                    URL url = new URL(wsdlFileUri);
                    if (url.getProtocol() != null && !url.getProtocol().equals("file")) {
                        return;
                    }
                }
                catch (MalformedURLException url) {
                    // empty catch block
                }
                InputStream wsdlFileInputStream = this.archive_.getEntry(wsdlFileUri);
                if (wsdlFileInputStream != null) {
                    wsdlFileInputStream.close();
                    BundleDescriptor bundle2 = webService.getBundleDescriptor();
                    if (!this.isWsdlContent(wsdlFileUri, bundle2)) {
                        String msg2 = localStrings.getLocalString("enterprise.deployment.util.wsdlpackagedinwrongservicelocation", "wsdl file {0} for web service {1} must be packaged in or below {2}", wsdlFileUri, webService.getName(), bundle2.getWsdlDir());
                        DOLUtils.getDefaultLogger().severe(msg2);
                        throw new RuntimeException(msg2);
                    }
                    break block13;
                }
                String fullFileUri = webService.getBundleDescriptor().getWsdlDir() + "/" + wsdlFileUri;
                wsdlFileInputStream = this.archive_.getEntry(fullFileUri);
                if (wsdlFileInputStream != null) {
                    wsdlFileInputStream.close();
                    webService.setWsdlFileUri(fullFileUri);
                    break block13;
                }
                String msg3 = localStrings.getLocalString("enterprise.deployment.util.servicewsdlfilenotfound", "wsdl file {0} does not exist for web service {1}", wsdlFileUri, webService.getName());
                DOLUtils.getDefaultLogger().severe(msg3);
                throw new RuntimeException(msg3);
            }
            catch (IOException ioe) {
                String msg4 = localStrings.getLocalString("enterprise.deployment.util.servicewsdlfilenotreadable", "wsdl file {0}  for service-ref {1} cannot be opened : {2}", webService.getWsdlFileUri(), webService.getName(), ioe.getMessage());
                DOLUtils.getDefaultLogger().severe(msg4);
                throw new RuntimeException(ioe);
            }
        }
        if (webService.getMappingFileUri() == null) {
            return;
        }
        try {
            InputStream mappingFileInputStream = this.archive_.getEntry(webService.getMappingFileUri());
            if (mappingFileInputStream == null) {
                msg = localStrings.getLocalString("enterprise.deployment.util.servicemappingfilenotfound", "Web Service mapping file {0} for web service {1} not found", webService.getMappingFileUri(), webService.getName());
                DOLUtils.getDefaultLogger().severe(msg);
                throw new RuntimeException(msg);
            }
            mappingFileInputStream.close();
        }
        catch (IOException ioe) {
            msg = localStrings.getLocalString("enterprise.deployment.util.servicemappingfilenotreadable", "Web Service mapping file {0} for web service {1} not found {2} ", webService.getMappingFileUri(), webService.getName(), ioe);
            DOLUtils.getDefaultLogger().severe(msg);
            throw new RuntimeException(ioe);
        }
    }

    public boolean isWsdlContent(String uri, BundleDescriptor bundle2) {
        String wsdlDir = bundle2.getWsdlDir();
        return uri != null && uri.startsWith(wsdlDir);
    }
}

