/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.node.runtime.connector;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.node.runtime.connector.PrincipalNode;
import com.sun.enterprise.deployment.runtime.connector.MapElement;
import com.sun.enterprise.deployment.runtime.connector.Principal;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MapElementNode
extends RuntimeDescriptorNode {
    public MapElementNode() {
        this.registerElementHandler(new XMLElement("principal"), PrincipalNode.class);
        this.registerElementHandler(new XMLElement("backend-principal"), PrincipalNode.class);
    }

    @Override
    public void addDescriptor(Object newDescriptor) {
        MapElement descriptor = (MapElement)this.getDescriptor();
        if (descriptor == null) {
            throw new RuntimeException("Cannot set info on null descriptor");
        }
        if (newDescriptor instanceof Principal) {
            Principal principal = (Principal)newDescriptor;
            if (principal.getValue("Credential") == null) {
                descriptor.addPrincipal(principal);
            } else {
                descriptor.setBackendPrincipal(true);
                descriptor.setAttributeValue("BackendPrincipal", "UserName", principal.getValue("UserName"));
                descriptor.setAttributeValue("BackendPrincipal", "Password", principal.getValue("Password"));
                descriptor.setAttributeValue("BackendPrincipal", "Credential", principal.getValue("Credential"));
            }
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, MapElement descriptor) {
        Principal[] principals;
        Node mapElementNode = super.writeDescriptor(parent, nodeName, descriptor);
        PrincipalNode pn = new PrincipalNode();
        for (Principal principal : principals = descriptor.getPrincipal()) {
            pn.writeDescriptor(mapElementNode, "principal", principal);
        }
        if (descriptor.isBackendPrincipal()) {
            Element backend = MapElementNode.appendChild(mapElementNode, "backend-principal");
            MapElementNode.setAttribute(backend, "user-name", descriptor.getAttributeValue("BackendPrincipal", "UserName"));
            MapElementNode.setAttribute(backend, "password", descriptor.getAttributeValue("BackendPrincipal", "Password"));
            MapElementNode.setAttribute(backend, "credential", descriptor.getAttributeValue("BackendPrincipal", "Credential"));
        }
        return mapElementNode;
    }
}

