/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.ManagedThreadFactoryDefinitionDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.annotation.handlers.ConcurrencyDefinitionConvertor;
import com.sun.enterprise.deployment.annotation.handlers.ManagedThreadFactoryDefinitionData;
import jakarta.enterprise.concurrent.ManagedThreadFactoryDefinition;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.jvnet.hk2.annotations.Service;

@Service
class ManagedThreadFactoryDefinitionConverter
extends ConcurrencyDefinitionConvertor<ManagedThreadFactoryDefinitionData, ManagedThreadFactoryDefinitionDescriptor> {
    private static final System.Logger LOG = System.getLogger(ManagedThreadFactoryDefinitionConverter.class.getName());

    ManagedThreadFactoryDefinitionConverter() {
        super(ManagedThreadFactoryDefinitionDescriptor.class, JavaEEResourceType.MTFDD);
    }

    @Override
    ManagedThreadFactoryDefinitionDescriptor createDescriptor(ManagedThreadFactoryDefinitionData data) {
        return new ManagedThreadFactoryDefinitionDescriptor(data, MetadataSource.ANNOTATION);
    }

    @Override
    ManagedThreadFactoryDefinitionData getData(ManagedThreadFactoryDefinitionDescriptor descriptor) {
        return descriptor.getData();
    }

    Set<ManagedThreadFactoryDefinitionData> convert(ManagedThreadFactoryDefinition[] annotation) {
        LOG.log(System.Logger.Level.TRACE, "convert(annotation={0})", new Object[]{annotation});
        if (annotation == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(annotation).map(this::convert).collect(Collectors.toSet());
    }

    ManagedThreadFactoryDefinitionData convert(ManagedThreadFactoryDefinition annotation) {
        LOG.log(System.Logger.Level.DEBUG, "convert(annotation={0})", annotation);
        ManagedThreadFactoryDefinitionData data = new ManagedThreadFactoryDefinitionData();
        data.setName(TranslatedConfigView.expandValue(annotation.name()));
        for (Class clazz : annotation.qualifiers()) {
            data.addQualifier(clazz.getCanonicalName());
        }
        data.setUseVirtualThreads(annotation.virtual());
        data.setContext(TranslatedConfigView.expandValue(annotation.context()));
        if (annotation.priority() <= 0) {
            data.setPriority(5);
        } else {
            data.setPriority(annotation.priority());
        }
        return data;
    }

    @Override
    void merge(ManagedThreadFactoryDefinitionData annotation, ManagedThreadFactoryDefinitionData descriptor) {
        LOG.log(System.Logger.Level.DEBUG, "merge(annotation={0}, descriptor={1})", annotation, descriptor);
        if (!annotation.getName().equals(descriptor.getName())) {
            throw new IllegalArgumentException("Cannot merge managed thread factories with different names: " + annotation.getName() + " x " + descriptor.getName());
        }
        this.mergeQualifiers(annotation, descriptor);
        if (!descriptor.getUseVirtualThreads()) {
            descriptor.setUseVirtualThreads(annotation.getUseVirtualThreads());
        }
        if (descriptor.getPriority() == -1 && annotation.getPriority() != -1) {
            descriptor.setPriority(annotation.getPriority());
        }
        if (descriptor.getContext() == null && annotation.getContext() != null && !annotation.getContext().isBlank()) {
            descriptor.setContext(TranslatedConfigView.expandValue(annotation.getContext()));
        }
    }
}

