/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.ConcurrencyResourceDefinition;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.glassfish.deployment.common.JavaEEResourceType;

abstract class ConcurrencyDefinitionConvertor<D extends ConcurrencyResourceDefinition, T extends ResourceDescriptor> {
    private static final System.Logger LOG = System.getLogger(ConcurrencyDefinitionConvertor.class.getName());
    private final Class<T> descriptorClass;
    private final JavaEEResourceType descriptorType;

    ConcurrencyDefinitionConvertor(Class<T> descriptorClass, JavaEEResourceType descriptorType) {
        this.descriptorClass = descriptorClass;
        this.descriptorType = descriptorType;
    }

    abstract T createDescriptor(D var1);

    abstract D getData(T var1);

    abstract void merge(D var1, D var2);

    final void updateDescriptors(D data, ResourceContainerContext[] contexts) {
        LOG.log(System.Logger.Level.DEBUG, "updateDescriptors(data={0}, contexts.length={1})", data, contexts.length);
        for (ResourceContainerContext context : contexts) {
            Set<ResourceDescriptor> descriptors = context.getResourceDescriptors(this.descriptorType);
            List<D> existing = this.getExisting(data, descriptors);
            if (existing.isEmpty()) {
                Object descriptor = this.createDescriptor(data);
                descriptors.add((ResourceDescriptor)descriptor);
                LOG.log(System.Logger.Level.DEBUG, () -> "Added new descriptor based on annotation: " + String.valueOf(descriptor));
                continue;
            }
            for (ConcurrencyResourceDefinition existingData : existing) {
                this.merge(data, existingData);
                LOG.log(System.Logger.Level.DEBUG, () -> "Merged data " + String.valueOf(data) + " into existing descriptor data, result: " + String.valueOf(existingData));
            }
        }
    }

    final void mergeQualifiers(D annotation, D descriptor) {
        if (descriptor.getQualifiers().size() == 1 && descriptor.getQualifiers().get(0).isEmpty()) {
            descriptor.setQualifiers(List.of());
        } else if (descriptor.getQualifiers().isEmpty() && !annotation.getQualifiers().isEmpty()) {
            descriptor.setQualifiers(annotation.getQualifiers());
        }
    }

    private List<D> getExisting(D data, Set<ResourceDescriptor> descriptors) {
        return descriptors.stream().filter(d -> this.isSameDefinition(data, (ResourceDescriptor)d)).map(d -> this.getData(d)).collect(Collectors.toList());
    }

    private boolean isSameDefinition(D data, ResourceDescriptor descriptor) {
        return this.descriptorClass.isInstance(descriptor) && Objects.equals(ResourceDescriptor.getJavaComponentJndiName(descriptor.getJndiName().toString()), ResourceDescriptor.getJavaComponentJndiName(data.getName()));
    }
}

