/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.OrderedSet;
import jakarta.resource.spi.AuthenticationMechanism;
import jakarta.resource.spi.TransactionSupport;
import jakarta.resource.spi.security.GenericCredential;
import jakarta.resource.spi.security.PasswordCredential;
import java.util.Set;
import org.glassfish.deployment.common.Descriptor;
import org.ietf.jgss.GSSCredential;

public class OutboundResourceAdapter
extends Descriptor {
    private static final long serialVersionUID = 1L;
    private TransactionSupport.TransactionSupportLevel transactionSupport = TransactionSupport.TransactionSupportLevel.LocalTransaction;
    private Set<AuthMechanism> authMechanisms = new OrderedSet<AuthMechanism>();
    private boolean reauthenticationSupport;
    private final Set<ConnectionDefDescriptor> connectionDefs = new OrderedSet<ConnectionDefDescriptor>();
    private boolean reauthenticationSupportSet;
    private boolean transactionSupportSet;

    public boolean supportsReauthentication() {
        return this.reauthenticationSupport;
    }

    public String getReauthenticationSupport() {
        return String.valueOf(this.reauthenticationSupport);
    }

    public void setReauthenticationSupport(boolean reauthenticationSupport) {
        this.reauthenticationSupportSet = true;
        this.reauthenticationSupport = reauthenticationSupport;
    }

    public void setReauthenticationSupport(String reauthSupport) {
        this.reauthenticationSupport = Boolean.parseBoolean(reauthSupport);
        this.reauthenticationSupportSet = true;
    }

    public String getTransSupport() {
        if (this.transactionSupport == TransactionSupport.TransactionSupportLevel.NoTransaction) {
            return "NoTransaction";
        }
        if (this.transactionSupport == TransactionSupport.TransactionSupportLevel.LocalTransaction) {
            return "LocalTransaction";
        }
        return "XATransaction";
    }

    public void setTransactionSupport(String support) {
        this.transactionSupport = "XATransaction".equals(support) ? TransactionSupport.TransactionSupportLevel.XATransaction : ("LocalTransaction".equals(support) ? TransactionSupport.TransactionSupportLevel.LocalTransaction : TransactionSupport.TransactionSupportLevel.NoTransaction);
        this.transactionSupportSet = true;
    }

    public Set<AuthMechanism> getAuthMechanisms() {
        if (this.authMechanisms == null) {
            this.authMechanisms = new OrderedSet<AuthMechanism>();
        }
        return this.authMechanisms;
    }

    public boolean addAuthMechanism(AuthMechanism mech) {
        for (AuthMechanism next : this.authMechanisms) {
            if (next.getAuthMechVal() != mech.getAuthMechVal()) continue;
            return false;
        }
        return this.authMechanisms.add(mech);
    }

    public boolean removeAuthMechanism(AuthMechanism mech) {
        for (AuthMechanism next : this.authMechanisms) {
            if (!next.equals(mech)) continue;
            return this.authMechanisms.remove(mech);
        }
        return false;
    }

    public boolean addAuthMechanism(int mech) {
        for (AuthMechanism next : this.authMechanisms) {
            if (next.getAuthMechVal() != mech) continue;
            return false;
        }
        AuthMechanism auth = new AuthMechanism(mech);
        return this.authMechanisms.add(auth);
    }

    public boolean removeAuthMechanism(int mech) {
        for (AuthMechanism next : this.authMechanisms) {
            if (next.getAuthMechVal() != mech) continue;
            return this.authMechanisms.remove(next);
        }
        return false;
    }

    public void addConnectionDefDescriptor(ConnectionDefDescriptor conDefDesc) {
        this.connectionDefs.add(conDefDesc);
    }

    public boolean hasConnectionDefDescriptor(String connectionFactoryIntf) {
        for (ConnectionDefDescriptor cdd : this.connectionDefs) {
            if (!cdd.getConnectionFactoryIntf().equals(connectionFactoryIntf)) continue;
            return true;
        }
        return false;
    }

    public void removeConnectionDefDescriptor(ConnectionDefDescriptor conDefDesc) {
        this.connectionDefs.remove(conDefDesc);
    }

    public Set<ConnectionDefDescriptor> getConnectionDefs() {
        return this.connectionDefs;
    }

    public void setConnectionDef(ConnectionDefDescriptor conDef) {
        this.connectionDefs.add(conDef);
    }

    public ConnectionDefDescriptor getConnectionDef() {
        return this.connectionDefs.iterator().next();
    }

    public String getManagedConnectionFactoryImpl() {
        return this.getConnectionDef().getManagedConnectionFactoryImpl();
    }

    public void setManagedConnectionFactoryImpl(String managedConnectionFactoryImpl) {
        this.getConnectionDef().setManagedConnectionFactoryImpl(managedConnectionFactoryImpl);
    }

    public Set<ConnectorConfigProperty> getConfigProperties() {
        return this.getConnectionDef().getConfigProperties();
    }

    public void addConfigProperty(ConnectorConfigProperty configProperty) {
        this.getConnectionDef().getConfigProperties().add(configProperty);
    }

    public void removeConfigProperty(ConnectorConfigProperty configProperty) {
        this.getConnectionDef().getConfigProperties().remove(configProperty);
    }

    public String getConnectionFactoryImpl() {
        return this.getConnectionDef().getConnectionFactoryImpl();
    }

    public void setConnectionFactoryImpl(String cf) {
        this.getConnectionDef().setConnectionFactoryImpl(cf);
    }

    public String getConnectionFactoryIntf() {
        return this.getConnectionDef().getConnectionFactoryIntf();
    }

    public void setConnectionFactoryIntf(String cf) {
        this.getConnectionDef().setConnectionFactoryIntf(cf);
    }

    public String getConnectionIntf() {
        return this.getConnectionDef().getConnectionIntf();
    }

    public void setConnectionIntf(String con) {
        this.getConnectionDef().setConnectionIntf(con);
    }

    public String getConnectionImpl() {
        return this.getConnectionDef().getConnectionImpl();
    }

    public void setConnectionImpl(String con) {
        this.getConnectionDef().setConnectionImpl(con);
    }

    public boolean isReauthenticationSupportSet() {
        return this.reauthenticationSupportSet;
    }

    public boolean isTransactionSupportSet() {
        return this.transactionSupportSet;
    }

    public static String getCredentialInterfaceName(AuthenticationMechanism.CredentialInterface ci) {
        if (ci.equals((Object)AuthenticationMechanism.CredentialInterface.GenericCredential)) {
            return GenericCredential.class.getName();
        }
        if (ci.equals((Object)AuthenticationMechanism.CredentialInterface.GSSCredential)) {
            return GSSCredential.class.getName();
        }
        if (ci.equals((Object)AuthenticationMechanism.CredentialInterface.PasswordCredential)) {
            return PasswordCredential.class.getName();
        }
        throw new RuntimeException("Invalid credential interface :  " + String.valueOf((Object)ci));
    }
}

