/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl.util;

import com.sun.enterprise.container.common.spi.util.GlassFishInputStreamHandler;
import com.sun.enterprise.container.common.spi.util.SerializableObjectFactory;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.common.util.ObjectInputOutputStreamFactory;
import org.glassfish.common.util.ObjectInputOutputStreamFactoryFactory;

class GlassFishObjectInputStream
extends ObjectInputStream {
    private static final Logger LOG = LogDomains.getLogger(GlassFishObjectInputStream.class, "jakarta.enterprise.system.core.naming", false);
    private final ClassLoader appLoader;
    private final ObjectInputOutputStreamFactory inputStreamHelper;
    private final Collection<GlassFishInputStreamHandler> handlers;

    GlassFishObjectInputStream(Collection<GlassFishInputStreamHandler> handlers, InputStream in, ClassLoader appLoader, boolean resolve) throws IOException, StreamCorruptedException {
        super(in);
        this.appLoader = appLoader;
        this.handlers = handlers;
        if (resolve) {
            this.enableResolveObject(resolve);
        }
        this.inputStreamHelper = ObjectInputOutputStreamFactoryFactory.getFactory();
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        try {
            if (obj instanceof SerializableObjectFactory) {
                return ((SerializableObjectFactory)obj).createObject();
            }
            for (GlassFishInputStreamHandler handler : this.handlers) {
                Object r = handler.resolveObject(obj);
                if (r == null) continue;
                if (r == GlassFishInputStreamHandler.NULL_OBJECT) {
                    return null;
                }
                return r;
            }
            return obj;
        }
        catch (IOException ioEx) {
            LOG.log(Level.SEVERE, "Exception resolving object", ioEx);
            throw ioEx;
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Exception resolving object", ex);
            throw new IOException("Could not resolve object: " + String.valueOf(obj), ex);
        }
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] classObjs = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> cl = Class.forName(interfaces[i], false, this.appLoader);
            if ((cl.getModifiers() & 1) == 0) {
                return super.resolveProxyClass(interfaces);
            }
            classObjs[i] = cl;
        }
        try {
            Class<?> proxyClass = Proxy.getProxyClass(this.appLoader, classObjs);
            return proxyClass;
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        Class<?> clazz = this.inputStreamHelper.resolveClass(this, desc);
        if (clazz != null) {
            return clazz;
        }
        try {
            return this.appLoader.loadClass(desc.getName());
        }
        catch (ClassNotFoundException e) {
            return super.resolveClass(desc);
        }
    }
}

