/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.service;

import com.sun.appserv.connectors.internal.api.ConnectorConstants;
import com.sun.enterprise.connectors.ConnectorConnectionPool;
import com.sun.enterprise.connectors.ConnectorDescriptorInfo;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.deployment.ConnectorConfigProperty;
import com.sun.enterprise.deployment.ResourcePrincipalDescriptor;
import java.util.Locale;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.resourcebase.resources.api.GenericResourceInfo;
import org.glassfish.resourcebase.resources.api.PoolInfo;

public class ConnectorAdminServiceUtils
implements ConnectorConstants {
    private ConnectorAdminServiceUtils() {
    }

    public static ResourcePrincipalDescriptor getDefaultResourcePrincipal(PoolInfo poolInfo) throws NamingException {
        SimpleJndiName jndiNameForPool = ConnectorAdminServiceUtils.getReservePrefixedJNDINameForPool(poolInfo);
        Context ic = ConnectorRuntime.getRuntime().getNamingManager().getInitialContext();
        ConnectorConnectionPool connectorConnectionPool = (ConnectorConnectionPool)ic.lookup(jndiNameForPool.toString());
        ConnectorDescriptorInfo cdi = connectorConnectionPool.getConnectorDescriptorInfo();
        Set<ConnectorConfigProperty> mcfConfigProperties = cdi.getMCFConfigProperties();
        String userName = "";
        String password = "";
        for (ConnectorConfigProperty prop : mcfConfigProperties) {
            if (prop.getName().toUpperCase(Locale.getDefault()).equals("USERNAME") || prop.getName().toUpperCase(Locale.getDefault()).equals("USER")) {
                userName = prop.getValue();
                continue;
            }
            if (!prop.getName().toUpperCase(Locale.getDefault()).equals("PASSWORD")) continue;
            password = prop.getValue();
        }
        return new ResourcePrincipalDescriptor(userName, password);
    }

    public static SimpleJndiName getReservePrefixedJNDINameForPool(PoolInfo poolInfo) {
        SimpleJndiName name = new SimpleJndiName("__SYSTEM/pools/" + String.valueOf(poolInfo.getName()));
        return ConnectorAdminServiceUtils.getScopedName(poolInfo, name);
    }

    private static SimpleJndiName getScopedName(GenericResourceInfo resourceInfo, SimpleJndiName name) {
        if (resourceInfo.getName().isJavaApp()) {
            if (!name.isJavaApp()) {
                return new SimpleJndiName("java:app/" + String.valueOf(name));
            }
        } else if (resourceInfo.getName().isJavaModule() && !name.isJavaModule()) {
            return new SimpleJndiName("java:module/" + String.valueOf(name));
        }
        return name;
    }

    public static SimpleJndiName getReservePrefixedJNDINameForDescriptor(String moduleName) {
        return new SimpleJndiName("__SYSTEM/descriptors/" + moduleName);
    }

    public static SimpleJndiName getReservePrefixedJNDINameForResource(String moduleName) {
        return new SimpleJndiName("__SYSTEM/resource/" + moduleName);
    }

    public static boolean isEmbeddedConnectorModule(String moduleName) {
        return moduleName.indexOf("#") != -1;
    }

    public static String toApplicationName(String moduleName) {
        if (ConnectorAdminServiceUtils.isEmbeddedConnectorModule(moduleName)) {
            int idx = moduleName.indexOf("#");
            return moduleName.substring(0, idx);
        }
        return null;
    }

    public static String toRarFileName(String moduleName) {
        if (ConnectorAdminServiceUtils.isEmbeddedConnectorModule(moduleName)) {
            int idx = moduleName.indexOf("#");
            return moduleName.substring(idx + 1) + ".rar";
        }
        return moduleName + ".rar";
    }

    public static boolean isJMSRA(String moduleName) {
        return "jmsra".equalsIgnoreCase(moduleName);
    }
}

