/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans;

import com.sun.enterprise.config.serverbeans.AppTenants;
import com.sun.enterprise.config.serverbeans.ApplicationExtension;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.customvalidators.ContextRootCheck;
import jakarta.validation.constraints.NotNull;
import java.beans.PropertyVetoException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.RestRedirect;
import org.glassfish.api.admin.RestRedirects;
import org.glassfish.api.admin.config.ApplicationName;
import org.glassfish.api.admin.config.PropertiesDesc;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.quality.ToDo;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.types.Property;
import org.jvnet.hk2.config.types.PropertyBag;

@Configured
@RestRedirects(value={@RestRedirect(opType=RestRedirect.OpType.DELETE, commandName="undeploy"), @RestRedirect(opType=RestRedirect.OpType.POST, commandName="redeploy")})
@ContextRootCheck(message="{contextroot.duplicate}", payload={Application.class})
public interface Application
extends ApplicationName,
PropertyBag {
    public static final String APP_LOCATION_PROP_NAME = "appLocation";
    public static final String DEPLOYMENT_PLAN_LOCATION_PROP_NAME = "deploymentPlanLocation";
    public static final String ARCHIVE_TYPE_PROP_NAME = "archiveType";
    public static final String ALT_DD_LOCATION_PROP_NAME = "altDDLocation";
    public static final String RUNTIME_ALT_DD_LOCATION_PROP_NAME = "runtimeAltDDLocation";

    @Attribute
    public String getContextRoot();

    public void setContextRoot(String var1) throws PropertyVetoException;

    @Attribute
    public String getLocation();

    public void setLocation(String var1) throws PropertyVetoException;

    @Attribute(required=true)
    @NotNull
    public String getObjectType();

    public void setObjectType(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getEnabled();

    public void setEnabled(String var1) throws PropertyVetoException;

    @Attribute
    public String getLibraries();

    public void setLibraries(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getAvailabilityEnabled();

    public void setAvailabilityEnabled(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="true", dataType=Boolean.class)
    public String getAsyncReplication();

    public void setAsyncReplication(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="false", dataType=Boolean.class)
    public String getDirectoryDeployed();

    public void setDirectoryDeployed(String var1) throws PropertyVetoException;

    @Attribute
    public String getDescription();

    public void setDescription(String var1) throws PropertyVetoException;

    @Attribute(defaultValue="100", dataType=Integer.class)
    public String getDeploymentOrder();

    public void setDeploymentOrder(String var1) throws PropertyVetoException;

    @Element
    public List<Module> getModule();

    @Element
    public List<Engine> getEngine();

    @Element
    public Resources getResources();

    public void setResources(Resources var1) throws PropertyVetoException;

    @Element
    public AppTenants getAppTenants();

    public void setAppTenants(AppTenants var1);

    @Element(value="*")
    public List<ApplicationExtension> getExtensions();

    default public <T extends ApplicationExtension> T getExtensionByType(Class<T> type2) {
        for (ApplicationExtension extension : this.getExtensions()) {
            try {
                return (T)((ApplicationExtension)type2.cast(extension));
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    default public <T extends ApplicationExtension> List<T> getExtensionsByType(Class<T> type2) {
        ArrayList<ApplicationExtension> extensions = new ArrayList<ApplicationExtension>();
        for (ApplicationExtension extension : this.getExtensions()) {
            try {
                extensions.add((ApplicationExtension)type2.cast(extension));
            }
            catch (Exception exception) {}
        }
        return extensions;
    }

    default public Module getModule(String moduleName) {
        for (Module module : this.getModule()) {
            if (!module.getName().equals(moduleName)) continue;
            return module;
        }
        return null;
    }

    default public Properties getDeployProperties() {
        String directoryDeployed;
        String contextRoot;
        Properties deploymentProps = new Properties();
        for (Property property : this.getProperty()) {
            String propertyValue = property.getValue();
            if (propertyValue == null) continue;
            deploymentProps.put(property.getName(), propertyValue);
        }
        String objectType = this.getObjectType();
        if (objectType != null) {
            deploymentProps.setProperty("object-type", objectType);
        }
        if ((contextRoot = this.getContextRoot()) != null) {
            deploymentProps.setProperty("context-root", contextRoot);
        }
        if ((directoryDeployed = this.getDirectoryDeployed()) != null) {
            deploymentProps.setProperty("directory-deployed", directoryDeployed);
        }
        return deploymentProps;
    }

    default public DeployCommandParameters getDeployParameters(ApplicationRef appRef) {
        URI uri = null;
        try {
            uri = new URI(this.getLocation());
        }
        catch (URISyntaxException e) {
            Logger.getAnonymousLogger().log(Level.SEVERE, e.getMessage(), e);
        }
        if (uri == null) {
            return null;
        }
        DeployCommandParameters deploymentParams = new DeployCommandParameters(new File(uri));
        deploymentParams.name = this.getName();
        deploymentParams.description = this.getDescription();
        deploymentParams.enabled = Boolean.parseBoolean(this.getEnabled()) && appRef != null && Boolean.parseBoolean(appRef.getEnabled()) ? Boolean.TRUE : Boolean.FALSE;
        deploymentParams.contextroot = this.getContextRoot();
        deploymentParams.libraries = this.getLibraries();
        deploymentParams.availabilityenabled = Boolean.parseBoolean(this.getAvailabilityEnabled());
        deploymentParams.asyncreplication = Boolean.parseBoolean(this.getAsyncReplication());
        if (appRef != null) {
            deploymentParams.lbenabled = appRef.getLbEnabled();
            deploymentParams.virtualservers = appRef.getVirtualServers();
        }
        deploymentParams.deploymentorder = Integer.valueOf(this.getDeploymentOrder());
        for (Property property : this.getProperty()) {
            String propertyName;
            switch (propertyName = property.getName()) {
                case "archiveType": {
                    deploymentParams.type = property.getValue();
                    break;
                }
                case "altDDLocation": {
                    URI altDDUri = null;
                    try {
                        altDDUri = new URI(property.getValue());
                    }
                    catch (URISyntaxException e) {
                        Logger.getAnonymousLogger().log(Level.SEVERE, e.getMessage(), e);
                    }
                    if (altDDUri == null) break;
                    deploymentParams.altdd = new File(altDDUri);
                    break;
                }
                case "runtimeAltDDLocation": {
                    URI runtimeAltDDUri = null;
                    try {
                        runtimeAltDDUri = new URI(property.getValue());
                    }
                    catch (URISyntaxException e) {
                        Logger.getAnonymousLogger().log(Level.SEVERE, e.getMessage(), e);
                    }
                    if (runtimeAltDDUri == null) break;
                    deploymentParams.runtimealtdd = new File(runtimeAltDDUri);
                    break;
                }
            }
        }
        return deploymentParams;
    }

    default public Map<String, Properties> getModulePropertiesMap() {
        HashMap<String, Properties> modulePropertiesMap = new HashMap<String, Properties>();
        for (Module module : this.getModule()) {
            List<Property> properties = module.getProperty();
            if (properties == null) continue;
            Properties moduleProps = new Properties();
            for (Property property : properties) {
                String propertyValue = property.getValue();
                if (propertyValue == null) continue;
                moduleProps.put(property.getName(), propertyValue);
            }
            modulePropertiesMap.put(module.getName(), moduleProps);
        }
        return modulePropertiesMap;
    }

    default public boolean isStandaloneModule() {
        return !Boolean.parseBoolean(this.getDeployProperties().getProperty("isComposite"));
    }

    default public boolean containsSnifferType(String snifferType) {
        ArrayList<Engine> engines = new ArrayList<Engine>(this.getEngine());
        for (Module module : this.getModule()) {
            engines.addAll(module.getEngines());
        }
        for (Engine engine : engines) {
            if (!engine.getSniffer().equals(snifferType)) continue;
            return true;
        }
        return false;
    }

    default public boolean isLifecycleModule() {
        return Boolean.parseBoolean(this.getDeployProperties().getProperty("isLifecycle"));
    }

    default public File application() {
        return this.fileForProp(APP_LOCATION_PROP_NAME);
    }

    default public File deploymentPlan() {
        return this.fileForProp(DEPLOYMENT_PLAN_LOCATION_PROP_NAME);
    }

    default public String archiveType() {
        for (Property property : this.getProperty()) {
            if (!property.getName().equals(ARCHIVE_TYPE_PROP_NAME)) continue;
            return property.getValue();
        }
        return null;
    }

    private File fileForProp(String propName) {
        for (Property property : this.getProperty()) {
            if (!property.getName().equals(propName)) continue;
            return new File(URI.create(property.getValue()));
        }
        return null;
    }

    @Override
    @ToDo(priority=ToDo.Priority.IMPORTANT, details="Provide PropertyDesc for legal props")
    @PropertiesDesc(props={})
    @Element
    public List<Property> getProperty();
}

