/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.modularity;

import com.sun.enterprise.config.modularity.RankedConfigBeanProxy;
import com.sun.enterprise.config.modularity.annotation.CustomConfiguration;
import com.sun.enterprise.config.modularity.annotation.HasCustomizationTokens;
import com.sun.enterprise.config.modularity.customization.ConfigBeanDefaultValue;
import com.sun.enterprise.config.modularity.customization.ConfigCustomizationToken;
import com.sun.enterprise.config.modularity.parser.ConfigurationPopulator;
import com.sun.enterprise.config.modularity.parser.ModuleXMLConfigurationFileParser;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemProperty;
import com.sun.enterprise.config.serverbeans.SystemPropertyBag;
import com.sun.enterprise.config.util.ConfigApiLoggerInfo;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.config.Named;
import org.glassfish.api.logging.LogHelper;
import org.glassfish.config.support.GlassFishConfigBean;
import org.glassfish.config.support.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.utilities.BuilderHelper;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigInjector;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.ConfigView;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.DomDocument;
import org.jvnet.hk2.config.IndentingXMLStreamWriter;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service
@Singleton
public final class ConfigModularityUtils {
    private static final Logger LOG = ConfigApiLoggerInfo.getLogger();
    @Inject
    private ServiceLocator serviceLocator;
    private boolean ignorePersisting;
    private boolean isCommandInvocation;

    public <U extends ConfigBeanProxy> URL getConfigurationFileUrl(Class<U> configBeanClass, String baseFileName, String runtimeType) {
        String fileName = runtimeType + "-" + baseFileName;
        URL fileUrl = configBeanClass.getClassLoader().getResource("META-INF/configuration/" + fileName);
        if (fileUrl == null) {
            fileUrl = configBeanClass.getClassLoader().getResource("META-INF/configuration/" + baseFileName);
        }
        return fileUrl;
    }

    public List<ConfigBeanDefaultValue> getDefaultConfigurations(Class configBeanClass, String runtimeType) {
        CustomConfiguration c = configBeanClass.getAnnotation(CustomConfiguration.class);
        List<ConfigBeanDefaultValue> defaults = Collections.emptyList();
        if (c.usesOnTheFlyConfigGeneration()) {
            Method m = this.getGetDefaultValuesMethod(configBeanClass);
            if (m != null) {
                try {
                    defaults = (List<ConfigBeanDefaultValue>)m.invoke(null, runtimeType);
                }
                catch (Exception e) {
                    LogHelper.log(LOG, Level.INFO, "NCLS-CFGAPI-00103", e, configBeanClass.getName());
                }
            }
        } else {
            LocalStringManagerImpl localStrings = new LocalStringManagerImpl(configBeanClass);
            ModuleXMLConfigurationFileParser parser = new ModuleXMLConfigurationFileParser(localStrings);
            try {
                defaults = parser.parseServiceConfiguration(this.getConfigurationFileUrl(configBeanClass, c.baseConfigurationFileName(), runtimeType).openStream());
            }
            catch (XMLStreamException e) {
                LOG.log(Level.SEVERE, "NCLS-CFGAPI-00104", e);
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, "NCLS-CFGAPI-00104", e);
            }
        }
        return defaults;
    }

    public boolean hasCustomConfig(Class configBeanClass) {
        return configBeanClass.getAnnotation(CustomConfiguration.class) != null;
    }

    public Method findSuitableCollectionGetter(Class owner, Class typeToSet) {
        Method[] methods = owner.getMethods();
        Method tm = this.returnException(owner, typeToSet);
        if (tm != null) {
            return tm;
        }
        for (Method m : methods) {
            Type t;
            if (!m.getName().startsWith("get") || !((t = m.getGenericReturnType()) instanceof ParameterizedType)) continue;
            ParameterizedType pt = (ParameterizedType)t;
            Type actualGenericParameter = pt.getActualTypeArguments()[0];
            if (pt.getActualTypeArguments().length != 1 || !Collection.class.isAssignableFrom(m.getReturnType()) || !(actualGenericParameter instanceof Class) || !typeToSet.isAssignableFrom((Class)actualGenericParameter)) continue;
            if (m.isDefault()) {
                return m;
            }
            Method deepM = this.findDeeperSuitableCollectionGetter(owner, typeToSet);
            return deepM != null ? deepM : m;
        }
        return this.findDeeperSuitableCollectionGetter(owner, typeToSet);
    }

    private Method returnException(Class owner, Class typeToSet) {
        if (owner.isAssignableFrom(Applications.class) && typeToSet.isAssignableFrom(Application.class) || typeToSet.isAssignableFrom(Module.class)) {
            try {
                Method m = owner.getMethod("getModules", new Class[0]);
                return m;
            }
            catch (NoSuchMethodException e) {
                LogHelper.log(LOG, Level.INFO, "NCLS-CFGAPI-00105", e, owner.getName(), typeToSet.getName());
            }
        }
        return null;
    }

    public Method findDeeperSuitableCollectionGetter(Class owner, Class typeToSet) {
        Method[] methods;
        Class[] ifs = typeToSet.getInterfaces();
        for (Method m : methods = owner.getMethods()) {
            Type t;
            if (!m.getName().startsWith("get") || !((t = m.getGenericReturnType()) instanceof ParameterizedType)) continue;
            ParameterizedType pt = (ParameterizedType)t;
            Type actualGenericParameter = pt.getActualTypeArguments()[0];
            if (pt.getActualTypeArguments().length != 1 || !Collection.class.isAssignableFrom(m.getReturnType()) || !(actualGenericParameter instanceof Class) || !this.checkInterfaces(ifs, actualGenericParameter)) continue;
            return m;
        }
        return null;
    }

    public boolean checkInterfaces(Class[] ifs, Type actualGenericParameter) {
        for (Class clz : ifs) {
            if (clz.getSimpleName().equals("ConfigBeanProxy") || clz.getSimpleName().equals("Injectable") || clz.getSimpleName().equals("PropertyBag") || !(actualGenericParameter instanceof Class) || !clz.isAssignableFrom((Class)actualGenericParameter)) continue;
            return true;
        }
        return false;
    }

    public Class getOwningClassForLocation(String location) {
        StringTokenizer tokenizer = new StringTokenizer(location, "/", false);
        if (!tokenizer.hasMoreElements()) {
            return null;
        }
        if (!tokenizer.nextToken().equalsIgnoreCase("domain")) {
            return null;
        }
        String level = "domain";
        if (location.equalsIgnoreCase("domain/configs")) {
            return this.getClassFor("domain");
        }
        if (tokenizer.countTokens() == 2 && location.startsWith("domain/configs")) {
            return Config.class;
        }
        while (tokenizer.hasMoreElements()) {
            level = tokenizer.nextToken();
        }
        return this.getClassFor(level);
    }

    public ConfigBeanProxy getOwningObject(String location) {
        if (!location.startsWith("domain/configs")) {
            if (!location.startsWith("domain")) {
                return null;
            }
            StringTokenizer tokenizer = new StringTokenizer(location, "/", false);
            if (tokenizer.countTokens() == 1) {
                return this.serviceLocator.getService(Domain.class, new Annotation[0]);
            }
            location = location.substring(location.indexOf("/", "domain".length()) + 1);
            tokenizer = new StringTokenizer(location, "/", false);
            ConfigBeanProxy parent = this.serviceLocator.getService(Domain.class, new Annotation[0]);
            String parentElement = "domain";
            String childElement = null;
            while (tokenizer.hasMoreTokens()) {
                try {
                    childElement = tokenizer.nextToken();
                    parent = this.getOwner(parent, parentElement, childElement);
                    parentElement = childElement;
                }
                catch (Exception e) {
                    LogHelper.log(LOG, Level.INFO, "NCLS-CFGAPI-00106", e, childElement);
                }
            }
            return parent;
        }
        Class typeToFindGetter = this.getOwningClassForLocation(location);
        if (typeToFindGetter == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(location, "/", false);
        if (tokenizer.countTokens() == 3) {
            String expression = location.substring(location.lastIndexOf("[") + 1, location.length() - 1);
            String configName = this.resolveExpression(expression);
            return this.serviceLocator.getService(Domain.class, new Annotation[0]).getConfigNamed(configName);
        }
        tokenizer = new StringTokenizer(location = location.substring(location.indexOf("/", "domain/configs".length()) + 1), "/", false);
        String curLevel = tokenizer.nextToken();
        String expression = curLevel.contains("[") ? curLevel.substring(curLevel.lastIndexOf("[") + 1, curLevel.length() - 1) : curLevel;
        String configName = this.resolveExpression(expression);
        ConfigBeanProxy parent = this.serviceLocator.getService(Domain.class, new Annotation[0]).getConfigNamed(configName);
        String parentElement = "Config";
        while (tokenizer.hasMoreTokens()) {
            try {
                String childElement = tokenizer.nextToken();
                parent = this.getOwner(parent, parentElement, childElement);
                parentElement = childElement;
            }
            catch (Exception e) {
                LogHelper.log(LOG, Level.INFO, "NCLS-CFGAPI-00106", e, configName);
            }
        }
        return parent;
    }

    public ConfigBeanProxy getOwner(ConfigBeanProxy parent, String parentElement, String childElement) throws InvocationTargetException, IllegalAccessException {
        Method m;
        Class clz;
        block11: {
            if (childElement.contains("CURRENT_INSTANCE_CONFIG_NAME")) {
                return this.serviceLocator.getService(Config.class, "default-instance-name", new Annotation[0]);
            }
            if (childElement.contains("CURRENT_INSTANCE_SERVER_NAME")) {
                return this.serviceLocator.getService(Server.class, "default-instance-name", new Annotation[0]);
            }
            if (childElement.endsWith("]")) {
                String elementName = childElement.substring(childElement.lastIndexOf("/") + 1, childElement.indexOf("["));
                String componentName = childElement.substring(childElement.lastIndexOf("[") + 1, childElement.indexOf("]"));
                Class childClass = this.getClassFor(elementName);
                Class parentClass = this.getClassFor(parentElement);
                Method m2 = this.findSuitableCollectionGetter(parentClass, childClass);
                if (m2 != null) {
                    try {
                        Collection col = (Collection)m2.invoke((Object)parent, new Object[0]);
                        componentName = this.resolveExpression(componentName);
                        return this.getNamedConfigBeanFromCollection(col, componentName, childClass);
                    }
                    catch (Exception e) {
                        LogHelper.log(LOG, Level.INFO, "NCLS-CFGAPI-00107", e, childElement, componentName);
                    }
                }
                return null;
            }
            clz = this.getClassFor(childElement);
            if (parent == null) {
                return null;
            }
            m = this.getMatchingGetterMethod(parent.getClass(), clz);
            if (m != null) {
                return (ConfigBeanProxy)m.invoke((Object)parent, new Object[0]);
            }
            try {
                m = parent.getClass().getMethod("getExtensionByType", Class.class);
            }
            catch (NoSuchMethodException e) {
                if (!LOG.isLoggable(Level.FINE)) break block11;
                LOG.log(Level.FINE, "Cannot find getExtensionByType", e);
            }
        }
        if (m != null) {
            return (ConfigBeanProxy)m.invoke((Object)parent, clz);
        }
        return null;
    }

    public <U extends ConfigBeanProxy> List<U> getExtensions(ConfigBeanProxy parent) {
        Method m = null;
        try {
            if (parent != null) {
                m = parent.getClass().getMethod("getExtensions", new Class[0]);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (m != null) {
            try {
                return (List)m.invoke((Object)parent, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    public <T extends ConfigBeanProxy> T setConfigBean(T finalConfigBean, ConfigBeanDefaultValue configBeanDefaultValue, ConfigBeanProxy parent) {
        Class owningClassForLocation = this.getOwningClassForLocation(configBeanDefaultValue.getLocation());
        Class configBeanClass = this.getClassForFullName(configBeanDefaultValue.getConfigBeanClassName());
        try {
            ConfigBeanProxy configBeanInstance = null;
            if (this.getNameForConfigBean(finalConfigBean, configBeanClass) == null) {
                List extensions = this.getExtensions(parent);
                for (ConfigBeanProxy extension : extensions) {
                    try {
                        configBeanInstance = (ConfigBeanProxy)configBeanClass.cast(extension);
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
                if (!(configBeanDefaultValue.replaceCurrentIfExists() && this.stackPositionHigher(finalConfigBean, configBeanInstance) || configBeanInstance == null)) {
                    return (T)configBeanInstance;
                }
                if (configBeanInstance != null) {
                    extensions.remove(configBeanInstance);
                }
            }
        }
        catch (InvocationTargetException e) {
            LOG.log(Level.INFO, "NCLS-CFGAPI-00108", e);
        }
        catch (IllegalAccessException e) {
            LOG.log(Level.INFO, "NCLS-CFGAPI-00108", e);
        }
        Method m = this.getMatchingSetterMethod(owningClassForLocation, configBeanClass);
        if (m != null) {
            try {
                if (configBeanClass.getAnnotation(HasCustomizationTokens.class) != null) {
                    this.applyCustomTokens(configBeanDefaultValue, finalConfigBean, parent);
                }
                m.invoke((Object)parent, finalConfigBean);
            }
            catch (Exception e) {
                LogHelper.log(LOG, Level.INFO, "NCLS-CFGAPI-00109", e, finalConfigBean.getClass().getName());
            }
            return finalConfigBean;
        }
        m = this.findSuitableCollectionGetter(owningClassForLocation, configBeanClass);
        if (m != null) {
            try {
                Collection col = (Collection)m.invoke((Object)parent, new Object[0]);
                String name = this.getNameForConfigBean(finalConfigBean, configBeanClass);
                T itemToRemove = this.getNamedConfigBeanFromCollection(col, name, configBeanClass);
                if (configBeanDefaultValue.replaceCurrentIfExists()) {
                    try {
                        if (itemToRemove != null && this.stackPositionHigher(finalConfigBean, (ConfigBeanProxy)itemToRemove)) {
                            col.remove(itemToRemove);
                        }
                    }
                    catch (Exception ex) {
                        LogHelper.log(LOG, Level.INFO, "NCLS-CFGAPI-00110", ex, finalConfigBean.getClass().getName());
                    }
                }
                if (configBeanClass.getAnnotation(HasCustomizationTokens.class) != null) {
                    this.applyCustomTokens(configBeanDefaultValue, finalConfigBean, parent);
                }
                if (itemToRemove != null && !configBeanDefaultValue.replaceCurrentIfExists() && ((ConfigView)Proxy.getInvocationHandler(itemToRemove)).getProxyType().isAssignableFrom(configBeanClass)) {
                    return finalConfigBean;
                }
                col.add(finalConfigBean);
                return finalConfigBean;
            }
            catch (Exception e) {
                LogHelper.log(LOG, Level.INFO, "NCLS-CFGAPI-00109", e, finalConfigBean.getClass().getName());
            }
        }
        return null;
    }

    public <T extends ConfigBeanProxy> boolean stackPositionHigher(T finalConfigBean, ConfigBeanProxy itemToRemove) {
        if (itemToRemove == null || finalConfigBean == null) {
            return true;
        }
        if (RankedConfigBeanProxy.class.isAssignableFrom(finalConfigBean.getClass()) && RankedConfigBeanProxy.class.isAssignableFrom(itemToRemove.getClass())) {
            int itemToRemoveRank = Integer.parseInt(((RankedConfigBeanProxy)itemToRemove).getRank());
            int finalConfigBeanRank = Integer.parseInt(((RankedConfigBeanProxy)finalConfigBean).getRank());
            return finalConfigBeanRank > itemToRemoveRank;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized <T extends ConfigBeanProxy> void applyCustomTokens(ConfigBeanDefaultValue configBeanDefaultValue, T finalConfigBean, ConfigBeanProxy parent) throws TransactionFailure, PropertyVetoException {
        if (parent instanceof SystemPropertyBag) {
            this.addSystemPropertyForToken(configBeanDefaultValue.getCustomizationTokens(), (SystemPropertyBag)parent);
        } else {
            Object curParent = finalConfigBean;
            while (!(curParent instanceof SystemPropertyBag)) {
                curParent = curParent.getParent();
            }
            if (configBeanDefaultValue.getCustomizationTokens().size() != 0) {
                boolean oldIP = this.isIgnorePersisting();
                try {
                    this.setIgnorePersisting(true);
                    final SystemPropertyBag bag = (SystemPropertyBag)curParent;
                    final List<ConfigCustomizationToken> tokens = configBeanDefaultValue.getCustomizationTokens();
                    ConfigSupport.apply(new SingleConfigCode<SystemPropertyBag>(){

                        @Override
                        public Object run(SystemPropertyBag param) throws PropertyVetoException, TransactionFailure {
                            ConfigModularityUtils.this.addSystemPropertyForToken(tokens, bag);
                            return param;
                        }
                    }, bag);
                }
                finally {
                    this.setIgnorePersisting(oldIP);
                }
            }
        }
    }

    public void addSystemPropertyForToken(List<ConfigCustomizationToken> tokens, SystemPropertyBag bag) throws TransactionFailure, PropertyVetoException {
        for (ConfigCustomizationToken token : tokens) {
            if (bag.containsProperty(token.getName())) continue;
            SystemProperty prop = bag.createChild(SystemProperty.class);
            prop.setName(token.getName());
            prop.setDescription(token.getDescription());
            prop.setValue(token.getValue());
            bag.getSystemProperty().add(prop);
        }
    }

    public <T extends ConfigBeanProxy> T getCurrentConfigBeanForDefaultValue(ConfigBeanDefaultValue defaultValue) throws InvocationTargetException, IllegalAccessException {
        Class configBeanClass;
        Class parentClass = this.getOwningClassForLocation(defaultValue.getLocation());
        Method m = this.findSuitableCollectionGetter(parentClass, configBeanClass = this.getClassForFullName(defaultValue.getConfigBeanClassName()));
        if (m != null) {
            ConfigParser configParser = new ConfigParser(this.serviceLocator);
            DomDocument<GlassFishConfigBean> doc = new DomDocument<GlassFishConfigBean>(this, this.serviceLocator){

                @Override
                public Dom make(ServiceLocator serviceLocator, XMLStreamReader xmlStreamReader, GlassFishConfigBean dom, ConfigModel configModel) {
                    return new GlassFishConfigBean(serviceLocator, (DomDocument)this, dom, configModel, xmlStreamReader);
                }
            };
            ConfigBeanProxy parent = this.getOwningObject(defaultValue.getLocation());
            ConfigurationPopulator populator = new ConfigurationPopulator(defaultValue.getXmlConfiguration(), doc, parent);
            populator.run(configParser);
            Object configBean = doc.getRoot().createProxy(configBeanClass);
            Collection col = (Collection)m.invoke((Object)parent, new Object[0]);
            return this.getConfigBeanFromCollection(col, configBean, configBeanClass);
        }
        return null;
    }

    public <T extends ConfigBeanProxy> T getConfigBeanFromCollection(Collection<T> col, T configBeanObject, Class typeOfObjects) throws InvocationTargetException, IllegalAccessException {
        String nameToLookFor = this.getNameForConfigBean(configBeanObject, typeOfObjects);
        if (nameToLookFor != null) {
            T returnee = this.getNamedConfigBeanFromCollection(col, nameToLookFor, typeOfObjects);
            if (returnee != null) {
                return returnee;
            }
        } else {
            for (ConfigBeanProxy configBean : col) {
                try {
                    typeOfObjects.cast(configBean);
                    return (T)configBean;
                }
                catch (Exception exception) {
                }
            }
        }
        return null;
    }

    public <T extends ConfigBeanProxy> T getNamedConfigBeanFromCollection(Collection<T> col, String nameToLookFor, Class typeOfObjects) throws InvocationTargetException, IllegalAccessException {
        if (nameToLookFor == null) {
            return null;
        }
        for (T item : col) {
            String name;
            if (!((ConfigView)Proxy.getInvocationHandler(item)).getProxyType().isAssignableFrom(typeOfObjects) || !nameToLookFor.equalsIgnoreCase(name = this.getNameForConfigBean(item, typeOfObjects))) continue;
            return (T)((ConfigBeanProxy)item);
        }
        return null;
    }

    public String getNameForConfigBean(Object configBean, Class configBeanType) throws InvocationTargetException, IllegalAccessException {
        Method[] methods;
        if (configBean instanceof Named) {
            Named nme = (Named)configBean;
            return nme.getName();
        }
        if (configBean instanceof Resource) {
            Resource res = (Resource)configBean;
            return res.getIdentity();
        }
        for (Method method : methods = configBeanType.getMethods()) {
            Attribute attributeAnnotation = method.getAnnotation(Attribute.class);
            if (attributeAnnotation == null || !attributeAnnotation.key()) continue;
            return (String)method.invoke(configBean, new Object[0]);
        }
        return null;
    }

    public String convertConfigElementNameToClassName(String name) {
        StringTokenizer tokenizer = new StringTokenizer(name, "-", false);
        StringBuilder className = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            String part = tokenizer.nextToken();
            Locale loc = Locale.getDefault();
            part = part.replaceFirst(part.substring(0, 1), part.substring(0, 1).toUpperCase(loc));
            className.append(part);
        }
        return className.toString();
    }

    public Class getClassFor(String serviceName) {
        serviceName = this.getServiceTypeNameIfNamedComponent(serviceName);
        ConfigInjector injector = this.serviceLocator.getService(ConfigInjector.class, serviceName.toLowerCase(Locale.getDefault()), new Annotation[0]);
        return this.getClassFromInjector(injector);
    }

    public Class getClassFromInjector(ConfigInjector injector) {
        if (injector != null) {
            String clzName = injector.getClass().getName().substring(0, injector.getClass().getName().length() - 8);
            try {
                return injector.getClass().getClassLoader().loadClass(clzName);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    public String getServiceTypeNameIfNamedComponent(String serviceName) {
        if (serviceName.endsWith("]")) {
            serviceName = serviceName.substring(0, serviceName.indexOf("["));
        }
        return serviceName;
    }

    public String resolveExpression(String expression) {
        if (expression.startsWith("$")) {
            String name = expression.substring(1, expression.length());
            if (name.equalsIgnoreCase("CURRENT_INSTANCE_CONFIG_NAME")) {
                expression = this.serviceLocator.getService(Config.class, "default-instance-name", new Annotation[0]).getName();
            }
            if (name.equalsIgnoreCase("CURRENT_INSTANCE_SERVER_NAME")) {
                expression = this.serviceLocator.getService(Server.class, "default-instance-name", new Annotation[0]).getName();
            }
        }
        return expression;
    }

    public String serializeConfigBeanByType(Class configBeanType) {
        ConfigBeanProxy configBeanProxy = this.getConfigBeanInstanceFor(configBeanType);
        return this.serializeConfigBean(configBeanProxy);
    }

    public ConfigBeanProxy getConfigBeanInstanceFor(Class configBeanType) {
        return (ConfigBeanProxy)this.serviceLocator.getService(configBeanType, new Annotation[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serializeConfigBean(ConfigBeanProxy configBean) {
        if (configBean == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLOutputFactory xmlFactory = XMLOutputFactory.newInstance();
        XMLStreamWriter writer = null;
        IndentingXMLStreamWriter indentingXMLStreamWriter = null;
        String s = null;
        try {
            writer = xmlFactory.createXMLStreamWriter(new BufferedOutputStream(bos), StandardCharsets.UTF_8.name());
            indentingXMLStreamWriter = new IndentingXMLStreamWriter(writer);
            Dom configBeanDom = Dom.unwrap(configBean);
            configBeanDom.writeTo(configBeanDom.model.getTagName(), indentingXMLStreamWriter);
            indentingXMLStreamWriter.flush();
            s = bos.toString(StandardCharsets.UTF_8);
        }
        catch (XMLStreamException e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Cannot serialize the configbean: " + configBean.toString(), e);
            }
            String string = null;
            return string;
        }
        finally {
            block20: {
                try {
                    bos.close();
                    if (writer != null) {
                        writer.close();
                    }
                    if (indentingXMLStreamWriter != null) {
                        indentingXMLStreamWriter.close();
                    }
                }
                catch (IOException e) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Cannot serialize the configbean: " + configBean.toString(), e);
                    }
                }
                catch (XMLStreamException e) {
                    if (!LOG.isLoggable(Level.FINE)) break block20;
                    LOG.log(Level.FINE, "Cannot serialize the configbean: " + configBean.toString(), e);
                }
            }
        }
        return s;
    }

    public Method getMatchingGetterMethod(Class classToQuery, Class methodReturnType) {
        Method[] methods;
        for (Method method : methods = classToQuery.getMethods()) {
            Class<?> rt = method.getReturnType();
            if (rt == null || methodReturnType == null || !rt.getSimpleName().equals(methodReturnType.getSimpleName())) continue;
            return method;
        }
        return null;
    }

    public Method getMatchingSetterMethod(Class classToQuery, Class typeToSet) {
        Method[] methods;
        String className = typeToSet.getName().substring(typeToSet.getName().lastIndexOf(".") + 1, typeToSet.getName().length());
        String setterName = "set" + className;
        for (Method method : methods = classToQuery.getClass().getMethods()) {
            if (!method.getName().equalsIgnoreCase(setterName)) continue;
            return method;
        }
        return null;
    }

    public Method getGetDefaultValuesMethod(Class<?> configBeanType) {
        try {
            return configBeanType.getMethod("getDefaultValues", String.class);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public boolean deleteConfigurationForConfigBean(ConfigBeanProxy configBean, Collection col, ConfigBeanDefaultValue defaultValue) {
        try {
            Class configBeanClass = this.getClassForFullName(defaultValue.getConfigBeanClassName());
            String name = this.getNameForConfigBean(configBean, configBeanClass);
            Object itemToRemove = this.getNamedConfigBeanFromCollection(col, name, configBeanClass);
            if (itemToRemove != null) {
                col.remove(itemToRemove);
                return true;
            }
            if (name == null) {
                col.remove(configBean);
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    public Class getClassForFullName(String configBeanClassName) {
        ActiveDescriptor<?> descriptor = this.serviceLocator.getBestDescriptor(BuilderHelper.createContractFilter(configBeanClassName));
        if (descriptor != null) {
            if (!descriptor.isReified()) {
                descriptor = this.serviceLocator.reifyDescriptor(descriptor);
            }
            return this.getClassFromDescriptor(descriptor);
        }
        descriptor = this.serviceLocator.getBestDescriptor(BuilderHelper.createContractFilter(configBeanClassName + "Injector"));
        if (!descriptor.isReified()) {
            descriptor = this.serviceLocator.reifyDescriptor(descriptor);
        }
        ConfigInjector injector = (ConfigInjector)this.serviceLocator.getServiceHandle(descriptor).getService();
        return this.getClassFromInjector(injector);
    }

    public Class getClassFromDescriptor(ActiveDescriptor<?> descriptor) {
        Class<?> defaultReturnValue = descriptor.getImplementationClass();
        String name = descriptor.getName();
        if (name == null) {
            return defaultReturnValue;
        }
        Class foundContract = null;
        for (Type contract : descriptor.getContractTypes()) {
            Class cc;
            if (!(contract instanceof Class) || !(cc = (Class)contract).getName().equals(name)) continue;
            foundContract = cc;
            break;
        }
        if (foundContract == null) {
            return defaultReturnValue;
        }
        return foundContract;
    }

    public String replacePropertiesWithCurrentValue(String xmlConfiguration, ConfigBeanDefaultValue value) throws InvocationTargetException, IllegalAccessException {
        for (ConfigCustomizationToken token : value.getCustomizationTokens()) {
            String toReplace = "${" + token.getName() + "}";
            Object current = this.getCurrentConfigBeanForDefaultValue(value);
            String propertyValue = this.getPropertyValue(token, (ConfigBeanProxy)current);
            if (propertyValue == null) continue;
            xmlConfiguration = xmlConfiguration.replace(toReplace, propertyValue);
        }
        return xmlConfiguration;
    }

    public String getPropertyValue(ConfigCustomizationToken token, ConfigBeanProxy finalConfigBean) {
        if (finalConfigBean != null) {
            ConfigBeanProxy parent = finalConfigBean.getParent();
            while (!(parent instanceof SystemPropertyBag)) {
                if ((parent = parent.getParent()) != null) continue;
                return null;
            }
            if (((SystemPropertyBag)parent).getSystemProperty(token.getName()) != null) {
                return ((SystemPropertyBag)parent).getSystemProperty(token.getName()).getValue();
            }
            return null;
        }
        return token.getValue();
    }

    public String getRuntimeTypePrefix(StartupContext startupContext) {
        Properties args = startupContext.getArguments();
        RuntimeType serverType = RuntimeType.getDefault();
        String typeString = args.getProperty("-type");
        if (typeString != null) {
            serverType = RuntimeType.valueOf(typeString);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("server type is: " + serverType.name());
        }
        if (serverType.isEmbedded()) {
            return "embedded";
        }
        if (serverType.isSingleInstance() || serverType.isDas()) {
            return "admin";
        }
        if (serverType.isInstance()) {
            return "instance";
        }
        return "";
    }

    public List<Class> getAnnotatedConfigBeans(Class annotationType) {
        ArrayList<Class> prox = new ArrayList<Class>();
        List<ActiveDescriptor<?>> descriptor = this.serviceLocator.getDescriptors(BuilderHelper.createContractFilter(ConfigInjector.class.getName()));
        Class<?> clz = null;
        for (ActiveDescriptor<?> desc : descriptor) {
            block5: {
                if (desc.getName() == null) continue;
                ConfigInjector injector = this.serviceLocator.getService(ConfigInjector.class, desc.getName(), new Annotation[0]);
                if (injector != null) {
                    String clzName = injector.getClass().getName().substring(0, injector.getClass().getName().length() - 8);
                    try {
                        clz = injector.getClass().getClassLoader().loadClass(clzName);
                        if (clz == null) {
                            if (!LOG.isLoggable(Level.FINE)) continue;
                            LOG.log(Level.FINE, "Cannot find the class mapping to:  " + clzName);
                        }
                        break block5;
                    }
                    catch (Throwable e) {
                        if (!LOG.isLoggable(Level.FINE)) continue;
                        LOG.log(Level.FINE, "Cannot load the class", e);
                    }
                    continue;
                }
            }
            if (clz == null || !clz.isAnnotationPresent(annotationType)) continue;
            prox.add(clz);
        }
        return prox;
    }

    public boolean isIgnorePersisting() {
        return this.ignorePersisting;
    }

    public void setIgnorePersisting(boolean ignorePersisting) {
        this.ignorePersisting = ignorePersisting;
    }

    public boolean isCommandInvocation() {
        return this.isCommandInvocation;
    }

    public void setCommandInvocation(boolean commandInvocation) {
        this.isCommandInvocation = commandInvocation;
    }

    public List<Class> getInstalledExtensions(Class extensionType) {
        ArrayList<Class> extensions = new ArrayList<Class>();
        List<Class> cbeans = this.getAnnotatedConfigBeans(Configured.class);
        for (Class c : cbeans) {
            try {
                if (c == extensionType) continue;
                extensions.add(c);
            }
            catch (ClassCastException e) {}
        }
        return extensions;
    }
}

