/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.DomainDirs;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.internal.api.RelativePathResolver;

abstract class NativeRemoteCommandsBase
extends CLICommand {
    @Param(optional=false, primary=true, multiple=true)
    String[] hosts;
    String sshpassword;
    String sshkeypassphrase = null;
    boolean promptPass = false;
    TokenResolver resolver = new TokenResolver();
    private String remoteUser;
    private int remotePort;

    NativeRemoteCommandsBase() {
    }

    abstract String getRawRemoteUser();

    abstract int getRawRemotePort();

    abstract String getSshKeyFile();

    @Override
    protected void validate() throws CommandException {
        this.remoteUser = this.resolver.resolve(this.getRawRemoteUser());
    }

    final String getRemoteUser() {
        return this.remoteUser;
    }

    final int getRemotePort() {
        return this.remotePort;
    }

    final void setRemotePort(int newPort) {
        this.remotePort = newPort;
    }

    String getSSHPassword(String node) throws CommandException {
        return this.getRemotePassword(node, "AS_ADMIN_SSHPASSWORD");
    }

    private String getRemotePassword(String node, String key) throws CommandException {
        String alias;
        String password = this.getFromPasswordFile(key);
        if (password != null && (alias = RelativePathResolver.getAlias(password)) != null) {
            password = this.expandPasswordAlias(node, alias, true);
        }
        if (password == null) {
            if (this.programOpts.isInteractive()) {
                char[] pArr = this.readPassword(Strings.get("SSHPasswordPrompt", this.getRemoteUser(), node));
                password = pArr != null ? new String(pArr) : null;
            } else {
                throw new CommandException(Strings.get("SSHPasswordNotFound"));
            }
        }
        return password;
    }

    String getSSHPassphrase(boolean verifyConn) {
        String alias;
        String passphrase = this.getFromPasswordFile("AS_ADMIN_SSHKEYPASSPHRASE");
        if (passphrase != null && (alias = RelativePathResolver.getAlias(passphrase)) != null) {
            passphrase = this.expandPasswordAlias(null, alias, verifyConn);
        }
        if (passphrase == null) {
            char[] pArr;
            passphrase = this.programOpts.isInteractive() ? ((pArr = this.readPassword(Strings.get("SSHPassphrasePrompt", this.getSshKeyFile()))) != null ? new String(pArr) : null) : "";
        }
        return passphrase;
    }

    String getMasterPassword(String domain) {
        String masterPass = this.getFromPasswordFile("AS_ADMIN_MASTERPASSWORD");
        if (masterPass == null) {
            char[] mpArr;
            masterPass = this.programOpts.isInteractive() ? ((mpArr = this.readPassword(Strings.get("DomainMasterPasswordPrompt", domain))) != null ? new String(mpArr) : null) : "changeit";
        }
        return masterPass;
    }

    private String getFromPasswordFile(String name) {
        return (String)this.passwords.get(name);
    }

    boolean isValidAnswer(String val) {
        return val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("no") || val.equalsIgnoreCase("y") || val.equalsIgnoreCase("n");
    }

    String expandPasswordAlias(String host, String alias, boolean verifyConn) {
        String expandedPassword;
        block13: {
            expandedPassword = null;
            boolean connStatus = false;
            try {
                File[] files;
                File domainsDirFile = DomainDirs.getDefaultDomainsDir();
                for (File f : files = domainsDirFile.listFiles(File::isDirectory)) {
                    block12: {
                        System.setProperty("com.sun.aas.instanceRoot", f.getAbsolutePath());
                        try {
                            PasswordAdapter pa = new PasswordAdapter(null);
                            boolean exists = pa.aliasExists(alias);
                            if (!exists) break block12;
                            String mPass = this.getMasterPassword(f.getName());
                            expandedPassword = new PasswordAdapter(mPass.toCharArray()).getPasswordForAlias(alias);
                        }
                        catch (Exception e) {
                            if (logger.isLoggable(Level.FINER)) {
                                logger.finer(StringUtils.cat(": ", alias, e.getMessage()));
                            }
                            logger.warning(Strings.get("GetPasswordFailure", f.getName()));
                            continue;
                        }
                    }
                    if (expandedPassword == null) continue;
                    if (host != null) {
                        this.sshpassword = expandedPassword;
                        sshL = new SSHLauncher(this.getRemoteUser(), host, this.getRemotePort(), this.sshpassword, null, null);
                        connStatus = sshL.checkPasswordAuth();
                        if (!connStatus) {
                            logger.warning(Strings.get("PasswordAuthFailure", f.getName()));
                        }
                    } else {
                        this.sshkeypassphrase = expandedPassword;
                        if (verifyConn) {
                            File keyFile = this.getSshKeyFile() == null ? null : new File(this.getSshKeyFile());
                            sshL = new SSHLauncher(this.getRemoteUser(), this.hosts[0], this.getRemotePort(), this.sshpassword, keyFile, this.sshkeypassphrase);
                            connStatus = sshL.checkConnection();
                            if (!connStatus) {
                                logger.warning(Strings.get("PasswordAuthFailure", f.getName()));
                            }
                        }
                    }
                    if (!connStatus) {
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                if (!logger.isLoggable(Level.FINER)) break block13;
                logger.log(Level.FINER, e.getMessage(), e);
            }
        }
        return expandedPassword;
    }

    List<Path> getListOfInstallFiles(Path installDir) throws IOException {
        String ins = this.resolver.resolve("${com.sun.aas.productRoot}");
        Set<File> files = FileUtils.getAllFilesAndDirectoriesUnder(new File(ins));
        logger.finer(() -> "Total number of files under " + ins + " = " + files.size());
        ArrayList<Path> modList = new ArrayList<Path>();
        for (File f : files) {
            modList.add(installDir.resolve(f.toPath()));
        }
        return modList;
    }

    void validateKey(String file) throws CommandException {
        File f = new File(file);
        if (!f.exists()) {
            throw new CommandException(Strings.get("KeyDoesNotExist", file));
        }
    }
}

