/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev.gen;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.AttributedString;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class JavaUtil {
    private static Map toObjectType = new HashMap();
    private static Map fromObjectType;
    private static Map immutableTable;
    private static final Class charArrayClass;
    public static final int BUFFER_SIZE = 4096;
    private static Map reservedWords;

    private JavaUtil() {
    }

    private static String toObject(String expr, String classType, boolean java5) {
        if ("boolean" == (classType = classType.intern())) {
            return "(" + expr + " ? java.lang.Boolean.TRUE : java.lang.Boolean.FALSE)";
        }
        String objClass = (String)toObjectType.get(classType);
        if (objClass == null) {
            return expr;
        }
        if (java5) {
            return objClass + ".valueOf(" + expr + ")";
        }
        return "new " + objClass + "(" + expr + ")";
    }

    public static String toObject(String expr, String classType, boolean j2me, boolean java5) {
        if (j2me && "boolean".equals(classType)) {
            return "new java.lang.Boolean(" + expr + ")";
        }
        return JavaUtil.toObject(expr, classType, java5);
    }

    public static String toObjectType(String classType) {
        String objClass = (String)toObjectType.get(classType);
        if (objClass == null) {
            return classType;
        }
        return objClass;
    }

    public static String fromObjectType(String classType) {
        String objClass = (String)fromObjectType.get(classType);
        if (objClass == null) {
            return classType;
        }
        return objClass;
    }

    public static String typeToString(String type2, String expr) {
        String string = type2 = type2 == null ? null : type2.intern();
        if ("String" == type2 || "java.lang.String" == type2) {
            return expr;
        }
        if (type2 == "java.util.Calendar") {
            return "java.text.DateFormat.getInstance().format(" + expr + ".getTime())";
        }
        if (type2 == "boolean") {
            return expr + " ? \"true\" : \"false\"";
        }
        if (JavaUtil.isPrimitiveType(type2)) {
            return "\"\"+" + expr;
        }
        return expr + ".toString()";
    }

    public static String fromObject(String type2, String expr) {
        if ((type2 = type2.intern()) == "int") {
            return "((java.lang.Integer)" + expr + ").intValue()";
        }
        if (type2 == "long") {
            return "((java.lang.Long)" + expr + ").longValue()";
        }
        if (type2 == "short") {
            return "((java.lang.Short)" + expr + ").shortValue()";
        }
        if (type2 == "byte") {
            return "((java.lang.Byte)" + expr + ").byteValue()";
        }
        if (type2 == "float") {
            return "((java.lang.Float)" + expr + ").floatValue()";
        }
        if (type2 == "double") {
            return "((java.lang.Double)" + expr + ").doubleValue()";
        }
        if (type2 == "char") {
            return "((java.lang.Character)" + expr + ").charValue()";
        }
        if (type2 == "boolean") {
            return "((java.lang.Boolean)" + expr + ").booleanValue()";
        }
        return "(" + type2 + ")" + expr;
    }

    public static boolean isImmutable(String className) {
        className = className.intern();
        return immutableTable.containsKey(className);
    }

    public static String instanceFrom(String type2, String value) {
        if (type2 == null) {
            return value;
        }
        if ((type2 = type2.intern()) == "java.lang.String" || type2 == "String") {
            StringBuffer buf = new StringBuffer("\"");
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                buf.append(JavaUtil.escapeCharForInstance(c, '\"'));
            }
            buf.append("\"");
            return buf.toString();
        }
        if (type2 == "java.lang.Character" || type2 == "Character") {
            return "new " + type2 + "(" + JavaUtil.instanceFrom("char", value) + ")";
        }
        if (type2 == "Double" || type2 == "java.lang.Double" || type2 == "Integer" || type2 == "java.lang.Integer" || type2 == "Boolean" || type2 == "java.lang.Boolean" || type2 == "Float" || type2 == "java.lang.Float" || type2 == "Short" || type2 == "java.lang.Short" || type2 == "Long" || type2 == "java.lang.Long") {
            return "new " + type2 + "(" + value + ")";
        }
        if (type2 == "char[]" || type2 == "char []") {
            return JavaUtil.instanceFrom("java.lang.String", value) + ".toCharArray()";
        }
        if (type2 == "char") {
            char c = value.charAt(0);
            return "'" + JavaUtil.escapeCharForInstance(c, '\'') + "'";
        }
        if (type2 == "float") {
            return value + "f";
        }
        if (type2 == "java.math.BigDecimal" || type2 == "java.math.BigInteger") {
            return "new " + type2 + "(\"" + value + "\")";
        }
        return value;
    }

    public static String escapeCharForInstance(char c, char illegalChar) {
        if (c == illegalChar) {
            return "\\" + illegalChar;
        }
        if (c == '\\') {
            return "\\\\";
        }
        if (c == '\b') {
            return "\\b";
        }
        if (c == '\t') {
            return "\\t";
        }
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\f') {
            return "\\f";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c < ' ' || c > '\u007f') {
            return JavaUtil.uencode(c);
        }
        return "" + c;
    }

    public static String compareTo(String value1, String type1, String value2) {
        type1 = type1.intern();
        String value2Instance = JavaUtil.genParseText(type1, value2, false);
        if (JavaUtil.isPrimitiveType(type1)) {
            if ("\"0\"".equals(value2)) {
                return value1;
            }
            return value1 + " - " + value2Instance;
        }
        return value1 + ".compareTo(" + value2Instance + ")";
    }

    public static String compareToText(String value1, String type1, String value2Text) {
        if ((type1 = type1.intern()) == "int" || type1 == "short") {
            return value1 + " - " + value2Text;
        }
        if (type1 == "long") {
            return value1 + " - " + value2Text + "L";
        }
        if (type1 == "float") {
            return value1 + " - " + value2Text + "f";
        }
        if (type1 == "double") {
            return value1 + " - " + value2Text + "d";
        }
        return JavaUtil.compareTo(value1, type1, JavaUtil.instanceFrom("java.lang.String", value2Text));
    }

    public static String genParseText(String type2, String expr, boolean j2me, boolean java5) {
        if (j2me) {
            return JavaUtil.genParseTextME(type2, expr);
        }
        return JavaUtil.genParseText(type2, expr, java5);
    }

    public static String genParseText(String type2, String expr, boolean java5) {
        if (type2 == null) {
            return expr;
        }
        if ((type2 = type2.intern()) == "java.lang.String" || type2 == "String") {
            return expr;
        }
        if (type2 == "boolean") {
            return "(\"true\".equalsIgnoreCase(" + expr + ") || \"1\".equals(" + expr + "))";
        }
        if (type2 == "java.lang.Boolean" || type2 == "Boolean") {
            return JavaUtil.genParseText("boolean", expr, java5) + "? java.lang.Boolean.TRUE : java.lang.Boolean.FALSE";
        }
        if (type2 == "java.lang.Integer" || type2 == "Integer" || type2 == "java.lang.Long" || type2 == "Long" || type2 == "java.lang.Short" || type2 == "Short" || type2 == "java.lang.Float" || type2 == "Float" || type2 == "java.lang.Double" || type2 == "Double" || type2 == "java.lang.Byte" || type2 == "Byte") {
            if (java5) {
                return type2 + ".valueOf(" + expr + ")";
            }
            return "new " + type2 + "(" + expr + ")";
        }
        if (type2 == "java.math.BigDecimal" || type2 == "BigDecimal" || type2 == "java.math.BigInteger" || type2 == "BigInteger" || type2 == "java.lang.StringBuffer" || type2 == "StringBuffer" || type2 == "java.text.MessageFormat" || type2 == "java.text.AttributedString" || type2 == "java.util.StringTokenizer" || type2 == "java.net.URI" || type2 == "javax.xml.namespace.QName" || type2 == "org.netbeans.modules.schema2beans.QName" || type2 == "java.io.File") {
            return "new " + type2 + "(" + expr + ")";
        }
        if (type2 == "java.lang.Character") {
            if (java5) {
                return "java.lang.Character.valueOf((" + expr + ").charAt(0))";
            }
            return "new java.lang.Character((" + expr + ").charAt(0))";
        }
        if (type2 == "char[]" || type2 == "char []") {
            return "(" + expr + ").toCharArray()";
        }
        if (type2 == "long") {
            return "Long.parseLong(" + expr + ")";
        }
        if (type2 == "int") {
            return "Integer.parseInt(" + expr + ")";
        }
        if (type2 == "byte") {
            return "Byte.parseByte(" + expr + ")";
        }
        if (type2 == "short") {
            return "Short.parseShort(" + expr + ")";
        }
        if (type2 == "float") {
            return "Float.parseFloat(" + expr + ")";
        }
        if (type2 == "double") {
            return "Double.parseDouble(" + expr + ")";
        }
        if (type2 == "char") {
            return "(" + expr + ").charAt(0)";
        }
        if ("java.util.Date" == type2) {
            return "java.text.DateFormat.getInstance().parse(" + expr + ")";
        }
        if ("javax.xml.soap.SOAPElement" == type2) {
            return "javax.xml.soap.SOAPElementFactory.newInstance().create(" + expr + ").addTextNode(" + expr + ")";
        }
        return "/* UNKNOWN type for parsing:" + type2 + "*/ " + expr;
    }

    public static String genParseTextME(String type2, String name) {
        String parm = name;
        if ((type2 = type2.intern()) == "String" || type2 == "java.lang.String") {
            return parm;
        }
        if (type2 == "int") {
            parm = "java.lang.Integer.parseInt(" + name + ")";
        } else if (type2 == "short") {
            parm = "java.lang.Short.parseShort(" + name + ")";
        } else if (type2 == "long") {
            parm = "java.lang.Long.parseLong(" + name + ")";
        } else if (type2 == "boolean") {
            parm = "(\"true\".equals(" + name + ") || \"1\".equals(" + name + ") || \"TRUE\".equals(" + name + ") || \"True\".equals(" + name + "))";
        } else if (type2 == "char") {
            parm = name + ".charAt(0)";
        } else if ("char[]" == type2) {
            parm = name + ".toCharArray()";
        } else if ("java.lang.Integer" == type2) {
            parm = "new java.lang.Integer(" + JavaUtil.genParseTextME("int", name) + ")";
        } else if ("java.lang.Long" == type2) {
            parm = "new java.lang.Long(" + JavaUtil.genParseTextME("long", name) + ")";
        } else if ("java.lang.Boolean" == type2) {
            parm = "new java.lang.Boolean(" + JavaUtil.genParseTextME("boolean", name) + ")";
        } else if (type2 == "double") {
            parm = "java.lang.Double.parseDouble(" + name + ")";
        } else if (type2 == "float") {
            parm = "java.lang.Float.parseFloat(" + name + ")";
        } else if (type2 == "byte") {
            parm = "java.lang.Byte.parseByte(" + name + ")";
        } else if ("java.lang.Short" == type2) {
            parm = "new " + type2 + "(" + JavaUtil.genParseTextME("short", name) + ")";
        } else if ("java.lang.Byte" == type2) {
            parm = "new " + type2 + "(" + JavaUtil.genParseTextME("byte", name) + ")";
        } else if ("java.lang.Double" == type2 || "java.lang.Float" == type2 || "java.lang.StringBuffer" == type2 || "java.math.BigInteger" == type2 || "java.math.BigDecimal" == type2) {
            parm = "new " + type2 + "(" + name + ")";
        } else if ("java.lang.Character" == type2) {
            parm = "new " + type2 + "(" + name + ".charAt(0))";
        }
        return parm;
    }

    public static String genParseText(String type2, String expr, String var, boolean java5) {
        return JavaUtil.genParseText(type2, expr, var, false, java5);
    }

    public static String genParseText(String type2, String expr, String var, boolean j2me, boolean java5) {
        if (type2 == null) {
            return expr;
        }
        type2 = type2.intern();
        StringBuffer out = new StringBuffer();
        if (type2 == "java.util.Calendar") {
            out.append(var);
            out.append(" = ");
            out.append("java.util.Calendar.getInstance(); ");
            out.append(var);
            out.append(".setTime(java.text.DateFormat.getInstance().parse(");
            out.append(expr);
            out.append("));");
        } else {
            out.append(var);
            out.append(" = ");
            out.append(JavaUtil.genParseText(type2, expr, j2me, java5));
            out.append(";");
        }
        return out.toString();
    }

    public static List exceptionsFromParsingText(String type2) {
        return JavaUtil.exceptionsFromParsingText(type2, true);
    }

    public static List exceptionsFromParsingText(String type2, boolean fromParsing) {
        ArrayList<String> result = new ArrayList<String>();
        if (type2 == null) {
            return result;
        }
        if ((type2 = type2.intern()) == "java.net.URI") {
            result.add("java.net.URISyntaxException");
        }
        if (fromParsing && type2 == "java.util.Calendar") {
            result.add("java.text.ParseException");
        }
        return result;
    }

    public static boolean isPrimitiveType(String className) {
        if (className == null) {
            return false;
        }
        return "long" == (className = className.intern()) || "int" == className || "char" == className || "short" == className || "double" == className || "float" == className || "byte" == className || "boolean" == className;
    }

    public static Class getPrimitive(String className) {
        if ((className = className.intern()) == "int") {
            return Integer.TYPE;
        }
        if (className == "long") {
            return Long.TYPE;
        }
        if (className == "float") {
            return Float.TYPE;
        }
        if (className == "double") {
            return Double.TYPE;
        }
        if (className == "byte") {
            return Byte.TYPE;
        }
        if (className == "boolean") {
            return Boolean.TYPE;
        }
        if (className == "char") {
            return Character.TYPE;
        }
        if (className == "short") {
            return Short.TYPE;
        }
        if (className == "void") {
            return Void.TYPE;
        }
        return null;
    }

    public static boolean canProduceNoXMLMetaChars(String className) {
        return "long" == (className = JavaUtil.fromObjectType(className).intern()) || "int" == className || "short" == className || "double" == className || "float" == className || "byte" == className || "boolean" == className || "java.math.BigDecimal" == className || "java.math.BigInteger" == className;
    }

    public static String nullValueForType(String type2) {
        if ((type2 = type2.intern()) == "long" || type2 == "int" || type2 == "short" || type2 == "char" || type2 == "byte") {
            return "0";
        }
        if (type2 == "double") {
            return "0.0";
        }
        if (type2 == "float") {
            return "0.0f";
        }
        if (type2 == "boolean") {
            return "false";
        }
        return "null";
    }

    public static String genNewDefault(String type2) {
        if ("java.lang.String" == (type2 = type2.intern()) || "String" == type2) {
            return "\"\"";
        }
        if (JavaUtil.isPrimitiveType(type2)) {
            return JavaUtil.nullValueForType(type2);
        }
        if (type2 == "java.lang.Boolean" || type2 == "Boolean") {
            return "java.lang.Boolean.FALSE";
        }
        if (type2 == "java.lang.Integer" || type2 == "Integer" || type2 == "java.lang.Long" || type2 == "Long" || type2 == "java.lang.Short" || type2 == "Short" || type2 == "java.lang.Float" || type2 == "Float" || type2 == "java.lang.Double" || type2 == "Double" || type2 == "java.lang.Byte" || type2 == "Byte" || type2 == "java.math.BigInteger" || type2 == "BigInteger" || type2 == "java.math.BigDecimal" || type2 == "BigDecimal") {
            return "new " + type2 + "(\"0\")";
        }
        if (type2 == "java.net.URI" || type2 == "javax.xml.namespace.QName" || type2 == "org.netbeans.modules.schema2beans.QName") {
            return "new " + type2 + "(\"\")";
        }
        if (type2 == "java.lang.Character") {
            return "new java.lang.Character('0')";
        }
        if (type2 == "java.util.Calendar") {
            return "java.util.Calendar.getInstance()";
        }
        if (type2 == "byte[]") {
            return "new byte[0]";
        }
        if (type2 == "org.w3c.dom.Element") {
            return "null";
        }
        return "new " + type2 + "()";
    }

    public static String exprToInt(String type2, String expr) {
        if ((type2 = type2.intern()) == "boolean") {
            return expr + " ? 0 : 1";
        }
        if (type2 == "byte" || type2 == "char" || type2 == "short") {
            return "(int) " + expr;
        }
        if (type2 == "int") {
            return expr;
        }
        if (type2 == "long") {
            return "(int)(" + expr + "^(" + expr + ">>>32))";
        }
        if (type2 == "float") {
            return "Float.floatToIntBits(" + expr + ")";
        }
        if (type2 == "double") {
            return JavaUtil.exprToInt("long", "Double.doubleToLongBits(" + expr + ")");
        }
        return "(" + expr + ").hashCode()";
    }

    public static String genEquals(String type2, String attr1, String attr2) {
        return JavaUtil.genEquals(type2, attr1, attr2, true);
    }

    public static String genEquals(String type2, String attr1, String attr2, boolean attr1CanBeNull) {
        if ((type2 = type2.intern()) == "float") {
            return "Float.floatToIntBits(" + attr1 + ") == Float.floatToIntBits(" + attr2 + ")";
        }
        if (type2 == "double") {
            return "Double.doubleToLongBits(" + attr1 + ") == Double.doubleToLongBits(" + attr2 + ")";
        }
        if (JavaUtil.isPrimitiveType(type2)) {
            return attr1 + " == " + attr2;
        }
        if (attr1CanBeNull) {
            return attr1 + " == null ? " + attr2 + " == null : " + attr1 + ".equals(" + attr2 + ")";
        }
        return attr1 + ".equals(" + attr2 + ")";
    }

    public static boolean isCloneable(String className) {
        if (className == null) {
            return false;
        }
        if ((className = className.intern()) == "java.util.Calendar") {
            return true;
        }
        try {
            Class<?> cls = Class.forName(className);
            if (cls == null) {
                return false;
            }
            if (Cloneable.class.isAssignableFrom(cls)) {
                System.out.println(className + " is cloneable.");
                return true;
            }
            return false;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isInstantiable(String className) {
        if (className == null) {
            return false;
        }
        if ((className = className.intern()) == "String" || className == "java.lang.String") {
            return true;
        }
        try {
            Class<?> cls = Class.forName(className);
            if (cls == null) {
                return false;
            }
            if (cls.isInterface()) {
                return false;
            }
            return !Modifier.isAbstract(cls.getModifiers());
        }
        catch (ClassNotFoundException e) {
            if (className.indexOf(46) < 0) {
                return JavaUtil.isInstantiable("java.lang." + className);
            }
            return false;
        }
    }

    public static boolean checkValueToType(String type2, String value) {
        block22: {
            try {
                if ("java.lang.String".equals(type2) || "char[]".equals(type2) || "char []".equals(type2) || "char".equals(type2) || "Character".equals(type2) || "String".equals(type2) || "java.lang.Character".equals(type2)) {
                    return true;
                }
                if ("long".equals(type2)) {
                    Long.parseLong(value);
                    break block22;
                }
                if ("int".equals(type2)) {
                    Integer.parseInt(value);
                    break block22;
                }
                if ("byte".equals(type2)) {
                    Byte.parseByte(value);
                    break block22;
                }
                if ("short".equals(type2)) {
                    Short.parseShort(value);
                    break block22;
                }
                if ("float".equals(type2)) {
                    Float.parseFloat(value);
                    break block22;
                }
                if ("double".equals(type2)) {
                    Double.parseDouble(value);
                    break block22;
                }
                if ("boolean".equals(type2)) {
                    Boolean.valueOf(value).booleanValue();
                    break block22;
                }
                if ("java.lang.Double".equals(type2)) {
                    new Double(value);
                    break block22;
                }
                if ("java.lang.Integer".equals(type2)) {
                    new Integer(value);
                    break block22;
                }
                if ("java.lang.Boolean".equals(type2)) {
                    Boolean.valueOf(value);
                    break block22;
                }
                if ("java.lang.Float".equals(type2)) {
                    new Float(value);
                    break block22;
                }
                if ("java.lang.Short".equals(type2)) {
                    new Short(value);
                    break block22;
                }
                if ("java.lang.Long".equals(type2)) {
                    new Long(value);
                    break block22;
                }
                if ("java.math.BigDecimal".equals(type2)) {
                    new BigDecimal(value);
                    break block22;
                }
                if ("java.math.BigInteger".equals(type2)) {
                    new BigInteger(value);
                    break block22;
                }
                if ("java.lang.StringBuffer".equals(type2)) {
                    new StringBuffer(value);
                    break block22;
                }
                if ("java.text.MessageFormat".equals(type2)) {
                    new MessageFormat(value);
                    break block22;
                }
                if ("java.text.AttributedString".equals(type2)) {
                    new AttributedString(value);
                    break block22;
                }
                if ("java.util.StringTokenizer".equals(type2)) {
                    new StringTokenizer(value);
                    break block22;
                }
                return !"".equals(value);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }

    public static String baseClassOfArray(String className) {
        if (className.startsWith("[L") && className.endsWith(";")) {
            return className.substring(2, className.length() - 1);
        }
        return className.substring(0, className.length() - 2);
    }

    public static String baseName(String fullClassName) {
        int pos = fullClassName.lastIndexOf(46);
        if (pos == -1) {
            return fullClassName;
        }
        return fullClassName.substring(pos + 1, fullClassName.length());
    }

    public static String getCanonicalClassName(Class cls) {
        if (charArrayClass.isAssignableFrom(cls)) {
            return "char[]";
        }
        if (cls.isArray()) {
            return JavaUtil.baseClassOfArray(cls.getName()) + "[]";
        }
        return cls.getName();
    }

    public static int getOptimialHashMapSize(Object[] keys) {
        return JavaUtil.getOptimialHashMapSize(keys, keys.length * 8);
    }

    public static int getOptimialHashMapSize(Object[] keys, int maxSize) {
        int keyLength = keys.length;
        int defaultAnswer = keyLength + 1;
        try {
            Field tableField = HashMap.class.getDeclaredField("table");
            tableField.setAccessible(true);
            for (int tableSize = keyLength + 1; tableSize <= maxSize; tableSize <<= 1) {
                HashMap<Object, Object> map = new HashMap<Object, Object>(tableSize, 1.0f);
                for (int k = 0; k < keyLength; ++k) {
                    map.put(keys[k], null);
                }
                Object[] table = (Object[])tableField.get(map);
                int nullCount = 0;
                for (int i = 0; i < table.length; ++i) {
                    if (table[i] != null) continue;
                    ++nullCount;
                }
                if (table.length - nullCount != keyLength) continue;
                return table.length;
            }
        }
        catch (IllegalAccessException e) {
            return defaultAnswer;
        }
        catch (NoSuchFieldException e) {
            return defaultAnswer;
        }
        return defaultAnswer;
    }

    public static void native2ascii(Writer out, Reader in) throws IOException {
        N2AFilter n2afilter = new N2AFilter(out);
        JavaUtil.copyStream(n2afilter, in);
    }

    public static String uencode(char c) {
        StringBuffer result = new StringBuffer("\\u");
        String s1 = Integer.toHexString(c);
        StringBuffer stringbuffer = new StringBuffer(s1);
        stringbuffer.reverse();
        int l = 4 - stringbuffer.length();
        for (int i1 = 0; i1 < l; ++i1) {
            stringbuffer.append('0');
        }
        for (int j1 = 0; j1 < 4; ++j1) {
            result.append(stringbuffer.charAt(3 - j1));
        }
        return result.toString();
    }

    public static int copyStream(Writer out, Reader in) throws IOException {
        int len;
        int totalLength = 0;
        char[] buf = new char[4096];
        while ((len = in.read(buf, 0, 4096)) != -1) {
            out.write(buf, 0, len);
            totalLength += len;
        }
        out.flush();
        return totalLength;
    }

    public static int copyStream(OutputStream out, InputStream in) throws IOException {
        int len;
        int totalLength = 0;
        byte[] buf = new byte[4096];
        while ((len = in.read(buf, 0, 4096)) != -1) {
            out.write(buf, 0, len);
            totalLength += len;
        }
        out.flush();
        return totalLength;
    }

    public static boolean reservedWord(String name) {
        return reservedWords.containsKey(name);
    }

    static {
        toObjectType.put("int", "java.lang.Integer");
        toObjectType.put("char", "java.lang.Character");
        toObjectType.put("long", "java.lang.Long");
        toObjectType.put("short", "java.lang.Short");
        toObjectType.put("byte", "java.lang.Byte");
        toObjectType.put("float", "java.lang.Float");
        toObjectType.put("double", "java.lang.Double");
        toObjectType.put("boolean", "java.lang.Boolean");
        fromObjectType = new HashMap();
        fromObjectType.put("java.lang.Integer", "int");
        fromObjectType.put("java.lang.Character", "char");
        fromObjectType.put("java.lang.Long", "long");
        fromObjectType.put("java.lang.Short", "short");
        fromObjectType.put("java.lang.Byte", "byte");
        fromObjectType.put("java.lang.Float", "float");
        fromObjectType.put("java.lang.Double", "double");
        fromObjectType.put("java.lang.Boolean", "boolean");
        fromObjectType.put("Integer", "int");
        fromObjectType.put("Character", "char");
        fromObjectType.put("Long", "long");
        fromObjectType.put("Short", "short");
        fromObjectType.put("Byte", "byte");
        fromObjectType.put("Float", "float");
        fromObjectType.put("Double", "double");
        fromObjectType.put("Boolean", "boolean");
        immutableTable = new HashMap();
        immutableTable.put("String", null);
        immutableTable.put("java.lang.String", null);
        immutableTable.put("int", null);
        immutableTable.put("short", null);
        immutableTable.put("long", null);
        immutableTable.put("boolean", null);
        immutableTable.put("char", null);
        immutableTable.put("float", null);
        immutableTable.put("double", null);
        immutableTable.put("byte", null);
        immutableTable.put("java.lang.Boolean", null);
        immutableTable.put("java.lang.Byte", null);
        immutableTable.put("java.lang.Character", null);
        immutableTable.put("java.lang.Double", null);
        immutableTable.put("java.lang.Float", null);
        immutableTable.put("java.lang.Integer", null);
        immutableTable.put("java.lang.Long", null);
        immutableTable.put("java.lang.Short", null);
        immutableTable.put("Boolean", null);
        immutableTable.put("Byte", null);
        immutableTable.put("Character", null);
        immutableTable.put("Double", null);
        immutableTable.put("Float", null);
        immutableTable.put("Integer", null);
        immutableTable.put("Long", null);
        immutableTable.put("Short", null);
        immutableTable.put("java.math.BigInteger", null);
        immutableTable.put("java.math.BigDecimal", null);
        immutableTable.put("javax.xml.namespace.QName", null);
        immutableTable.put("org.netbeans.modules.schema2beans.QName", null);
        immutableTable.put("java.net.URI", null);
        charArrayClass = Array.newInstance(Character.TYPE, 0).getClass();
        reservedWords = new HashMap();
        reservedWords.put("abstract", "_abstract");
        reservedWords.put("assert", "_assert");
        reservedWords.put("boolean", "_boolean");
        reservedWords.put("break", "_break");
        reservedWords.put("byte", "_byte");
        reservedWords.put("case", "_case");
        reservedWords.put("catch", "_catch");
        reservedWords.put("char", "_char");
        reservedWords.put("class", "_class");
        reservedWords.put("const", "_const");
        reservedWords.put("continue", "_continue");
        reservedWords.put("default", "_default");
        reservedWords.put("do", "_do");
        reservedWords.put("double", "_double");
        reservedWords.put("else", "_else");
        reservedWords.put("extends", "_extends");
        reservedWords.put("false", "_false");
        reservedWords.put("final", "_final");
        reservedWords.put("finally", "_finally");
        reservedWords.put("float", "_float");
        reservedWords.put("for", "_for");
        reservedWords.put("goto", "_goto");
        reservedWords.put("if", "_if");
        reservedWords.put("implements", "_implements");
        reservedWords.put("import", "_import");
        reservedWords.put("instanceof", "_instanceof");
        reservedWords.put("int", "_int");
        reservedWords.put("interface", "_interface");
        reservedWords.put("long", "_long");
        reservedWords.put("native", "_native");
        reservedWords.put("new", "_new");
        reservedWords.put("null", "_null");
        reservedWords.put("package", "_package");
        reservedWords.put("private", "_private");
        reservedWords.put("protected", "_protected");
        reservedWords.put("public", "_public");
        reservedWords.put("return", "_return");
        reservedWords.put("short", "_short");
        reservedWords.put("static", "_static");
        reservedWords.put("strictfp", "_strictfp");
        reservedWords.put("super", "_super");
        reservedWords.put("switch", "_switch");
        reservedWords.put("synchronized", "_synchronized");
        reservedWords.put("this", "_this");
        reservedWords.put("throw", "_throw");
        reservedWords.put("throws", "_throws");
        reservedWords.put("transient", "_transient");
        reservedWords.put("true", "_true");
        reservedWords.put("try", "_try");
        reservedWords.put("void", "_void");
        reservedWords.put("volatile", "_volatile");
        reservedWords.put("while", "_while");
    }

    public static class InputMonitor
    implements Runnable {
        private InputStream is;
        private OutputStream out;

        public InputMonitor(InputStream is, OutputStream out) {
            this.is = is;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    byte ch = (byte)c;
                    this.out.write(ch);
                }
                this.out.flush();
            }
            catch (IOException e) {
                try {
                    this.out.write(e.getMessage().getBytes());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    public static class N2AFilter
    extends FilterWriter {
        public N2AFilter(Writer writer) {
            super(writer);
        }

        @Override
        public void write(char[] cbuf) throws IOException {
            this.write(cbuf, 0, cbuf.length);
        }

        @Override
        public void write(int c) throws IOException {
            this.write((char)c);
        }

        public void write(char c) throws IOException {
            if (c > '\u007f') {
                this.out.write(JavaUtil.uencode(c));
            } else {
                this.out.write(c);
            }
        }

        @Override
        public void write(char[] ac, int off, int len) throws IOException {
            int end = off + len;
            for (int k = off; k < end; ++k) {
                this.write(ac[k]);
            }
        }

        @Override
        public void write(String str) throws IOException {
            this.write(str.toCharArray(), 0, str.length());
        }

        @Override
        public void write(String str, int off, int len) throws IOException {
            this.write(str.toCharArray(), off, len);
        }
    }
}

