/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.config.generator;

import com.sun.codemodel.CodeWriter;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JForEach;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleElementVisitor9;
import javax.lang.model.util.SimpleTypeVisitor9;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.StandardLocation;
import org.jvnet.hk2.annotations.InhabitantAnnotation;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Attribute;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigInjector;
import org.jvnet.hk2.config.Configured;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.Element;
import org.jvnet.hk2.config.InjectionTarget;
import org.jvnet.hk2.config.NoopConfigInjector;
import org.jvnet.hk2.config.generator.Property;
import org.jvnet.hk2.config.generator.TypeMath;
import org.jvnet.hk2.config.generator.apt.ContractFinder;

public class ConfigInjectorGenerator
extends AbstractProcessor {
    private JCodeModel cm;
    private TypeMath math;
    private TypeElement configBeanProxy;
    private final GeneratorVisitor visitor = new GeneratorVisitor();
    final SimpleTypeVisitor9<JType, Void> toJtype = new SimpleTypeVisitor9<JType, Void>(){

        @Override
        public JType visitPrimitive(PrimitiveType type2, Void param) {
            switch (type2.getKind()) {
                case BOOLEAN: {
                    return ConfigInjectorGenerator.this.cm.BOOLEAN;
                }
                case BYTE: {
                    return ConfigInjectorGenerator.this.cm.BYTE;
                }
                case CHAR: {
                    return ConfigInjectorGenerator.this.cm.CHAR;
                }
                case DOUBLE: {
                    return ConfigInjectorGenerator.this.cm.DOUBLE;
                }
                case FLOAT: {
                    return ConfigInjectorGenerator.this.cm.FLOAT;
                }
                case INT: {
                    return ConfigInjectorGenerator.this.cm.INT;
                }
                case LONG: {
                    return ConfigInjectorGenerator.this.cm.LONG;
                }
                case SHORT: {
                    return ConfigInjectorGenerator.this.cm.SHORT;
                }
                case NULL: {
                    return ConfigInjectorGenerator.this.cm.NULL;
                }
                case VOID: {
                    return ConfigInjectorGenerator.this.cm.VOID;
                }
            }
            throw new IllegalArgumentException("Unsupported type: " + String.valueOf(type2));
        }

        @Override
        public JType visitArray(ArrayType type2, Void param) {
            return ((JType)this.visit(type2.getComponentType(), null)).array();
        }

        @Override
        public JType visitDeclared(DeclaredType type2, Void param) {
            return ConfigInjectorGenerator.this.cm.ref(((TypeElement)type2.asElement()).getQualifiedName().toString());
        }

        @Override
        public JType visitNoType(NoType t, Void aVoid) {
            return ConfigInjectorGenerator.this.cm.VOID;
        }
    };

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(Configured.class.getName());
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.math = new TypeMath(processingEnv);
        this.configBeanProxy = processingEnv.getElementUtils().getTypeElement(ConfigBeanProxy.class.getName());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.cm = new JCodeModel();
        for (TypeElement typeElement : annotations) {
            for (javax.lang.model.element.Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                element.accept(this.visitor, null);
            }
            try {
                this.cm.build((CodeWriter)new FilerCodeWriter(this.processingEnv.getFiler()));
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
        return true;
    }

    private boolean isSubType(TypeElement subType, TypeElement baseType) {
        Types types = this.processingEnv.getTypeUtils();
        return types.isSubtype(types.getDeclaredType(subType, new TypeMirror[0]), types.getDeclaredType(baseType, new TypeMirror[0]));
    }

    private static void addToMetadata(TreeMap<String, List<String>> metadata, String key, String value) {
        List<String> inner = metadata.get(key);
        if (inner == null) {
            inner = new LinkedList<String>();
            metadata.put(key, inner);
        }
        inner.add(value);
    }

    private static String toCommaSeparatedString(TreeMap<String, List<String>> metadata) {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<String, List<String>> e : metadata.entrySet()) {
            for (String v : e.getValue()) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                buf.append(e.getKey()).append('=').append(v);
            }
        }
        return buf.toString();
    }

    private static String getCanonicalTypeFrom(MirroredTypeException me) {
        TypeMirror tm = me.getTypeMirror();
        if (tm.getKind() == TypeKind.DECLARED) {
            DeclaredType dec = (DeclaredType)tm;
            return ((TypeElement)dec.asElement()).getQualifiedName().toString();
        }
        return "";
    }

    private TypeMirror erasure(TypeMirror type2) {
        return this.processingEnv.getTypeUtils().erasure(type2);
    }

    private void printError(String error, javax.lang.model.element.Element element) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, error, element);
    }

    private class GeneratorVisitor
    extends SimpleElementVisitor9<Void, Void> {
        private GeneratorVisitor() {
        }

        @Override
        public Void visitType(TypeElement element, Void aVoid) {
            switch (element.getKind()) {
                case INTERFACE: {
                    try {
                        if (ConfigInjectorGenerator.this.isSubType(element, ConfigInjectorGenerator.this.configBeanProxy)) {
                            new ClassGenerator(element, true).generate();
                            break;
                        }
                        ConfigInjectorGenerator.this.printError(String.valueOf(element.getQualifiedName()) + " has @Configured but doesn't extend ConfigBeanProxy", element);
                    }
                    catch (JClassAlreadyExistsException ex) {
                        ConfigInjectorGenerator.this.printError(ex.toString(), element);
                    }
                    break;
                }
                case CLASS: {
                    try {
                        new ClassGenerator(element, false).generate();
                    }
                    catch (JClassAlreadyExistsException ex) {
                        ConfigInjectorGenerator.this.printError(ex.toString(), element);
                    }
                    break;
                }
            }
            return null;
        }
    }

    public static final class FilerCodeWriter
    extends CodeWriter {
        private final Filer filer;

        public FilerCodeWriter(Filer filer) {
            this.filer = filer;
        }

        public OutputStream openBinary(JPackage pkg, String fileName) throws IOException {
            StandardLocation loc = fileName.endsWith(".java") ? StandardLocation.SOURCE_PATH : StandardLocation.CLASS_PATH;
            return this.filer.createResource(loc, pkg.name(), fileName, new javax.lang.model.element.Element[0]).openOutputStream();
        }

        public Writer openSource(JPackage pkg, String fileName) throws IOException {
            Object name = pkg.isUnnamed() ? fileName : pkg.name() + "." + fileName;
            name = ((String)name).substring(0, ((String)name).length() - 5);
            return this.filer.createSourceFile((CharSequence)name, new javax.lang.model.element.Element[0]).openWriter();
        }

        public void close() {
        }
    }

    class ClassGenerator {
        final TypeElement clz;
        final JDefinedClass injector;
        final JClass targetType;
        final JAnnotationUse service;
        final JMethod injectMethod;
        final JMethod injectAttributeMethod;
        final JMethod injectElementMethod;
        final TreeMap<String, List<String>> metadata = new TreeMap();
        private Property key;
        private final boolean generateNoopConfigInjector;

        ClassGenerator(TypeElement clz, boolean generateNoopConfigInjector) throws JClassAlreadyExistsException {
            this.clz = clz;
            this.generateNoopConfigInjector = generateNoopConfigInjector;
            Configured c = clz.getAnnotation(Configured.class);
            String name = clz.getQualifiedName().toString();
            this.targetType = ConfigInjectorGenerator.this.cm.ref(name);
            this.injector = ConfigInjectorGenerator.this.cm._class(name + "Injector");
            String elementName = c.name();
            if (c.local()) {
                if (!elementName.isEmpty()) {
                    ConfigInjectorGenerator.this.printError("@Configured.local and @Configured.name is mutually exclusive", clz);
                    elementName = "";
                }
            } else if (elementName.isEmpty()) {
                elementName = Dom.convertName(clz.getSimpleName().toString());
            }
            this.service = this.injector.annotate(Service.class).param("name", elementName);
            this.injector.annotate(InjectionTarget.class).param("value", (JType)this.targetType);
            HashSet<String> targetHabitats = new HashSet<String>();
            for (AnnotationMirror annotationMirror : clz.getAnnotationMirrors()) {
                InhabitantAnnotation ia = annotationMirror.getAnnotationType().asElement().getAnnotation(InhabitantAnnotation.class);
                if (ia == null) continue;
                targetHabitats.add(ia.value());
            }
            if (generateNoopConfigInjector) {
                this.injector._extends(ConfigInjectorGenerator.this.cm.ref(NoopConfigInjector.class));
                this.injectAttributeMethod = null;
                this.injectMethod = null;
                this.injectElementMethod = null;
            } else {
                this.injector._extends(ConfigInjectorGenerator.this.cm.ref(ConfigInjector.class).narrow(this.targetType));
                this.injectMethod = this.injector.method(1, Void.TYPE, "inject");
                this.injectMethod.param(Dom.class, "dom");
                this.injectMethod.param((JType)this.targetType, "target");
                this.injectMethod.body();
                this.injectAttributeMethod = this.injector.method(1, Void.TYPE, "injectAttribute");
                this.addReinjectionParam(this.injectAttributeMethod);
                this.injectElementMethod = this.injector.method(1, Void.TYPE, "injectElement");
                this.addReinjectionParam(this.injectElementMethod);
            }
            ConfigInjectorGenerator.addToMetadata(this.metadata, "target", name);
            for (TypeElement typeElement : ContractFinder.find(clz)) {
                ConfigInjectorGenerator.addToMetadata(this.metadata, "target-contracts", typeElement.getQualifiedName().toString());
            }
            if (targetHabitats.size() > 0) {
                StringBuilder sb = new StringBuilder();
                for (String h : targetHabitats) {
                    sb.append(h).append(";");
                }
                ConfigInjectorGenerator.addToMetadata(this.metadata, "target-habitats", sb.toString());
            }
        }

        private void addReinjectionParam(JMethod method) {
            method.param(Dom.class, "dom");
            method.param(String.class, "name");
            method.param((JType)this.targetType, "target");
        }

        public void generate() {
            Stack<TypeElement> q = new Stack<TypeElement>();
            HashSet<TypeElement> visited = new HashSet<TypeElement>();
            q.push(this.clz);
            while (!q.isEmpty()) {
                TypeMirror sc;
                TypeElement t = (TypeElement)q.pop();
                if (!visited.add(t)) continue;
                block5: for (javax.lang.model.element.Element element : t.getEnclosedElements()) {
                    switch (element.getKind()) {
                        case FIELD: {
                            this.generate(new Property.Field((VariableElement)element));
                            continue block5;
                        }
                        case METHOD: {
                            this.generate(new Property.Method((ExecutableElement)element));
                        }
                    }
                }
                for (TypeMirror typeMirror : t.getInterfaces()) {
                    q.add((TypeElement)((DeclaredType)typeMirror).asElement());
                }
                if (!ElementKind.CLASS.equals((Object)t.getKind()) || TypeKind.NONE.equals((Object)(sc = t.getSuperclass()).getKind())) continue;
                q.add((TypeElement)((DeclaredType)sc).asElement());
            }
            this.service.param("metadata", ConfigInjectorGenerator.toCommaSeparatedString(this.metadata));
        }

        private void generate(Property p) {
            Attribute a = p.getAnnotation(Attribute.class);
            Element e = p.getAnnotation(Element.class);
            if (a == null) {
                if (e != null) {
                    new ElementMethodGenerator(p, e).generate();
                }
            } else {
                new AttributeMethodGenerator(p, a).generate();
                if (e != null) {
                    ConfigInjectorGenerator.this.printError("Cannot have both @Element and @Attribute at the same time", p.decl());
                }
            }
            if (p.isKey()) {
                if (this.key != null) {
                    ConfigInjectorGenerator.this.printError("Multiple key properties", p.decl());
                    ConfigInjectorGenerator.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Another one is at here", this.key.decl());
                }
                this.key = p;
            }
        }

        private final class ElementMethodGenerator
        extends MethodGenerator {
            private final Element e;

            private ElementMethodGenerator(Property p, Element e) {
                super("element_", ClassGenerator.this.injectElementMethod, p, e.value());
                this.e = e;
            }

            @Override
            protected String xmlTokenName() {
                return "<" + this.xmlName + ">";
            }

            @Override
            protected JExpression getXmlValue() {
                String name;
                if (this.conv.isLeaf()) {
                    name = this.isVariableExpansion() ? "leafElement" : "rawLeafElement";
                } else {
                    if (this.xmlName.equals("*")) {
                        return this.invokeDom("nodeByTypeElement").arg(((JType)ConfigInjectorGenerator.this.toJtype.visit(this.itemType, null)).boxify().dotclass());
                    }
                    name = "nodeElement";
                }
                return this.invokeDom(name).arg(this.xmlName);
            }

            @Override
            protected void generate() {
                super.generate();
                if (this.packer == null) {
                    for (AnnotationMirror annotationMirror : this.p.decl().getAnnotationMirrors()) {
                        if (annotationMirror.toString().contains("hk2")) continue;
                        ConfigInjectorGenerator.addToMetadata(ClassGenerator.this.metadata, this.xmlTokenName(), annotationMirror.toString());
                    }
                }
            }

            @Override
            protected boolean isRequired() {
                return this.e.required();
            }

            @Override
            protected boolean isReference() {
                return this.e.reference();
            }

            @Override
            protected boolean isVariableExpansion() {
                return this.e.variableExpansion();
            }

            @Override
            protected boolean isAllElementMatch() {
                return this.e.value().equals("*");
            }
        }

        private final class AttributeMethodGenerator
        extends MethodGenerator {
            private final Attribute a;

            private AttributeMethodGenerator(Property p, Attribute a) {
                super("attribute_", ClassGenerator.this.injectAttributeMethod, p, a.value());
                this.a = a;
            }

            @Override
            protected String xmlTokenName() {
                return "@" + this.xmlName;
            }

            @Override
            protected boolean isRequired() {
                return this.a.required();
            }

            @Override
            protected boolean isReference() {
                return this.a.reference();
            }

            @Override
            protected boolean isVariableExpansion() {
                return this.a.variableExpansion();
            }

            @Override
            protected boolean isAllElementMatch() {
                return false;
            }

            protected boolean hasDefault() {
                boolean noDefaultValue = this.a.defaultValue().length() == 1 && this.a.defaultValue().charAt(0) == '\u0000';
                return !noDefaultValue;
            }

            @Override
            protected void generate() {
                ConfigInjectorGenerator.addToMetadata(ClassGenerator.this.metadata, this.xmlTokenName(), this.isRequired() ? "required" : "optional");
                if (this.hasDefault()) {
                    if (this.a.defaultValue().indexOf(44) != -1) {
                        ConfigInjectorGenerator.addToMetadata(ClassGenerator.this.metadata, this.xmlTokenName(), "\"default:" + this.a.defaultValue() + "\"");
                    } else {
                        ConfigInjectorGenerator.addToMetadata(ClassGenerator.this.metadata, this.xmlTokenName(), "default:" + this.a.defaultValue());
                    }
                }
                String ant = "";
                try {
                    this.a.dataType();
                }
                catch (MirroredTypeException me) {
                    ant = ConfigInjectorGenerator.getCanonicalTypeFrom(me);
                }
                if (ant.length() == 0) {
                    Property.Method m = (Property.Method)this.p;
                    String typeReturnedByMethodDecl = m.method.getReturnType().toString();
                    ConfigInjectorGenerator.addToMetadata(ClassGenerator.this.metadata, this.xmlTokenName(), "datatype:" + typeReturnedByMethodDecl);
                } else {
                    ConfigInjectorGenerator.addToMetadata(ClassGenerator.this.metadata, this.xmlTokenName(), "datatype:" + ant);
                }
                super.generate();
            }

            @Override
            protected JExpression getXmlValue() {
                if (!this.isVariableExpansion() && this.packer != null) {
                    ConfigInjectorGenerator.this.printError("collection attribute property is inconsistent with variableExpansion=false", this.p.decl());
                }
                return this.invokeDom(this.isVariableExpansion() ? "attribute" : "rawAttribute").arg(this.xmlName);
            }
        }

        private abstract class MethodGenerator {
            final JBlock body;
            final JVar $dom;
            final JVar $target;
            final String xmlName;
            final Property p;
            private int iota = 1;
            final TypeMirror erasure;
            final Packer packer;
            final TypeMirror itemType;
            Converter conv;

            MethodGenerator(String methodNamePrefix, JMethod reinjectionMethod, Property p, String xmlName) {
                this.xmlName = p.inferName(xmlName);
                this.p = p;
                if (ClassGenerator.this.generateNoopConfigInjector) {
                    this.body = null;
                    this.$dom = null;
                    this.$target = null;
                } else {
                    JMethod m = ClassGenerator.this.injector.method(1, Void.TYPE, methodNamePrefix + p.seedName());
                    this.$dom = m.param(Dom.class, "dom");
                    this.$target = m.param((JType)ClassGenerator.this.targetType, "target");
                    this.body = m.body();
                    ClassGenerator.this.injectMethod.body().invoke(m).arg((JExpression)this.$dom).arg((JExpression)this.$target);
                    reinjectionMethod.body()._if((JExpression)JExpr.lit((String)this.xmlName).invoke("equals").arg((JExpression)JExpr.ref((String)"name")))._then().invoke(m).arg((JExpression)this.$dom).arg((JExpression)this.$target);
                }
                this.erasure = ConfigInjectorGenerator.this.erasure(p.type());
                this.packer = this.createPacker(p.type(), this.erasure);
                this.itemType = this.packer == null ? this.erasure : ConfigInjectorGenerator.this.erasure(this.packer.itemType());
            }

            private void assign(JExpression rhs) {
                this.p.assign(this.$target, this.body, rhs);
            }

            protected abstract String xmlTokenName();

            protected void generate() {
                this.conv = this.createConverter(this.itemType);
                this.conv.addMetadata(this.xmlTokenName(), this.itemType);
                if (!this.isVariableExpansion() && ConfigInjectorGenerator.this.toJtype.visit(this.itemType, null) != ConfigInjectorGenerator.this.cm.ref(String.class)) {
                    ConfigInjectorGenerator.this.printError("variableExpansion=false is only allowed on String", this.p.decl());
                }
                if (!ClassGenerator.this.generateNoopConfigInjector) {
                    JVar value = this.var((JType)(this.packer != null ? ConfigInjectorGenerator.this.cm.ref(List.class).narrow(this.conv.sourceType()) : this.conv.sourceType()), this.getXmlValue());
                    if (!this.isRequired()) {
                        this.body._if(value.eq(JExpr._null()))._then()._return();
                    }
                    if (this.packer != null) {
                        this.handleMultiValue(value);
                    } else {
                        this.assign(this.conv.as((JExpression)value, this.itemType));
                    }
                }
                if (this.p.isKey()) {
                    this.addKey();
                }
            }

            protected abstract boolean isRequired();

            protected abstract boolean isReference();

            protected abstract boolean isVariableExpansion();

            protected abstract boolean isAllElementMatch();

            protected abstract JExpression getXmlValue();

            private void addKey() {
                ConfigInjectorGenerator.addToMetadata(ClassGenerator.this.metadata, "key", this.xmlTokenName());
                ConfigInjectorGenerator.addToMetadata(ClassGenerator.this.metadata, "keyed-as", ((TypeElement)this.p.decl().getEnclosingElement()).getQualifiedName().toString());
            }

            final JInvocation invokeDom(String methodName) {
                if (this.packer != null) {
                    methodName = (String)methodName + "s";
                }
                return this.$dom.invoke((String)methodName);
            }

            private void handleMultiValue(JVar values) {
                this.packer.start((JExpression)values.invoke("size"));
                JForEach forEach = this.body.forEach((JType)this.conv.sourceType(), this.id(), (JExpression)values);
                this.packer.pack(forEach.body(), this.conv.as((JExpression)forEach.var(), this.packer.itemType()), (JExpression)forEach.var());
                this.assign(this.packer.end());
            }

            protected JVar var(JType t, JExpression init) {
                return this.body.decl(t, this.id(), init);
            }

            protected JVar var(Class t, JExpression init) {
                return this.var((JType)ConfigInjectorGenerator.this.cm.ref(t), init);
            }

            private String id() {
                return "v" + this.iota++;
            }

            private Packer createPacker(TypeMirror type2, TypeMirror erasure) {
                if (erasure.getKind() == TypeKind.ARRAY) {
                    return new ArrayPacker((ArrayType)erasure);
                }
                TypeMirror itemType = ConfigInjectorGenerator.this.math.isCollection(type2);
                if (itemType != null) {
                    return new ListPacker(type2, itemType);
                }
                TypeMirror mapType = (TypeMirror)ConfigInjectorGenerator.this.math.baseClassFinder.visit(type2, ConfigInjectorGenerator.this.processingEnv.getElementUtils().getTypeElement(Map.class.getName()));
                if (mapType != null) {
                    DeclaredType d = (DeclaredType)mapType;
                    List<? extends TypeMirror> itr = d.getTypeArguments();
                    return new MapPacker(itr.get(1));
                }
                return null;
            }

            private Converter createConverter(TypeMirror itemType) {
                try {
                    ConfigInjectorGenerator.this.math.simpleValueConverter.visit(itemType, JExpr._null());
                    return new LeafConverter();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    TypeElement decl;
                    Configured cfg;
                    if (TypeKind.DECLARED.equals((Object)itemType.getKind()) && (cfg = (decl = (TypeElement)((DeclaredType)itemType).asElement()).getAnnotation(Configured.class)) != null) {
                        if (this.isReference()) {
                            return new ReferenceConverter();
                        }
                        return new NodeConverter();
                    }
                    if (this.isAllElementMatch()) {
                        return new NodeByTypeConverter(itemType);
                    }
                    ConfigInjectorGenerator.this.printError("I don't know how to inject " + String.valueOf(itemType) + " from configuration", this.p.decl());
                    return new NodeConverter();
                }
            }

            abstract class Packer {
                Packer() {
                }

                abstract TypeMirror itemType();

                abstract void start(JExpression var1);

                abstract void pack(JBlock var1, JExpression var2, JExpression var3);

                abstract JExpression end();
            }

            abstract class Converter {
                Converter() {
                }

                abstract JExpression as(JExpression var1, TypeMirror var2);

                abstract JClass sourceType();

                abstract boolean isLeaf();

                abstract void addMetadata(String var1, TypeMirror var2);

                protected final String makeCollectionIfNecessary(String s) {
                    if (MethodGenerator.this.packer != null) {
                        return "collection:" + s;
                    }
                    return s;
                }
            }

            final class ArrayPacker
            extends Packer {
                private JVar $array;
                private JVar $index;
                private final JType arrayT;
                private final JType componentT;
                private final ArrayType at;

                ArrayPacker(ArrayType t) {
                    this.at = t;
                    this.componentT = (JType)ConfigInjectorGenerator.this.toJtype.visit(this.itemType(), null);
                    this.arrayT = this.componentT.array();
                }

                @Override
                TypeMirror itemType() {
                    return this.at.getComponentType();
                }

                @Override
                void start(JExpression $valueSize) {
                    this.$array = MethodGenerator.this.var(this.arrayT, (JExpression)JExpr.newArray((JType)this.componentT, (JExpression)$valueSize));
                    this.$index = MethodGenerator.this.var(Integer.TYPE, JExpr.lit((int)0));
                }

                @Override
                void pack(JBlock block, JExpression item, JExpression sourceValue) {
                    block.assign((JAssignmentTarget)this.$array.component(this.$index.incr()), item);
                }

                @Override
                JExpression end() {
                    return this.$array;
                }
            }

            final class ListPacker
            extends Packer {
                private JVar $list;
                private final JClass collectionType;
                private final JClass itemType;
                private final TypeMirror itemT;

                ListPacker(TypeMirror collectionType, TypeMirror itemType) {
                    this.collectionType = ((JType)ConfigInjectorGenerator.this.toJtype.visit(collectionType)).boxify();
                    JType javaItemType = (JType)ConfigInjectorGenerator.this.toJtype.visit(itemType);
                    this.itemType = javaItemType == null ? null : javaItemType.boxify();
                    this.itemT = itemType;
                }

                @Override
                TypeMirror itemType() {
                    return this.itemT;
                }

                @Override
                void start(JExpression $valueSize) {
                    this.$list = MethodGenerator.this.var((JType)this.collectionType, (JExpression)JExpr._new((JType)this.implType()).arg($valueSize));
                }

                JType implType() {
                    if (ConfigInjectorGenerator.this.cm.ref(Set.class).isAssignableFrom(this.collectionType)) {
                        return ConfigInjectorGenerator.this.cm.ref(HashSet.class).narrow(this.itemType);
                    }
                    return ConfigInjectorGenerator.this.cm.ref(ArrayList.class).narrow(this.itemType);
                }

                @Override
                void pack(JBlock block, JExpression item, JExpression sourceValue) {
                    block.invoke((JExpression)this.$list, "add").arg(item);
                }

                @Override
                JExpression end() {
                    return this.$list;
                }
            }

            final class MapPacker
            extends Packer {
                private JVar $map;
                private final TypeMirror itemT;

                MapPacker(TypeMirror itemType) {
                    this.itemT = itemType;
                }

                @Override
                TypeMirror itemType() {
                    return this.itemT;
                }

                @Override
                void start(JExpression $valueSize) {
                    this.$map = MethodGenerator.this.var(Map.class, (JExpression)JExpr._new((JClass)ConfigInjectorGenerator.this.cm.ref(HashMap.class)).arg($valueSize));
                }

                @Override
                void pack(JBlock block, JExpression item, JExpression itemDom) {
                    block.invoke((JExpression)this.$map, "put").arg((JExpression)itemDom.invoke("getKey")).arg(item);
                }

                @Override
                JExpression end() {
                    return this.$map;
                }
            }

            class LeafConverter
            extends Converter {
                LeafConverter() {
                }

                @Override
                JExpression as(JExpression rhs, TypeMirror targetType) {
                    return (JExpression)ConfigInjectorGenerator.this.math.simpleValueConverter.visit(targetType, rhs);
                }

                @Override
                JClass sourceType() {
                    return ConfigInjectorGenerator.this.cm.ref(String.class);
                }

                @Override
                boolean isLeaf() {
                    return true;
                }

                @Override
                void addMetadata(String key, TypeMirror itemType) {
                    ConfigInjectorGenerator.addToMetadata(ClassGenerator.this.metadata, key, this.makeCollectionIfNecessary("leaf"));
                }
            }

            class ReferenceConverter
            extends Converter {
                ReferenceConverter() {
                }

                @Override
                JExpression as(JExpression rhs, TypeMirror targetType) {
                    return JExpr.invoke((String)"reference").arg((JExpression)MethodGenerator.this.$dom).arg(rhs).arg(((JType)ConfigInjectorGenerator.this.toJtype.visit(targetType, null)).boxify().dotclass());
                }

                @Override
                JClass sourceType() {
                    return ConfigInjectorGenerator.this.cm.ref(String.class);
                }

                @Override
                boolean isLeaf() {
                    return true;
                }

                @Override
                void addMetadata(String key, TypeMirror itemType) {
                    ConfigInjectorGenerator.addToMetadata(ClassGenerator.this.metadata, key, this.makeCollectionIfNecessary("leaf"));
                    ConfigInjectorGenerator.addToMetadata(ClassGenerator.this.metadata, key, "reference");
                }
            }

            class NodeConverter
            extends Converter {
                NodeConverter() {
                }

                @Override
                JExpression as(JExpression rhs, TypeMirror targetType) {
                    return JExpr.cast((JType)((JType)ConfigInjectorGenerator.this.toJtype.visit(targetType, null)), (JExpression)rhs.invoke("get"));
                }

                @Override
                JClass sourceType() {
                    return ConfigInjectorGenerator.this.cm.ref(Dom.class);
                }

                @Override
                boolean isLeaf() {
                    return false;
                }

                @Override
                void addMetadata(String key, TypeMirror itemType) {
                    String typeName = itemType.getKind() == TypeKind.DECLARED ? ((DeclaredType)itemType).asElement().toString() : itemType.toString();
                    ConfigInjectorGenerator.addToMetadata(ClassGenerator.this.metadata, key, this.makeCollectionIfNecessary(typeName));
                }
            }

            class NodeByTypeConverter
            extends Converter {
                final JClass sourceType;

                NodeByTypeConverter(TypeMirror sourceType) {
                    this.sourceType = ((JType)ConfigInjectorGenerator.this.toJtype.visit(sourceType, null)).boxify();
                }

                @Override
                JExpression as(JExpression rhs, TypeMirror targetType) {
                    return rhs;
                }

                @Override
                JClass sourceType() {
                    return this.sourceType;
                }

                @Override
                boolean isLeaf() {
                    return false;
                }

                @Override
                void addMetadata(String key, TypeMirror itemType) {
                }
            }
        }
    }
}

