/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util;

import java.util.Map;
import org.jboss.weld.util.collections.ImmutableMap;

public final class Defaults {
    private static final Map<Class<?>, Object> JLS_PRIMITIVE_DEFAULT_VALUES;

    private Defaults() {
    }

    public static <T> T getJlsDefaultValue(Class<T> type2) {
        if (!type2.isPrimitive()) {
            return null;
        }
        return (T)JLS_PRIMITIVE_DEFAULT_VALUES.get(type2);
    }

    static {
        ImmutableMap.Builder<Class<Comparable<Boolean>>, Comparable<Boolean>> builder = ImmutableMap.builder();
        builder.put(Boolean.TYPE, Boolean.valueOf(false));
        builder.put(Character.TYPE, Character.valueOf('\u0000'));
        builder.put(Byte.TYPE, Byte.valueOf((byte)0));
        builder.put(Short.TYPE, Short.valueOf((short)0));
        builder.put(Integer.TYPE, Integer.valueOf(0));
        builder.put(Long.TYPE, Long.valueOf(0L));
        builder.put(Float.TYPE, Float.valueOf(0.0f));
        builder.put(Double.TYPE, Double.valueOf(0.0));
        JLS_PRIMITIVE_DEFAULT_VALUES = builder.build();
    }
}

