/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import jakarta.enterprise.inject.spi.ObserverMethod;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.jboss.weld.bootstrap.events.ProcessAnnotatedTypeEventResolvable;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.event.ContainerLifecycleEventObserverMethod;
import org.jboss.weld.event.ResolvedObservers;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.resolution.AssignabilityRules;
import org.jboss.weld.resolution.EventTypeAssignabilityRules;
import org.jboss.weld.resolution.QualifierInstance;
import org.jboss.weld.resolution.Resolvable;
import org.jboss.weld.resolution.TypeSafeResolver;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.Observers;
import org.jboss.weld.util.reflection.Reflections;

public class TypeSafeObserverResolver
extends TypeSafeResolver<Resolvable, ObserverMethod<?>, List<ObserverMethod<?>>, ResolvedObservers<?>> {
    private final MetaAnnotationStore metaAnnotationStore;
    private final AssignabilityRules rules;

    public TypeSafeObserverResolver(MetaAnnotationStore metaAnnotationStore, Iterable<ObserverMethod<?>> observers, WeldConfiguration configuration) {
        super(observers, configuration);
        this.metaAnnotationStore = metaAnnotationStore;
        this.rules = EventTypeAssignabilityRules.instance();
    }

    @Override
    protected boolean matches(Resolvable resolvable, ObserverMethod<?> observer) {
        if (!this.rules.matches(observer.getObservedType(), resolvable.getTypes())) {
            return false;
        }
        if (!Beans.containsAllQualifiers(QualifierInstance.of(observer.getObservedQualifiers(), this.metaAnnotationStore), resolvable.getQualifiers())) {
            return false;
        }
        if (observer instanceof ContainerLifecycleEventObserverMethod) {
            ContainerLifecycleEventObserverMethod lifecycleObserver = (ContainerLifecycleEventObserverMethod)observer;
            if (resolvable instanceof ProcessAnnotatedTypeEventResolvable && !lifecycleObserver.getRequiredAnnotations().isEmpty()) {
                ProcessAnnotatedTypeEventResolvable patResolvable = (ProcessAnnotatedTypeEventResolvable)resolvable;
                return patResolvable.containsRequiredAnnotations(lifecycleObserver.getRequiredAnnotations());
            }
        } else {
            return !this.isContainerLifecycleEvent(resolvable);
        }
        return true;
    }

    protected boolean isContainerLifecycleEvent(Resolvable resolvable) {
        for (Type type2 : resolvable.getTypes()) {
            if (!Observers.CONTAINER_LIFECYCLE_EVENT_TYPES.contains(Reflections.getRawType(type2))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Set<ObserverMethod<?>> filterResult(Set<ObserverMethod<?>> matched) {
        return matched;
    }

    @Override
    protected List<ObserverMethod<?>> sortResult(Set<ObserverMethod<?>> matched) {
        ArrayList observers = new ArrayList(matched);
        Collections.sort(observers, ObserverMethodComparator.INSTANCE);
        return observers;
    }

    @Override
    protected ResolvedObservers<?> makeResultImmutable(List<ObserverMethod<?>> result) {
        return ResolvedObservers.of((List)Reflections.cast(result));
    }

    public MetaAnnotationStore getMetaAnnotationStore() {
        return this.metaAnnotationStore;
    }

    private static class ObserverMethodComparator
    implements Comparator<ObserverMethod<?>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static ObserverMethodComparator INSTANCE = new ObserverMethodComparator();

        private ObserverMethodComparator() {
        }

        @Override
        public int compare(ObserverMethod<?> o1, ObserverMethod<?> o2) {
            ObserverMethod<?> eom1 = o1;
            ObserverMethod<?> eom2 = o2;
            return eom1.getPriority() - eom2.getPriority();
        }
    }
}

