/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.lang.model.types.Type;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.util.Arrays;
import java.util.Objects;
import org.jboss.weld.lite.extension.translator.AnnotationTargetImpl;
import org.jboss.weld.lite.extension.translator.ArrayTypeImpl;
import org.jboss.weld.lite.extension.translator.ClassTypeImpl;
import org.jboss.weld.lite.extension.translator.ParameterizedTypeImpl;
import org.jboss.weld.lite.extension.translator.PrimitiveTypeImpl;
import org.jboss.weld.lite.extension.translator.TypeVariableImpl;
import org.jboss.weld.lite.extension.translator.VoidTypeImpl;
import org.jboss.weld.lite.extension.translator.WildcardTypeImpl;
import org.jboss.weld.lite.extension.translator.logging.LiteExtensionTranslatorLogger;
import org.jboss.weld.lite.extension.translator.util.AnnotationOverrides;
import org.jboss.weld.lite.extension.translator.util.reflection.AnnotatedTypes;

abstract class TypeImpl<ReflectionType extends AnnotatedType>
extends AnnotationTargetImpl<ReflectionType>
implements Type {
    TypeImpl(ReflectionType reflectionType, AnnotationOverrides overrides, BeanManager bm) {
        super(reflectionType, overrides, bm);
    }

    static Type fromReflectionType(AnnotatedType reflectionType, BeanManager bm) {
        return TypeImpl.fromReflectionType(reflectionType, null, bm);
    }

    static Type fromReflectionType(AnnotatedType reflectionType, AnnotationOverrides overrides, BeanManager bm) {
        if (reflectionType instanceof AnnotatedParameterizedType) {
            return new ParameterizedTypeImpl((AnnotatedParameterizedType)reflectionType, overrides, bm);
        }
        if (reflectionType instanceof AnnotatedTypeVariable) {
            return new TypeVariableImpl((AnnotatedTypeVariable)reflectionType, overrides, bm);
        }
        if (reflectionType instanceof AnnotatedArrayType) {
            return new ArrayTypeImpl((AnnotatedArrayType)reflectionType, overrides, bm);
        }
        if (reflectionType instanceof AnnotatedWildcardType) {
            return new WildcardTypeImpl((AnnotatedWildcardType)reflectionType, overrides, bm);
        }
        if (reflectionType.getType() instanceof Class) {
            Class clazz = (Class)reflectionType.getType();
            if (clazz.isPrimitive()) {
                if (clazz == Void.TYPE) {
                    return new VoidTypeImpl(bm);
                }
                return new PrimitiveTypeImpl(reflectionType, overrides, bm);
            }
            if (clazz.isArray()) {
                return new ArrayTypeImpl((AnnotatedArrayType)AnnotatedTypes.from(clazz), overrides, bm);
            }
            return new ClassTypeImpl(reflectionType, overrides, bm);
        }
        throw LiteExtensionTranslatorLogger.LOG.unknownReflectionType(reflectionType);
    }

    public String toString() {
        return ((AnnotatedType)this.reflection).getType().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TypeImpl)) {
            return false;
        }
        TypeImpl type2 = (TypeImpl)o;
        return Objects.equals(((AnnotatedType)this.reflection).getType(), ((AnnotatedType)type2.reflection).getType()) && Objects.deepEquals(((AnnotatedType)this.reflection).getAnnotations(), ((AnnotatedType)type2.reflection).getAnnotations());
    }

    public int hashCode() {
        int result = Objects.hash(((AnnotatedType)this.reflection).getType());
        result = 31 * result + Arrays.hashCode(((AnnotatedType)this.reflection).getAnnotations());
        return result;
    }
}

