/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.build.compatible.spi.AnnotationBuilder;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.AnnotationMember;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.types.ArrayType;
import jakarta.enterprise.lang.model.types.Type;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.jboss.weld.lite.extension.translator.AnnotationInfoImpl;
import org.jboss.weld.lite.extension.translator.AnnotationMemberImpl;
import org.jboss.weld.lite.extension.translator.AnnotationProxy;
import org.jboss.weld.lite.extension.translator.ArrayTypeImpl;
import org.jboss.weld.lite.extension.translator.ClassInfoImpl;
import org.jboss.weld.lite.extension.translator.ClassTypeImpl;
import org.jboss.weld.lite.extension.translator.PrimitiveTypeImpl;
import org.jboss.weld.lite.extension.translator.VoidTypeImpl;
import org.jboss.weld.lite.extension.translator.logging.LiteExtensionTranslatorLogger;

class AnnotationBuilderImpl
implements AnnotationBuilder {
    private final Class<? extends Annotation> clazz;
    private final Map<String, AnnotationMember> members = new HashMap<String, AnnotationMember>();
    private final BeanManager bm;

    AnnotationBuilderImpl(Class<? extends Annotation> clazz, BeanManager bm) {
        this.clazz = clazz;
        this.bm = bm;
    }

    @Override
    public AnnotationBuilder member(String name, AnnotationMember value) {
        this.members.put(name, value);
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, boolean value) {
        this.members.put(name, new AnnotationMemberImpl(value, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, boolean[] values) {
        this.members.put(name, new AnnotationMemberImpl(values, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, byte value) {
        this.members.put(name, new AnnotationMemberImpl(value, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, byte[] values) {
        this.members.put(name, new AnnotationMemberImpl(values, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, short value) {
        this.members.put(name, new AnnotationMemberImpl(value, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, short[] values) {
        this.members.put(name, new AnnotationMemberImpl(values, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, int value) {
        this.members.put(name, new AnnotationMemberImpl(value, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, int[] values) {
        this.members.put(name, new AnnotationMemberImpl(values, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, long value) {
        this.members.put(name, new AnnotationMemberImpl(value, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, long[] values) {
        this.members.put(name, new AnnotationMemberImpl(values, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, float value) {
        this.members.put(name, new AnnotationMemberImpl(Float.valueOf(value), this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, float[] values) {
        this.members.put(name, new AnnotationMemberImpl(values, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, double value) {
        this.members.put(name, new AnnotationMemberImpl(value, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, double[] values) {
        this.members.put(name, new AnnotationMemberImpl(values, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, char value) {
        this.members.put(name, new AnnotationMemberImpl(Character.valueOf(value), this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, char[] values) {
        this.members.put(name, new AnnotationMemberImpl(values, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, String value) {
        this.members.put(name, new AnnotationMemberImpl(value, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, String[] values) {
        this.members.put(name, new AnnotationMemberImpl(values, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, Enum<?> value) {
        this.members.put(name, new AnnotationMemberImpl(value, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, Enum<?>[] values) {
        this.members.put(name, new AnnotationMemberImpl(values, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, Class<? extends Enum<?>> enumType, String enumValue) {
        Enum<?> enumConstant = Enum.valueOf(enumType, enumValue);
        this.members.put(name, new AnnotationMemberImpl(enumConstant, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, Class<? extends Enum<?>> enumType, String[] enumValues) {
        Enum[] enumConstants = new Enum[enumValues.length];
        for (int i = 0; i < enumValues.length; ++i) {
            enumConstants[i] = Enum.valueOf(enumType, enumValues[i]);
        }
        this.members.put(name, new AnnotationMemberImpl(enumConstants, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, ClassInfo enumType, String enumValue) {
        Class enumClass = ((AnnotatedType)((ClassInfoImpl)enumType).cdiDeclaration).getJavaClass();
        Object enumConstant = Enum.valueOf(enumClass, enumValue);
        this.members.put(name, new AnnotationMemberImpl(enumConstant, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, ClassInfo enumType, String[] enumValues) {
        Class enumClass = ((AnnotatedType)((ClassInfoImpl)enumType).cdiDeclaration).getJavaClass();
        Enum[] enumConstants = new Enum[enumValues.length];
        for (int i = 0; i < enumValues.length; ++i) {
            enumConstants[i] = Enum.valueOf(enumClass, enumValues[i]);
        }
        this.members.put(name, new AnnotationMemberImpl(enumConstants, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, Class<?> value) {
        this.members.put(name, new AnnotationMemberImpl(value, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, Class<?>[] values) {
        this.members.put(name, new AnnotationMemberImpl(values, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, ClassInfo value) {
        Class clazz = ((AnnotatedType)((ClassInfoImpl)value).cdiDeclaration).getJavaClass();
        this.members.put(name, new AnnotationMemberImpl(clazz, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, ClassInfo[] values) {
        Class[] classes = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            classes[i] = ((AnnotatedType)((ClassInfoImpl)values[i]).cdiDeclaration).getJavaClass();
        }
        this.members.put(name, new AnnotationMemberImpl(classes, this.bm));
        return this;
    }

    private Class<?> validateType(Type type2) {
        if (type2 instanceof VoidTypeImpl) {
            return ((VoidTypeImpl)type2).clazz;
        }
        if (type2 instanceof PrimitiveTypeImpl) {
            return ((PrimitiveTypeImpl)type2).clazz;
        }
        if (type2 instanceof ClassTypeImpl) {
            return ((ClassTypeImpl)type2).clazz;
        }
        if (type2 instanceof ArrayTypeImpl) {
            ArrayType arrayType = type2.asArray();
            Type elementType = arrayType.componentType();
            while (elementType.isArray()) {
                elementType = elementType.asArray().componentType();
            }
            if (elementType instanceof PrimitiveTypeImpl) {
                return ((PrimitiveTypeImpl)elementType).clazz;
            }
            if (elementType instanceof ClassTypeImpl) {
                return ((ClassTypeImpl)elementType).clazz;
            }
        }
        throw LiteExtensionTranslatorLogger.LOG.illegalAnnotationMemberType(type2);
    }

    @Override
    public AnnotationBuilder member(String name, Type value) {
        Class<?> clazz = this.validateType(value);
        this.members.put(name, new AnnotationMemberImpl(clazz, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, Type[] values) {
        Class[] classes = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            classes[i] = this.validateType(values[i]);
        }
        this.members.put(name, new AnnotationMemberImpl(classes, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, AnnotationInfo value) {
        Annotation annotation = ((AnnotationInfoImpl)value).annotation;
        this.members.put(name, new AnnotationMemberImpl(annotation, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, AnnotationInfo[] values) {
        Annotation[] annotations = new Annotation[values.length];
        for (int i = 0; i < values.length; ++i) {
            annotations[i] = ((AnnotationInfoImpl)values[i]).annotation;
        }
        this.members.put(name, new AnnotationMemberImpl(annotations, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, Annotation value) {
        this.members.put(name, new AnnotationMemberImpl(value, this.bm));
        return this;
    }

    @Override
    public AnnotationBuilder member(String name, Annotation[] values) {
        this.members.put(name, new AnnotationMemberImpl(values, this.bm));
        return this;
    }

    @Override
    public AnnotationInfo build() {
        Annotation annotation = AnnotationProxy.create(this.clazz, this.members);
        return new AnnotationInfoImpl(annotation, this.bm);
    }
}

