/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.injection.producer;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import java.util.List;
import java.util.Set;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.slim.SlimAnnotatedType;
import org.jboss.weld.injection.FieldInjectionPoint;
import org.jboss.weld.injection.InjectionContextImpl;
import org.jboss.weld.injection.InjectionPointFactory;
import org.jboss.weld.injection.MethodInjectionPoint;
import org.jboss.weld.injection.producer.Injector;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.util.BeanMethods;
import org.jboss.weld.util.Beans;
import org.jboss.weld.util.InjectionPoints;

public class DefaultInjector<T>
implements Injector<T> {
    private final List<Set<FieldInjectionPoint<?, ?>>> injectableFields;
    private final List<Set<MethodInjectionPoint<?, ?>>> initializerMethods;

    public static <T> DefaultInjector<T> of(EnhancedAnnotatedType<T> type2, Bean<T> bean, BeanManagerImpl beanManager) {
        return new DefaultInjector<T>(type2, bean, beanManager);
    }

    public DefaultInjector(EnhancedAnnotatedType<T> type2, Bean<T> bean, BeanManagerImpl beanManager) {
        this.injectableFields = InjectionPointFactory.instance().getFieldInjectionPoints(bean, type2, beanManager);
        this.initializerMethods = BeanMethods.getInitializerMethods(bean, type2, beanManager);
    }

    @Override
    public void registerInjectionPoints(Set<InjectionPoint> injectionPoints) {
        injectionPoints.addAll(InjectionPoints.flattenInjectionPoints(this.injectableFields));
        injectionPoints.addAll(InjectionPoints.flattenParameterInjectionPoints(this.initializerMethods));
    }

    @Override
    public void inject(final T instance, final CreationalContext<T> ctx, final BeanManagerImpl manager, SlimAnnotatedType<T> type2, InjectionTarget<T> injectionTarget) {
        new InjectionContextImpl<T>(manager, injectionTarget, type2, instance){

            @Override
            public void proceed() {
                Beans.injectFieldsAndInitializers(instance, ctx, manager, DefaultInjector.this.injectableFields, DefaultInjector.this.initializerMethods);
            }
        }.run();
    }

    @Override
    public List<Set<FieldInjectionPoint<?, ?>>> getInjectableFields() {
        return this.injectableFields;
    }

    @Override
    public List<Set<MethodInjectionPoint<?, ?>>> getInitializerMethods() {
        return this.initializerMethods;
    }
}

